package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.enums.TeamSourceFlagEnum;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerEnterVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.labor.mapper.WorkerEnterMapper;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.service.IWorkerEnterService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 劳务进场单
 * 
 * @author generator
 * 
 */
@Service("workerEnterService")
public class WorkerEnterServiceImpl extends BaseServiceImpl<WorkerEnterMapper, WorkerEnterEntity> implements IWorkerEnterService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "LABOR_WORKER_ENTER";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IWorkRecordService recordService;
    @Autowired
    private IProjectTeamService projectTeamService;
    /**
     *  1、只引入人员：只引入人员信息，如人员所在班组在项目中存在，则自动挂项目班组上，如不存在则班组为空；
     *  2、引入人员及班组：同时引入人员与班组，当人员对应班组在项目中存在时，则不需要引入，直接挂项目对应班组即可；
     * @param voList
     * @return
     */
    @Override
    public List<String> insertWorkRecord(List<WorkerVO> voList){
        List<String> errorMsg = new ArrayList<>();
        List<WorkerEnterEntity> saveList = new ArrayList<>();
        List<WorkRecordVO> recordVOList = new ArrayList<>();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            //获取项目数据
            CommonResponse<ProjectRegisterVO> projectRegisterVOCommonResponse = projectApi.queryProjectByProjectDepartmentId(InvocationInfoProxy.getOrgId().toString());
            if(!projectRegisterVOCommonResponse.isSuccess()) {
                throw new BusinessException("网络异常，获取项目信息， 请稍后再试");
            }
            ProjectRegisterVO project = projectRegisterVOCommonResponse.getData();
            //获取 项目根班组
            QueryWrapper<ProjectTeamEntity> queryProject = new QueryWrapper<>();
            queryProject.eq("project_id",project.getId());
            queryProject.isNull("parent_id");
            ProjectTeamEntity projectTeam = projectTeamService.getOne(queryProject);
            for (WorkerVO vo:voList){
                //TODO 当项目班组中该人员在场的情况下，不可引入
                //查询 当前人员是否存在入场单
                LambdaQueryWrapper<WorkerEnterEntity> lambdaCount = new LambdaQueryWrapper<>();
                lambdaCount.eq(WorkerEnterEntity::getProjectId,projectTeam.getId());
                lambdaCount.eq(WorkerEnterEntity::getPhone,vo.getPhone());
                lambdaCount.eq(WorkerEnterEntity::getWorkState,1);
                int count = super.count(lambdaCount);
                if (count>0){
                    errorMsg.add("当项目班组中该人员"+ vo.getName()+"在场");
                }else {
                    //TODO 将vo转换为劳务进场
                    WorkerEnterEntity entity = BeanMapper.map(vo, WorkerEnterEntity.class);
                    entity.setSourceFlag(2);
                    entity.setSourceFlagName("公司花名册");
                    //设置项目信息
                    entity.setProjectId(projectTeam.getId());
                    entity.setProjectName(projectTeam.getName());
                    entity.setOrgId(project.getProjectDepartmentId());
                    entity.setParentOrgId(project.getOrgId());
                    entity.setParentOrgName(project.getOrgName());
                    //TODO 人员所在班组在项目中存在，则自动挂项目班组上，如不存在则班组为空；
                    //去查询班组是否存在
                    LambdaQueryWrapper<ProjectTeamEntity> teamLambda = new LambdaQueryWrapper<>();
                    teamLambda.eq(ProjectTeamEntity::getProjectId,project.getId());
                    teamLambda.eq(ProjectTeamEntity::getSourceFlag, TeamSourceFlagEnum.公司.getStatus());
                    int teamCount = projectTeamService.count(teamLambda);
                    if (!(teamCount>0)){
                        entity.setTeamId(null);
                        entity.setTeamName(null);
                    }
                    BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),vo);
                    CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                    if(!billCode.isSuccess()) {
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                    entity.setBillCode(billCode.getData());
                    //TODO 导入的单据状态 是否生效
                    entity.setBillState(1);
                    entity.setEnterDate(new Date());
                    entity.setManageDate(new Date());
                    saveList.add(entity);

                    //TODO 将entity转换为用工记录
                    WorkRecordVO record = BeanMapper.map(entity, WorkRecordVO.class);
                    record.setWorkerId(vo.getId());
                    record.setOrgTeamId(vo.getTeamId());
                    record.setOrgTeamName(vo.getTeamName());
                    record.setOrgWorkType(vo.getWorkType());
                    record.setOrgWorkTypeName(vo.getWorkTypeName());
                    record.setProjectAddress(project.getAddress());
                    record.setSourceFlag(2);
                    record.setSourceId(vo.getId());
                    record.setEnterExitState(1);
                    recordVOList.add(record);
                }
            }
            if (CollectionUtils.isNotEmpty(saveList)){
                //TODO 保存 推送数据到用工记录单
                super.saveOrUpdateBatch(saveList);
                recordService.insertWorkRecord(recordVOList);
            }
        }else {
            errorMsg.add("当前登录不是项目部!");
        }
        return errorMsg;
    }
}
