package com.ejianc.business.labor.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.labor.bean.SalaryDetailEntity;
import com.ejianc.business.labor.bean.SalarySlipEntity;
/**
 * 劳务工资单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_labor_salary")
public class SalaryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="salary_month")
    private Date salaryMonth; // 工资月份
    @TableField(value="labor_type")
    private Integer laborType; // 劳务类型
    @TableField(value="labor_type_name")
    private String laborTypeName; // 劳务类型名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织d
    @TableField(value="org_name")
    private String orgName; // 所属组织
    @TableField(value="should_salary_mny")
    private BigDecimal shouldSalaryMny; // 应发工资金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; //  经办人部门
    @TableField(value="handle_date")
    private Date handleDate; // 办理日期
    @TableField(value="memo")
    private String memo; //  备注
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="salaryDetailService")//此处有pid="xxx"，默认值pid="pid"
    private List<SalaryDetailEntity> salaryDetailList = new ArrayList<>(); // 劳务工资单-用工记录
    @TableField(exist=false)
    @SubEntity(serviceName="salarySlipService")//此处有pid="xxx"，默认值pid="pid"
    private List<SalarySlipEntity> salarySlipList = new ArrayList<>(); // 工资条
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getSalaryMonth() {
        return salaryMonth;
    }

    public void setSalaryMonth(Date salaryMonth) {
        this.salaryMonth = salaryMonth;
    }
    public Integer getLaborType() {
        return laborType;
    }

    public void setLaborType(Integer laborType) {
        this.laborType = laborType;
    }
    public String getLaborTypeName() {
        return laborTypeName;
    }

    public void setLaborTypeName(String laborTypeName) {
        this.laborTypeName = laborTypeName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getShouldSalaryMny() {
        return shouldSalaryMny;
    }

    public void setShouldSalaryMny(BigDecimal shouldSalaryMny) {
        this.shouldSalaryMny = shouldSalaryMny;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    public List<SalaryDetailEntity> getSalaryDetailList() {
        return salaryDetailList;
    }

    public void setSalaryDetailList(List<SalaryDetailEntity> salaryDetailList) {
        this.salaryDetailList = salaryDetailList;
    }
    public List<SalarySlipEntity> getSalarySlipList() {
        return salarySlipList;
    }

    public void setSalarySlipList(List<SalarySlipEntity> salarySlipList) {
        this.salarySlipList = salarySlipList;
    }
}
