package com.ejianc.business.labor.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.WorkerRegisterEntity;
import com.ejianc.business.labor.service.IWorkerRegisterService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.service.IOrgTeamService;

/**
 * 公司花名册班组
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("orgTeam")
public class OrgTeamController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOrgTeamService service;
    @Autowired
    private IWorkerRegisterService workerRegisterService;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "LABOR_ORG_TEAM";//此处需要根据实际修改

    @RequestMapping(value = "/lazyOrgTeamCategory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String,Object>>> lazyOrgTeamCategory (Long parentId){
        LambdaQueryWrapper<OrgTeamEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(parentId != null,OrgTeamEntity::getParentId,parentId);
        wrapper.eq(OrgTeamEntity::getTenantId,InvocationInfoProxy.getTenantid());
        List<OrgTeamEntity> list = service.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            List<OrgTeamVO> vos = BeanMapper.mapList(list, OrgTeamVO.class);
            List<Map> resultMapList = BeanMapper.mapList(vos, Map.class);
            resultMapList.forEach(l-> {
                if(l.get("isLeaf").equals(false)){
                    l.put("children", new ArrayList<>());
                }
            });
            return CommonResponse.success(ResultAsTree.createTreeData(resultMapList));
        }else{
            //TODO 没有数据需要插入一条名称为当前根组织的班组
            OrgTeamEntity orgTeamEntity = new OrgTeamEntity();
            Long id = IdWorker.getId();
            CommonResponse<OrgVO> orgRes = iOrgApi.getOneById(InvocationInfoProxy.getOrgId());
            orgTeamEntity.setId(id);
            orgTeamEntity.setName(orgRes.getData().getName());
            orgTeamEntity.setInnerCode(id.toString());
            orgTeamEntity.setIsLeaf(true);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),new OrgTeamVO());
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                orgTeamEntity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            service.save(orgTeamEntity);
            List<OrgTeamEntity> list1 = new ArrayList<>();
            list1.add(orgTeamEntity);
            List<Map> resultMapList = BeanMapper.mapList(list1, Map.class);
            resultMapList.forEach(l-> {
                if(l.get("isLeaf").equals(false)){
                    l.put("children", new ArrayList<>());
                }
            });
            return CommonResponse.success(ResultAsTree.createTreeData(resultMapList));
        }
    }


    /**
     * 参照异步（懒加载）树----物资分类树
     * @param condition
     * @param pid
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/lazyOrgTeamTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> lazyOrgTeamTree(@RequestParam(required=false) String condition,
                                                              @RequestParam(required=false) Long pid, @RequestParam(required = false) String searchText) {
        List<OrgTeamVO> dataList = null;
        try {
            Map<String,Object> params = new HashMap<>();
            if(StringUtils.isNotBlank(searchText)) {
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
                dataList = service.queryListTree(params);
            }else{
                dataList = service.queryListByPid(pid);
                if(StringUtils.isNotBlank(condition)){
                    /** 处理condition */
                    JSONObject con = JSONObject.parseObject(condition);
                    Object categoryIdObj = con.get("categoryId");
                    if (null != categoryIdObj && pid == null) {
                        List<Long> asList = new ArrayList<>();
                        String categoryId = ((String) categoryIdObj);
                        if(categoryId.indexOf(",") > 0){
                            String[] strings = categoryId.split(",");
                            for(String str : strings){
                                asList.add(Long.valueOf(str));
                            }
                        }else{
                            asList.add(Long.valueOf(categoryId));
                        }
                        dataList = service.queryCategoryListByIds(asList);
                    }
                }
            }
            List<Map> map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData(map);
        }catch (Exception e){
            return null;
        }
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrgTeamVO> saveOrUpdate(@RequestBody OrgTeamVO saveOrUpdateVO) {
        OrgTeamVO vo = service.insertOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgTeamVO> queryDetail(Long id) {
    	OrgTeamEntity entity = service.selectById(id);
    	OrgTeamVO vo = BeanMapper.map(entity, OrgTeamVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrgTeamVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OrgTeamVO vo : vos) {
                OrgTeamEntity teamEntity = service.getById(vo.getId());
                if(teamEntity.getParentId()==null){
                    return CommonResponse.error("删除失败，根班组无法删除！");
                }
                //先查询该班组下是否有子级班组，如果有则无法删除
                LambdaQueryWrapper<OrgTeamEntity> wrapper = new LambdaQueryWrapper();
                wrapper.eq(OrgTeamEntity::getParentId,vo.getId());
                wrapper.eq(OrgTeamEntity::getDr,0);
                List<OrgTeamEntity> list = service.list(wrapper);
                if(CollectionUtils.isNotEmpty(list) && list.size()>0){
                    return CommonResponse.error("删除失败，该班组下有子级，无法删除！");
                }
                // 还需要判断该班组下是否有人员 有则不许删除
                LambdaQueryWrapper<WorkerRegisterEntity> wrapper1 = new LambdaQueryWrapper<>();
                wrapper1.eq(WorkerRegisterEntity::getTeamId,vo.getId());
                wrapper1.eq(WorkerRegisterEntity::getDr,0);
                List<WorkerRegisterEntity> list1 = workerRegisterService.list(wrapper1);
                if(CollectionUtils.isNotEmpty(list1)){
                    return CommonResponse.error("删除失败，该班组下有人员，无法删除！");
                }
            }
        }
        OrgTeamEntity entity = service.selectById(vos.get(0).getId());
        service.removeByIds(vos.stream().map(OrgTeamVO::getId).collect(Collectors.toList()),true);
        for (OrgTeamVO vo : vos) {
            //删除后上级班组没有子级时更改上级班组的isLeaf字段
            LambdaQueryWrapper<OrgTeamEntity> wrapper = new LambdaQueryWrapper();
            wrapper.eq(OrgTeamEntity::getParentId,vo.getId());
            wrapper.eq(OrgTeamEntity::getDr,0);
            List<OrgTeamEntity> list = service.list(wrapper);
            if(CollectionUtils.isEmpty(list) || list.size()==0){

                LambdaUpdateWrapper<OrgTeamEntity> updateWrapper = new LambdaUpdateWrapper<>();
                updateWrapper.set(OrgTeamEntity::getIsLeaf,1);
                updateWrapper.eq(OrgTeamEntity::getId,entity.getParentId());
                service.update(updateWrapper);
            }
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrgTeamVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OrgTeamEntity> page = service.queryPage(param,false);
        IPage<OrgTeamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrgTeamVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OrgTeamEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OrgTeam-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOrgTeamData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OrgTeamVO>> refOrgTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OrgTeamEntity> page = service.queryPage(param,false);
        IPage<OrgTeamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrgTeamVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
