package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.*;
import com.ejianc.business.labor.enums.LastFlagEnum;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.labor.mapper.WorkRecordMapper;
import com.ejianc.business.labor.service.IWorkRecordService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 用工记录
 * 
 * @author generator
 * 
 */
@Service("workRecordService")
public class WorkRecordServiceImpl extends BaseServiceImpl<WorkRecordMapper, WorkRecordEntity> implements IWorkRecordService{


    @Autowired
    private IWorkerService workerService;
    @Autowired
    private IWorkerEnterService workerEnterService;
    /**
     * 公司推送 设置:
     *      teamId teamName orgTeamId orgTeamName
     *      workType workTypeName orgWorkType  orgWorkTypeName
     *
     *
     * 项目推送 设置:
     *      teamId teamName projectTeamId projectTeamName
     *      workType workTypeName projectWorkType projectWorkTypeName
     *
     *
     * 设置来源: sourceFlag 来源（1自制-劳务进场单、2公司花名册、3邀请）
     * @param voList
     * @return
     */
    @Override
    public List<WorkRecordVO> insertWorkRecord(List<WorkRecordVO> voList){
        List<WorkRecordVO> returnList = new ArrayList<>();
        for (WorkRecordVO vo:voList){
            //根据用户 id 查询
            QueryWrapper<WorkRecordEntity> query = new QueryWrapper<>();
            query.eq("project_id", vo.getPhone());
            query.eq("last_flag", LastFlagEnum.是.getStatus());
            WorkRecordEntity one = super.getOne(query);
            //存在修改旧的
            if (one!=null){
                LambdaUpdateWrapper<WorkRecordEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.set(WorkRecordEntity::getLastFlag,LastFlagEnum.否.getStatus());
                wrapper.eq(WorkRecordEntity::getId,one.getId());
                super.update(wrapper);
            }
            WorkRecordEntity entity = BeanMapper.map(vo, WorkRecordEntity.class);
            entity.setLastFlag(LastFlagEnum.是.getStatus());
            super.saveOrUpdate(entity);
            WorkRecordVO recordVO = BeanMapper.map(entity, WorkRecordVO.class);
            returnList.add(recordVO);
        }
        return returnList;
    }

    /**
     *  如修改了基本信息（除班组外）
     *  修改后会自动同步公司花名册
     * @param vo
     * @return
     */
    @Override
    public WorkRecordVO updateWorkRecord(WorkRecordVO vo) {
        WorkRecordEntity entity = BeanMapper.map(vo, WorkRecordEntity.class);
        super.saveOrUpdate(entity,false);

        if (entity.getSourceFlag()==2){
            //TODO 回写数据到 公司花名册 班组外
            WorkerEntity workerEntity = workerService.selectById(entity.getSourceId());
            if (workerEntity!=null){
                // 最后更新的项目id
                workerEntity.setLastProjectId(entity.getProjectId());
                if (entity.getName()!=null){//姓名
                    workerEntity.setName(workerEntity.getName());
                }
                if (entity.getPhone()!=null){//手机号
                    workerEntity.setPhone(workerEntity.getPhone());
                }
                if (entity.getSex()!=null){//性别
                    workerEntity.setSex(workerEntity.getSex());
                }
                if (entity.getBirthDate()!=null){//出生年月
                    workerEntity.setBirthDate(workerEntity.getBirthDate());
                }
                if (entity.getNation()!=null){// 民族
                    workerEntity.setNation(workerEntity.getNation());
                }
                if (entity.getWorkType()!=null){// 工种
                    workerEntity.setWorkType(workerEntity.getWorkType());
                }
                if (entity.getWorkTypeName()!=null){// 工种名称
                    workerEntity.setWorkTypeName(workerEntity.getWorkTypeName());
                }
                if (entity.getBankName()!=null){// 开户行
                    workerEntity.setBankName(workerEntity.getBankName());
                }
                if (entity.getBankAccount()!=null){// 银行账号
                    workerEntity.setBankAccount(workerEntity.getBankAccount());
                }
                if (entity.getWagesType()!=null){// 工资类型
                    workerEntity.setWagesType(workerEntity.getWagesType());
                }
                if (entity.getWagesTypeName()!=null){// 工资类型名称
                    workerEntity.setWagesTypeName(workerEntity.getWagesTypeName());
                }
                if (entity.getWage()!=null){// 工价
                    workerEntity.setWage(workerEntity.getWage());
                }
                if (entity.getProvince()!=null){// 省
                    workerEntity.setProvince(workerEntity.getProvince());
                }
                if (entity.getCity()!=null){// 市
                    workerEntity.setCity(workerEntity.getCity());
                }
                if (entity.getArea()!=null){// 省市
                    workerEntity.setArea(workerEntity.getArea());
                }
                if (entity.getAddress()!=null){// 详细地址
                    workerEntity.setAddress(workerEntity.getAddress());
                }
                if (entity.getWagesTypeName()!=null){// 工资类型名称
                    workerEntity.setWagesTypeName(workerEntity.getWagesTypeName());
                }
                if (entity.getMemo()!=null){// 工资类型名称
                    workerEntity.setMemo(workerEntity.getMemo());
                }
                workerService.saveOrUpdate(workerEntity);
            }

        }
        if (entity.getSourceFlag()==1){
            //TODO 分包合同、供应商：修改时需要回写对应的进场记录；
            WorkerEnterEntity workerEnterEntity = workerEnterService.selectById(entity.getSourceId());
            if (workerEnterEntity!=null){
                if (entity.getSubContractId()!=null){
                    // 分包合同、供应商
                    workerEnterEntity.setSubContractId(entity.getSubContractId());
                    workerEnterEntity.setSubContractName(entity.getSubContractName());
                    workerEnterEntity.setSupplierId(entity.getSupplierId());
                    workerEnterEntity.setSubContractName(entity.getSupplierName());
                }
                workerEnterService.saveOrUpdate(workerEnterEntity);
            }
        }
        WorkRecordVO returnVo = BeanMapper.map(entity, WorkRecordVO.class);
        return returnVo;
    }

    @Override
    public WorkRecordVO updateBatWorker(WorkRecordVO updateVO) {
        List<Long> ids = updateVO.getIds();//用户ids
        String teamId = updateVO.getTeamId();//所选班组
        String teamName = updateVO.getTeamName();//班组名称
        String workType = updateVO.getWorkType();//所选工种
        String workTypeName = updateVO.getWorkTypeName();//工种名称
        Long supplierId = updateVO.getSupplierId();
        String supplierName = updateVO.getSupplierName();
        Long subContractId = updateVO.getSubContractId();
        String subContractName = updateVO.getSubContractName();
        if(CollectionUtils.isNotEmpty(ids)){
            if(teamName!=null || workType!=null||subContractId!=null){
                LambdaUpdateWrapper<WorkRecordEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.set(teamId!=null,WorkRecordEntity::getTeamId,teamId);
                wrapper.set(teamId!=null,WorkRecordEntity::getTeamName,teamName);
                wrapper.set(workType!=null,WorkRecordEntity::getWorkType,workType);
                wrapper.set(workType!=null,WorkRecordEntity::getWorkTypeName,workTypeName);

                wrapper.set(supplierId!=null,WorkRecordEntity::getSupplierId,supplierId);
                wrapper.set(supplierName!=null,WorkRecordEntity::getSupplierName,supplierName);
                wrapper.set(subContractId!=null,WorkRecordEntity::getSubContractId,subContractId);
                wrapper.set(subContractName!=null,WorkRecordEntity::getSubContractName,subContractName);
                wrapper.in(WorkRecordEntity::getId,ids);
                super.update(wrapper);
            }
        }
        return updateVO;
    }
}
