package com.ejianc.business.labor.service.impl;

import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.service.IFaceService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.FaceInfoVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("worker")
public class WorkerBpmServiceImpl implements ICommonBusinessService {

	private static final String BILL_TYPE = "BT202211000007";
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	@Resource
	private IWorkerService service;
	@Resource
	private IFaceService faceService;
	@Resource
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 *
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		// 查询单据信息
		WorkerEntity entity = service.selectById(billId);
		if (null == entity) {
			return CommonResponse.error("单据已不存在！");
		}

		// 获取人脸图片地址
		CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(billId, BILL_TYPE, "face", null);
		if (!response.isSuccess() || CollectionUtils.isEmpty(response.getData())) {
			logger.info("获取人脸图片地址，入参：sourceId-{}，billType-{}", billId, BILL_TYPE);
			return CommonResponse.error("获取人脸图片地址失败，失败原因：{}", response.getMsg());
		}
		List<AttachmentVO> faceAttachmentVOList = response.getData();
		AttachmentVO faceAttachmentVO = faceAttachmentVOList.get(0);

		try {
			// 单据生效进行人脸注册
			FaceInfoVO faceInfoVO = new FaceInfoVO();
			faceInfoVO.setUserId(Long.valueOf(entity.getIdCard()));
			faceInfoVO.setUserName(entity.getName());
			faceInfoVO.setIdNumber(entity.getIdCard());
			faceInfoVO.setImgUrl(faceAttachmentVO.getTruePath());
			faceService.faceRegistration(faceInfoVO);
		} catch (Exception e) {
			logger.info("公司花名册单据生效人脸注册失败，失败原因：{}", e.getMessage());
			e.printStackTrace();
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
