/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.mapper.OrgTeamMapper;
import com.ejianc.business.labor.service.IOrgTeamService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orgTeamService")
public class OrgTeamServiceImpl
extends BaseServiceImpl<OrgTeamMapper, OrgTeamEntity>
implements IOrgTeamService {
    @Autowired
    private OrgTeamMapper orgTeamMapper;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "LABOR_ORG_TEAM";

    @Override
    public List<OrgTeamVO> queryListTree(Map<String, Object> params) {
        List<OrgTeamVO> orgTeamList = this.orgTeamMapper.queryListTree(params);
        return orgTeamList;
    }

    @Override
    public List<OrgTeamVO> queryListByPid(Long id) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<OrgTeamVO> orgTeamList = this.orgTeamMapper.queryListByPid(tenantId, id);
        return orgTeamList;
    }

    @Override
    public List<OrgTeamVO> queryCategoryListByIds(List<Long> ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Long tenantId = InvocationInfoProxy.getTenantid();
        params.put("tenantId", tenantId);
        params.put("ids", ids);
        List<OrgTeamVO> orgTeamList = this.orgTeamMapper.queryListByIds(params);
        return orgTeamList;
    }

    @Override
    public OrgTeamVO insertOrUpdate(OrgTeamVO saveOrUpdateVO) {
        OrgTeamEntity entity = (OrgTeamEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OrgTeamEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        Long parentId = entity.getParentId();
        LambdaUpdateWrapper curWrapper = new LambdaUpdateWrapper();
        curWrapper.eq(BaseEntity::getId, (Object)entity.getId());
        String innerCode = entity.getId().toString();
        if (parentId != null) {
            LambdaUpdateWrapper parentWrapper = new LambdaUpdateWrapper();
            parentWrapper.set(OrgTeamEntity::getIsLeaf, (Object)false);
            parentWrapper.eq(BaseEntity::getId, (Object)parentId);
            this.update((Wrapper)parentWrapper);
            OrgTeamEntity parentEntity = (OrgTeamEntity)((Object)this.selectById(entity.getParentId()));
            innerCode = parentEntity.getInnerCode() + "|" + entity.getId();
            curWrapper.set(OrgTeamEntity::getParentCode, (Object)parentEntity.getCode());
        }
        curWrapper.set(OrgTeamEntity::getInnerCode, (Object)innerCode);
        LambdaQueryWrapper childQueryWrapper = new LambdaQueryWrapper();
        childQueryWrapper.ne(BaseEntity::getId, (Object)entity.getId());
        childQueryWrapper.likeRight(OrgTeamEntity::getInnerCode, (Object)entity.getInnerCode());
        List childList = this.list((Wrapper)childQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)childList)) {
            for (OrgTeamEntity childOrgTeamEntity : childList) {
                LambdaUpdateWrapper childUpdWrapper = new LambdaUpdateWrapper();
                childUpdWrapper.set(OrgTeamEntity::getInnerCode, (Object)(innerCode + "|" + childOrgTeamEntity.getId()));
                childUpdWrapper.eq(BaseEntity::getId, (Object)childOrgTeamEntity.getId());
                this.update((Wrapper)childUpdWrapper);
            }
            curWrapper.set(OrgTeamEntity::getIsLeaf, (Object)Boolean.FALSE);
        } else {
            curWrapper.set(OrgTeamEntity::getIsLeaf, (Object)Boolean.TRUE);
        }
        this.update((Wrapper)curWrapper);
        OrgTeamVO vo = (OrgTeamVO)BeanMapper.map((Object)((Object)entity), OrgTeamVO.class);
        return vo;
    }
}

