/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.enums.LastFlagEnum;
import com.ejianc.business.labor.mapper.WorkRecordMapper;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workRecordService")
public class WorkRecordServiceImpl
extends BaseServiceImpl<WorkRecordMapper, WorkRecordEntity>
implements IWorkRecordService {
    @Autowired
    private IWorkerService workerService;
    @Autowired
    private IWorkerEnterService workerEnterService;

    @Override
    public List<WorkRecordVO> insertWorkRecord(List<WorkRecordVO> voList) {
        ArrayList<WorkRecordVO> returnList = new ArrayList<WorkRecordVO>();
        for (WorkRecordVO vo : voList) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"project_id", (Object)vo.getPhone());
            query.eq((Object)"last_flag", (Object)LastFlagEnum.\u662f.getStatus());
            WorkRecordEntity one = (WorkRecordEntity)((Object)super.getOne((Wrapper)query));
            if (one != null) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.set(WorkRecordEntity::getLastFlag, (Object)LastFlagEnum.\u5426.getStatus());
                wrapper.eq(BaseEntity::getId, (Object)one.getId());
                super.update((Wrapper)wrapper);
            }
            WorkRecordEntity entity = (WorkRecordEntity)((Object)BeanMapper.map((Object)vo, WorkRecordEntity.class));
            entity.setLastFlag(LastFlagEnum.\u662f.getStatus());
            super.saveOrUpdate((Object)entity);
            WorkRecordVO recordVO = (WorkRecordVO)BeanMapper.map((Object)((Object)entity), WorkRecordVO.class);
            returnList.add(recordVO);
        }
        return returnList;
    }

    @Override
    public WorkRecordVO updateWorkRecord(WorkRecordVO vo) {
        WorkerEnterEntity workerEnterEntity;
        WorkerEntity workerEntity;
        WorkRecordEntity entity = (WorkRecordEntity)((Object)BeanMapper.map((Object)vo, WorkRecordEntity.class));
        super.saveOrUpdate((Object)entity, false);
        if (entity.getSourceFlag() == 2 && (workerEntity = (WorkerEntity)((Object)this.workerService.selectById(entity.getSourceId()))) != null) {
            workerEntity.setLastProjectId(entity.getProjectId());
            if (entity.getName() != null) {
                workerEntity.setName(workerEntity.getName());
            }
            if (entity.getPhone() != null) {
                workerEntity.setPhone(workerEntity.getPhone());
            }
            if (entity.getSex() != null) {
                workerEntity.setSex(workerEntity.getSex());
            }
            if (entity.getBirthDate() != null) {
                workerEntity.setBirthDate(workerEntity.getBirthDate());
            }
            if (entity.getNation() != null) {
                workerEntity.setNation(workerEntity.getNation());
            }
            if (entity.getWorkType() != null) {
                workerEntity.setWorkType(workerEntity.getWorkType());
            }
            if (entity.getWorkTypeName() != null) {
                workerEntity.setWorkTypeName(workerEntity.getWorkTypeName());
            }
            if (entity.getBankName() != null) {
                workerEntity.setBankName(workerEntity.getBankName());
            }
            if (entity.getBankAccount() != null) {
                workerEntity.setBankAccount(workerEntity.getBankAccount());
            }
            if (entity.getWagesType() != null) {
                workerEntity.setWagesType(workerEntity.getWagesType());
            }
            if (entity.getWagesTypeName() != null) {
                workerEntity.setWagesTypeName(workerEntity.getWagesTypeName());
            }
            if (entity.getWage() != null) {
                workerEntity.setWage(workerEntity.getWage());
            }
            if (entity.getProvince() != null) {
                workerEntity.setProvince(workerEntity.getProvince());
            }
            if (entity.getCity() != null) {
                workerEntity.setCity(workerEntity.getCity());
            }
            if (entity.getArea() != null) {
                workerEntity.setArea(workerEntity.getArea());
            }
            if (entity.getAddress() != null) {
                workerEntity.setAddress(workerEntity.getAddress());
            }
            if (entity.getWagesTypeName() != null) {
                workerEntity.setWagesTypeName(workerEntity.getWagesTypeName());
            }
            if (entity.getMemo() != null) {
                workerEntity.setMemo(workerEntity.getMemo());
            }
            this.workerService.saveOrUpdate((Object)workerEntity);
        }
        if (entity.getSourceFlag() == 1 && (workerEnterEntity = (WorkerEnterEntity)((Object)this.workerEnterService.selectById(entity.getSourceId()))) != null) {
            if (entity.getSubContractId() != null) {
                workerEnterEntity.setSubContractId(entity.getSubContractId());
                workerEnterEntity.setSubContractName(entity.getSubContractName());
                workerEnterEntity.setSupplierId(entity.getSupplierId());
                workerEnterEntity.setSubContractName(entity.getSupplierName());
            }
            this.workerEnterService.saveOrUpdate((Object)workerEnterEntity);
        }
        WorkRecordVO returnVo = (WorkRecordVO)BeanMapper.map((Object)((Object)entity), WorkRecordVO.class);
        return returnVo;
    }

    @Override
    public WorkRecordVO updateBatWorker(WorkRecordVO updateVO) {
        List ids = updateVO.getIds();
        String teamId = updateVO.getTeamId();
        String teamName = updateVO.getTeamName();
        String workType = updateVO.getWorkType();
        String workTypeName = updateVO.getWorkTypeName();
        Long supplierId = updateVO.getSupplierId();
        String supplierName = updateVO.getSupplierName();
        Long subContractId = updateVO.getSubContractId();
        String subContractName = updateVO.getSubContractName();
        if (CollectionUtils.isNotEmpty((Collection)ids) && (teamName != null || workType != null || subContractId != null)) {
            LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
            wrapper.set(teamId != null, WorkRecordEntity::getTeamId, (Object)teamId);
            wrapper.set(teamId != null, WorkRecordEntity::getTeamName, (Object)teamName);
            wrapper.set(workType != null, WorkRecordEntity::getWorkType, (Object)workType);
            wrapper.set(workType != null, WorkRecordEntity::getWorkTypeName, (Object)workTypeName);
            wrapper.set(supplierId != null, WorkRecordEntity::getSupplierId, (Object)supplierId);
            wrapper.set(supplierName != null, WorkRecordEntity::getSupplierName, (Object)supplierName);
            wrapper.set(subContractId != null, WorkRecordEntity::getSubContractId, (Object)subContractId);
            wrapper.set(subContractName != null, WorkRecordEntity::getSubContractName, (Object)subContractName);
            wrapper.in(BaseEntity::getId, (Collection)ids);
            super.update((Wrapper)wrapper);
        }
        return updateVO;
    }
}

