/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.service.IFaceService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.FaceInfoVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="worker")
public class WorkerBpmServiceImpl
implements ICommonBusinessService {
    private static final String BILL_TYPE = "BT202211000007";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Resource
    private IWorkerService service;
    @Resource
    private IFaceService faceService;
    @Resource
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        WorkerEntity entity = (WorkerEntity)((Object)this.service.selectById(billId));
        if (null == entity) {
            return CommonResponse.error((String)"\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        CommonResponse response = this.attachmentApi.queryListBySourceId(billId, BILL_TYPE, "face", null);
        if (!response.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            this.logger.info("\u83b7\u53d6\u4eba\u8138\u56fe\u7247\u5730\u5740\uff0c\u5165\u53c2\uff1asourceId-{}\uff0cbillType-{}", (Object)billId, (Object)BILL_TYPE);
            return CommonResponse.error((String)"\u83b7\u53d6\u4eba\u8138\u56fe\u7247\u5730\u5740\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)response.getMsg());
        }
        List faceAttachmentVOList = (List)response.getData();
        AttachmentVO faceAttachmentVO = (AttachmentVO)faceAttachmentVOList.get(0);
        try {
            FaceInfoVO faceInfoVO = new FaceInfoVO();
            faceInfoVO.setUserId(Long.valueOf(entity.getIdCard()));
            faceInfoVO.setUserName(entity.getName());
            faceInfoVO.setIdNumber(entity.getIdCard());
            faceInfoVO.setImgUrl(faceAttachmentVO.getTruePath());
            this.faceService.faceRegistration(faceInfoVO);
        }
        catch (Exception e) {
            this.logger.info("\u516c\u53f8\u82b1\u540d\u518c\u5355\u636e\u751f\u6548\u4eba\u8138\u6ce8\u518c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

