package com.ejianc.business.labor.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.labor.bean.WorktimeSetDetailEntity;
/**
 * 考勤设置
 * 
 * @author generator
 * 
 */
 @TableName("ejc_labor_worktime_set")
public class WorktimeSetEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="off_site_flag")
    private Integer offSiteFlag; // 是否允许异地打卡（1:是 0：否）
    @TableField(value="enable")
    private Integer enable; // 是否启用（1:是 0：否）
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="memo")
    private String memo; // 描述
    @TableField(value="attendance_address")
    private String attendanceAddress; // 考勤地址
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="worktimeSetDetailService",pidName = "worktimeId")//此处有pid="xxx"，默认值pid="pid"
    private List<WorktimeSetDetailEntity> worktimeSetDetailList = new ArrayList<>(); // 考勤设置明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Integer getOffSiteFlag() {
        return offSiteFlag;
    }

    public void setOffSiteFlag(Integer offSiteFlag) {
        this.offSiteFlag = offSiteFlag;
    }
    public Integer getEnable() {
        return enable;
    }

    public void setEnable(Integer enable) {
        this.enable = enable;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    public List<WorktimeSetDetailEntity> getWorktimeSetDetailList() {
        return worktimeSetDetailList;
    }

    public void setWorktimeSetDetailList(List<WorktimeSetDetailEntity> worktimeSetDetailList) {
        this.worktimeSetDetailList = worktimeSetDetailList;
    }

    public String getAttendanceAddress() {
        return attendanceAddress;
    }

    public void setAttendanceAddress(String attendanceAddress) {
        this.attendanceAddress = attendanceAddress;
    }
}
