package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.WorktimeSetEntity;
import com.ejianc.business.labor.mapper.WorktimeSetMapper;
import com.ejianc.business.labor.service.IWorktimeSetService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/**
 * 考勤设置
 *
 * @author generator
 */
@Service("worktimeSetService")
public class WorktimeSetServiceImpl extends BaseServiceImpl<WorktimeSetMapper, WorktimeSetEntity> implements IWorktimeSetService {
	private static final String QR_CODE_LOGIN_URL = "ejc-labor-mobile/#/qrCodeLogin/card";
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Value("${common.env.base-host}")
	private String BaseHost;

	/**
	 * 考勤二维码
	 *
	 * @param id 考勤设置id
	 *
	 * @return {@link JSONObject}
	 */
	@Override
	public JSONObject getQrCode(Long id) {
		Assert.notNull(id, "考勤设置id不能为空！");
		WorktimeSetEntity entity = super.selectById(id);
		Assert.notNull(entity, "考勤设置信息不能为空！");

		JSONObject resp = new JSONObject();
		StringBuilder sb = new StringBuilder();
		sb.append("?worktimeSetId=").append(id)
				.append("&tenantId=").append(entity.getTenantId())
				.append("&projectId=").append(entity.getProjectId())
				.append("&projectName=").append(entity.getProjectName());
		resp.put("mobileH5Url", BaseHost + QR_CODE_LOGIN_URL + sb);
		resp.put("mobileWxUrl", BaseHost + QR_CODE_LOGIN_URL + sb);
		return resp;
	}
}
