/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.WorkerRegisterEntity;
import com.ejianc.business.labor.service.IOrgTeamService;
import com.ejianc.business.labor.service.IWorkerRegisterService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"orgTeam"})
public class OrgTeamController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOrgTeamService service;
    @Autowired
    private IWorkerRegisterService workerRegisterService;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "LABOR_ORG_TEAM";

    @RequestMapping(value={"/lazyOrgTeamCategory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> lazyOrgTeamCategory(Long parentId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        int count = this.service.count((Wrapper)wrapper);
        List<OrgTeamEntity> list = new ArrayList();
        if (count == 0) {
            OrgTeamEntity orgTeamEntity = new OrgTeamEntity();
            Long id = IdWorker.getId();
            CommonResponse orgRes = this.iOrgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());
            orgTeamEntity.setId(id);
            orgTeamEntity.setName(((OrgVO)orgRes.getData()).getName());
            orgTeamEntity.setInnerCode(id.toString());
            orgTeamEntity.setIsLeaf(true);
            orgTeamEntity.setCode("OT000001");
            this.service.save((Object)orgTeamEntity);
            list.add(orgTeamEntity);
        } else {
            wrapper.eq(parentId != null, OrgTeamEntity::getParentId, (Object)parentId);
            list = this.service.list((Wrapper)wrapper);
        }
        List resultMapList = BeanMapper.mapList(list, Map.class);
        return CommonResponse.success((Object)ResultAsTree.createTreeData((List)resultMapList));
    }

    @RequestMapping(value={"/lazyOrgTeamTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyOrgTeamTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("code", "name"));
        param.setSearchText(searchText);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("parentId", new Parameter("eq", (Object)pid));
        Object notContainsIdAndChild = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            notContainsIdAndChild = _con.get((Object)"notContainsIdAndChild");
        }
        List orgTeamEntities = this.service.queryList(param, false);
        List list = BeanMapper.mapList((Iterable)orgTeamEntities, Map.class);
        if (null != notContainsIdAndChild) {
            for (Map map : list) {
                String innerCode = String.valueOf(map.get("innerCode"));
                if (!innerCode.contains(String.valueOf(notContainsIdAndChild))) continue;
                map.put("disable", true);
            }
        }
        return ResultAsTree.createTreeData((List)list);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrgTeamVO> saveOrUpdate(@RequestBody OrgTeamVO saveOrUpdateVO) {
        OrgTeamVO vo = this.service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrgTeamVO> queryDetail(Long id) {
        OrgTeamEntity entity = (OrgTeamEntity)((Object)this.service.selectById(id));
        OrgTeamVO vo = (OrgTeamVO)BeanMapper.map((Object)((Object)entity), OrgTeamVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrgTeamVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OrgTeamVO vo : vos) {
                OrgTeamEntity teamEntity = (OrgTeamEntity)((Object)this.service.getById(vo.getId()));
                if (teamEntity.getParentId() == null) {
                    return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u6839\u73ed\u7ec4\u65e0\u6cd5\u5220\u9664\uff01");
                }
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(OrgTeamEntity::getParentId, (Object)vo.getId());
                int count = this.service.count((Wrapper)wrapper);
                if (count > 0) {
                    return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u8be5\u73ed\u7ec4\u4e0b\u6709\u5b50\u7ea7\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
                }
                LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
                wrapper1.eq(WorkerRegisterEntity::getTeamId, (Object)vo.getId());
                int count1 = this.workerRegisterService.count((Wrapper)wrapper1);
                if (count1 <= 0) continue;
                return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff0c\u8be5\u73ed\u7ec4\u4e0b\u6709\u4eba\u5458\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            }
        }
        List delOrgTeamIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (OrgTeamVO vo : vos) {
            OrgTeamEntity entity = (OrgTeamEntity)((Object)this.service.selectById(vo.getId()));
            Long parentId = entity.getParentId();
            if (parentId == null) continue;
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(OrgTeamEntity::getParentId, (Object)parentId);
            wrapper.notIn(BaseEntity::getId, delOrgTeamIds);
            int count = this.service.count((Wrapper)wrapper);
            if (count != 0) continue;
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(OrgTeamEntity::getIsLeaf, (Object)Boolean.TRUE);
            updateWrapper.eq(BaseEntity::getId, (Object)parentId);
            this.service.update((Wrapper)updateWrapper);
        }
        this.service.removeByIds(delOrgTeamIds);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrgTeamVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgTeamVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OrgTeam-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refOrgTeamData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrgTeamVO>> refOrgTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrgTeamVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

