/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.business.labor.vo.ProjectTeamVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectTeam"})
public class ProjectTeamController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectApi projectApi;
    private static final String BILL_CODE = "LABOR_PROJECT_TEAM";
    @Autowired
    private IProjectTeamService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IWorkerEnterService workerEnterService;

    @RequestMapping(value={"/lazyTeamCategory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> lazyTeamCategory(Long parentId) {
        if (!OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            throw new BusinessException("\u5f53\u524d\u767b\u5f55\u4e0d\u662f\u9879\u76ee\u90e8");
        }
        if (parentId == null) {
            CommonResponse projectRegisterVOCommonResponse = this.projectApi.queryProjectByProjectDepartmentId(InvocationInfoProxy.getOrgId().toString());
            ProjectRegisterVO project = (ProjectRegisterVO)projectRegisterVOCommonResponse.getData();
            LambdaQueryWrapper wrapperByProject = new LambdaQueryWrapper();
            wrapperByProject.eq(project.getId() != null, ProjectTeamEntity::getProjectId, (Object)project.getId());
            wrapperByProject.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            List list = this.service.list((Wrapper)wrapperByProject);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List vos = BeanMapper.mapList((Iterable)list, ProjectTeamVO.class);
                List resultMapList = BeanMapper.mapList((Iterable)vos, Map.class);
                for (Map map : resultMapList) {
                    System.out.println(map);
                    if (!map.get("isLeaf").equals(false)) continue;
                    map.put("children", new ArrayList());
                }
                return CommonResponse.success((Object)ResultAsTree.createTreeData((List)resultMapList));
            }
            ProjectTeamEntity entity = new ProjectTeamEntity();
            Long id = IdWorker.getId();
            entity.setId(id);
            entity.setInnerCode(id.toString());
            entity.setIsLeaf(true);
            UserContext userContext = UserContext.getUserContext();
            userContext.getOrgType();
            entity.setName(project.getName());
            entity.setProjectId(project.getId());
            entity.setProjectName(project.getName());
            entity.setOrgId(project.getProjectDepartmentId());
            entity.setParentOrgId(project.getOrgId());
            entity.setParentOrgName(project.getOrgName());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)new OrgTeamVO());
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            this.service.save((Object)entity);
            List listTwo = this.service.list((Wrapper)wrapperByProject);
            if (CollectionUtils.isNotEmpty((Collection)listTwo)) {
                List vos = BeanMapper.mapList((Iterable)listTwo, ProjectTeamVO.class);
                List resultMapList = BeanMapper.mapList((Iterable)vos, Map.class);
                for (Map map : resultMapList) {
                    System.out.println(map);
                    if (!map.get("isLeaf").equals(false)) continue;
                    map.put("children", new ArrayList());
                }
                return CommonResponse.success((Object)ResultAsTree.createTreeData((List)resultMapList));
            }
        } else {
            LambdaQueryWrapper wrapperByParentId = new LambdaQueryWrapper();
            wrapperByParentId.eq(parentId != null, ProjectTeamEntity::getParentId, (Object)parentId);
            wrapperByParentId.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            List list = this.service.list((Wrapper)wrapperByParentId);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List vos = BeanMapper.mapList((Iterable)list, ProjectTeamVO.class);
                List resultMapList = BeanMapper.mapList((Iterable)vos, Map.class);
                for (Map map : resultMapList) {
                    System.out.println(map);
                    if (!map.get("isLeaf").equals(false)) continue;
                    map.put("children", new ArrayList());
                }
                return CommonResponse.success((Object)ResultAsTree.createTreeData((List)resultMapList));
            }
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/lazyTeamTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyTeamTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        QueryParam param = new QueryParam();
        Object notContainsIdAndChild = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            notContainsIdAndChild = _con.get((Object)"notContainsIdAndChild");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (pid != null) {
            param.getParams().put("parent_id", new Parameter("eq", (Object)pid));
        }
        List projectTeamEntities = this.service.queryList(param);
        List list = BeanMapper.mapList((Iterable)projectTeamEntities, Map.class);
        if (null != notContainsIdAndChild) {
            for (Map map : list) {
                String innerCode = String.valueOf(map.get("innerCode"));
                if (!innerCode.contains(String.valueOf(notContainsIdAndChild))) continue;
                map.put("disable", true);
            }
        }
        return ResultAsTree.createTreeData((List)list);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectTeamVO> saveOrUpdate(@RequestBody ProjectTeamVO saveOrUpdateVO) {
        ProjectTeamVO projectTeamVO = this.service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)projectTeamVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectTeamVO> queryDetail(Long id) {
        ProjectTeamEntity entity = (ProjectTeamEntity)((Object)this.service.selectById(id));
        ProjectTeamVO vo = (ProjectTeamVO)BeanMapper.map((Object)((Object)entity), ProjectTeamVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectTeamVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectTeamVO projectTeamVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryList(@RequestBody QueryParam param) {
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        param.getParams().put("status", new Parameter("eq", (Object)2));
        param.getParams().put("validStatus", new Parameter("eq", (Object)0));
        CommonResponse projectResponse = this.projectApi.queryProjectPage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u9879\u76ee\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List records = ((Page)projectResponse.getData()).getRecords();
        for (ProjectRegisterVO vo : records) {
            JSONObject jsonObject = new JSONObject();
            LambdaQueryWrapper workNumLambda = new LambdaQueryWrapper();
            workNumLambda.eq(WorkerEnterEntity::getProjectId, (Object)vo.getId());
            int workNum = this.workerEnterService.count((Wrapper)workNumLambda);
            jsonObject.put("workNum", (Object)workNum);
            LambdaQueryWrapper teamNumLambda = new LambdaQueryWrapper();
            teamNumLambda.eq(ProjectTeamEntity::getProjectId, (Object)vo.getId());
            teamNumLambda.isNotNull(ProjectTeamEntity::getParentId);
            int teamNum = this.service.count((Wrapper)teamNumLambda);
            jsonObject.put("teamNum", (Object)teamNum);
            jsonObject.put("workTypeNum", (Object)0);
            LambdaQueryWrapper faceNumLambda = new LambdaQueryWrapper();
            faceNumLambda.eq(WorkerEnterEntity::getProjectId, (Object)vo.getId());
            faceNumLambda.eq(WorkerEnterEntity::getFacePhotoFlag, (Object)1);
            int faceCollection = this.workerEnterService.count((Wrapper)faceNumLambda);
            jsonObject.put("faceCollection", (Object)(faceCollection + "/" + workNum));
            String statusStr = "";
            statusStr = vo.getStatus().equals("1") ? "\u672a\u5f00\u5de5" : (vo.getStatus().equals("2") ? "\u5728\u5efa" : "\u5b8c\u6210");
            jsonObject.put("status", (Object)vo.getStatus());
            jsonObject.put("statusStr", (Object)statusStr);
            jsonObject.put("id", (Object)vo.getId());
            jsonObject.put("name", (Object)vo.getName());
            jsonObjects.add(jsonObject);
        }
        Page pageData = new Page(((Page)projectResponse.getData()).getCurrent(), ((Page)projectResponse.getData()).getSize(), ((Page)projectResponse.getData()).getTotal());
        pageData.setRecords(jsonObjects);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        HashMap beans = new HashMap();
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        param.getParams().put("status", new Parameter("eq", (Object)2));
        param.getParams().put("validStatus", new Parameter("eq", (Object)0));
        CommonResponse projectResponse = this.projectApi.queryProjectPage(param);
        if (!projectResponse.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u83b7\u53d6\u9879\u76ee\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List records = ((Page)projectResponse.getData()).getRecords();
        for (ProjectRegisterVO vo : records) {
            JSONObject jsonObject = new JSONObject();
            LambdaQueryWrapper workNumLambda = new LambdaQueryWrapper();
            workNumLambda.eq(WorkerEnterEntity::getProjectId, (Object)vo.getId());
            int workNum = this.workerEnterService.count((Wrapper)workNumLambda);
            jsonObject.put("workNum", (Object)workNum);
            LambdaQueryWrapper teamNumLambda = new LambdaQueryWrapper();
            teamNumLambda.eq(ProjectTeamEntity::getProjectId, (Object)vo.getId());
            teamNumLambda.isNotNull(ProjectTeamEntity::getParentId);
            int teamNum = this.service.count((Wrapper)teamNumLambda);
            jsonObject.put("teamNum", (Object)teamNum);
            jsonObject.put("workTypeNum", (Object)0);
            LambdaQueryWrapper faceNumLambda = new LambdaQueryWrapper();
            faceNumLambda.eq(WorkerEnterEntity::getProjectId, (Object)vo.getId());
            faceNumLambda.eq(WorkerEnterEntity::getFacePhotoFlag, (Object)1);
            int faceCollection = this.workerEnterService.count((Wrapper)faceNumLambda);
            jsonObject.put("faceCollection", (Object)(faceCollection + "/" + workNum));
            String statusStr = "";
            statusStr = vo.getStatus().equals("1") ? "\u672a\u5f00\u5de5" : (vo.getStatus().equals("2") ? "\u5728\u5efa" : "\u5b8c\u6210");
            jsonObject.put("statusStr", (Object)statusStr);
            jsonObject.put("id", (Object)vo.getId());
            jsonObject.put("name", (Object)vo.getName());
            jsonObjects.add(jsonObject);
        }
        beans.put("records", jsonObjects);
        ExcelExport.getInstance().export("ProjectTeam-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectTeamData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectTeamVO>> refProjectTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectTeamVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/insertBatch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> insertBatch(@RequestBody List<ProjectTeamVO> vos) {
        List<String> strings = this.service.insertBatch(vos);
        if (strings.size() > 0) {
            return CommonResponse.error((String)strings.toString());
        }
        return CommonResponse.success((String)"\u63d2\u5165\u6210\u529f");
    }
}

