/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.enums.LastFlagEnum;
import com.ejianc.business.labor.enums.TeamSourceFlagEnum;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"workRecord"})
public class WorkRecordController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IWorkRecordService service;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IWorkerService workerService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkRecordVO> saveOrUpdate(@RequestBody WorkRecordVO saveOrUpdateVO) {
        WorkRecordVO recordVO = this.service.updateWorkRecord(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)recordVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkRecordVO> queryDetail(Long id) {
        WorkRecordEntity entity = (WorkRecordEntity)((Object)this.service.selectById(id));
        WorkRecordVO vo = (WorkRecordVO)BeanMapper.map((Object)((Object)entity), WorkRecordVO.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"phone", (Object)entity.getPhone());
        queryWrapper.orderByDesc((Object)"enter_date");
        List list = this.service.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List recordVOS = BeanMapper.mapList((Iterable)list, WorkRecordVO.class);
            vo.setRecordList(recordVOS);
        }
        vo.setBillState(Integer.valueOf(0));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkRecordVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WorkRecordVO workRecordVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("projectId") && !param.getParams().containsKey("teamId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (param.getParams().containsKey("teamId")) {
            fuzzyFields.add("team_id");
            Parameter teamId = (Parameter)param.getParams().get("teamId");
            param.getParams().put("teamId", new Parameter("like", teamId.getValue()));
        }
        param.getOrderMap().putIfAbsent("enter_date", "desc");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("projectId") && !param.getParams().containsKey("teamId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (param.getParams().containsKey("teamId")) {
            fuzzyFields.add("team_id");
            Parameter teamId = (Parameter)param.getParams().get("teamId");
            param.getParams().put("teamId", new Parameter("like", teamId.getValue()));
        }
        param.getOrderMap().putIfAbsent("enter_date", "desc");
        IPage page = this.service.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", page.getRecords());
        ExcelExport.getInstance().export("WorkRecord-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWorkRecordData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> refWorkRecordData(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            // empty if block
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("last_flag", new Parameter("eq", (Object)LastFlagEnum.\u662f.getStatus()));
        param.getParams().put("enter_exit_state", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (conditionMap.containsKey("projectId")) {
                param.getParams().put("project_id", new Parameter("eq", conditionMap.get("projectId")));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("enter_date", "desc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkRecordVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refWorkRecordDataToLab"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkRecordVO>> refWorkRecordDataToLab(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            Long categoryId = Long.parseLong(relyCondition.split("=")[1]);
            param.getParams().put("team_id", new Parameter("eq", (Object)categoryId));
        }
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            // empty if block
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (conditionMap.containsKey("projectId")) {
                param.getParams().put("project_id", new Parameter("eq", conditionMap.get("projectId")));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("enter_date", "desc");
        orderMap.put("create_time", "desc");
        param.setOrderMap(orderMap);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List recordVOS = BeanMapper.mapList((Iterable)page.getRecords(), WorkRecordVO.class);
        for (WorkRecordVO vo : recordVOS) {
            vo.setCheckingDay(Integer.valueOf(10));
        }
        pageData.setRecords(recordVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/insertWorkRecord"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> insertWorkRecord(@RequestBody List<WorkerVO> vos) {
        ArrayList<String> errorMsg = new ArrayList<String>();
        ArrayList<WorkRecordVO> saveVoList = new ArrayList<WorkRecordVO>();
        ArrayList<Long> enterIdS = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(vos)) {
            Long projectId = vos.get(0).getRuteProjectId();
            CommonResponse projectDetail = this.projectApi.queryProjectDetail(projectId);
            if (!projectDetail.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u9879\u76ee\u4fe1\u606f\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            ProjectRegisterVO project = (ProjectRegisterVO)projectDetail.getData();
            QueryWrapper queryProject = new QueryWrapper();
            queryProject.eq((Object)"project_id", (Object)project.getId());
            queryProject.isNull((Object)"parent_id");
            ProjectTeamEntity projectTeam = (ProjectTeamEntity)((Object)this.projectTeamService.getOne((Wrapper)queryProject));
            for (WorkerVO vo : vos) {
                LambdaQueryWrapper lambdaCount = new LambdaQueryWrapper();
                lambdaCount.eq(WorkRecordEntity::getProjectId, (Object)projectTeam.getProjectId());
                lambdaCount.eq(WorkRecordEntity::getPhone, (Object)vo.getPhone());
                lambdaCount.eq(WorkRecordEntity::getEnterExitState, (Object)1);
                lambdaCount.eq(WorkRecordEntity::getLastFlag, (Object)1);
                int count = this.service.count((Wrapper)lambdaCount);
                if (count > 0) {
                    errorMsg.add("\u5f53\u9879\u76ee\u73ed\u7ec4\u4e2d\u8be5\u4eba\u5458" + vo.getName() + "\u5728\u573a");
                    continue;
                }
                WorkRecordVO record = (WorkRecordVO)BeanMapper.map((Object)vo, WorkRecordVO.class);
                record.setId(Long.valueOf(IdWorker.getId()));
                record.setWorkerId(vo.getId());
                record.setOrgTeamId(vo.getTeamId());
                record.setOrgTeamName(vo.getTeamName());
                record.setOrgWorkType(vo.getWorkType());
                record.setOrgWorkTypeName(vo.getWorkTypeName());
                record.setProjectAddress(project.getAddress());
                record.setSourceFlag(Integer.valueOf(2));
                record.setSourceFlagName("\u516c\u53f8\u82b1\u540d\u518c");
                record.setSourceId(vo.getId());
                record.setEnterExitState(Integer.valueOf(1));
                record.setProjectId(project.getId());
                record.setProjectName(project.getName());
                record.setOrgId(project.getProjectDepartmentId());
                record.setParentOrgId(project.getOrgId());
                record.setParentOrgName(project.getOrgName());
                if (StringUtils.isNotEmpty((CharSequence)vo.getTeamId())) {
                    List<String> teamIdS = Arrays.asList(vo.getTeamId().split(","));
                    LambdaQueryWrapper teamLambda = new LambdaQueryWrapper();
                    teamLambda.eq(ProjectTeamEntity::getProjectId, (Object)project.getId());
                    teamLambda.in(BaseEntity::getId, teamIdS);
                    teamLambda.eq(ProjectTeamEntity::getSourceFlag, (Object)TeamSourceFlagEnum.\u516c\u53f8.getStatus());
                    List list = this.projectTeamService.list((Wrapper)teamLambda);
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        String teamId = list.stream().map(BaseEntity::getId).collect(Collectors.toList()).stream().map(Objects::toString).collect(Collectors.joining(","));
                        String teamName = list.stream().map(ProjectTeamEntity::getName).collect(Collectors.toList()).stream().map(Objects::toString).collect(Collectors.joining(","));
                        record.setTeamId(teamId);
                        record.setTeamName(teamName);
                    } else {
                        record.setTeamId(null);
                        record.setTeamName(null);
                    }
                }
                enterIdS.add(vo.getId());
                saveVoList.add(record);
            }
        }
        if (CollectionUtils.isNotEmpty(saveVoList)) {
            this.service.insertWorkRecord(saveVoList);
            this.workerService.updateEnterStatusByIdS(enterIdS);
        }
        if (errorMsg.size() > 0) {
            return CommonResponse.error((String)((Object)errorMsg).toString());
        }
        return CommonResponse.success((String)"\u5f15\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/updateBatWorker"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkRecordVO> updateBatWorker(@RequestBody WorkRecordVO updateVO) {
        WorkRecordVO vo = this.service.updateBatWorker(updateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }
}

