/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.AttendanceBindEntity;
import com.ejianc.business.labor.bean.AttendanceLogEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.mapper.AttendanceLogMapper;
import com.ejianc.business.labor.service.IAmapService;
import com.ejianc.business.labor.service.IAttendanceBindService;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.utils.MockLogin;
import com.ejianc.business.labor.vo.DistanceVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="attendanceLogService")
public class AttendanceLogServiceImpl
extends BaseServiceImpl<AttendanceLogMapper, AttendanceLogEntity>
implements IAttendanceLogService {
    private static final String WEIXIN_OAUTH_2_URL = "https://api.weixin.qq.com/sns/oauth2/access_token";
    private static final String DEFAULT_TEMPLATE_CODE = "SMS_195335075";
    private static final String CODE = "Weixin";
    private static final String BILL_TYPE = "BT202211000002";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private EnvironmentTools environmentTools;
    @Resource
    private IThirdSystemApi thirdSystemApi;
    @Resource
    private IAmapService amapService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private MockLogin mockLogin;
    @Resource
    private IAttendanceBindService attendanceBindService;
    @Resource
    private IWorkRecordService workRecordService;
    @Resource
    private IAttachmentApi attachmentApi;

    @Override
    public void login(Long tenantId, Long projectId, String phone, String templateCode, String validate, String openid) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)validate, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)openid, (String)"openid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String checkMessageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/checkMessage";
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{templateCode})) {
            param.put("templateCode", templateCode);
        } else {
            param.put("templateCode", DEFAULT_TEMPLATE_CODE);
        }
        param.put("phone", phone);
        param.put("validate", validate);
        HttpResponse response = HttpUtil.createPost((String)checkMessageUrl).form(param).execute();
        if (!response.isOk()) {
            throw new BusinessException("\u6821\u9a8c\u9a8c\u8bc1\u7801\u5931\u8d25\uff01");
        }
        String checkBind = this.checkBind(tenantId, openid);
        if (StringUtils.isBlank((CharSequence)checkBind)) {
            AttendanceBindEntity attendanceBindEntity = new AttendanceBindEntity();
            attendanceBindEntity.setTenantId(tenantId);
            attendanceBindEntity.setPhone(phone);
            attendanceBindEntity.setOpenid(openid);
            this.attendanceBindService.saveOrUpdateNoES((Object)attendanceBindEntity);
        } else {
            LambdaUpdateWrapper lambdaUpdate = Wrappers.lambdaUpdate();
            lambdaUpdate.eq(AttendanceBindEntity::getOpenid, (Object)openid);
            lambdaUpdate.set(AttendanceBindEntity::getPhone, (Object)phone);
            this.attendanceBindService.update((Wrapper)lambdaUpdate);
        }
    }

    @Override
    public String getOpenId(String code) {
        Assert.hasText((String)code, (String)"\u4e34\u65f6\u767b\u5f55\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse thirdSystemResponse = this.thirdSystemApi.getOneByCode(CODE);
        if (!thirdSystemResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + thirdSystemResponse.getMsg());
        }
        ThirdSystemVO thirdSystemVO = (ThirdSystemVO)thirdSystemResponse.getData();
        String configInfo = thirdSystemVO.getConfigInfo();
        JSONObject configJson = JSON.parseObject((String)configInfo);
        String appId = configJson.getString("appid");
        String secret = configJson.getString("secret");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appid", appId);
        paramMap.put("secret", secret);
        paramMap.put("code", code);
        paramMap.put("grant_type", "authorization_code");
        HttpResponse response = HttpUtil.createGet((String)WEIXIN_OAUTH_2_URL).form(paramMap).execute();
        if (!response.isOk()) {
            throw new BusinessException("\u8bf7\u6c42\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)response.body());
        if (jsonObject.containsKey((Object)"errcode")) {
            throw new BusinessException("\u83b7\u53d6openid\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + jsonObject.getString("errmsg"));
        }
        return jsonObject.getString("openid");
    }

    @Override
    public JSONObject getWeiXinConfigData(String reqFrom, String url) {
        Assert.hasText((String)reqFrom, (String)"\u5ba2\u6237\u7aef\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)url, (String)"url\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("\u83b7\u53d6\u5fae\u4fe1\u914d\u7f6e\u6570\u636e: req_from = {}\uff0curl = {}", (Object)reqFrom, (Object)url);
        JSONObject res = new JSONObject();
        CommonResponse thirdSystemResponse = this.thirdSystemApi.getOneByCode(reqFrom);
        if (!thirdSystemResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5fae\u4fe1\u914d\u7f6e\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + thirdSystemResponse.getMsg());
        }
        ThirdSystemVO thirdSystemVO = (ThirdSystemVO)thirdSystemResponse.getData();
        if (thirdSystemVO != null) {
            String configInfo = thirdSystemVO.getConfigInfo();
            JSONObject configJson = JSON.parseObject((String)configInfo);
            String corpAppId = configJson.getString("corp_appId");
            String corpSecret = configJson.getString("corp_secret");
            String accessToken = null;
            String jsapi_ticket = null;
            if ("weixinminprogram".equals(reqFrom)) {
                accessToken = this.getMiniProgramAccessToken(corpAppId, corpSecret);
                String key = url.replace("://", "_").replace("/", "_");
                jsapi_ticket = this.getMiniProgramJsapiTicket(key, accessToken);
            }
            String noncestr = UUID.randomUUID().toString();
            String timestamp = System.currentTimeMillis() / 1000L + "";
            String signature = "";
            String string1 = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + noncestr + "&timestamp=" + timestamp + "&url=" + url;
            this.logger.info("string1 ====> " + string1);
            try {
                MessageDigest crypt = MessageDigest.getInstance("SHA-1");
                crypt.reset();
                crypt.update(string1.getBytes(StandardCharsets.UTF_8));
                signature = AttendanceLogServiceImpl.byteToHex(crypt.digest());
                System.out.println("signature ====> " + signature);
                res.put("url", (Object)url);
                res.put("jsapi_ticket", (Object)jsapi_ticket);
                res.put("noncestr", (Object)noncestr);
                res.put("timestamp", (Object)timestamp);
                res.put("signature", (Object)signature);
                res.put("appid", (Object)corpAppId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return res;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public String getMiniProgramAccessToken(String appId, String appSecret) {
        String key = appId + "_" + appSecret;
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)key);
        this.logger.info("redis----MiniProgramaccessToken=" + accessToken);
        System.out.println("redis----MiniProgramaccessToken=" + accessToken);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            HashMap<String, String> param = new HashMap<String, String>();
            String accessResult = null;
            param.put("grant_type", "client_credential");
            param.put("appid", appId);
            param.put("secret", appSecret);
            try {
                accessResult = ReferHttpClientUtils.get((String)"https://api.weixin.qq.com/cgi-bin/token", param, new HashMap());
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.logger.info("MiniProgramaccessTokenaccessResult=" + accessResult);
            System.out.println("MiniProgramaccessTokenaccessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult)) {
                JSONObject accessJson = JSON.parseObject((String)accessResult);
                accessToken = accessJson.getString("access_token");
                String errmsg = accessJson.getString("errcode");
                if ("0".equals(errmsg) && StringUtils.isNotBlank((CharSequence)accessToken)) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)accessToken, 7000L, TimeUnit.SECONDS);
                }
            }
        }
        return accessToken;
    }

    public String getMiniProgramJsapiTicket(String corpAppId, String accessToken) {
        String key = corpAppId + "_jsapi_ticket";
        String jsapiTicket = (String)this.redisTemplate.opsForValue().get((Object)key);
        this.logger.info("redis----jsapiTicket=" + jsapiTicket);
        System.out.println("redis----jsapiTicket=" + jsapiTicket);
        if (StringUtils.isBlank((CharSequence)jsapiTicket)) {
            HashMap<String, String> param = new HashMap<String, String>();
            String accessResult = null;
            param.put("access_token", accessToken);
            param.put("type", "jsapi");
            try {
                accessResult = ReferHttpClientUtils.get((String)"https://api.weixin.qq.com/cgi-bin/ticket/getticket", param, new HashMap());
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println("accessResult=" + accessResult);
            this.logger.info("accessResult=" + accessResult);
            if (StringUtils.isNotBlank((CharSequence)accessResult)) {
                JSONObject accessJson = JSON.parseObject((String)accessResult);
                jsapiTicket = accessJson.getString("ticket");
                String errmsg = accessJson.getString("errcode");
                if ("0".equals(errmsg) && StringUtils.isNotBlank((CharSequence)jsapiTicket)) {
                    this.redisTemplate.opsForValue().set((Object)key, (Object)jsapiTicket, 7000L, TimeUnit.SECONDS);
                }
            }
        }
        return jsapiTicket;
    }

    @Override
    public String checkBind(Long tenantId, String openid) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(AttendanceBindEntity::getOpenid, (Object)openid);
        AttendanceBindEntity attendanceBindEntity = (AttendanceBindEntity)((Object)this.attendanceBindService.getOne((Wrapper)lambdaQuery));
        return attendanceBindEntity.getPhone();
    }

    @Override
    public String sendMsg(Long tenantId, Long projectId, String phone, String templateCode, String signName) throws Exception {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)templateCode, (String)"\u77ed\u4fe1\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)signName, (String)"\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        if (workRecordEntity == null) {
            throw new BusinessException("\u624b\u673a\u53f7\u5728\u5e73\u53f0\u79df\u6237\u82b1\u540d\u518c\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", (Object)phone);
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            messageParam.put("templateCode", (Object)DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put("templateCode", (Object)templateCode);
        }
        if (StringUtils.isNotBlank((CharSequence)signName)) {
            messageParam.put("signName", (Object)signName);
        }
        String messageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
        this.logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a[{}]", (Object)phone, (Object)responseStr);
        CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
        return "\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01";
    }

    @Override
    public void checkDistance(String projectId, String destination) {
        Assert.hasText((String)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)destination, (String)"\u76ee\u7684\u5730\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<DistanceVO> distance = this.amapService.distance("116.481028,39.989643|114.481028,39.989643|115.481028,39.989643", "114.465302,40.004717", "0");
        this.logger.info("\u8ddd\u79bb\u6d4b\u91cf--{}", (Object)JSON.toJSONString(distance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
    }

    @Override
    public Boolean checkFace(Long tenantId, Long projectId, String phone) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        if (workRecordEntity == null) {
            throw new BusinessException("\u6821\u9a8c\u4eba\u8138\u4fe1\u606f\u5931\u8d25\uff01");
        }
        CommonResponse response = this.attachmentApi.queryListBySourceId(workRecordEntity.getId(), BILL_TYPE, "face", null);
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u4eba\u8138\u4fe1\u606f\u5931\u8d25\uff01");
        }
        return CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()));
    }
}

