/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.enums.LastFlagEnum;
import com.ejianc.business.labor.mapper.WorkRecordMapper;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workRecordService")
public class WorkRecordServiceImpl
extends BaseServiceImpl<WorkRecordMapper, WorkRecordEntity>
implements IWorkRecordService {
    @Autowired
    private IWorkerService workerService;
    @Autowired
    private IWorkerEnterService workerEnterService;

    @Override
    public List<WorkRecordVO> insertWorkRecord(List<WorkRecordVO> voList) {
        ArrayList<WorkRecordVO> returnList = new ArrayList<WorkRecordVO>();
        for (WorkRecordVO vo : voList) {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"project_id", (Object)vo.getProjectId());
            query.eq((Object)"last_flag", (Object)LastFlagEnum.\u662f.getStatus());
            WorkRecordEntity one = (WorkRecordEntity)((Object)super.getOne((Wrapper)query));
            if (one != null) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.set(WorkRecordEntity::getLastFlag, (Object)LastFlagEnum.\u5426.getStatus());
                wrapper.eq(BaseEntity::getId, (Object)one.getId());
                super.update((Wrapper)wrapper);
            }
            WorkRecordEntity entity = (WorkRecordEntity)((Object)BeanMapper.map((Object)vo, WorkRecordEntity.class));
            entity.setLastFlag(LastFlagEnum.\u662f.getStatus());
            super.saveOrUpdate((Object)entity);
            WorkRecordVO recordVO = (WorkRecordVO)BeanMapper.map((Object)((Object)entity), WorkRecordVO.class);
            returnList.add(recordVO);
        }
        return returnList;
    }

    @Override
    public WorkRecordVO updateWorkRecord(WorkRecordVO vo) {
        WorkerEnterEntity workerEnterEntity;
        LambdaQueryWrapper idCardQueryWrapper = new LambdaQueryWrapper();
        idCardQueryWrapper.eq(WorkerEntity::getIdCard, (Object)vo.getIdCard());
        idCardQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        idCardQueryWrapper.ne(vo.getSourceId() != null, BaseEntity::getId, (Object)vo.getSourceId());
        List idCardList = this.workerService.list((Wrapper)idCardQueryWrapper);
        LambdaQueryWrapper phoneQueryWrapper = new LambdaQueryWrapper();
        phoneQueryWrapper.eq(WorkerEntity::getPhone, (Object)vo.getPhone());
        phoneQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        phoneQueryWrapper.ne(vo.getSourceId() != null, BaseEntity::getId, (Object)vo.getSourceId());
        List phoneList = this.workerService.list((Wrapper)phoneQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)idCardList)) {
            throw new BusinessException("\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u5931\u8d25\uff0c\u516c\u53f8\u82b1\u540d\u518c\u8eab\u4efd\u8bc1\u5df2\u5b58\u5728");
        }
        if (CollectionUtils.isNotEmpty((Collection)phoneList)) {
            throw new BusinessException("\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u5931\u8d25\uff0c\u516c\u53f8\u82b1\u540d\u518c\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        WorkRecordEntity entity = (WorkRecordEntity)((Object)BeanMapper.map((Object)vo, WorkRecordEntity.class));
        super.saveOrUpdate((Object)entity, false);
        WorkerEntity workerEntity = (WorkerEntity)((Object)this.workerService.selectById(entity.getSourceId()));
        if (workerEntity != null && workerEntity != null) {
            workerEntity.setLastProjectId(entity.getProjectId());
            if (entity.getName() != null) {
                workerEntity.setName(entity.getName());
            }
            if (entity.getPhone() != null) {
                workerEntity.setPhone(entity.getPhone());
            }
            if (entity.getSex() != null) {
                workerEntity.setSex(entity.getSex());
            }
            if (entity.getBirthDate() != null) {
                workerEntity.setBirthDate(entity.getBirthDate());
            }
            if (entity.getNation() != null) {
                workerEntity.setNation(entity.getNation());
            }
            if (entity.getWorkType() != null) {
                workerEntity.setWorkType(entity.getWorkType());
            }
            if (entity.getWorkTypeName() != null) {
                workerEntity.setWorkTypeName(entity.getWorkTypeName());
            }
            if (entity.getBankName() != null) {
                workerEntity.setBankName(entity.getBankName());
            }
            if (entity.getBankAccount() != null) {
                workerEntity.setBankAccount(entity.getBankAccount());
            }
            if (entity.getWagesType() != null) {
                workerEntity.setWagesType(entity.getWagesType());
            }
            if (entity.getWagesTypeName() != null) {
                workerEntity.setWagesTypeName(entity.getWagesTypeName());
            }
            if (entity.getWage() != null) {
                workerEntity.setWage(entity.getWage());
            }
            if (entity.getProvince() != null) {
                workerEntity.setProvince(entity.getProvince());
            }
            if (entity.getCity() != null) {
                workerEntity.setCity(entity.getCity());
            }
            if (entity.getArea() != null) {
                workerEntity.setArea(entity.getArea());
            }
            if (entity.getAddress() != null) {
                workerEntity.setAddress(entity.getAddress());
            }
            if (entity.getWagesTypeName() != null) {
                workerEntity.setWagesTypeName(entity.getWagesTypeName());
            }
            if (entity.getMemo() != null) {
                workerEntity.setMemo(entity.getMemo());
            }
            if (entity.getMemo() != null) {
                workerEntity.setMemo(entity.getMemo());
            }
            if (entity.getMemo() != null) {
                workerEntity.setMemo(entity.getMemo());
            }
            if (entity.getMemo() != null) {
                workerEntity.setMemo(entity.getMemo());
            }
            if (entity.getMemo() != null) {
                workerEntity.setMemo(entity.getMemo());
            }
            this.workerService.saveOrUpdate((Object)workerEntity);
        }
        if (entity.getSourceFlag() == 1 && (workerEnterEntity = (WorkerEnterEntity)((Object)this.workerEnterService.selectById(entity.getSourceId()))) != null) {
            if (entity.getSubContractId() != null) {
                workerEnterEntity.setSubContractId(entity.getSubContractId());
                workerEnterEntity.setSubContractName(entity.getSubContractName());
                workerEnterEntity.setSupplierId(entity.getSupplierId());
                workerEnterEntity.setSubContractName(entity.getSupplierName());
            }
            this.workerEnterService.saveOrUpdate((Object)workerEnterEntity);
        }
        WorkRecordVO returnVo = (WorkRecordVO)BeanMapper.map((Object)((Object)entity), WorkRecordVO.class);
        returnVo.setBillState(Integer.valueOf(0));
        return returnVo;
    }

    @Override
    public WorkRecordVO updateBatWorker(WorkRecordVO updateVO) {
        List ids = updateVO.getIds();
        String teamId = updateVO.getTeamId();
        String teamName = updateVO.getTeamName();
        String workType = updateVO.getWorkType();
        String workTypeName = updateVO.getWorkTypeName();
        Long supplierId = updateVO.getSupplierId();
        String supplierName = updateVO.getSupplierName();
        Long subContractId = updateVO.getSubContractId();
        String subContractName = updateVO.getSubContractName();
        if (CollectionUtils.isNotEmpty((Collection)ids)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"id", (Object)ids);
            List list = super.list((Wrapper)queryWrapper);
            ArrayList<Long> workerEntities = new ArrayList<Long>();
            ArrayList<Long> enterEntities = new ArrayList<Long>();
            for (WorkRecordEntity record : list) {
                if (record.getSourceFlag() == 1) {
                    enterEntities.add(record.getSourceId());
                }
                workerEntities.add(record.getSourceId());
            }
            if (teamName != null || workType != null || subContractId != null) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                LambdaUpdateWrapper workerEntityWrapper = new LambdaUpdateWrapper();
                LambdaUpdateWrapper enterWrapper = new LambdaUpdateWrapper();
                wrapper.set(teamId != null, WorkRecordEntity::getTeamId, (Object)teamId);
                wrapper.set(teamId != null, WorkRecordEntity::getTeamName, (Object)teamName);
                wrapper.set(workType != null, WorkRecordEntity::getWorkType, (Object)workType);
                wrapper.set(workTypeName != null, WorkRecordEntity::getWorkTypeName, (Object)workTypeName);
                workerEntityWrapper.set(workType != null, WorkerEntity::getWorkType, (Object)workType);
                workerEntityWrapper.set(workTypeName != null, WorkerEntity::getWorkTypeName, (Object)workTypeName);
                wrapper.set(supplierId != null, WorkRecordEntity::getSupplierId, (Object)supplierId);
                wrapper.set(supplierName != null, WorkRecordEntity::getSupplierName, (Object)supplierName);
                wrapper.set(subContractId != null, WorkRecordEntity::getSubContractId, (Object)subContractId);
                wrapper.set(subContractName != null, WorkRecordEntity::getSubContractName, (Object)subContractName);
                enterWrapper.set(supplierId != null, WorkerEnterEntity::getSupplierId, (Object)supplierId);
                enterWrapper.set(supplierName != null, WorkerEnterEntity::getSupplierName, (Object)supplierName);
                enterWrapper.set(subContractId != null, WorkerEnterEntity::getSubContractId, (Object)subContractId);
                enterWrapper.set(subContractName != null, WorkerEnterEntity::getSubContractName, (Object)subContractName);
                wrapper.in(BaseEntity::getId, (Collection)ids);
                super.update((Wrapper)wrapper);
                this.workerEnterService.update((Wrapper)enterWrapper);
                this.workerService.update((Wrapper)workerEntityWrapper);
            }
        }
        return updateVO;
    }
}

