/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerExitDetailEntity;
import com.ejianc.business.labor.bean.WorkerExitEntity;
import com.ejianc.business.labor.service.ISalaryService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerExitService;
import com.ejianc.business.labor.utils.EJCDateUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workerExit")
public class WorkerExitBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private IWorkerExitService service;
    @Autowired
    private ISalaryService salaryService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        WorkerExitEntity workerExitEntity = (WorkerExitEntity)((Object)this.service.selectById(billId));
        List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
        if (CollectionUtils.isNotEmpty(workerExitDetailList)) {
            for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(WorkRecordEntity::getProjectId, (Object)workerExitEntity.getProjectId());
                updateWrapper.eq(WorkRecordEntity::getWorkerId, (Object)workerExitDetailEntity.getWorkerId());
                updateWrapper.eq(WorkRecordEntity::getLastFlag, (Object)1);
                updateWrapper.set(WorkRecordEntity::getEnterExitState, (Object)0);
                updateWrapper.set(WorkRecordEntity::getExitDate, (Object)workerExitDetailEntity.getExitDate());
                this.workRecordService.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        WorkerExitEntity workerExitEntity = (WorkerExitEntity)((Object)this.service.selectById(billId));
        List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
        if (CollectionUtils.isNotEmpty(workerExitDetailList)) {
            for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
                QueryWrapper objectQueryWrapper = new QueryWrapper();
                objectQueryWrapper.eq((Object)"project_id", (Object)workerExitEntity.getProjectId());
                objectQueryWrapper.eq((Object)"worker_id", (Object)workerExitDetailEntity.getWorkerId());
                objectQueryWrapper.eq((Object)"enter_exit_state", (Object)1);
                List list = this.workRecordService.list((Wrapper)objectQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    String err = "\u59d3\u540d:" + workerExitDetailEntity.getWorkerName() + ",\u5df2\u7ecf\u8fdb\u573a,\u4e0d\u652f\u6301\u5f03\u5ba1";
                    return CommonResponse.error((String)err);
                }
                String exitDate = EJCDateUtil.format(workerExitDetailEntity.getExitDate(), "yyyy-MM");
                Integer con = this.salaryService.haveSalaryFlag(workerExitDetailEntity.getWorkerId(), exitDate);
                if (con <= 1) continue;
                String err = "\u59d3\u540d:" + workerExitDetailEntity.getWorkerName() + ",\u5df2\u7ecf\u6709\u5de5\u8d44\u5355,\u4e0d\u652f\u6301\u5f03\u5ba1";
                return CommonResponse.error((String)err);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        WorkerExitEntity workerExitEntity = (WorkerExitEntity)((Object)this.service.selectById(billId));
        List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
        if (CollectionUtils.isNotEmpty(workerExitDetailList)) {
            for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(WorkRecordEntity::getProjectId, (Object)workerExitEntity.getProjectId());
                updateWrapper.eq(WorkRecordEntity::getWorkerId, (Object)workerExitDetailEntity.getWorkerId());
                updateWrapper.eq(WorkRecordEntity::getLastFlag, (Object)1);
                updateWrapper.set(WorkRecordEntity::getEnterExitState, (Object)1);
                updateWrapper.set(WorkRecordEntity::getExitDate, null);
                this.workRecordService.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success();
    }
}

