package com.ejianc.business.labor.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.AttendanceLogEntity;
import com.ejianc.business.labor.vo.AttendanceLogVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 考勤日志
 *
 * @author generator
 */
public interface IAttendanceLogService extends IBaseService<AttendanceLogEntity> {

	/**
	 * 登录
	 *
	 * @param tenantId     租户id
	 * @param projectId    项目id
	 * @param phone        手机号
	 * @param templateCode 短信模版
	 * @param validate     验证码
	 * @param openid       openid
	 */
	void login(Long tenantId, Long projectId, String phone, String templateCode, String validate, String openid);


	/**
	 * 获取openid
	 *
	 * @param code 临时登录凭证
	 *
	 * @return {@link JSONObject}
	 */
	String getOpenId(String code);


	/**
	 * 给指定手机号发送验证码或者短信
	 *
	 * @param tenantId     租户id
	 * @param projectId    项目id
	 * @param phone        手机号
	 * @param templateCode 短信模板编码
	 * @param signName     短信签名
	 *
	 * @return {@link String}
	 *
	 * @throws Exception 异常
	 */
	String sendMsg(Long tenantId, Long projectId, String phone, String templateCode, String signName) throws Exception;


	/**
	 * 距离测量
	 *
	 * @param projectId   项目id
	 * @param destination 目的地
	 */
	void checkDistance(String projectId, String destination);


	/**
	 * 获取微信配置数据
	 *
	 * @param reqFrom 请求来自客户端
	 * @param url     url
	 *
	 * @return {@link JSONObject}
	 */
	JSONObject getWeiXinConfigData(String reqFrom, String url);


	/**
	 * 租户手机号绑定openid校验
	 *
	 * @param tenantId 租户id
	 * @param openid   openid
	 *
	 * @return {@link String}
	 */
	String checkBind(Long tenantId, String openid);


	/**
	 * 校验人脸信息
	 *
	 * @param tenantId  租户id
	 * @param projectId 项目id
	 * @param phone     手机号
	 *
	 * @return {@link Boolean}
	 */
	Boolean checkFace(Long tenantId, Long projectId, String phone);


	/**
	 * 考勤打卡
	 *
	 * @param tenantId       租户id
	 * @param projectId      项目id
	 * @param phone          手机号
	 * @param punchCardType  打卡类型：上班打卡、下班打卡
	 * @param punchCardPlace 打卡地点
	 * @param remoteFlag     是否是异地打卡（1:是 0：否）
	 *
	 * @return {@link AttendanceLogVO}
	 */
	AttendanceLogVO punchCard(Long tenantId, Long projectId, String phone, String punchCardType, String punchCardPlace, Integer remoteFlag);
}
