package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labor.bean.SalaryDetailEntity;
import com.ejianc.business.labor.bean.SalaryEntity;
import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.service.ISalaryService;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.vo.SalaryDetailVO;
import com.ejianc.business.labor.vo.SalarySlipVO;
import com.ejianc.business.labor.vo.SalaryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

@Service("salary") 
public class SalaryBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private ISalaryService salaryService;
	@Autowired
	private IBillCodeApi billCodeApi;
	private static final String BILL_CODE = "SALARYSLIP_CODE";//此处需要根据实际修改
	@Autowired
	private ISalarySlipService salarySlipService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		SalaryEntity salaryEntity = salaryService.selectById(billId);
		List<SalaryDetailEntity> salaryDetailList = salaryEntity.getSalaryDetailList();
		if (CollectionUtils.isNotEmpty(salaryDetailList)){
			List<SalarySlipEntity> salarySlipList = BeanMapper.mapList(salaryDetailList, SalarySlipEntity.class);
			for (SalarySlipEntity entity : salarySlipList) {
				entity.setId(null);
				entity.setVersion(null);
				entity.setCreateUserCode(null);
				entity.setCreateTime(null);
				entity.setUpdateUserCode(null);
				entity.setUpdateTime(null);
				entity.setProjectId(salaryEntity.getProjectId());
				entity.setProjectName(salaryEntity.getProjectName());
				entity.setOrgId(salaryEntity.getOrgId());
				entity.setOrgName(salaryEntity.getOrgName());
				entity.setAckFlag(0);
				entity.setSalaryMonth(salaryEntity.getSalaryMonth());
				SalarySlipVO salarySlipVO = BeanMapper.map(entity, SalarySlipVO.class);
				if(entity.getId() == null || entity.getId() == 0){
					BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),salarySlipVO);
					CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
					if(billCode.isSuccess()) {
						entity.setBillCode(billCode.getData());
					}else{
						throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
					}
				}
			}
			salarySlipService.saveBatch(salarySlipList, salarySlipList.size());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		QueryWrapper<SalarySlipEntity> objectQueryWrapper = new QueryWrapper<>();
		objectQueryWrapper.eq("salary_id",billId);
		List<SalarySlipEntity> list = salarySlipService.list(objectQueryWrapper);
		if (CollectionUtils.isNotEmpty(list)){
			salarySlipService.removeByIds(list.stream().map(SalarySlipEntity::getId).collect(Collectors.toList()),true);
		}
		return CommonResponse.success();
	}

}
