package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labor.bean.*;
import com.ejianc.business.labor.service.*;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerEnterVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.labor.mapper.WorkerEnterMapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 劳务进场单
 * 
 * @author generator
 * 
 */
@Service("workerEnterService")
public class WorkerEnterServiceImpl extends BaseServiceImpl<WorkerEnterMapper, WorkerEnterEntity> implements IWorkerEnterService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "LABOR_WORKER_ENTER";//此处需要根据实际修改
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IWorkRecordService recordService;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    private IOrgTeamService orgTeamService;
    @Autowired
    private IWorkerService workerService;
    public WorkerEnterVO saveOrUpdate(WorkerEnterVO saveOrUpdateVO){
        WorkerEnterEntity entity = BeanMapper.map(saveOrUpdateVO, WorkerEnterEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (entity.getSourceFlag()==1){
                entity.setSourceFlagName("自制");
            }
            if (entity.getSourceFlag()==2){
                entity.setSourceFlagName("公司花名册");
            }
            if (entity.getSourceFlag()==3){
                entity.setSourceFlagName("邀请");
            }
        }
        super.saveOrUpdate(entity, false);
        WorkerEnterVO vo = BeanMapper.map(entity, WorkerEnterVO.class);
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> saveCheck(WorkerEnterVO vo){
        // level 0  不可保存
        // level 1 可以保存 提示
        JSONObject jsonObject = new JSONObject();

        // 保存时校验 手机号
        //查看 未生效的进场记录否存在
        QueryWrapper<WorkerEnterEntity> queryEnter = new QueryWrapper<>();
        queryEnter.eq("phone",vo.getPhone());
        if (vo.getId()!=null){
            queryEnter.ne("id",vo.getId());
        }
        queryEnter.notIn("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()});
        WorkerEnterEntity enterOne = super.getOne(queryEnter);
        if (enterOne!=null){
            jsonObject.put("level",0);
            jsonObject.put("msg","该手机号被进场记录【"+enterOne.getName()+"】注册，不可重复添加；");
            return CommonResponse.success(jsonObject);
        }
        // 保存时校验身份证号在未生效的进场记录中是否存在，如存在，不可保存。
        // 提示：该人员在【项目名称】中已存在未生效的进场记录，请等待上次进场审批通过后再进行本次进场；
        QueryWrapper<WorkerEnterEntity> queryEnterByCard = new QueryWrapper<>();
        queryEnterByCard.eq("id_card",vo.getIdCard());
//        queryEnterByCard.eq("project_id",vo.getProjectId());
        if (vo.getId()!=null){
            queryEnterByCard.ne("id",vo.getId());
        }
        queryEnterByCard.notIn("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()});
        WorkerEnterEntity enterOneCard = super.getOne(queryEnterByCard);
        if (enterOneCard!=null){
            jsonObject.put("level",0);
            jsonObject.put("msg","该人员在【"+enterOneCard.getProjectName()+"】中已存在未生效的进场记录，请等待上次进场审批通过后再进行本次进场；");
            return CommonResponse.success(jsonObject);
        }

        //查看项目花名册
        QueryWrapper<WorkRecordEntity> queryRecord = new QueryWrapper<>();
        queryRecord.eq("phone",vo.getPhone());
        queryRecord.eq("dr",0);
        queryRecord.eq("enter_exit_state",1);
        queryRecord.eq("last_flag",1);
        WorkRecordEntity recordOne = recordService.getOne(queryRecord);
        if (recordOne!=null){
            jsonObject.put("level",0);
            jsonObject.put("msg","该手机号被项目花名册【"+recordOne.getName()+"】注册，不可重复添加；");
            return CommonResponse.success(jsonObject);
        }
        // 保存时校验身份证号在本租户公司花名册中是否存在，如不存在，按正常进场逻辑。
        // 如存在，提示：该用户在花名册中已存在，本次进场将会修改公司花名册中该人员的基本信息，是否确定？
        // 花名册已存在时，进场记录依旧可以保存，提交。进场记录生效后，补充公司花名册基本信息。逻辑为：进场有值取进场，进场无值取公司花名册值；
        WorkerEntity recordOneByCard = workerService.queryOneByIdCard(vo.getIdCard());
        if (recordOneByCard!=null){
            jsonObject.put("level",1);
            jsonObject.put("msg","该用户在司花名册中已存在，本次进场将会修改公司花名册中该人员的基本信息，是否确定？");
            return CommonResponse.success(jsonObject);
        }

        //保存时校验身份证号在项目花名册中是否在场，如果在场，提示：该劳务人员已在场，不能重复进场；
        QueryWrapper<WorkRecordEntity> queryRecordCard = new QueryWrapper<>();
        queryRecordCard.eq("phone",vo.getPhone());
        queryRecordCard.eq("enter_exit_state",1);
        queryRecordCard.eq("last_flag",1);
        WorkRecordEntity recordOneCard = recordService.getOne(queryRecordCard);
        if (recordOneCard!=null){
            jsonObject.put("level",0);
            jsonObject.put("msg","该劳务人员已在场，不能重复进场");
            return CommonResponse.success(jsonObject);
        }
        jsonObject.put("level",2);
        return CommonResponse.success(jsonObject);
    }


    /**
     *  审批通过 回写 或插入数据
     * @param entity
     */
    @Override
    public void bpmWriteBackAndInsert(WorkerEnterEntity entity){
        //TODO 推送到那个公司??
        WorkerEntity recordOneByCard = workerService.queryOneByIdCard(entity.getIdCard());
        CommonResponse<ProjectRegisterVO> projectRegisterVOCommonResponse = projectApi.queryProjectDetail(entity.getProjectId());
        if(!projectRegisterVOCommonResponse.isSuccess()) {
            throw new BusinessException("网络异常，获取项目信息， 请稍后再试");
        }
        ProjectRegisterVO project = projectRegisterVOCommonResponse.getData();

        //最终 save newWorker
        WorkerVO newWorker = BeanMapper.map(entity, WorkerVO.class);
        // 回写数据 进场记录生效后，补充公司花名册基本信息。逻辑为：进场有值取进场，进场无值取公司花名册值；
        if (recordOneByCard!=null){
            newWorker =  BeanMapper.map(recordOneByCard, WorkerVO.class);
            newWorker.setLastProjectId(entity.getProjectId());
            if (entity.getName()!=null){//姓名
                newWorker.setName(entity.getName());
            }
            if (entity.getPhone()!=null){//手机号
                newWorker.setPhone(entity.getPhone());
            }
            if (entity.getSex()!=null){//性别
                newWorker.setSex(entity.getSex());
            }
            if (entity.getBirthDate()!=null){//出生年月
                newWorker.setBirthDate(entity.getBirthDate());
            }
            if (entity.getNation()!=null){// 民族
                newWorker.setNation(entity.getNation());
            }
            if (entity.getWorkType()!=null){// 工种
                newWorker.setWorkType(entity.getWorkType());
            }
            if (entity.getWorkTypeName()!=null){// 工种名称
                newWorker.setWorkTypeName(entity.getWorkTypeName());
            }
            if (entity.getBankName()!=null){// 开户行
                newWorker.setBankName(entity.getBankName());
            }
            if (entity.getBankAccount()!=null){// 银行账号
                newWorker.setBankAccount(entity.getBankAccount());
            }
            if (entity.getWagesType()!=null){// 工资类型
                newWorker.setWagesType(entity.getWagesType());
            }
            if (entity.getWagesTypeName()!=null){// 工资类型名称
                newWorker.setWagesTypeName(entity.getWagesTypeName());
            }
            if (entity.getWage()!=null){// 工价
                newWorker.setWage(entity.getWage());
            }
            if (entity.getProvince()!=null){// 省
                newWorker.setProvince(entity.getProvince());
            }
            if (entity.getCity()!=null){// 市
                newWorker.setCity(entity.getCity());
            }
            if (entity.getArea()!=null){// 省市
                newWorker.setArea(entity.getArea());
            }
            if (entity.getAddress()!=null){// 详细地址
                newWorker.setAddress(entity.getAddress());
            }
            if (entity.getWagesTypeName()!=null){// 工资类型名称
                newWorker.setWagesTypeName(entity.getWagesTypeName());
            }
            if (entity.getMemo()!=null){// 工资类型名称
                newWorker.setMemo(entity.getMemo());
            }


            if (entity.getIdCardFrontPhotoFlag()!=null){// 身份证正面照片状态：0-待校验，1-是，2-否，3-异常
                newWorker.setIdCardFrontPhotoFlag(entity.getIdCardFrontPhotoFlag());
            }
            if (entity.getIdCardBackPhotoFlag()!=null){//  身份证反面照片状态：0-待校验，1-是，2-否，3-异常
                newWorker.setIdCardBackPhotoFlag(entity.getIdCardBackPhotoFlag());
            }
            if (entity.getFacePhotoFlag()!=null){//  人脸采集状态：0-待校验，1-是，2-否，3-异常
                newWorker.setFacePhotoFlag(entity.getFacePhotoFlag());
            }


        }else {
            //单据审批通过后，该人员进入项目花名册、公司花名册；
            // 如公司花名册没有对应班组，那么班组为空即可；
            List<String> teamIdS = Arrays.asList(entity.getTeamId().split(","));
            LambdaQueryWrapper<OrgTeamEntity> teamLambda = new LambdaQueryWrapper<>();
            teamLambda.in(OrgTeamEntity::getId,teamIdS);
            List<OrgTeamEntity> list = orgTeamService.list(teamLambda);
            if (CollectionUtils.isNotEmpty(list)){
                String newTeamIdS = list.stream().map(OrgTeamEntity::getId).collect(Collectors.toList()).
                        stream().map(Objects::toString).collect(Collectors.joining(","));;
                String newTeamNames = list.stream().map(OrgTeamEntity::getName).collect(Collectors.toList()).
                        stream().map(Objects::toString).collect(Collectors.joining(","));;
                newWorker.setTeamId(newTeamIdS);
                newWorker.setTeamName(newTeamNames);
            }else {
                newWorker.setTeamId(null);
                newWorker.setTeamName(null);
            }
            newWorker.setId(null);
            //设置来源
            newWorker.setSourceFlag(2);
            newWorker.setSourceFlagName("项目进场");
            newWorker.setSourceProjectId(entity.getProjectId());
            newWorker.setLastProjectId(entity.getProjectId());
        }
        // 插入数据到 用工记录
        WorkRecordVO record = BeanMapper.map(newWorker, WorkRecordVO.class);
        record.setId(IdWorker.getId());
        record.setWorkerId(entity.getId());
        record.setProjectTeamId(entity.getTeamId());
        record.setProjectTeamName(entity.getTeamName());
        record.setProjectWorkType(entity.getWorkType());
        record.setProjectWorkTypeName(entity.getWorkTypeName());
        record.setProjectAddress(project.getAddress());
        record.setSourceFlag(1);
        record.setSourceFlagName("项目进场");
        record.setSourceId(entity.getId());
        record.setEnterExitState(1);
        record.setSubContractId(entity.getSubContractId());
        record.setSubContractName(entity.getSubContractName());
        record.setSupplierId(entity.getSupplierId());
        record.setSupplierName(entity.getSupplierName());
        //设置入场信息
//        record.setLastFlag(1);

        //设置项目信息
        record.setProjectId(project.getId());
        record.setProjectName(project.getName());
        record.setOrgId(project.getProjectDepartmentId());
        record.setParentOrgId(project.getOrgId());
        record.setParentOrgName(project.getOrgName());
        List<WorkRecordVO> saveVoList = new ArrayList<>();
        saveVoList.add(record);
        recordService.insertWorkRecord(saveVoList);
        newWorker.setEnabled(1);
        newWorker.setWorkState(1);
        newWorker.setWorkStateName("已入场");
        workerService.insertOrUpdate(newWorker);
    }
}
