/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.AttendanceLogEntity;
import com.ejianc.business.labor.service.IAmapService;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.labor.vo.AttendanceLogVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"attendanceLog"})
public class AttendanceLogController
implements Serializable {
    private static final long serialVersionUID = 5204994771029686422L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IBillTypeApi billTypeApi;
    @Resource
    private IBillCodeApi billCodeApi;
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IAttendanceLogService service;
    @Autowired
    private SessionManager sessionManager;
    @Resource
    private IAmapService amapService;

    @GetMapping(value={"getWeiXinConfigData"})
    public CommonResponse<JSONObject> getWeiXinConfigData(@RequestParam(value="req_from") String reqFrom, @RequestParam(value="url") String url) {
        return CommonResponse.success((Object)this.service.getWeiXinConfigData(reqFrom, url));
    }

    @GetMapping(value={"getOpenId"})
    public CommonResponse<String> getOpenId(@RequestParam(value="code") String code) {
        return CommonResponse.success((String)"\u83b7\u53d6openid\u6210\u529f\uff01", (Object)this.service.getOpenId(code));
    }

    @GetMapping(value={"checkBind"})
    public CommonResponse<String> checkBind(@RequestParam(value="tenantId") Long tenantId, @RequestParam(value="openid") String openid) {
        return CommonResponse.success((String)"\u79df\u6237\u624b\u673a\u53f7\u7ed1\u5b9aopenid\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.checkBind(tenantId, openid));
    }

    @GetMapping(value={"sendMessage"})
    public CommonResponse<String> sendMessage(@RequestParam(value="tenantId") Long tenantId, @RequestParam(value="projectId") Long projectId, @RequestParam(value="phone") String phone, @RequestParam(value="templateCode", required=false) String templateCode, @RequestParam(value="signName") String signName) throws Exception {
        return CommonResponse.success((String)this.service.sendMsg(tenantId, projectId, phone, templateCode, signName));
    }

    @GetMapping(value={"login"})
    public CommonResponse<Void> login(@RequestParam(value="tenantId") Long tenantId, @RequestParam(value="projectId") Long projectId, @RequestParam(value="phone") String phone, @RequestParam(value="templateCode") String templateCode, @RequestParam(value="validate") String validate, @RequestParam(value="openid") String openid) {
        this.service.login(tenantId, projectId, phone, templateCode, validate, openid);
        return CommonResponse.success((String)"\u767b\u5f55\u6210\u529f\uff01");
    }

    @PostMapping(value={"checkFace"})
    public CommonResponse<WorkRecordVO> checkFace(@RequestBody JSONObject jsonObject) {
        Long tenantId = jsonObject.getLong("tenantId");
        Long projectId = jsonObject.getLong("projectId");
        String phone = jsonObject.getString("phone");
        String imgBase64A = jsonObject.getString("imgBase64A");
        return this.service.checkFace(tenantId, projectId, phone, imgBase64A);
    }

    @GetMapping(value={"checkDistance"})
    public CommonResponse<JSONObject> checkDistance(@RequestParam(value="worktimeSetId") String worktimeSetId, @RequestParam(value="destination") String destination) {
        return this.service.checkDistance(worktimeSetId, destination);
    }

    @GetMapping(value={"checkPunchCardAuth"})
    public CommonResponse<String> checkPunchCardAuth(@RequestParam(value="tenantId") Long tenantId, @RequestParam(value="projectId") Long projectId, @RequestParam(value="phone") String phone) {
        this.service.checkPunchCardAuth(tenantId, projectId, phone);
        return CommonResponse.success((String)"\u9879\u76ee\u6253\u5361\u6743\u9650\u6821\u9a8c\u6210\u529f\uff01");
    }

    @GetMapping(value={"checkExistedLog"})
    public CommonResponse<List<AttendanceLogVO>> checkExistedLog(@RequestParam(value="tenantId") Long tenantId, @RequestParam(value="projectId") Long projectId, @RequestParam(value="phone") String phone, @RequestParam(value="punchCardType") String punchCardType) {
        return this.service.checkExistedLog(tenantId, projectId, phone, punchCardType);
    }

    @GetMapping(value={"/punchCard"})
    public CommonResponse<AttendanceLogVO> punchCard(@RequestParam(value="tenantId") Long tenantId, @RequestParam(value="projectId") Long projectId, @RequestParam(value="phone") String phone, @RequestParam(value="punchCardType") String punchCardType, @RequestParam(value="punchCardPlace") String punchCardPlace, @RequestParam(value="remoteFlag") Integer remoteFlag) {
        return CommonResponse.success((String)"\u8003\u52e4\u6253\u5361\u6210\u529f\uff01", (Object)this.service.punchCard(tenantId, projectId, phone, punchCardType, punchCardPlace, remoteFlag));
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<AttendanceLogVO> queryDetail(Long id) {
        AttendanceLogEntity entity = (AttendanceLogEntity)((Object)this.service.selectById(id));
        AttendanceLogVO vo = (AttendanceLogVO)BeanMapper.map((Object)((Object)entity), AttendanceLogVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/queryPage"})
    public CommonResponse<IPage<AttendanceLogVO>> queryPage(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("startWorkPlace");
        fuzzyFields.add("endWorkPlace");
        Object punchCardDate = ((Parameter)param.getParams().get("punchCardDate")).getValue();
        param.getParams().remove("punchCardDate");
        QueryWrapper queryWrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        queryWrapper.apply("date_format(punch_card_date,'%Y-%m') = {0}", new Object[]{punchCardDate});
        Page p = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage page = this.service.page((IPage)p, (Wrapper)queryWrapper);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AttendanceLogVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/refAttendanceLogData"})
    public CommonResponse<IPage<AttendanceLogVO>> refAttendanceLogData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AttendanceLogVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

