package com.ejianc.business.labor.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.vo.SalaryVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.vo.SalarySlipVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 工资条
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("salarySlip")
public class SalarySlipController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SALARYSLIP_CODE";//此处需要根据实际修改

    @Autowired
    private ISalarySlipService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SalarySlipVO> saveOrUpdate(@RequestBody SalarySlipVO saveOrUpdateVO) {
    	SalarySlipEntity entity = BeanMapper.map(saveOrUpdateVO, SalarySlipEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SalarySlipVO vo = BeanMapper.map(entity, SalarySlipVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalarySlipVO> queryDetail(Long id) {
    	SalarySlipEntity entity = service.selectById(id);
    	SalarySlipVO vo = BeanMapper.map(entity, SalarySlipVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalarySlipVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SalarySlipVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SalarySlipVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalarySlipVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        /** 租户隔离 */
        String salaryMonth=null;
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("salaryMonth")){
            salaryMonth = (String)params.get("salaryMonth").getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth=split[0]+"-"+split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<SalarySlipVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<SalarySlipVO> list = service.querySalarySlipVOPage(wrapper,salaryMonth,page);
        page.setTotal(page.getTotal());
        page.setRecords(list);

        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        /** 租户隔离 */
        String salaryMonth=null;
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("salaryMonth")){
            salaryMonth = (String)params.get("salaryMonth").getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth=split[0]+"-"+split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<SalarySlipVO> list = service.querySalarySlipVOPage(wrapper,salaryMonth,null);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SalarySlip-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSalarySlipData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SalarySlipVO>> refSalarySlipData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SalarySlipEntity> page = service.queryPage(param,false);
        IPage<SalarySlipVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalarySlipVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description ackSalary 工资条确认
     */
    @RequestMapping(value = "/ackSalary", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> ackSalary(@RequestBody SalarySlipVO vo) {
        LambdaUpdateWrapper<SalarySlipEntity> salarySlipAckWrapper = new LambdaUpdateWrapper<>();
        salarySlipAckWrapper.eq(SalarySlipEntity::getId,vo.getId());
        salarySlipAckWrapper.set(SalarySlipEntity::getAckFlag,1);
        salarySlipAckWrapper.set(SalarySlipEntity::getAckTime,new Date());
        salarySlipAckWrapper.set(SalarySlipEntity::getLogonPeople,vo.getLogonPeople());
        salarySlipAckWrapper.set(SalarySlipEntity::getFacePhotoId,vo.getFacePhotoId());
        salarySlipAckWrapper.set(SalarySlipEntity::getFacePhoto,vo.getFacePhoto());
        salarySlipAckWrapper.set(SalarySlipEntity::getSignPhotoId,vo.getSignPhotoId());
        salarySlipAckWrapper.set(SalarySlipEntity::getSignPhoto,vo.getSignPhoto());
        service.update(salarySlipAckWrapper);
        return CommonResponse.success("工资条确认成功！");
    }

    /**
     * @Description querySalarySlipList 查询工资条移动端列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/querySalarySlipList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalarySlipVO>> querySalarySlipList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        /** 租户隔离 */
        String salaryMonth=null;
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("salaryMonth")){
            salaryMonth = (String)params.get("salaryMonth").getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth=split[0]+"-"+split[1];
            param.getParams().remove("salaryMonth");
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<SalarySlipVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<SalarySlipVO> list = service.querySalarySlipVOPage(wrapper,salaryMonth,page);
        page.setTotal(page.getTotal());
        page.setRecords(list);

        return CommonResponse.success("查询列表数据成功！",page);
    }

}
