package com.ejianc.business.labor.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.labor.vo.SalaryVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.labor.bean.SalaryEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 劳务工资单
 * 
 * @author generator
 * 
 */
@Mapper
public interface SalaryMapper extends BaseCrudMapper<SalaryEntity> {

    Integer haveSalaryFlag(Long workerId, String exitDate);

    List<AttendanceVO> queryWorkerAttendanceList(Long workerId, String month);

    List<SalaryVO> querySalaryPage(@Param(Constants.WRAPPER) QueryWrapper wrapper, String salaryMonth, Page<SalaryVO> page);
}
