package com.ejianc.business.labor.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.AttendanceLogEntity;
import com.ejianc.business.labor.vo.AttendanceLogVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * 考勤日志
 *
 * @author generator
 */
public interface IAttendanceLogService extends IBaseService<AttendanceLogEntity> {

	/**
	 * 登录
	 *
	 * @param tenantId     租户id
	 * @param projectId    项目id
	 * @param phone        手机号
	 * @param templateCode 短信模版
	 * @param validate     验证码
	 * @param openid       openid
	 */
	void login(Long tenantId, Long projectId, String phone, String templateCode, String validate, String openid);


	/**
	 * 获取openid
	 *
	 * @param code 临时登录凭证
	 *
	 * @return {@link JSONObject}
	 */
	String getOpenId(String code);


	/**
	 * 给指定手机号发送验证码或者短信
	 *
	 * @param tenantId     租户id
	 * @param projectId    项目id
	 * @param phone        手机号
	 * @param templateCode 短信模板编码
	 * @param signName     短信签名
	 *
	 * @return {@link String}
	 *
	 * @throws Exception 异常
	 */
	String sendMsg(Long tenantId, Long projectId, String phone, String templateCode, String signName) throws Exception;


	/**
	 * 校验考勤范围
	 *
	 * @param worktimeSetId 考勤设置id
	 * @param destination   当前位置经纬度
	 *
	 * @return {@link CommonResponse}<{@link JSONObject}>
	 */
	CommonResponse<JSONObject> checkDistance(String worktimeSetId, String destination);


	/**
	 * 获取微信配置数据
	 *
	 * @param reqFrom 请求来自客户端
	 * @param url     url
	 *
	 * @return {@link JSONObject}
	 */
	JSONObject getWeiXinConfigData(String reqFrom, String url);


	/**
	 * 租户手机号绑定openid校验
	 *
	 * @param tenantId 租户id
	 * @param openid   openid
	 *
	 * @return {@link String}
	 */
	String checkBind(Long tenantId, String openid);


	/**
	 * 校验人脸
	 *
	 * @param tenantId   租户id
	 * @param projectId  项目id
	 * @param phone      手机号
	 * @param imgBase64A 待识别人脸照片base64编码
	 *
	 * @return {@link CommonResponse}<{@link WorkRecordVO}>
	 */
	CommonResponse<WorkRecordVO> checkFace(Long tenantId, Long projectId, String phone, String imgBase64A);


	/**
	 * 考勤打卡
	 *
	 * @param tenantId       租户id
	 * @param projectId      项目id
	 * @param phone          手机号
	 * @param punchCardType  打卡类型：上班打卡、下班打卡
	 * @param punchCardPlace 打卡地点
	 * @param remoteFlag     是否是异地打卡（1:是 0：否）
	 *
	 * @return {@link AttendanceLogVO}
	 */
	AttendanceLogVO punchCard(Long tenantId, Long projectId, String phone, String punchCardType, String punchCardPlace, Integer remoteFlag);


	/**
	 * 校验项目打卡权限
	 *
	 * @param tenantId  租户id
	 * @param projectId 项目id
	 * @param phone     手机号
	 */
	void checkPunchCardAuth(Long tenantId, Long projectId, String phone);


	/**
	 * 校验已存在的打卡记录
	 *
	 * @param tenantId      租户id
	 * @param projectId     项目id
	 * @param phone         手机号
	 * @param punchCardType 打卡类型：上班打卡、下班打卡
	 *
	 * @return {@link CommonResponse}<{@link List}<{@link AttendanceLogVO}>>
	 */
	CommonResponse<List<AttendanceLogVO>> checkExistedLog(Long tenantId, Long projectId, String phone, String punchCardType);
}
