package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.utils.EJCDateUtil;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.labor.vo.SalaryDetailVO;
import com.ejianc.business.labor.vo.SalaryVO;
import com.ejianc.business.labor.vo.importSalaryDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.labor.mapper.SalaryMapper;
import com.ejianc.business.labor.bean.SalaryEntity;
import com.ejianc.business.labor.service.ISalaryService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 劳务工资单
 * 
 * @author generator
 * 
 */
@Service("salaryService")
public class SalaryServiceImpl extends BaseServiceImpl<SalaryMapper, SalaryEntity> implements ISalaryService{

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String regex = "^\\d{16}|\\d{19}$";
    private static  final  String IdCardRegex="/(^\\d{15}$)|(^\\d{18}$)|(^\\d{17}(\\d|X|x)$)/";
    @Autowired
    private IWorkRecordService workRecordService;

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<importSalaryDetailVO> successList = new ArrayList<>();
            List<importSalaryDetailVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 16) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
                if (result.size()>=10000){
                    throw new BusinessException("文件数据不能超过10000行，超过请分批次多次导入");
                }
                List<String> idCardList = new ArrayList<>();
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    importSalaryDetailVO salaryDetailVO = new importSalaryDetailVO();
                    //WorkerName
                    if (StringUtils.isBlank(datas.get(0))) {
                        salaryDetailVO.setErrorMessage("名字为必填项");
                    }
                    salaryDetailVO.setWorkerName(datas.get(0));

                    if (datas.get(1).length() ==0) {
                        salaryDetailVO.setErrorMessage("身份证为必填项");
                    }
                    if ((datas.get(1)!=null) && (StringUtils.isNotBlank(datas.get(1)))){
                        String idCard = datas.get(1).trim();
                        if (idCardList.indexOf(idCard)==-1){
                            if (!idCard.matches(IdCardRegex)){
                                salaryDetailVO.setErrorMessage("填写身份证号错误");
                            }
                            idCardList.add(idCard);
                            salaryDetailVO.setIdCard(idCard);
                        }else {
                            salaryDetailVO.setErrorMessage(i + 1 + "行身份证号重复");
                        }
                    }
                    //sex
                    if (datas.get(2)!=null) {
                        if ("男".equals(datas.get(2))){
                            salaryDetailVO.setSex("1");
                        } else {
                            salaryDetailVO.setSex("2");
                        }
                    }
                    //班组
                    salaryDetailVO.setTeamName(datas.get(3));
                    //工种
                    salaryDetailVO.setWorkTypeName(datas.get(4));
                    //开户行
                    salaryDetailVO.setBankName(datas.get(5));
                    //银行卡号
                    if (datas.get(6)!=null &&  !datas.get(6).matches(regex)){
                        salaryDetailVO.setErrorMessage("银行卡号填写错误");
                    }
                    salaryDetailVO.setBankCard(datas.get(6));
                    //工资类型
                    if (datas.get(7)!=null){
                        String wagesTypeName = datas.get(7);
                        String wagesType=null;
                        if ("按小时计算".equals(wagesTypeName)) {
                            wagesType="1";
                        }
                        else if ("按日计算".equals(wagesTypeName)) {
                            wagesType="2";
                        }
                        else if ("按月计算".equals(wagesTypeName)) {
                            wagesType="3";
                        }
                        else if ("按工程量计算".equals(wagesTypeName)) {
                            wagesType="4";
                        }
                        salaryDetailVO.setWagesType(wagesType);
                    }
                    //工价
                    if (StringUtils.isNotBlank(datas.get(8))) {
                        try {
                            salaryDetailVO.setPrice(new BigDecimal(datas.get(8)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("工价为必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("工价为必填项");
                    }
                    //实际考勤
                    if (StringUtils.isNotBlank(datas.get(9))) {
                        try {
                            salaryDetailVO.setActualCheckNum(new BigDecimal(datas.get(9)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("实际考勤为必须为数字");
                        }
                    } else {
                        salaryDetailVO.setErrorMessage("实际考勤为必填项");
                    }
                    if (salaryDetailVO.getActualCheckNum()!=null && salaryDetailVO.getPrice()!=null ){
                        BigDecimal mny = ComputeUtil.safeMultiply(salaryDetailVO.getActualCheckNum(), salaryDetailVO.getPrice());
                        salaryDetailVO.setMny(mny);
                    }
                    //加班工资
                    if (StringUtils.isNotBlank(datas.get(10))) {
                        try {
                            salaryDetailVO.setOvertimeMny(new BigDecimal(datas.get(10)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("加班工资为必须为数字");
                        }
                    }
                    //扣款
                    if (StringUtils.isNotBlank(datas.get(11))) {
                        try {
                            salaryDetailVO.setDeductMny(new BigDecimal(datas.get(11)));
                        } catch (Exception e) {
                            salaryDetailVO.setErrorMessage("扣款为必须为数字");
                        }
                    }
                    //扣款原因
                    salaryDetailVO.setDeductReason(datas.get(12));
                    //扣款原因
                    salaryDetailVO.setDeductReason(datas.get(13));
                    //应发工资
                    BigDecimal shouldSalaryMny = ComputeUtil.safeSub(ComputeUtil.safeAdd(salaryDetailVO.getMny(), salaryDetailVO.getOvertimeMny()), salaryDetailVO.getDeductMny());
                    salaryDetailVO.setShouldSalaryMny(shouldSalaryMny);
                    salaryDetailVO.setDeductReason(datas.get(15));
                    QueryWrapper<WorkRecordEntity> objectQueryWrapper = new QueryWrapper<>();
                    //加上租户id过滤
                    objectQueryWrapper.eq("tenant_id",InvocationInfoProxy.getTenantid());
                    objectQueryWrapper.eq("id_card",salaryDetailVO.getIdCard());
                    objectQueryWrapper.orderByDesc("enter_date");
                    List<WorkRecordEntity> list = workRecordService.list(objectQueryWrapper);
                    if (CollectionUtils.isNotEmpty(list)){
                        WorkRecordEntity entity = list.get(0);
                        salaryDetailVO.setContractId(entity.getSubContractId());
                        salaryDetailVO.setContractName(entity.getSubContractName());
                        salaryDetailVO.setSupplierId(entity.getSupplierId());
                        salaryDetailVO.setSupplierName(entity.getSupplierName());
                        salaryDetailVO.setWorkerId(entity.getWorkerId());
                        salaryDetailVO.setPhone(entity.getPhone());
                        logger.info("身份证号匹配的信息"+JSONObject.toJSONString(entity));
                        if (entity.getEnterDate()!=null && entity.getExitDate()!=null){
                            String enterDate = EJCDateUtil.format(entity.getEnterDate(), EJCDateUtil.DATE);
                            String exitDate = EJCDateUtil.format(entity.getExitDate(), EJCDateUtil.DATE);
                            List<String> dayBetween = EJCDateUtil.getDayBetween(enterDate, exitDate);
                            salaryDetailVO.setSysCheckNum(dayBetween.size());
                        }
                        salaryDetailVO.setSource("1");
                    }else {
                        salaryDetailVO.setSource("2");
                    }
                    if (StringUtils.isBlank(salaryDetailVO.getErrorMessage())) {
                        successList.add(salaryDetailVO);
                    }else {
                        errorList.add(salaryDetailVO);
                    }
                }
            }
            //errorListTable
            JSONObject json = new JSONObject();
            json.put("successList", successList);
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
}

    @Override
    public Integer haveSalaryFlag(Long workerId, String exitDate) {
        return baseMapper.haveSalaryFlag(workerId,exitDate);
    }

    @Override
    public List<AttendanceVO> queryWorkerAttendanceList(Long workerId, String month) {
        return baseMapper.queryWorkerAttendanceList(workerId,month);
    }

    @Override
    public List<SalaryVO> querySalaryPage(QueryWrapper wrapper, String salaryMonth, Page<SalaryVO> page) {
        return baseMapper.querySalaryPage(wrapper,salaryMonth,page);
    }
}
