package com.ejianc.business.labor.service.impl;

import cn.hutool.log.Log;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.*;
import com.ejianc.business.labor.enums.LastFlagEnum;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.labor.mapper.WorkRecordMapper;
import com.ejianc.business.labor.service.IWorkRecordService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 用工记录
 * 
 * @author generator
 * 
 */
@Service("workRecordService")
public class WorkRecordServiceImpl extends BaseServiceImpl<WorkRecordMapper, WorkRecordEntity> implements IWorkRecordService{

    private static final String RECORD_BILL_TYPE = "BT202211000002";//用工记录 billType
    private static final String ENTER_BILL_TYPE = "BT202211000003";//劳务进场 billType
    private static final String WORKER_BILL_TYPE = "BT202211000007";//劳务 billType
    private static final String IDCARD_SOURCE_TYPE = "idCardFront";// 身份证信息正面 sourceType
    private static final String IDBACK_TYPE = "idCardBack";// 身份证信息反面sourceType
    private static final String FACE_TYPE = "face";// 人脸 sourceType ORDER_TYPE
    private static final String ORDER_TYPE = "desc";//ORDER_TYPE

    private static final String RECORD_FILE_SOURCE_TYPE = "workerUser";// 用工记录 附件管理 sourceType
    private static final String ENTER_FILE_SOURCE_TYPE = "worker001";// 劳务进场 附件管理 sourceType
    private static final String WORKER_FILE_SOURCE_TYPE = "worker001";// 劳务 附件管理 sourceType
    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IWorkerService workerService;
    @Autowired
    private IWorkerEnterService workerEnterService;
    /**
     * 公司推送 设置:
     *      teamId teamName orgTeamId orgTeamName
     *      workType workTypeName orgWorkType  orgWorkTypeName
     *
     *
     * 项目推送 设置:
     *      teamId teamName projectTeamId projectTeamName
     *      workType workTypeName projectWorkType projectWorkTypeName
     *
     *
     * 设置来源: sourceFlag 来源（1自制-劳务进场单、2公司花名册、3邀请）
     * @param voList
     * @return
     */
    @Override
    public List<WorkRecordVO> insertWorkRecord(List<WorkRecordVO> voList){
        List<WorkRecordVO> returnList = new ArrayList<>();
        for (WorkRecordVO vo:voList){
            //根据用户 id 查询
            QueryWrapper<WorkRecordEntity> query = new QueryWrapper<>();
            query.eq("project_id", vo.getProjectId());
            query.eq("last_flag", LastFlagEnum.是.getStatus());
            query.eq("worker_id", vo.getWorkerId());
            WorkRecordEntity one = super.getOne(query);
            //存在修改旧的
            if (one!=null){
                LambdaUpdateWrapper<WorkRecordEntity> wrapper = new LambdaUpdateWrapper<>();
                wrapper.set(WorkRecordEntity::getLastFlag,LastFlagEnum.否.getStatus());
                wrapper.eq(WorkRecordEntity::getId,one.getId());
                super.update(wrapper);
            }
            WorkRecordEntity entity = BeanMapper.map(vo, WorkRecordEntity.class);
            entity.setLastFlag(LastFlagEnum.是.getStatus());
            entity.setEnterDate(new Date());
            super.saveOrUpdate(entity);
            WorkRecordVO recordVO = BeanMapper.map(entity, WorkRecordVO.class);
            returnList.add(recordVO);
            //引入认证信息 这里劳务进场推送的时候 会先推送到公司花名册  也就是说 无脑公司就可已
            orgToProjectCertified(entity);
        }
        return returnList;
    }


    void orgToProjectCertified(WorkRecordEntity entity){
        List<String> typeList = new ArrayList();
        typeList.add(IDCARD_SOURCE_TYPE);
        typeList.add(IDBACK_TYPE);
        typeList.add(FACE_TYPE);
        for (String s :typeList){
            attachmentApi.copyFilesFromSourceBillToTargetBill(
                    Long.toString(entity.getWorkerId()), WORKER_BILL_TYPE, s,
                    Long.toString(entity.getId()), RECORD_BILL_TYPE, s
            );
        }
    }
    /**
     *  如修改了基本信息（除班组外）
     *  修改后会自动同步公司花名册
     * @param vo
     * @return
     */
    @Override
    public WorkRecordVO updateWorkRecord(WorkRecordVO vo) {
        LambdaQueryWrapper<WorkerEntity> idCardQueryWrapper = new LambdaQueryWrapper<>();
        idCardQueryWrapper.eq(WorkerEntity::getIdCard, vo.getIdCard());
        idCardQueryWrapper.eq(WorkerEntity::getTenantId, InvocationInfoProxy.getTenantid());
        idCardQueryWrapper.ne(vo.getSourceId() != null, WorkerEntity::getId, vo.getSourceId());
        List<WorkerEntity> idCardList = workerService.list(idCardQueryWrapper);
        LambdaQueryWrapper<WorkerEntity> phoneQueryWrapper = new LambdaQueryWrapper<>();
        phoneQueryWrapper.eq(WorkerEntity::getPhone, vo.getPhone());
        phoneQueryWrapper.eq(WorkerEntity::getTenantId, InvocationInfoProxy.getTenantid());
        phoneQueryWrapper.ne(vo.getSourceId() != null, WorkerEntity::getId, vo.getSourceId());
        List<WorkerEntity> phoneList = workerService.list(phoneQueryWrapper);
        if (CollectionUtils.isNotEmpty(idCardList)) {
            throw new BusinessException("保存或修改单据失败，公司花名册身份证已存在");
        } else if (CollectionUtils.isNotEmpty(phoneList)) {
            throw new BusinessException("保存或修改单据失败，公司花名册手机号已存在");
        }
        WorkRecordEntity entity = BeanMapper.map(vo, WorkRecordEntity.class);
        super.saveOrUpdate(entity,false);
        WorkerEntity workerEntity= workerService.selectById(entity.getWorkerId());
        // 回写数据到 公司花名册 班组外
        if (workerEntity!=null){
            // 最后更新的项目id
            workerEntity.setLastProjectId(entity.getProjectId());
            if (entity.getName()!=null){//姓名
                workerEntity.setName(entity.getName());
            }
            if (entity.getPhone()!=null){//手机号
                workerEntity.setPhone(entity.getPhone());
            }
            if (entity.getSex()!=null){//性别
                workerEntity.setSex(entity.getSex());
            }
            if (entity.getBirthDate()!=null){//出生年月
                workerEntity.setBirthDate(entity.getBirthDate());
            }
            if (entity.getNation()!=null){// 民族
                workerEntity.setNation(entity.getNation());
            }
            if (entity.getWorkType()!=null){// 工种
                workerEntity.setWorkType(entity.getWorkType());
            }
            if (entity.getWorkTypeName()!=null){// 工种名称
                workerEntity.setWorkTypeName(entity.getWorkTypeName());
            }
            if (entity.getBankName()!=null){// 开户行
                workerEntity.setBankName(entity.getBankName());
            }
            if (entity.getBankAccount()!=null){// 银行账号
                workerEntity.setBankAccount(entity.getBankAccount());
            }
            if (entity.getWagesType()!=null){// 工资类型
                workerEntity.setWagesType(entity.getWagesType());
            }
            if (entity.getWagesTypeName()!=null){// 工资类型名称
                workerEntity.setWagesTypeName(entity.getWagesTypeName());
            }
            if (entity.getWage()!=null){// 工价
                workerEntity.setWage(entity.getWage());
            }
            if (entity.getProvince()!=null){// 省
                workerEntity.setProvince(entity.getProvince());
            }
            if (entity.getCity()!=null){// 市
                workerEntity.setCity(entity.getCity());
            }
            if (entity.getArea()!=null){// 省市
                workerEntity.setArea(entity.getArea());
            }
            if (entity.getAddress()!=null){// 详细地址
                workerEntity.setAddress(entity.getAddress());
            }
            if (entity.getWagesTypeName()!=null){// 工资类型名称
                workerEntity.setWagesTypeName(entity.getWagesTypeName());
            }
            if (entity.getMemo()!=null){// 备注
                workerEntity.setMemo(entity.getMemo());
            }

            if (entity.getMemo()!=null){// 工资类型名称
                workerEntity.setMemo(entity.getMemo());
            }
            if (entity.getMemo()!=null){// 工资类型名称
                workerEntity.setMemo(entity.getMemo());
            }
            if (entity.getMemo()!=null){// 工资类型名称
                workerEntity.setMemo(entity.getMemo());
            }
            if (entity.getMemo()!=null){// 工资类型名称
                workerEntity.setMemo(entity.getMemo());
            }

            workerService.saveOrUpdate(workerEntity);
            updateAttachmentCheck(entity);
            //查询项目花名册是否存在附件 项目花名册 往公司花名册 上加
            CommonResponse<List<AttachmentVO>> recordFileResponse = attachmentApi.queryListBySourceId(
                    entity.getId(), RECORD_BILL_TYPE, RECORD_FILE_SOURCE_TYPE, ORDER_TYPE);
            if (!recordFileResponse.isSuccess()){
                throw new BusinessException("网络异常 访问文件中心异常");
            }
            if (CollectionUtils.isNotEmpty(recordFileResponse.getData())){
                //写入公司花名册附件
                attachmentApi.copyFilesFromSourceBillToTargetBill(
                        Long.toString(entity.getId()),RECORD_BILL_TYPE,RECORD_FILE_SOURCE_TYPE,
                        Long.toString(entity.getWorkerId()),WORKER_BILL_TYPE,WORKER_FILE_SOURCE_TYPE);
            }
        }
        if (entity.getSourceFlag()==1){
            // 分包合同、供应商：修改时需要回写对应的进场记录；
            WorkerEnterEntity workerEnterEntity = workerEnterService.selectById(entity.getSourceId());
            if (workerEnterEntity!=null){
                if (entity.getSubContractId()!=null){
                    // 分包合同、供应商
                    workerEnterEntity.setSubContractId(entity.getSubContractId());
                    workerEnterEntity.setSubContractName(entity.getSubContractName());
                    workerEnterEntity.setSupplierId(entity.getSupplierId());
                    workerEnterEntity.setSubContractName(entity.getSupplierName());
                }
                workerEnterService.saveOrUpdate(workerEnterEntity);
            }
        }
        WorkRecordVO returnVo = BeanMapper.map(entity, WorkRecordVO.class);
        returnVo.setBillState(0);
        return returnVo;
    }

    @Override
    public WorkRecordVO updateBatWorker(WorkRecordVO updateVO) {
        List<Long> ids = updateVO.getIds();//用户ids
        String teamId = updateVO.getTeamId();//所选班组
        String teamName = updateVO.getTeamName();//班组名称
        String workType = updateVO.getWorkType();//所选工种
        String workTypeName = updateVO.getWorkTypeName();//工种名称
        Long supplierId = updateVO.getSupplierId();
        String supplierName = updateVO.getSupplierName();
        Long subContractId = updateVO.getSubContractId();
        String subContractName = updateVO.getSubContractName();

        if(CollectionUtils.isNotEmpty(ids)){
            //回写数据
            QueryWrapper<WorkRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.in("id",ids);
            List<WorkRecordEntity> list = super.list(queryWrapper);
            List<Long> workerEntities = new ArrayList<>();
            List<Long> enterEntities = new ArrayList<>();
            for (WorkRecordEntity record:list){
                if (record.getSourceFlag()==1){
                    enterEntities.add(record.getSourceId());
                }
                workerEntities.add(record.getWorkerId());
            }


            if(teamName!=null || workType!=null||subContractId!=null){
                LambdaUpdateWrapper<WorkRecordEntity> wrapper = new LambdaUpdateWrapper<>();
                LambdaUpdateWrapper<WorkerEntity> workerEntityWrapper = new LambdaUpdateWrapper<>();
                LambdaUpdateWrapper<WorkerEnterEntity> enterWrapper = new LambdaUpdateWrapper<>();

                wrapper.set(teamId!=null,WorkRecordEntity::getTeamId,teamId);
                wrapper.set(teamId!=null,WorkRecordEntity::getTeamName,teamName);
                wrapper.set(workType!=null,WorkRecordEntity::getWorkType,workType);
                wrapper.set(workTypeName!=null,WorkRecordEntity::getWorkTypeName,workTypeName);
                wrapper.set(supplierId!=null,WorkRecordEntity::getSupplierId,supplierId);
                wrapper.set(supplierName!=null,WorkRecordEntity::getSupplierName,supplierName);
                wrapper.set(subContractId!=null,WorkRecordEntity::getSubContractId,subContractId);
                wrapper.set(subContractName!=null,WorkRecordEntity::getSubContractName,subContractName);
                wrapper.in(WorkRecordEntity::getId,ids);
                //回写公司
                workerEntityWrapper.set(workType!=null,WorkerEntity::getWorkType,workType);
                workerEntityWrapper.set(workTypeName!=null,WorkerEntity::getWorkTypeName,workTypeName);
                workerEntityWrapper.in(WorkerEntity::getId,workerEntities);



                enterWrapper.set(supplierId!=null,WorkerEnterEntity::getSupplierId,supplierId);
                enterWrapper.set(supplierName!=null,WorkerEnterEntity::getSupplierName,supplierName);
                enterWrapper.set(subContractId!=null,WorkerEnterEntity::getSubContractId,subContractId);
                enterWrapper.set(subContractName!=null,WorkerEnterEntity::getSubContractName,subContractName);
                enterWrapper.in(WorkerEnterEntity::getId,enterEntities);
                super.update(wrapper);
                if (workType!=null&&CollectionUtils.isNotEmpty(workerEntities)){
                    workerService.update(workerEntityWrapper);
                }
                //回写入场
                if (subContractId!=null&&CollectionUtils.isNotEmpty(enterEntities)){
                    workerEnterService.update(enterWrapper);
                }
            }
        }

        return updateVO;
    }

    /**
     *  图片校验的回写 项目花名册 往公司花名册 写
     */
    void updateAttachmentCheck(WorkRecordEntity entity){
        List<String> typeList = new ArrayList();
        typeList.add(IDCARD_SOURCE_TYPE);
        typeList.add(IDBACK_TYPE);
        typeList.add(FACE_TYPE);
        for (String s :typeList){
            //1.项目花名册 是否存在
            CommonResponse<List<AttachmentVO>> idCardResponse = attachmentApi.queryListBySourceId(
                    entity.getId(), RECORD_BILL_TYPE, s, ORDER_TYPE);
            if (!idCardResponse.isSuccess()){
                throw new BusinessException("网络异常 访问文件中心异常");
            }
            //2.存在就修改公司花名册 修改记录
            if (CollectionUtils.isNotEmpty(idCardResponse.getData())){
                //3.查询公司花名册 是否存在
                CommonResponse<List<AttachmentVO>> orgIdCardResponse = attachmentApi.queryListBySourceId(
                        entity.getWorkerId(), WORKER_BILL_TYPE, s, ORDER_TYPE);
                if (!orgIdCardResponse.isSuccess()){
                    throw new BusinessException("网络异常 查询文件中心异常");
                }
                if (CollectionUtils.isNotEmpty(orgIdCardResponse.getData())){
                    //4.公司花名册 存在就删除
                    CommonResponse<String> deleteFileByParam = attachmentApi.deleteFileByParam(
                            entity.getWorkerId(), WORKER_BILL_TYPE, s);
                    if (!deleteFileByParam.isSuccess()){
                        throw new BusinessException("网络异常 文件中心删除失败");
                    }
                }
                //5.然后写入公司花名册
                CommonResponse<String> commonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(
                        Long.toString(entity.getId()), RECORD_BILL_TYPE,s ,
                        Long.toString(entity.getWorkerId()),WORKER_BILL_TYPE ,s );
                if (!commonResponse.isSuccess()){
                    throw new BusinessException("网络异常 文件中心复制失败");
                }
            }
        }

    }

}
