package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.*;
import com.ejianc.business.labor.service.ISalaryService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerExitService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.utils.EJCDateUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.stream.Collectors;

@Service("workerExit") 
public class WorkerExitBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IWorkRecordService workRecordService;

	@Autowired
	private IWorkerService workerService;
	@Autowired
	private IWorkerExitService service;
	@Autowired
	private ISalaryService salaryService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		WorkerExitEntity workerExitEntity = service.selectById(billId);
		List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
		if (CollectionUtils.isNotEmpty(workerExitDetailList)){
			for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
				LambdaUpdateWrapper<WorkRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
				updateWrapper.eq(WorkRecordEntity::getProjectId,workerExitEntity.getProjectId());
				updateWrapper.eq(WorkRecordEntity::getWorkerId,workerExitDetailEntity.getWorkerId());
				updateWrapper.eq(WorkRecordEntity::getLastFlag,1);
				updateWrapper.set(WorkRecordEntity::getEnterExitState,0);
				updateWrapper.set(WorkRecordEntity::getExitDate,workerExitDetailEntity.getExitDate());
				workRecordService.update(updateWrapper);
				//公司花名册是否回写 进场状态
				LambdaUpdateWrapper<WorkerEntity> workerWrapper = new LambdaUpdateWrapper<>();
				workerWrapper.eq(WorkerEntity::getId,workerExitDetailEntity.getWorkerId());
				workerWrapper.set(WorkerEntity::getWorkState,0); //0未入场
				workerService.update(workerWrapper);
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		WorkerExitEntity workerExitEntity = service.selectById(billId);
		List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
		if (CollectionUtils.isNotEmpty(workerExitDetailList)){
			for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
				QueryWrapper<WorkRecordEntity> objectQueryWrapper = new QueryWrapper<>();
				objectQueryWrapper.eq("project_id",workerExitEntity.getProjectId());
				objectQueryWrapper.eq("worker_id",workerExitDetailEntity.getWorkerId());
				objectQueryWrapper.eq("enter_exit_state",1);
				List<WorkRecordEntity> list = workRecordService.list(objectQueryWrapper);
				if (CollectionUtils.isNotEmpty(list)){
					String err="姓名:"+workerExitDetailEntity.getWorkerName()+",已经进场,不支持弃审";
				    return CommonResponse.error(err);
				}
				/**
				 * 之后该人员是否有工资单
				 */
				String exitDate = EJCDateUtil.format(workerExitDetailEntity.getExitDate(), EJCDateUtil.MONTH);
				Integer con=salaryService.haveSalaryFlag(workerExitDetailEntity.getWorkerId(),exitDate);
			    if (con>1){
					String err="姓名:"+workerExitDetailEntity.getWorkerName()+",已经有工资单,不支持弃审";
					return CommonResponse.error(err);
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		WorkerExitEntity workerExitEntity = service.selectById(billId);
		List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
		if (CollectionUtils.isNotEmpty(workerExitDetailList)){
			for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
				LambdaUpdateWrapper<WorkRecordEntity> updateWrapper = new LambdaUpdateWrapper<>();
				updateWrapper.eq(WorkRecordEntity::getProjectId,workerExitEntity.getProjectId());
				updateWrapper.eq(WorkRecordEntity::getWorkerId,workerExitDetailEntity.getWorkerId());
				updateWrapper.eq(WorkRecordEntity::getLastFlag,1);
				updateWrapper.set(WorkRecordEntity::getEnterExitState,1);
				updateWrapper.set(WorkRecordEntity::getExitDate,null);
				workRecordService.update(updateWrapper);
				//公司花名册是否回写 进场状态
				LambdaUpdateWrapper<WorkerEntity> workerWrapper = new LambdaUpdateWrapper<>();
				workerWrapper.eq(WorkerEntity::getId,workerExitDetailEntity.getWorkerId());
				workerWrapper.set(WorkerEntity::getWorkState,1); //0未入场
				workerService.update(workerWrapper);
			}
		}
		return CommonResponse.success();
	}

}
