/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.AttendanceBindEntity;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.bean.AttendanceLogEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorktimeSetDetailEntity;
import com.ejianc.business.labor.bean.WorktimeSetEntity;
import com.ejianc.business.labor.common.dtoMapper.AttendanceLogMapper;
import com.ejianc.business.labor.common.dtoMapper.WorkRecordMapper;
import com.ejianc.business.labor.service.IAmapService;
import com.ejianc.business.labor.service.IAttendanceBindService;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorktimeSetService;
import com.ejianc.business.labor.utils.MockLogin;
import com.ejianc.business.labor.vo.AttendanceLogVO;
import com.ejianc.business.labor.vo.DistanceVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="attendanceLogService")
public class AttendanceLogServiceImpl
extends BaseServiceImpl<com.ejianc.business.labor.mapper.AttendanceLogMapper, AttendanceLogEntity>
implements IAttendanceLogService {
    private static final String WEIXIN_OAUTH_2_URL = "https://api.weixin.qq.com/sns/oauth2/access_token";
    private static final String DEFAULT_TEMPLATE_CODE = "SMS_195335075";
    private static final String CODE = "Weixin";
    private static final String BILL_TYPE = "BT202211000002";
    private static final String START_WORK = "\u4e0a\u73ed\u6253\u5361";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private EnvironmentTools environmentTools;
    @Resource
    private IThirdSystemApi thirdSystemApi;
    @Resource
    private IAmapService amapService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private MockLogin mockLogin;
    @Resource
    private IAttendanceBindService attendanceBindService;
    @Resource
    private IWorkRecordService workRecordService;
    @Resource
    private IAttachmentApi attachmentApi;
    @Resource
    private IAttendanceService attendanceService;
    @Resource
    private IWorktimeSetService worktimeSetService;
    @Resource
    private IFaceAndIdCardService faceAndIdCardService;
    @Resource
    private IUserApi userApi;

    @Override
    public String getOpenId(String code) {
        Assert.hasText((String)code, (String)"\u4e34\u65f6\u767b\u5f55\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse thirdSystemResponse = this.thirdSystemApi.getOneByCode(CODE);
        if (!thirdSystemResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + thirdSystemResponse.getMsg());
        }
        ThirdSystemVO thirdSystemVO = (ThirdSystemVO)thirdSystemResponse.getData();
        String configInfo = thirdSystemVO.getConfigInfo();
        JSONObject configJson = JSON.parseObject((String)configInfo);
        String appId = configJson.getString("appid");
        String secret = configJson.getString("secret");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appid", appId);
        paramMap.put("secret", secret);
        paramMap.put("code", code);
        paramMap.put("grant_type", "authorization_code");
        HttpResponse response = HttpUtil.createGet((String)WEIXIN_OAUTH_2_URL).form(paramMap).execute();
        if (!response.isOk()) {
            throw new BusinessException("\u8bf7\u6c42\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)response.body());
        if (jsonObject.containsKey((Object)"errcode")) {
            throw new BusinessException("\u83b7\u53d6openid\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + jsonObject.getString("errmsg"));
        }
        return jsonObject.getString("openid");
    }

    @Override
    public String checkBind(Long tenantId, String openid) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(AttendanceBindEntity::getOpenid, (Object)openid);
        AttendanceBindEntity attendanceBindEntity = (AttendanceBindEntity)((Object)this.attendanceBindService.getOne((Wrapper)lambdaQuery));
        return attendanceBindEntity.getPhone();
    }

    @Override
    public String sendMsg(Long tenantId, Long projectId, String phone, String templateCode, String signName) throws Exception {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)templateCode, (String)"\u77ed\u4fe1\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)signName, (String)"\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        if (workRecordEntity == null) {
            throw new BusinessException("\u624b\u673a\u53f7\u5728\u5e73\u53f0\u79df\u6237\u82b1\u540d\u518c\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", (Object)phone);
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            messageParam.put("templateCode", (Object)DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put("templateCode", (Object)templateCode);
        }
        if (StringUtils.isNotBlank((CharSequence)signName)) {
            messageParam.put("signName", (Object)signName);
        }
        String messageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
        this.logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a[{}]", (Object)phone, (Object)responseStr);
        CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
        return "\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01";
    }

    @Override
    public void login(Long tenantId, Long projectId, String phone, String templateCode, String validate, String openid) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)validate, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)openid, (String)"openid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String checkMessageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/checkMessage";
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{templateCode})) {
            param.put("templateCode", templateCode);
        } else {
            param.put("templateCode", DEFAULT_TEMPLATE_CODE);
        }
        param.put("phone", phone);
        param.put("validate", validate);
        HttpResponse response = HttpUtil.createPost((String)checkMessageUrl).form(param).execute();
        if (!response.isOk()) {
            throw new BusinessException("\u6821\u9a8c\u9a8c\u8bc1\u7801\u5931\u8d25\uff01");
        }
        String checkBind = this.checkBind(tenantId, openid);
        if (StringUtils.isBlank((CharSequence)checkBind)) {
            AttendanceBindEntity attendanceBindEntity = new AttendanceBindEntity();
            attendanceBindEntity.setTenantId(tenantId);
            attendanceBindEntity.setPhone(phone);
            attendanceBindEntity.setOpenid(openid);
            this.attendanceBindService.saveOrUpdateNoES((Object)attendanceBindEntity);
        } else {
            LambdaUpdateWrapper lambdaUpdate = Wrappers.lambdaUpdate();
            lambdaUpdate.eq(AttendanceBindEntity::getOpenid, (Object)openid);
            lambdaUpdate.set(AttendanceBindEntity::getPhone, (Object)phone);
            this.attendanceBindService.update((Wrapper)lambdaUpdate);
        }
    }

    @Override
    public List<JSONObject> fetchProject(String phone) {
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        List workRecordEntityList = this.workRecordService.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)workRecordEntityList)) {
            for (WorkRecordEntity workRecord : workRecordEntityList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("projectId", (Object)workRecord.getProjectId());
                jsonObject.put("projectName", (Object)workRecord.getProjectName());
                result.add(jsonObject);
            }
        }
        return result;
    }

    @Override
    public CommonResponse<String> checkFaceDataSetting(Long tenantId, Long projectId, String phone) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        if (workRecordEntity == null) {
            throw new BusinessException("\u624b\u673a\u53f7\u5728\u5e73\u53f0\u79df\u6237\u82b1\u540d\u518c\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        CommonResponse response = this.attachmentApi.queryListBySourceId(workRecordEntity.getId(), BILL_TYPE, "face", null);
        if (!response.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            return CommonResponse.error((String)"\u63d0\u793a\uff1a\u5f53\u524d\u7528\u6237\u672a\u8bbe\u7f6e\u4eba\u8138\u4fe1\u606f\uff0c\u65e0\u6cd5\u8fdb\u884c\u624b\u673a\u6253\u5361\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\u6dfb\u52a0\uff1b");
        }
        return CommonResponse.success();
    }

    @Override
    public void checkPunchCardAuth(Long tenantId, Long projectId, String phone) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        if (workRecordEntity == null || workRecordEntity.getEnterExitState() != 1) {
            throw new BusinessException("\u65e0\u8be5\u9879\u76ee\u6253\u5361\u6743\u9650");
        }
    }

    @Override
    public CommonResponse<JSONObject> checkDistance(String worktimeSetId, String destination) {
        Assert.hasText((String)worktimeSetId, (String)"\u8003\u52e4\u8bbe\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)destination, (String)"\u5f53\u524d\u4f4d\u7f6e\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject jsonObject = new JSONObject();
        WorktimeSetEntity worktimeSetEntity = (WorktimeSetEntity)((Object)this.worktimeSetService.selectById((Serializable)((Object)worktimeSetId)));
        Assert.notNull((Object)((Object)worktimeSetEntity), (String)"\u8003\u52e4\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<WorktimeSetDetailEntity> detailList = worktimeSetEntity.getWorktimeSetDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Integer offSiteFlag = worktimeSetEntity.getOffSiteFlag();
            String lngLat = detailList.stream().map(WorktimeSetDetailEntity::getLngLat).collect(Collectors.joining("|"));
            List<DistanceVO> distance = this.amapService.distance(lngLat, destination, "0");
            this.logger.info("\u6821\u9a8c\u8003\u52e4\u8303\u56f4--{}", (Object)JSON.toJSONString(distance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            Map distanceMap = distance.stream().collect(Collectors.toMap(DistanceVO::getDistance, Function.identity()));
            BigDecimal min = distance.stream().map(d -> new BigDecimal(d.getDistance())).min(Comparator.comparing(x -> x)).orElse(null);
            DistanceVO minDistanceVO = (DistanceVO)distanceMap.get(min.toString());
            WorktimeSetDetailEntity worktimeSetDetailEntity = detailList.get(Integer.parseInt(minDistanceVO.getOriginId()) - 1);
            if (new BigDecimal(minDistanceVO.getDistance()).compareTo(worktimeSetDetailEntity.getEffectiveRange()) < 0) {
                jsonObject.put("punchCardPlace", (Object)worktimeSetDetailEntity.getAddress());
                jsonObject.put("remoteFlag", (Object)0);
                return CommonResponse.success((String)"\u8003\u52e4\u8303\u56f4\u6821\u9a8c\u6210\u529f\uff01", (Object)jsonObject);
            }
            if (offSiteFlag == 1) {
                JSONObject regeo = this.amapService.regeo(destination);
                this.logger.info("\u6821\u9a8c\u8003\u52e4\u8303\u56f4\uff0c\u9006\u5730\u7406\u7f16\u7801--{}", (Object)regeo);
                String formattedAddress = regeo.getString("formatted_address");
                jsonObject.put("punchCardPlace", (Object)formattedAddress);
                jsonObject.put("remoteFlag", (Object)1);
                return CommonResponse.error((String)"\u5f53\u524d\u5b9a\u4f4d\u4e0d\u5728\u9879\u76ee\u8bbe\u5b9a\u6253\u5361\u8303\u56f4\u5185\uff0c\u7ee7\u7eed\u6253\u5361\u4f1a\u6807\u8bb0\u4e3a\u5f02\u5e38\u6253\u5361\uff0c\u662f\u5426\u786e\u5b9a\u6253\u5361\uff1f", (Object)jsonObject);
            }
            return CommonResponse.error((String)"\u5f53\u524d\u5b9a\u4f4d\u4e0d\u5728\u9879\u76ee\u8bbe\u5b9a\u6253\u5361\u8303\u56f4\u5185\uff0c\u4e0d\u5141\u8bb8\u6253\u5361", (Object)jsonObject);
        }
        return CommonResponse.error((String)"\u8003\u52e4\u8303\u56f4\u6821\u9a8c\u5931\u8d25\uff01", (Object)jsonObject);
    }

    @Override
    public CommonResponse<WorkRecordVO> checkFace(Long tenantId, Long projectId, String phone, String imgBase64A) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        if (workRecordEntity == null) {
            throw new BusinessException("\u6821\u9a8c\u4eba\u8138\u4fe1\u606f\u5931\u8d25\uff01");
        }
        CommonResponse response = this.attachmentApi.queryListBySourceId(workRecordEntity.getId(), BILL_TYPE, "face", null);
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u4eba\u8138\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Assert.notEmpty((Collection)((Collection)response.getData()), (String)"\u9879\u76ee\u82b1\u540d\u518c\u4eba\u8138\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AttachmentVO attachmentVO = (AttachmentVO)((List)response.getData()).get(0);
        String truePath = attachmentVO.getTruePath();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("imgBase64A", (Object)imgBase64A);
        jsonObject.put("imgUrlB", (Object)truePath);
        this.logger.info("\u6821\u9a8c\u4eba\u8138\uff0c\u5165\u53c2\uff0cimgBase64A--{}\uff0cimgUrlB--{}", (Object)imgBase64A, (Object)truePath);
        CommonResponse res = this.faceAndIdCardService.compareFace(jsonObject);
        this.logger.info("\u6821\u9a8c\u4eba\u8138\uff0c\u4eba\u8138\u8bc6\u522b\u7ed3\u679c--{}", (Object)res);
        if (!res.isSuccess()) {
            throw new BusinessException("\u4eba\u8138\u8bc6\u522b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        Boolean flag = (Boolean)res.getData();
        if (Boolean.TRUE.equals(flag)) {
            return CommonResponse.success((String)"\u4eba\u8138\u4fe1\u606f\u6821\u9a8c\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)workRecordEntity), WorkRecordVO.class));
        }
        return CommonResponse.error((String)"\u4eba\u8138\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff01", null);
    }

    @Override
    public CommonResponse<List<AttendanceLogVO>> checkExistedLog(Long tenantId, Long projectId, String phone, String punchCardType) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardType, (String)"\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(AttendanceLogEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(AttendanceLogEntity::getPhone, (Object)phone);
        lambdaQuery.eq(AttendanceLogEntity::getPunchCardType, (Object)punchCardType);
        lambdaQuery.eq(AttendanceLogEntity::getPunchCardDate, (Object)DateUtil.formatDate((Date)new Date()));
        if (START_WORK.equals(punchCardType)) {
            lambdaQuery.orderByDesc(AttendanceLogEntity::getStartWorkTime);
        } else {
            lambdaQuery.orderByDesc(AttendanceLogEntity::getEndWorkTime);
        }
        List logs = super.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)logs)) {
            return CommonResponse.error((String)("\u4eca\u5929\u5df2\u5b58\u5728" + punchCardType + "\uff0c\u662f\u5426\u9700\u8981\u66f4\u65b0"), (Object)BeanMapper.mapList((Iterable)logs, AttendanceLogVO.class));
        }
        return CommonResponse.success((String)"\u5df2\u5b58\u5728\u7684\u8bb0\u5f55\u6821\u9a8c\u6210\u529f\uff01");
    }

    @Override
    public AttendanceLogVO punchCard(Long tenantId, Long projectId, String phone, String punchCardType, String punchCardPlace, Integer remoteFlag) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardType, (String)"\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardPlace, (String)"\u6253\u5361\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)remoteFlag, (String)"\u662f\u5426\u662f\u5f02\u5730\u6253\u5361\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        Assert.notNull((Object)((Object)workRecordEntity), (String)"\u65e0\u8be5\u9879\u76ee\u6253\u5361\u6743\u9650");
        AttendanceLogEntity attendanceLogEntity = WorkRecordMapper.INSTANCE.transformAttendanceLogEntity(workRecordEntity);
        attendanceLogEntity.setPunchCardDate(new Date());
        if (START_WORK.equals(punchCardType)) {
            attendanceLogEntity.setStartWorkTime(new Date());
            attendanceLogEntity.setStartWorkPlace(punchCardPlace);
        } else {
            attendanceLogEntity.setEndWorkTime(new Date());
            attendanceLogEntity.setEndWorkPlace(punchCardPlace);
        }
        if (remoteFlag == 0) {
            attendanceLogEntity.setAttendanceStatus("\u6b63\u5e38");
        } else {
            attendanceLogEntity.setAttendanceStatus("\u5f02\u5e38");
        }
        attendanceLogEntity.setPunchCardType(punchCardType);
        super.saveOrUpdate((Object)attendanceLogEntity, false);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(BaseEntity::getTenantId, (Object)tenantId);
        wrapper.eq(AttendanceEntity::getProjectId, (Object)projectId);
        wrapper.eq(AttendanceEntity::getPhone, (Object)phone);
        AttendanceEntity attendanceEntity = (AttendanceEntity)((Object)this.attendanceService.getOne((Wrapper)wrapper));
        if (attendanceEntity == null) {
            AttendanceEntity entity = AttendanceLogMapper.INSTANCE.transformAttendanceEntity(attendanceLogEntity);
            if (entity.getStartWorkTime() != null && entity.getEndWorkTime() != null) {
                entity.setDuration(DateUtil.formatBetween((Date)entity.getStartWorkTime(), (Date)entity.getEndWorkTime()));
            } else {
                entity.setDuration(null);
            }
            this.attendanceService.saveOrUpdate((Object)entity, false);
        } else {
            if (START_WORK.equals(punchCardType)) {
                attendanceEntity.setStartWorkTime(attendanceLogEntity.getStartWorkTime());
                attendanceEntity.setStartWorkPlace(attendanceLogEntity.getStartWorkPlace());
            } else {
                attendanceEntity.setEndWorkTime(attendanceLogEntity.getEndWorkTime());
                attendanceEntity.setEndWorkPlace(attendanceLogEntity.getEndWorkPlace());
            }
            if (attendanceEntity.getStartWorkTime() != null && attendanceEntity.getEndWorkTime() != null) {
                attendanceEntity.setDuration(DateUtil.formatBetween((Date)attendanceEntity.getStartWorkTime(), (Date)attendanceEntity.getEndWorkTime()));
            } else {
                attendanceEntity.setDuration(null);
            }
            attendanceEntity.setAttendanceStatus(attendanceLogEntity.getAttendanceStatus());
            attendanceEntity.setRemoteFlag(attendanceLogEntity.getRemoteFlag());
            this.attendanceService.saveOrUpdate((Object)attendanceEntity, false);
        }
        return (AttendanceLogVO)BeanMapper.map((Object)((Object)attendanceLogEntity), AttendanceLogVO.class);
    }

    @Override
    public List<WorkRecordVO> internalFetchWorkRecord(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("teamName");
        fuzzyFields.add("projectWorkTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List workRecordEntityList = this.workRecordService.queryList(param);
        if (CollectionUtils.isEmpty((Collection)workRecordEntityList)) {
            return new ArrayList<WorkRecordVO>();
        }
        return BeanMapper.mapList((Iterable)workRecordEntityList, WorkRecordVO.class);
    }

    @Override
    public List<WorkRecordVO> leaderFetchWorkRecord(QueryParam param) {
        CommonResponse response = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4e0b\u5f53\u524d\u7528\u6237\u6240\u5728\u73ed\u7ec4\u7684\u5728\u573a\u7528\u6237\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0" + response.getMsg());
        }
        UserVO userVO = (UserVO)response.getData();
        String userMobile = userVO.getUserMobile();
        if (StringUtils.isBlank((CharSequence)userMobile)) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4e0b\u5f53\u524d\u7528\u6237\u6240\u5728\u73ed\u7ec4\u7684\u5728\u573a\u7528\u6237\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5f53\u524d\u7528\u6237\u5728\u7cfb\u7edf\u5185\u672a\u7ef4\u62a4\u624b\u673a\u53f7\uff01");
        }
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQuery.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid())).eq(param.getParams().containsKey("projectId"), WorkRecordEntity::getProjectId, ((Parameter)param.getParams().get("projectId")).getValue())).eq(WorkRecordEntity::getPhone, (Object)userMobile);
        WorkRecordEntity workRecord = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        if (workRecord == null) {
            return new ArrayList<WorkRecordVO>();
        }
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("teamName");
        fuzzyFields.add("projectWorkTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        QueryWrapper queryWrapper = AttendanceLogServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<String> teamIds = Arrays.asList(workRecord.getTeamId().split(","));
        queryWrapper.and(i -> {
            for (String teamId : teamIds) {
                ((QueryWrapper)i.like((Object)"team_id", (Object)teamId)).or();
            }
            return i;
        });
        List workRecordEntityList = this.workRecordService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)workRecordEntityList)) {
            return new ArrayList<WorkRecordVO>();
        }
        return BeanMapper.mapList((Iterable)workRecordEntityList, WorkRecordVO.class);
    }
}

