/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.labor.service.IFaceService;
import com.ejianc.business.labor.vo.FaceInfoVO;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="faceService")
public class FaceServiceImpl
implements IFaceService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IFaceAndIdCardService faceAndIdCardService;

    @Override
    public Boolean checkFaceQualityAndLive(FaceInfoVO faceInfoVO) {
        this.logger.info("\u4eba\u8138\u6d3b\u4f53\u6821\u9a8c\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)faceInfoVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        CommonResponse faceQuality = this.faceAndIdCardService.checkFaceQuality(faceInfoVO.getImgUrl());
        if (!faceQuality.isSuccess()) {
            this.logger.info("\u4eba\u8138\u6d3b\u4f53\u6821\u9a8c\uff0c\u6821\u9a8c\u7167\u7247\u662f\u5426\u5305\u542b\u53ef\u7528\u4eba\u8138\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)faceQuality.getMsg());
            throw new BusinessException(faceQuality.getMsg());
        }
        CommonResponse live = this.faceAndIdCardService.liveCheck(faceInfoVO.getImgUrl());
        if (!live.isSuccess()) {
            this.logger.info("\u4eba\u8138\u6d3b\u4f53\u6821\u9a8c\uff0c\u6821\u9a8c\u7167\u7247\u662f\u5426\u5305\u542b\u53ef\u7528\u4eba\u8138\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)live.getMsg());
            throw new BusinessException(live.getMsg());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean faceRegistration(FaceInfoVO faceInfoVO) {
        CommonResponse addFaceToUser;
        this.logger.info("\u4eba\u8138\u6ce8\u518c\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)faceInfoVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        this.checkFaceQualityAndLive(faceInfoVO);
        CommonResponse getFaceDbUser = this.faceAndIdCardService.getFaceDbUser(faceInfoVO.getUserId());
        if (!getFaceDbUser.isSuccess()) {
            this.logger.info("\u4eba\u8138\u6ce8\u518c\uff0c\u67e5\u8be2\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237\u662f\u5426\u5b58\u5728\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)getFaceDbUser.getMsg());
            throw new BusinessException(getFaceDbUser.getMsg());
        }
        Boolean flag = (Boolean)getFaceDbUser.getData();
        if (Boolean.FALSE.equals(flag)) {
            CommonResponse createFaceDbUser = this.faceAndIdCardService.createFaceDbUser(faceInfoVO.getUserId(), faceInfoVO.getUserName());
            if (!createFaceDbUser.isSuccess()) {
                this.logger.info("\u4eba\u8138\u6ce8\u518c\uff0c\u521b\u5efa\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)createFaceDbUser.getMsg());
                throw new BusinessException(createFaceDbUser.getMsg());
            }
        } else {
            CommonResponse updateFaceDbUser = this.faceAndIdCardService.updateFaceDbUser(faceInfoVO.getUserId(), faceInfoVO.getUserName());
            if (!updateFaceDbUser.isSuccess()) {
                this.logger.info("\u4eba\u8138\u6ce8\u518c\uff0c\u66f4\u65b0\u4eba\u8138\u6570\u636e\u5e93\u7528\u6237\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)updateFaceDbUser.getMsg());
                throw new BusinessException(updateFaceDbUser.getMsg());
            }
        }
        if (!(addFaceToUser = this.faceAndIdCardService.addFaceToUser(faceInfoVO.getUserId(), faceInfoVO.getImgUrl())).isSuccess()) {
            this.logger.info("\u4eba\u8138\u6ce8\u518c\uff0c\u6dfb\u52a0\u4eba\u8138\u6570\u636e\u5230\u6307\u5b9a\u7528\u6237\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)addFaceToUser.getMsg());
            throw new BusinessException(addFaceToUser.getMsg());
        }
        return true;
    }
}

