/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.bean.WorkerRegisterEntity;
import com.ejianc.business.labor.enums.WorkerConsts;
import com.ejianc.business.labor.service.IFaceService;
import com.ejianc.business.labor.service.IIdCardService;
import com.ejianc.business.labor.service.IOrgTeamService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerRegisterService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.utils.UserInfoValidateUtil;
import com.ejianc.business.labor.utils.WagesTypeEnum;
import com.ejianc.business.labor.vo.BatchCheckPhotoVO;
import com.ejianc.business.labor.vo.CustomValidateGroup;
import com.ejianc.business.labor.vo.FaceInfoVO;
import com.ejianc.business.labor.vo.IdentityCardInfoVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Validated
@RestController
@RequestMapping(value={"worker"})
public class WorkerController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWorkerService service;
    @Autowired
    private IOrgTeamService orgTeamService;
    @Autowired
    private IWorkerRegisterService workerRegisterService;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IWorkRecordService workRecordService;
    @Resource
    private IIdCardService iIdCardService;
    @Resource
    private IFaceService faceService;
    @Resource
    private IAttachmentApi attachmentApi;
    private static final String BILL_CODE = "LABOR_WORKER";
    private static final String WORK_RECORD_CONTRACT_SOURCE_TYPE = "workRecord001";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkerVO> saveOrUpdate(@RequestBody WorkerVO saveOrUpdateVO) {
        LambdaQueryWrapper idCardQueryWrapper = new LambdaQueryWrapper();
        idCardQueryWrapper.eq(WorkerEntity::getIdCard, (Object)saveOrUpdateVO.getIdCard());
        idCardQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        idCardQueryWrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        int idCardCount = this.service.count((Wrapper)idCardQueryWrapper);
        if (idCardCount > 0) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u5931\u8d25\uff0c\u8eab\u4efd\u8bc1\u5df2\u5b58\u5728");
        }
        LambdaQueryWrapper phoneQueryWrapper = new LambdaQueryWrapper();
        phoneQueryWrapper.eq(WorkerEntity::getPhone, (Object)saveOrUpdateVO.getPhone());
        phoneQueryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        phoneQueryWrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        int phoneCount = this.service.count((Wrapper)phoneQueryWrapper);
        if (phoneCount > 0) {
            return CommonResponse.error((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u5931\u8d25\uff0c\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        WorkerVO vo = this.service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/updateBatWorker"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkerVO> updateBatWorker(@RequestBody WorkerVO updateVO) {
        WorkerVO vo = this.service.updateBatWorker(updateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkerVO> queryDetail(Long id) {
        WorkerEntity entity = (WorkerEntity)((Object)this.service.selectById(id));
        WorkerVO vo = (WorkerVO)BeanMapper.map((Object)((Object)entity), WorkerVO.class);
        LambdaQueryWrapper workRecordWrapper = Wrappers.lambdaQuery();
        workRecordWrapper.eq(WorkRecordEntity::getWorkerId, (Object)entity.getId());
        List workRecordList = this.workRecordService.list((Wrapper)workRecordWrapper);
        List workRecordVOS = BeanMapper.mapList((Iterable)workRecordList, WorkRecordVO.class);
        if (CollectionUtils.isNotEmpty((Collection)workRecordVOS)) {
            JSONObject fileParam = new JSONObject();
            List sourceIds = workRecordVOS.stream().map(BaseVO::getId).collect(Collectors.toList());
            fileParam.put("sourceIds", sourceIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add((Object)WORK_RECORD_CONTRACT_SOURCE_TYPE);
            fileParam.put("sourceTypeList", (Object)JSONObject.toJSONString((Object)sourceTypeArr));
            CommonResponse listCommonResponse = this.attachmentApi.queryAllBySourceIdList(fileParam);
            List fileData = (List)listCommonResponse.getData();
            if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)fileData)) {
                Map fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                for (WorkRecordVO workRecordVO : workRecordVOS) {
                    AttachmentVO attachmentVO = (AttachmentVO)fileMap.get(workRecordVO.getId());
                    if (attachmentVO == null) continue;
                    workRecordVO.setSubContractFileId(attachmentVO.getId());
                    workRecordVO.setSubContractFileName(attachmentVO.getFileName());
                }
            }
        }
        vo.setWorkRecordList(workRecordVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkerVO> vos) {
        List delIds = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.service.removeByIds(delIds, true);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(BaseEntity::getDr, (Object)1);
        updateWrapper.in(WorkerRegisterEntity::getWorkerId, delIds);
        this.workerRegisterService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Map params = param.getParams();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("enabled", "desc");
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        Page pageData = null;
        IPage page = null;
        List<WorkerEntity> list = null;
        Long teamId = null;
        if (params.containsKey("teamId")) {
            Object teamIdObj = ((Parameter)params.get("teamId")).getValue();
            teamId = Long.valueOf(String.valueOf(teamIdObj));
            OrgTeamEntity byId = (OrgTeamEntity)((Object)this.orgTeamService.getById(teamId));
            teamId = byId.getParentId() == null ? null : teamId;
            params.remove("teamId");
        }
        if (teamId != null) {
            page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            list = this.service.queryOrgTeamWorkerPage((Page<WorkerEntity>)((Page)page), param, teamId);
        } else {
            page = this.service.queryPage(param, false);
            list = page.getRecords();
        }
        pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, WorkerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Map params = param.getParams();
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("enabled", "desc");
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        IPage page = null;
        List<WorkerEntity> list = null;
        Long teamId = null;
        if (params.containsKey("teamId")) {
            Object teamIdObj = ((Parameter)params.get("teamId")).getValue();
            teamId = Long.valueOf(String.valueOf(teamIdObj));
            Object byId = (OrgTeamEntity)((Object)this.orgTeamService.getById(teamId));
            teamId = byId.getParentId() == null ? null : teamId;
            params.remove("teamId");
        }
        if (teamId != null) {
            page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
            list = this.service.queryOrgTeamWorkerPage((Page<WorkerEntity>)((Page)page), param, teamId);
        } else {
            page = this.service.queryPage(param, false);
            list = page.getRecords();
        }
        List workerVOS = BeanMapper.mapList((Iterable)list, WorkerVO.class);
        for (WorkerVO workerVO : workerVOS) {
            workerVO.setSexName(WorkerConsts.SexEnum.getNameByCode((Integer)workerVO.getSex()));
            workerVO.setIdCardFrontPhotoFlagName(WorkerConsts.ValidateEnum.getNameByCode((Integer)workerVO.getIdCardFrontPhotoFlag()));
            workerVO.setFacePhotoFlagName(WorkerConsts.ValidateEnum.getNameByCode((Integer)workerVO.getFacePhotoFlag()));
            workerVO.setWorkStateName(WorkerConsts.WorkStateEnum.getNameByCode((Integer)workerVO.getWorkState()));
            workerVO.setEnabledName(WorkerConsts.EnabledEnum.getNameByCode((Integer)workerVO.getEnabled()));
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", workerVOS);
        ExcelExport.getInstance().export("Worker-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/downloadPersonTemplet"})
    @ResponseBody
    public void downloadPersonTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Worker-import.xlsx", (String)"\u5bfc\u5165\u4eba\u5458");
    }

    @RequestMapping(value={"/excelImportPerson"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImportPerson(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<WorkerVO> successList = new ArrayList<WorkerVO>();
        ArrayList<WorkerVO> errorList = new ArrayList<WorkerVO>();
        if (result != null && result.size() > 0 && ((List)result.get(0)).size() != 15) {
            throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
        }
        HashMap<String, Integer> idCardMap = new HashMap<String, Integer>();
        HashMap<String, Integer> phoneMap = new HashMap<String, Integer>();
        for (int i = 0; i < result.size(); ++i) {
            String area;
            String wage;
            String workType;
            String sex;
            int rowNum = i + 2;
            WorkerVO workerVO = new WorkerVO();
            List row = (List)result.get(i);
            StringBuilder errMsg = new StringBuilder();
            if (row.get(1) == null) continue;
            String name = ((String)row.get(0)).trim();
            workerVO.setName(name);
            if (StringUtils.isBlank((CharSequence)name)) {
                errMsg.append("`\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a`");
            }
            String idCard = ((String)row.get(1)).trim();
            workerVO.setIdCard(idCard);
            if (UserInfoValidateUtil.isIdentityCode(idCard)) {
                if (!idCardMap.containsKey(idCard)) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    wrapper.eq(WorkerEntity::getIdCard, (Object)idCard);
                    wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                    int count = this.service.count((Wrapper)wrapper);
                    if (count > 0) {
                        errMsg.append("`\u7b2c" + rowNum + "\u884c\u8eab\u4efd\u8bc1\u53f7\u5728\u516c\u53f8\u82b1\u540d\u518c\u5df2\u5b58\u5728`");
                    } else {
                        idCardMap.put(idCard, rowNum);
                    }
                } else {
                    errMsg.append("`\u7b2c" + idCardMap.get(idCard) + "\u3001" + rowNum + "\u884c\u8eab\u4efd\u8bc1\u53f7\u91cd\u590d`");
                }
            } else {
                errMsg.append("`\u8eab\u4efd\u8bc1\u53f7\u4e3a\u7a7a\u6216\u4e0d\u5408\u6cd5`");
            }
            String birthDate = ((String)row.get(2)).trim();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (StringUtils.isNotBlank((CharSequence)birthDate)) {
                try {
                    Date parse = sdf.parse(birthDate);
                    workerVO.setBirthDate(parse);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    errMsg.append("`\u51fa\u751f\u65e5\u671f\u683c\u5f0f\u6709\u8bef`");
                }
            }
            if ((sex = ((String)row.get(3)).trim()) != null) {
                if ("\u7537".equals(sex)) {
                    workerVO.setSex(WorkerConsts.SexEnum.\u7537.getCode());
                    workerVO.setSexName(WorkerConsts.SexEnum.\u7537.getName());
                } else {
                    workerVO.setSex(WorkerConsts.SexEnum.\u5973.getCode());
                    workerVO.setSexName(WorkerConsts.SexEnum.\u5973.getName());
                }
            }
            String nation = ((String)row.get(4)).trim();
            workerVO.setNation(nation);
            String teamName = ((String)row.get(5)).trim();
            if (teamName != null && !"".equals(teamName)) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.eq(OrgTeamEntity::getName, (Object)teamName);
                List list = this.orgTeamService.list((Wrapper)wrapper);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    workerVO.setTeamId(String.valueOf(((OrgTeamEntity)((Object)list.get(0))).getId()));
                    workerVO.setTeamName(((OrgTeamEntity)((Object)list.get(0))).getName());
                }
            }
            if ((workType = ((String)row.get(6)).trim()) != null && !"".equals(workType)) {
                CommonResponse workerTypeListRes = this.defdocApi.getDefDocByDefCode("labor_worker_type");
                if (workerTypeListRes.isSuccess()) {
                    List workerTypeList = (List)workerTypeListRes.getData();
                    for (DefdocDetailVO defdocDetailVO : workerTypeList) {
                        if (!defdocDetailVO.getName().equals(workType)) continue;
                        workerVO.setWorkType(String.valueOf(defdocDetailVO.getId()));
                        workerVO.setWorkTypeName(defdocDetailVO.getName());
                    }
                } else {
                    errMsg.append("`\u5de5\u79cd\u67e5\u8be2\u5931\u8d25`");
                }
            }
            String phone = ((String)row.get(7)).trim();
            workerVO.setPhone(phone);
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                if (UserInfoValidateUtil.verifyPhone(phone)) {
                    if (!phoneMap.containsKey(phone)) {
                        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                        wrapper.eq(WorkerEntity::getPhone, (Object)phone);
                        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
                        int count = this.service.count((Wrapper)wrapper);
                        if (count > 0) {
                            errMsg.append("`\u7b2c" + rowNum + "\u884c\u624b\u673a\u53f7\u5728\u516c\u53f8\u82b1\u540d\u518c\u5df2\u5b58\u5728`");
                        } else {
                            phoneMap.put(phone, rowNum);
                        }
                    } else {
                        errMsg.append("`\u7b2c" + phoneMap.get(phone) + "\u3001" + rowNum + "\u884c\u624b\u673a\u53f7\u91cd\u590d`");
                    }
                } else {
                    errMsg.append("`\u624b\u673a\u53f7\u4e0d\u6b63\u786e`");
                }
            }
            String bankName = ((String)row.get(8)).trim();
            workerVO.setBankName(bankName);
            String bankAccount = ((String)row.get(9)).trim();
            workerVO.setBankAccount(bankAccount);
            String wagesType = ((String)row.get(10)).trim();
            if (wagesType != null && !"".equals(wagesType)) {
                if (WagesTypeEnum.HOUR.getName().equals(wagesType)) {
                    workerVO.setWagesType(WagesTypeEnum.HOUR.getCode());
                    workerVO.setWagesTypeName(WagesTypeEnum.HOUR.getName());
                }
                if (WagesTypeEnum.DAY.getName().equals(wagesType)) {
                    workerVO.setWagesType(WagesTypeEnum.DAY.getCode());
                    workerVO.setWagesTypeName(WagesTypeEnum.DAY.getName());
                }
                if (WagesTypeEnum.MONTH.getName().equals(wagesType)) {
                    workerVO.setWagesType(WagesTypeEnum.MONTH.getCode());
                    workerVO.setWagesTypeName(WagesTypeEnum.MONTH.getName());
                }
                if (WagesTypeEnum.QUANT.getName().equals(wagesType)) {
                    workerVO.setWagesType(WagesTypeEnum.QUANT.getCode());
                    workerVO.setWagesTypeName(WagesTypeEnum.QUANT.getName());
                }
            }
            if ((wage = ((String)row.get(11)).trim()) != null && !"".equals(wage)) {
                workerVO.setWage(new BigDecimal(wage));
            }
            if ((area = ((String)row.get(12)).trim()) != null && !"".equals(area)) {
                Map<String, Object> map = this.service.getArea(area);
                if (map.get("province") != null) {
                    workerVO.setProvince(String.valueOf(map.get("province")));
                }
                if (map.get("city") != null) {
                    workerVO.setCity(String.valueOf(map.get("city")));
                }
                if (map.get("area") != null) {
                    workerVO.setArea(String.valueOf(map.get("area")));
                }
            }
            String address = ((String)row.get(13)).trim();
            workerVO.setAddress(address);
            String memo = ((String)row.get(14)).trim();
            workerVO.setMemo(memo);
            workerVO.setErrorMessage(errMsg.toString());
            if (StringUtils.isBlank((CharSequence)workerVO.getErrorMessage())) {
                successList.add(workerVO);
            } else {
                workerVO.setId(Long.valueOf(i));
                errorList.add(workerVO);
            }
            workerVO.setSourceFlag(WorkerConsts.SourceFlagEnum.\u516c\u53f8\u81ea\u5236.getCode());
            workerVO.setSourceFlagName(WorkerConsts.SourceFlagEnum.\u516c\u53f8\u81ea\u5236.getName());
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/saveImportPerson"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportPerson(HttpServletRequest request, @RequestBody List<WorkerVO> workerVOS) {
        return CommonResponse.success((String)this.service.saveImportPerson(request, workerVOS));
    }

    @RequestMapping(value={"refWorkerPage"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> refWorkerPage(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String relyCondition, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        Long teamId = null;
        if (StringUtils.isNotBlank((CharSequence)relyCondition)) {
            teamId = Long.parseLong(relyCondition.split("=")[1]);
            OrgTeamEntity orgTeam = (OrgTeamEntity)((Object)this.orgTeamService.getById(teamId));
            if (orgTeam == null) {
                return CommonResponse.error((String)"\u5f53\u524d\u73ed\u7ec4\u4e0d\u5b58\u5728\u6863\u6848\uff01");
            }
            teamId = orgTeam.getParentId() == null ? null : teamId;
        }
        QueryParam queryParam = new QueryParam();
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("workTypeName");
        fuzzyFields.add("teamName");
        fuzzyFields.add("phone");
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        Map param = queryParam.getParams();
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            if (search.get((Object)"name") != null) {
                param.put("name", new Parameter("like", (Object)search.get((Object)"name").toString()));
            }
            if (search.get((Object)"idCard") != null) {
                param.put("idCard", new Parameter("like", (Object)search.get((Object)"idCard").toString()));
            }
            if (search.get((Object)"workTypeName") != null) {
                param.put("workTypeName", new Parameter("like", (Object)search.get((Object)"workTypeName").toString()));
            }
            if (search.get((Object)"teamName") != null) {
                param.put("teamName", new Parameter("like", (Object)search.get((Object)"teamName").toString()));
            }
            if (search.get((Object)"phone") != null) {
                param.put("phone", new Parameter("like", (Object)search.get((Object)"phone").toString()));
            }
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("enabled", "desc");
        orderMap.put("createTime", "desc");
        queryParam.setOrderMap(orderMap);
        param.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.put("enabled", new Parameter("eq", (Object)1));
        Page pageData = null;
        IPage page = null;
        List<WorkerEntity> list = null;
        if (teamId != null) {
            page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
            list = this.service.queryOrgTeamWorkerPage((Page<WorkerEntity>)((Page)page), queryParam, teamId);
        } else {
            page = this.service.queryPage(queryParam, false);
            list = page.getRecords();
        }
        pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, WorkerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refWorkerData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> refWorkerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WorkerVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"checkAndRecognizeIdentityCardInfo"})
    public CommonResponse<IdentityCardInfoVO> checkAndRecognizeIdentityCardInfo(@RequestParam(value="imageUrl") String imageUrl, @RequestParam(value="side") String side) {
        return CommonResponse.success((String)"\u6821\u9a8c\u8eab\u4efd\u8bc1\u4ee5\u53ca\u8eab\u4efd\u8bc1\u4fe1\u606f\u8bc6\u522b\uff0c\u6210\u529f\uff01", (Object)this.iIdCardService.checkAndRecognizeIdentityCardInfo(imageUrl, side));
    }

    @PostMapping(value={"checkFaceQualityAndLive"})
    public CommonResponse<Boolean> checkFaceQualityAndLive(@Validated(value={CustomValidateGroup.Crud.Create.class}) @RequestBody FaceInfoVO faceInfoVO) {
        return CommonResponse.success((String)"\u4eba\u8138\u6d3b\u4f53\u6821\u9a8c\uff0c\u6210\u529f\uff01", (Object)this.faceService.checkFaceQualityAndLive(faceInfoVO));
    }

    @PostMapping(value={"/checkTask"})
    public CommonResponse<Void> checkTask(HttpServletRequest request) {
        this.service.checkTask(request);
        return CommonResponse.success((String)"\u5b9a\u65f6\u4efb\u52a1\uff0c\u8eab\u4efd\u8bc1\u548c\u4eba\u8138\u6821\u9a8c\u6267\u884c\u6210\u529f\uff01");
    }

    @PostMapping(value={"/download"})
    public void download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ClassPathResource resource = new ClassPathResource("zip/\u5bfc\u5165\u8bc1\u4ef6.zip");
        InputStream inputStream = resource.getInputStream();
        response.reset();
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u5bfc\u5165\u8bc1\u4ef6.zip", "utf-8"));
        response.setContentType("application/octet-stream;charset=UTF-8");
        IoUtil.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
    }

    @PostMapping(value={"batchCheck"})
    public CommonResponse<JSONObject> batchCheck(HttpServletRequest request, HttpServletResponse response) throws IOException, NoSuchFieldException, IllegalAccessException {
        return CommonResponse.success((String)"\u6279\u91cf\u6821\u9a8c\u8bc1\u4ef6\uff0c\u6210\u529f\uff01", (Object)this.service.batchCheck(request, response));
    }

    @PostMapping(value={"updatePhotoData"})
    public CommonResponse<Void> updatePhotoData(@Validated @RequestBody List<BatchCheckPhotoVO> batchCheckPhotoVOS) {
        this.service.updatePhotoData(batchCheckPhotoVOS);
        return CommonResponse.success((String)"\u66f4\u65b0\u7167\u7247\u6570\u636e\uff0c\u6210\u529f\uff01");
    }

    @GetMapping(value={"enabled"})
    public CommonResponse<String> enabled(Long id, Integer enabled) {
        if (id != null && enabled != null) {
            LambdaUpdateWrapper updWrapper = new LambdaUpdateWrapper();
            updWrapper.set(WorkerEntity::getEnabled, (Object)enabled);
            updWrapper.eq(BaseEntity::getId, (Object)id);
            this.service.update((Wrapper)updWrapper);
        }
        return CommonResponse.success((String)"\u505c\u7528/\u542f\u7528\u6210\u529f\uff01");
    }
}

