/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/projectTeam/"})
public class ProjectTeamApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private ISalarySlipService salarySlipService;

    @GetMapping(value={"/queryTeamWorkerIdByPhone"})
    CommonResponse<List<Long>> queryTeamWorkerIdByPhone(String phone, Long projectId) {
        List teamList;
        List<Object> workIds = new ArrayList();
        ArrayList<String> teamIds = new ArrayList<String>();
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"phone", (Object)phone);
        objectQueryWrapper.eq((Object)"project_id", (Object)projectId);
        List workRecordList = this.workRecordService.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)workRecordList) && CollectionUtils.isNotEmpty(teamList = workRecordList.stream().filter(s -> s.getTeamId() != null).map(WorkRecordEntity::getTeamId).collect(Collectors.toList()))) {
            for (String s2 : teamList) {
                String[] split = s2.split(",");
                teamIds.addAll(Arrays.asList(split));
            }
            if (CollectionUtils.isNotEmpty(teamIds)) {
                List<WorkRecordVO> workRecordVOs = this.salarySlipService.queryWorkByTeamId(projectId, teamIds);
                workIds = workRecordVOs.stream().filter(s -> s.getWorkerId() != null).map(WorkRecordVO::getWorkerId).collect(Collectors.toList());
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u4eba\u5458id\u6210\u529f\uff01", workIds);
    }

    @PostMapping(value={"/updateAlreadyApplyMny"})
    CommonResponse<String> updateAlreadyApplyMny(@RequestBody Map<Long, BigDecimal> map) {
        Set<Long> ids = map.keySet();
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Long id : ids) {
                BigDecimal alreadyApplyMny = map.get(id);
                LambdaUpdateWrapper objectLambdaUpdateWrapper = new LambdaUpdateWrapper();
                objectLambdaUpdateWrapper.eq(BaseEntity::getId, (Object)id);
                objectLambdaUpdateWrapper.set(SalarySlipEntity::getAlreadyApplyMny, (Object)alreadyApplyMny);
                this.salarySlipService.update((Wrapper)objectLambdaUpdateWrapper);
            }
        }
        return CommonResponse.success((String)"\u4fee\u6539\u5df2\u7ecf\u7533\u8bf7\u91d1\u989d\u6210\u529f\uff01");
    }

    @GetMapping(value={"/queryWorkerIdByPhone"})
    CommonResponse<List<Long>> queryWorkerIdByPhone(@RequestParam(value="phone") String phone) {
        List<Object> workerIds = new ArrayList();
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"phone", (Object)phone);
        List workRecordList = this.workRecordService.list((Wrapper)objectQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)workRecordList)) {
            workerIds = workRecordList.stream().filter(s -> s.getTeamId() != null).map(WorkRecordEntity::getWorkerId).distinct().collect(Collectors.toList());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u4eba\u5458id\u6210\u529f\uff01", workerIds);
    }
}

