/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.AttendanceBindEntity;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.bean.AttendanceLogEntity;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.bean.WorktimeSetDetailEntity;
import com.ejianc.business.labor.bean.WorktimeSetEntity;
import com.ejianc.business.labor.common.dtoMapper.AttendanceLogMapper;
import com.ejianc.business.labor.common.dtoMapper.WorkRecordMapper;
import com.ejianc.business.labor.service.IAmapService;
import com.ejianc.business.labor.service.IAttendanceBindService;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.service.IWorktimeSetDetailService;
import com.ejianc.business.labor.service.IWorktimeSetService;
import com.ejianc.business.labor.utils.MockLogin;
import com.ejianc.business.labor.vo.AttendanceLogVO;
import com.ejianc.business.labor.vo.DistanceVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.api.IFaceAndIdCardService;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="attendanceLogService")
public class AttendanceLogServiceImpl
extends BaseServiceImpl<com.ejianc.business.labor.mapper.AttendanceLogMapper, AttendanceLogEntity>
implements IAttendanceLogService {
    private static final String WEIXIN_OAUTH_2_URL = "https://api.weixin.qq.com/sns/oauth2/access_token";
    private static final String DEFAULT_TEMPLATE_CODE = "SMS_195335075";
    private static final String CODE = "Weixin";
    private static final String BILL_TYPE = "BT202211000007";
    private static final String START_WORK = "\u4e0a\u73ed\u6253\u5361";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private EnvironmentTools environmentTools;
    @Resource
    private IThirdSystemApi thirdSystemApi;
    @Resource
    private IAmapService amapService;
    @Resource
    private RedisTemplate<String, Object> redisTemplate;
    @Resource
    private MockLogin mockLogin;
    @Resource
    private IAttendanceBindService attendanceBindService;
    @Resource
    private IWorkerService workerService;
    @Resource
    private IWorkRecordService workRecordService;
    @Resource
    private IProjectTeamService projectTeamService;
    @Resource
    private IAttachmentApi attachmentApi;
    @Resource
    private IAttendanceService attendanceService;
    @Resource
    private IWorktimeSetService worktimeSetService;
    @Resource
    private IWorktimeSetDetailService worktimeSetDetailService;
    @Resource
    private IFaceAndIdCardService faceAndIdCardService;
    @Resource
    private IUserApi userApi;

    @Override
    public String getOpenId(String code) {
        Assert.hasText((String)code, (String)"\u4e34\u65f6\u767b\u5f55\u51ed\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse thirdSystemResponse = this.thirdSystemApi.getOneByCode(CODE);
        if (!thirdSystemResponse.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + thirdSystemResponse.getMsg());
        }
        ThirdSystemVO thirdSystemVO = (ThirdSystemVO)thirdSystemResponse.getData();
        String configInfo = thirdSystemVO.getConfigInfo();
        JSONObject configJson = JSON.parseObject((String)configInfo);
        String appId = configJson.getString("appid");
        String secret = configJson.getString("secret");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("appid", appId);
        paramMap.put("secret", secret);
        paramMap.put("code", code);
        paramMap.put("grant_type", "authorization_code");
        HttpResponse response = HttpUtil.createGet((String)WEIXIN_OAUTH_2_URL).form(paramMap).execute();
        if (!response.isOk()) {
            throw new BusinessException("\u8bf7\u6c42\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)response.body());
        if (jsonObject.containsKey((Object)"errcode")) {
            throw new BusinessException("\u83b7\u53d6openid\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + jsonObject.getString("errmsg"));
        }
        return jsonObject.getString("openid");
    }

    @Override
    public String checkBind(String openid) {
        Assert.hasText((String)openid, (String)"openid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.logger.info("\u79df\u6237\u624b\u673a\u53f7\u7ed1\u5b9aopenid\u6821\u9a8c\uff0c\u5165\u53c2\uff1aopenid-{}", (Object)openid);
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(AttendanceBindEntity::getOpenid, (Object)openid);
        AttendanceBindEntity attendanceBindEntity = (AttendanceBindEntity)this.attendanceBindService.getOne((Wrapper)lambdaQuery);
        if (attendanceBindEntity != null) {
            return attendanceBindEntity.getPhone();
        }
        return null;
    }

    @Override
    public String sendMsg(String phone, String templateCode, String signName) throws Exception {
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)templateCode, (String)"\u77ed\u4fe1\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)signName, (String)"\u77ed\u4fe1\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        List workRecordEntityList = this.workRecordService.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isEmpty((Collection)workRecordEntityList)) {
            throw new BusinessException("\u624b\u673a\u53f7\u5728\u5e73\u53f0\u82b1\u540d\u518c\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)workRecordEntityList.get(0));
        Long workerId = workRecordEntity.getWorkerId();
        WorkerEntity workerEntity = (WorkerEntity)((Object)this.workerService.selectById(workerId));
        if (workerEntity == null) {
            throw new BusinessException("\u624b\u673a\u53f7\u5728\u5e73\u53f0\u82b1\u540d\u518c\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        JSONObject messageParam = new JSONObject();
        messageParam.put("phone", (Object)phone);
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            messageParam.put("templateCode", (Object)DEFAULT_TEMPLATE_CODE);
        } else {
            messageParam.put("templateCode", (Object)templateCode);
        }
        if (StringUtils.isNotBlank((CharSequence)signName)) {
            messageParam.put("signName", (Object)signName);
        }
        String messageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/sendMessage";
        String responseStr = HttpTookit.postByJson((String)messageUrl, (String)JSON.toJSONString((Object)messageParam));
        this.logger.info("\u5411\u624b\u673a\u53f7[{}]\u53d1\u9001\u9a8c\u8bc1\u7801\u7ed3\u679c\uff1a[{}]", (Object)phone, (Object)responseStr);
        CommonResponse response = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
        if (!response.isSuccess()) {
            throw new BusinessException("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
        }
        return "\u77ed\u4fe1\u53d1\u9001\u6210\u529f\uff01";
    }

    @Override
    public void login(String phone, String templateCode, String validate, String openid) {
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)validate, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)openid, (String)"openid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String checkMessageUrl = this.environmentTools.getBaseHost() + "/ejc-message-web/no_auth/sms/checkMessage";
        HashMap<String, String> param = new HashMap<String, String>();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{templateCode})) {
            param.put("templateCode", templateCode);
        } else {
            param.put("templateCode", DEFAULT_TEMPLATE_CODE);
        }
        param.put("phone", phone);
        param.put("validate", validate);
        HttpResponse response = HttpUtil.createPost((String)checkMessageUrl).form(param).execute();
        if (!response.isOk()) {
            throw new BusinessException("\u6821\u9a8c\u9a8c\u8bc1\u7801\u5931\u8d25\uff01");
        }
        String responseStr = response.body();
        if (StringUtils.isNotBlank((CharSequence)responseStr)) {
            CommonResponse checkResponse = (CommonResponse)JSON.parseObject((String)responseStr, CommonResponse.class);
            if (0 != checkResponse.getCode()) {
                this.logger.info("\u6821\u9a8c\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)checkResponse.getMsg());
                throw new BusinessException("\u6821\u9a8c\u9a8c\u8bc1\u7801\u5931\u8d25\uff01");
            }
        } else {
            throw new BusinessException("\u6821\u9a8c\u9a8c\u8bc1\u7801\u5931\u8d25\uff01");
        }
        String checkBind = this.checkBind(openid);
        if (StringUtils.isBlank((CharSequence)checkBind)) {
            AttendanceBindEntity attendanceBindEntity = new AttendanceBindEntity();
            attendanceBindEntity.setPhone(phone);
            attendanceBindEntity.setOpenid(openid);
            this.attendanceBindService.saveOrUpdateNoES(attendanceBindEntity);
        } else {
            LambdaUpdateWrapper lambdaUpdate = Wrappers.lambdaUpdate();
            lambdaUpdate.eq(AttendanceBindEntity::getOpenid, (Object)openid);
            lambdaUpdate.set(AttendanceBindEntity::getPhone, (Object)phone);
            this.attendanceBindService.update((Wrapper)lambdaUpdate);
        }
    }

    @Override
    public List<JSONObject> fetchProject(String phone) {
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        lambdaQuery.eq(WorkRecordEntity::getEnterExitState, (Object)1);
        List workRecordEntityList = this.workRecordService.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)workRecordEntityList)) {
            for (WorkRecordEntity workRecord : workRecordEntityList) {
                JSONObject jsonObject = new JSONObject();
                Long projectId = workRecord.getProjectId();
                jsonObject.put("tenantId", (Object)workRecord.getTenantId());
                jsonObject.put("projectId", (Object)projectId);
                jsonObject.put("projectName", (Object)workRecord.getProjectName());
                LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
                lambdaQueryWrapper.eq(WorktimeSetEntity::getProjectId, (Object)projectId);
                WorktimeSetEntity worktimeSetEntity = (WorktimeSetEntity)((Object)this.worktimeSetService.getOne((Wrapper)lambdaQueryWrapper));
                jsonObject.put("worktimeSetId", (Object)(worktimeSetEntity != null ? worktimeSetEntity.getId() : null));
                result.add(jsonObject);
            }
        }
        return result;
    }

    @Override
    public CommonResponse<String> checkFaceDataSetting(Long tenantId, Long projectId, String phone) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        List workRecordEntityList = this.workRecordService.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isEmpty((Collection)workRecordEntityList)) {
            throw new BusinessException("\u624b\u673a\u53f7\u5728\u5e73\u53f0\u79df\u6237\u82b1\u540d\u518c\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)workRecordEntityList.get(0));
        Long workerId = workRecordEntity.getWorkerId();
        WorkerEntity workerEntity = (WorkerEntity)((Object)this.workerService.selectById(workerId));
        if (workerEntity == null) {
            throw new BusinessException("\u624b\u673a\u53f7\u5728\u5e73\u53f0\u79df\u6237\u82b1\u540d\u518c\u4e2d\u4e0d\u5b58\u5728\uff01");
        }
        CommonResponse response = this.attachmentApi.queryListBySourceId(workerEntity.getId(), BILL_TYPE, "face", null);
        if (!response.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            return CommonResponse.error((String)"\u63d0\u793a\uff1a\u5f53\u524d\u7528\u6237\u672a\u8bbe\u7f6e\u4eba\u8138\u4fe1\u606f\uff0c\u65e0\u6cd5\u8fdb\u884c\u624b\u673a\u6253\u5361\uff0c\u8bf7\u8054\u7cfb\u9879\u76ee\u7ba1\u7406\u4eba\u5458\u6dfb\u52a0\uff1b");
        }
        return CommonResponse.success();
    }

    @Override
    public void checkPunchCardAuth(Long tenantId, Long projectId, String phone) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(WorkRecordEntity::getPhone, (Object)phone);
        lambdaQuery.eq(WorkRecordEntity::getEnterExitState, (Object)1);
        List workRecordEntityList = this.workRecordService.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isEmpty((Collection)workRecordEntityList)) {
            throw new BusinessException("\u65e0\u8be5\u9879\u76ee\u6253\u5361\u6743\u9650");
        }
    }

    @Override
    public CommonResponse<JSONObject> checkDistance(String worktimeSetId, String destination) {
        Assert.hasText((String)worktimeSetId, (String)"\u8003\u52e4\u8bbe\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)destination, (String)"\u5f53\u524d\u4f4d\u7f6e\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject jsonObject = new JSONObject();
        WorktimeSetEntity worktimeSetEntity = (WorktimeSetEntity)((Object)this.worktimeSetService.selectById((Serializable)((Object)worktimeSetId)));
        Assert.notNull((Object)((Object)worktimeSetEntity), (String)"\u8003\u52e4\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<WorktimeSetDetailEntity> detailList = worktimeSetEntity.getWorktimeSetDetailList();
        if (CollectionUtils.isNotEmpty(detailList)) {
            Integer offSiteFlag = worktimeSetEntity.getOffSiteFlag();
            String lngLat = detailList.stream().map(WorktimeSetDetailEntity::getLngLat).collect(Collectors.joining("|"));
            List<DistanceVO> distance = this.amapService.distance(lngLat, destination, "0");
            this.logger.info("\u6821\u9a8c\u8003\u52e4\u8303\u56f4--{}", (Object)JSON.toJSONString(distance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            Map distanceMap = distance.stream().collect(Collectors.toMap(DistanceVO::getDistance, Function.identity(), (key1, key2) -> key2));
            BigDecimal min = distance.stream().map(d -> new BigDecimal(d.getDistance())).min(Comparator.comparing(x -> x)).orElse(null);
            DistanceVO minDistanceVO = (DistanceVO)distanceMap.get(Objects.requireNonNull(min).toString());
            WorktimeSetDetailEntity worktimeSetDetailEntity = detailList.get(Integer.parseInt(minDistanceVO.getOriginId()) - 1);
            if (new BigDecimal(minDistanceVO.getDistance()).compareTo(worktimeSetDetailEntity.getEffectiveRange()) < 0) {
                jsonObject.put("punchCardPlace", (Object)worktimeSetDetailEntity.getAddress());
                jsonObject.put("remoteFlag", (Object)0);
                return CommonResponse.success((String)"\u8003\u52e4\u8303\u56f4\u6821\u9a8c\u6210\u529f\uff01", (Object)jsonObject);
            }
            if (offSiteFlag == 1) {
                JSONObject regeo = this.amapService.regeo(destination);
                this.logger.info("\u6821\u9a8c\u8003\u52e4\u8303\u56f4\uff0c\u9006\u5730\u7406\u7f16\u7801--{}", (Object)regeo);
                String formattedAddress = regeo.getString("formatted_address");
                jsonObject.put("punchCardPlace", (Object)formattedAddress);
                jsonObject.put("remoteFlag", (Object)1);
                return CommonResponse.error((String)"\u5f53\u524d\u5b9a\u4f4d\u4e0d\u5728\u9879\u76ee\u8bbe\u5b9a\u6253\u5361\u8303\u56f4\u5185\uff0c\u7ee7\u7eed\u6253\u5361\u4f1a\u6807\u8bb0\u4e3a\u5f02\u5e38\u6253\u5361\uff0c\u662f\u5426\u786e\u5b9a\u6253\u5361\uff1f", (Object)jsonObject);
            }
            return CommonResponse.error((String)"\u5f53\u524d\u5b9a\u4f4d\u4e0d\u5728\u9879\u76ee\u8bbe\u5b9a\u6253\u5361\u8303\u56f4\u5185\uff0c\u4e0d\u5141\u8bb8\u6253\u5361", (Object)jsonObject);
        }
        return CommonResponse.error((String)"\u8003\u52e4\u8303\u56f4\u6821\u9a8c\u5931\u8d25\uff01", (Object)jsonObject);
    }

    @Override
    public CommonResponse<WorkerVO> checkFace(Long tenantId, Long projectId, String phone, String imgBase64A) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)imgBase64A, (String)"\u5f85\u8bc6\u522b\u4eba\u8138\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId)).eq(WorkRecordEntity::getProjectId, (Object)projectId)).eq(WorkRecordEntity::getPhone, (Object)phone)).eq(WorkRecordEntity::getEnterExitState, (Object)1);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        WorkerEntity workerEntity = (WorkerEntity)((Object)this.workerService.selectById(workRecordEntity.getWorkerId()));
        if (workerEntity == null) {
            throw new BusinessException("\u6821\u9a8c\u4eba\u8138\u4fe1\u606f\u5931\u8d25\uff01");
        }
        CommonResponse response = this.attachmentApi.queryListBySourceId(workerEntity.getId(), BILL_TYPE, "face", null);
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u4eba\u8138\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Assert.notEmpty((Collection)((Collection)response.getData()), (String)"\u9879\u76ee\u82b1\u540d\u518c\u4eba\u8138\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AttachmentVO attachmentVO = (AttachmentVO)((List)response.getData()).get(0);
        String truePath = attachmentVO.getTruePath();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("imgBase64A", (Object)imgBase64A);
        jsonObject.put("imgUrlB", (Object)truePath);
        CommonResponse res = this.faceAndIdCardService.compareFace(jsonObject);
        this.logger.info("\u6821\u9a8c\u4eba\u8138\uff0c\u4eba\u8138\u8bc6\u522b\u7ed3\u679c--{}", (Object)res);
        if (!res.isSuccess()) {
            throw new BusinessException("\u4eba\u8138\u8bc6\u522b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        Boolean flag = (Boolean)res.getData();
        if (Boolean.TRUE.equals(flag)) {
            return CommonResponse.success((String)"\u4eba\u8138\u4fe1\u606f\u6821\u9a8c\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)workerEntity), WorkerVO.class));
        }
        return CommonResponse.error((String)"\u4eba\u8138\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff01");
    }

    @Override
    public CommonResponse<WorkerVO> checkFaceByWorkerId(Long workerId, String imgBase64A) {
        Assert.notNull((Object)workerId, (String)"\u516c\u53f8\u82b1\u540d\u518c\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)imgBase64A, (String)"\u5f85\u8bc6\u522b\u4eba\u8138\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        WorkerEntity workerEntity = (WorkerEntity)((Object)this.workerService.selectById(workerId));
        if (workerEntity == null) {
            throw new BusinessException("\u516c\u53f8\u82b1\u540d\u518c\u4eba\u5458\u4e0d\u5b58\u5728\uff01");
        }
        CommonResponse response = this.attachmentApi.queryListBySourceId(workerEntity.getId(), BILL_TYPE, "face", null);
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u4eba\u8138\u4fe1\u606f\u5931\u8d25\uff01");
        }
        Assert.notEmpty((Collection)((Collection)response.getData()), (String)"\u516c\u53f8\u82b1\u540d\u518c\u4eba\u8138\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AttachmentVO attachmentVO = (AttachmentVO)((List)response.getData()).get(0);
        String truePath = attachmentVO.getTruePath();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("imgBase64A", (Object)imgBase64A);
        jsonObject.put("imgUrlB", (Object)truePath);
        this.logger.info("\u6821\u9a8c\u4eba\u8138\uff0c\u5165\u53c2\uff0cimgBase64A--{}\uff0cimgUrlB--{}", (Object)imgBase64A, (Object)truePath);
        CommonResponse res = this.faceAndIdCardService.compareFace(jsonObject);
        this.logger.info("\u6821\u9a8c\u4eba\u8138\uff0c\u4eba\u8138\u8bc6\u522b\u7ed3\u679c--{}", (Object)res);
        if (!res.isSuccess()) {
            throw new BusinessException("\u4eba\u8138\u8bc6\u522b\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + res.getMsg());
        }
        Boolean flag = (Boolean)res.getData();
        if (Boolean.TRUE.equals(flag)) {
            return CommonResponse.success((String)"\u4eba\u8138\u4fe1\u606f\u6821\u9a8c\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)workerEntity), WorkerVO.class));
        }
        return CommonResponse.error((String)"\u4eba\u8138\u4fe1\u606f\u6821\u9a8c\u5931\u8d25\uff01");
    }

    @Override
    public CommonResponse<List<AttendanceLogVO>> checkExistedLog(Long tenantId, Long projectId, String phone, String punchCardType) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)phone, (String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardType, (String)"\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQuery.eq(AttendanceLogEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(AttendanceLogEntity::getPhone, (Object)phone);
        lambdaQuery.eq(AttendanceLogEntity::getPunchCardType, (Object)punchCardType);
        lambdaQuery.eq(AttendanceLogEntity::getPunchCardDate, (Object)DateUtil.formatDate((Date)new Date()));
        if (START_WORK.equals(punchCardType)) {
            lambdaQuery.orderByDesc(AttendanceLogEntity::getStartWorkTime);
        } else {
            lambdaQuery.orderByDesc(AttendanceLogEntity::getEndWorkTime);
        }
        List logs = super.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)logs)) {
            return CommonResponse.error((String)("\u4eca\u5929\u5df2\u5b58\u5728" + punchCardType + "\uff0c\u662f\u5426\u9700\u8981\u66f4\u65b0"), (Object)BeanMapper.mapList((Iterable)logs, AttendanceLogVO.class));
        }
        return CommonResponse.success((String)"\u5df2\u5b58\u5728\u7684\u8bb0\u5f55\u6821\u9a8c\u6210\u529f\uff01");
    }

    @Override
    public AttendanceLogVO punchCard(Long projectId, Long workerId, String punchCardType, String punchCardPlace, Integer remoteFlag) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)workerId, (String)"\u516c\u53f8\u82b1\u540d\u518c\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardType, (String)"\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardPlace, (String)"\u6253\u5361\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)remoteFlag, (String)"\u662f\u5426\u662f\u5f02\u5730\u6253\u5361\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId)).eq(WorkRecordEntity::getWorkerId, (Object)workerId)).eq(WorkRecordEntity::getEnterExitState, (Object)1);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        AttendanceLogEntity attendanceLogEntity = WorkRecordMapper.INSTANCE.transformAttendanceLogEntity(workRecordEntity);
        attendanceLogEntity.setPunchCardDate(new Date());
        if (START_WORK.equals(punchCardType)) {
            attendanceLogEntity.setStartWorkTime(new Date());
            attendanceLogEntity.setStartWorkPlace(punchCardPlace);
        } else {
            attendanceLogEntity.setEndWorkTime(new Date());
            attendanceLogEntity.setEndWorkPlace(punchCardPlace);
        }
        attendanceLogEntity.setRemoteFlag(remoteFlag);
        if (remoteFlag == 0) {
            attendanceLogEntity.setAttendanceStatus("\u6b63\u5e38");
        } else {
            attendanceLogEntity.setAttendanceStatus("\u5f02\u5e38");
        }
        attendanceLogEntity.setPunchCardType(punchCardType);
        super.saveOrUpdate((Object)attendanceLogEntity, false);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(AttendanceEntity::getProjectId, (Object)projectId);
        wrapper.eq(AttendanceEntity::getWorkerId, (Object)workerId);
        wrapper.eq(AttendanceEntity::getPunchCardDate, (Object)DateUtil.formatDate((Date)new Date()));
        AttendanceEntity attendanceEntity = (AttendanceEntity)((Object)this.attendanceService.getOne((Wrapper)wrapper));
        if (attendanceEntity == null) {
            AttendanceEntity entity = AttendanceLogMapper.INSTANCE.transformAttendanceEntity(attendanceLogEntity);
            entity.setDuration(0L);
            this.attendanceService.saveOrUpdate((Object)entity, false);
        } else {
            if (START_WORK.equals(punchCardType)) {
                attendanceEntity.setStartWorkTime(attendanceLogEntity.getStartWorkTime());
                attendanceEntity.setStartWorkPlace(attendanceLogEntity.getStartWorkPlace());
                if (attendanceEntity.getEndWorkTime() != null) {
                    attendanceEntity.setDuration(DateUtil.between((Date)attendanceEntity.getStartWorkTime(), (Date)attendanceEntity.getEndWorkTime(), (DateUnit)DateUnit.HOUR));
                }
            } else {
                attendanceEntity.setEndWorkTime(attendanceLogEntity.getEndWorkTime());
                attendanceEntity.setEndWorkPlace(attendanceLogEntity.getEndWorkPlace());
                if (attendanceEntity.getStartWorkTime() != null) {
                    attendanceEntity.setDuration(DateUtil.between((Date)attendanceEntity.getStartWorkTime(), (Date)attendanceEntity.getEndWorkTime(), (DateUnit)DateUnit.HOUR));
                }
            }
            attendanceEntity.setAttendanceStatus(attendanceLogEntity.getAttendanceStatus());
            attendanceEntity.setRemoteFlag(attendanceLogEntity.getRemoteFlag());
            this.attendanceService.saveOrUpdate((Object)attendanceEntity, false);
        }
        return (AttendanceLogVO)BeanMapper.map((Object)((Object)attendanceLogEntity), AttendanceLogVO.class);
    }

    @Override
    public IPage<WorkRecordVO> internalFetchWorkRecord(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("teamName");
        fuzzyFields.add("projectWorkTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.workRecordService.queryPage(param);
        Page result = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), WorkRecordVO.class);
        result.setRecords(records);
        return result;
    }

    @Override
    public CommonResponse<JSONObject> internalCheckDistance(Long projectId, String destination) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)destination, (String)"\u5f53\u524d\u4f4d\u7f6e\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject jsonObject = new JSONObject();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid())).eq(WorktimeSetEntity::getProjectId, (Object)projectId);
        WorktimeSetEntity worktimeSetEntity = (WorktimeSetEntity)((Object)this.worktimeSetService.getOne((Wrapper)lambdaQuery));
        Assert.notNull((Object)((Object)worktimeSetEntity), (String)"\u8003\u52e4\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper l = Wrappers.lambdaQuery();
        l.eq(WorktimeSetDetailEntity::getWorktimeId, (Object)worktimeSetEntity.getId());
        List detailList = this.worktimeSetDetailService.list((Wrapper)l);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            Integer offSiteFlag = worktimeSetEntity.getOffSiteFlag();
            String lngLat = detailList.stream().map(WorktimeSetDetailEntity::getLngLat).collect(Collectors.joining("|"));
            List<DistanceVO> distance = this.amapService.distance(lngLat, destination, "0");
            this.logger.info("\u6821\u9a8c\u8003\u52e4\u8303\u56f4--{}", (Object)JSON.toJSONString(distance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            Map distanceMap = distance.stream().collect(Collectors.toMap(DistanceVO::getDistance, Function.identity(), (key1, key2) -> key2));
            BigDecimal min = distance.stream().map(d -> new BigDecimal(d.getDistance())).min(Comparator.comparing(x -> x)).orElse(null);
            DistanceVO minDistanceVO = (DistanceVO)distanceMap.get(Objects.requireNonNull(min).toString());
            WorktimeSetDetailEntity worktimeSetDetailEntity = (WorktimeSetDetailEntity)((Object)detailList.get(Integer.parseInt(minDistanceVO.getOriginId()) - 1));
            if (new BigDecimal(minDistanceVO.getDistance()).compareTo(worktimeSetDetailEntity.getEffectiveRange()) < 0) {
                jsonObject.put("punchCardPlace", (Object)worktimeSetDetailEntity.getAddress());
                jsonObject.put("remoteFlag", (Object)0);
                return CommonResponse.success((String)"\u8003\u52e4\u8303\u56f4\u6821\u9a8c\u6210\u529f\uff01", (Object)jsonObject);
            }
            if (offSiteFlag == 1) {
                JSONObject regeo = this.amapService.regeo(destination);
                this.logger.info("\u6821\u9a8c\u8003\u52e4\u8303\u56f4\uff0c\u9006\u5730\u7406\u7f16\u7801--{}", (Object)regeo);
                String formattedAddress = regeo.getString("formatted_address");
                jsonObject.put("punchCardPlace", (Object)formattedAddress);
                jsonObject.put("remoteFlag", (Object)1);
                return CommonResponse.error((String)"\u5f53\u524d\u5b9a\u4f4d\u4e0d\u5728\u9879\u76ee\u8bbe\u5b9a\u6253\u5361\u8303\u56f4\u5185\uff0c\u7ee7\u7eed\u6253\u5361\u4f1a\u6807\u8bb0\u4e3a\u5f02\u5e38\u6253\u5361\uff0c\u662f\u5426\u786e\u5b9a\u6253\u5361\uff1f", (Object)jsonObject);
            }
            return CommonResponse.error((String)"\u5f53\u524d\u5b9a\u4f4d\u4e0d\u5728\u9879\u76ee\u8bbe\u5b9a\u6253\u5361\u8303\u56f4\u5185\uff0c\u4e0d\u5141\u8bb8\u6253\u5361", (Object)jsonObject);
        }
        return CommonResponse.error((String)"\u8003\u52e4\u8303\u56f4\u6821\u9a8c\u5931\u8d25\uff01", (Object)jsonObject);
    }

    @Override
    public CommonResponse<WorkerVO> internalCheckFace(Long projectId, String imgBase64A) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)imgBase64A, (String)"\u5f85\u8bc6\u522b\u4eba\u8138\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        byte[] imgBytes = Base64.getDecoder().decode(imgBase64A);
        CommonResponse response = this.faceAndIdCardService.getUserByFaceImgByte(imgBytes);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)"\u6253\u5361\u5931\u8d25\uff0c\u65e0\u6cd5\u8bc6\u522b\u4eba\u8138");
        }
        HashSet ids = new HashSet((Collection)response.getData());
        this.logger.info("\u901a\u8fc7\u4eba\u8138\u83b7\u53d6\u4eba\u5458ids--{}", (Object)JSON.toJSONString(ids));
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId);
        lambdaQuery.eq(WorkRecordEntity::getEnterExitState, (Object)1);
        List workRecordEntityList = this.workRecordService.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isEmpty((Collection)workRecordEntityList)) {
            return CommonResponse.error((String)"\u9879\u76ee\u65e0\u5728\u573a\u4eba\u5458");
        }
        Set workerIds = workRecordEntityList.stream().map(WorkRecordEntity::getWorkerId).collect(Collectors.toSet());
        Map workRecordEntityMap = workRecordEntityList.stream().collect(Collectors.toMap(WorkRecordEntity::getWorkerId, Function.identity(), (key1, key2) -> key2));
        Sets.SetView workerId = Sets.intersection(ids, workerIds);
        if (workerId.isEmpty()) {
            return CommonResponse.error((String)"\u6253\u5361\u5931\u8d25\uff0c\u65e0\u6cd5\u8bc6\u522b\u4eba\u8138");
        }
        UnmodifiableIterator iterator = workerId.iterator();
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)workRecordEntityMap.get(iterator.next()));
        WorkerEntity workerEntity = (WorkerEntity)((Object)this.workerService.selectById(workRecordEntity.getWorkerId()));
        return CommonResponse.success((String)"\u4eba\u8138\u4fe1\u606f\u6821\u9a8c\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)workerEntity), WorkerVO.class));
    }

    @Override
    public CommonResponse<List<AttendanceLogVO>> internalCheckExistedLog(Long workerId, Long projectId, String punchCardType) {
        Assert.notNull((Object)workerId, (String)"\u9879\u76ee\u82b1\u540d\u518c\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardType, (String)"\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQuery.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid())).eq(AttendanceLogEntity::getProjectId, (Object)projectId)).eq(AttendanceLogEntity::getWorkerId, (Object)workerId)).eq(AttendanceLogEntity::getPunchCardType, (Object)punchCardType)).eq(AttendanceLogEntity::getPunchCardDate, (Object)DateUtil.formatDate((Date)new Date()));
        if (START_WORK.equals(punchCardType)) {
            lambdaQuery.orderByDesc(AttendanceLogEntity::getStartWorkTime);
        } else {
            lambdaQuery.orderByDesc(AttendanceLogEntity::getEndWorkTime);
        }
        List logs = super.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)logs)) {
            return CommonResponse.error((String)("\u4eca\u5929\u5df2\u5b58\u5728" + punchCardType + "\uff0c\u662f\u5426\u9700\u8981\u66f4\u65b0"), (Object)BeanMapper.mapList((Iterable)logs, AttendanceLogVO.class));
        }
        return CommonResponse.success((String)"\u5df2\u5b58\u5728\u7684\u8bb0\u5f55\u6821\u9a8c\u6210\u529f\uff01");
    }

    @Override
    public AttendanceLogVO internalPunchCard(Long workerId, Long projectId, String punchCardType, String punchCardPlace, Integer remoteFlag) {
        Assert.notNull((Object)workerId, (String)"\u9879\u76ee\u82b1\u540d\u518c\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardType, (String)"\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardPlace, (String)"\u6253\u5361\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)remoteFlag, (String)"\u662f\u5426\u662f\u5f02\u5730\u6253\u5361\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId)).eq(WorkRecordEntity::getWorkerId, (Object)workerId)).eq(WorkRecordEntity::getEnterExitState, (Object)1);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        AttendanceLogEntity attendanceLogEntity = WorkRecordMapper.INSTANCE.transformAttendanceLogEntity(workRecordEntity);
        attendanceLogEntity.setPunchCardDate(new Date());
        if (START_WORK.equals(punchCardType)) {
            attendanceLogEntity.setStartWorkTime(new Date());
            attendanceLogEntity.setStartWorkPlace(punchCardPlace);
        } else {
            attendanceLogEntity.setEndWorkTime(new Date());
            attendanceLogEntity.setEndWorkPlace(punchCardPlace);
        }
        attendanceLogEntity.setRemoteFlag(remoteFlag);
        if (remoteFlag == 0) {
            attendanceLogEntity.setAttendanceStatus("\u6b63\u5e38");
        } else {
            attendanceLogEntity.setAttendanceStatus("\u5f02\u5e38");
        }
        attendanceLogEntity.setPunchCardType(punchCardType);
        super.saveOrUpdate((Object)attendanceLogEntity, false);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq(AttendanceEntity::getProjectId, (Object)projectId);
        wrapper.eq(AttendanceEntity::getWorkerId, (Object)workerId);
        wrapper.eq(AttendanceEntity::getPunchCardDate, (Object)DateUtil.formatDate((Date)new Date()));
        AttendanceEntity attendanceEntity = (AttendanceEntity)((Object)this.attendanceService.getOne((Wrapper)wrapper));
        if (attendanceEntity == null) {
            AttendanceEntity entity = AttendanceLogMapper.INSTANCE.transformAttendanceEntity(attendanceLogEntity);
            entity.setDuration(0L);
            this.attendanceService.saveOrUpdate((Object)entity, false);
        } else {
            if (START_WORK.equals(punchCardType)) {
                attendanceEntity.setStartWorkTime(attendanceLogEntity.getStartWorkTime());
                attendanceEntity.setStartWorkPlace(attendanceLogEntity.getStartWorkPlace());
                if (attendanceEntity.getEndWorkTime() != null) {
                    attendanceEntity.setDuration(DateUtil.between((Date)attendanceEntity.getStartWorkTime(), (Date)attendanceEntity.getEndWorkTime(), (DateUnit)DateUnit.HOUR));
                }
            } else {
                attendanceEntity.setEndWorkTime(attendanceLogEntity.getEndWorkTime());
                attendanceEntity.setEndWorkPlace(attendanceLogEntity.getEndWorkPlace());
                if (attendanceEntity.getStartWorkTime() != null) {
                    attendanceEntity.setDuration(DateUtil.between((Date)attendanceEntity.getStartWorkTime(), (Date)attendanceEntity.getEndWorkTime(), (DateUnit)DateUnit.HOUR));
                }
            }
            attendanceEntity.setAttendanceStatus(attendanceLogEntity.getAttendanceStatus());
            attendanceEntity.setRemoteFlag(attendanceLogEntity.getRemoteFlag());
            this.attendanceService.saveOrUpdate((Object)attendanceEntity, false);
        }
        return (AttendanceLogVO)BeanMapper.map((Object)((Object)attendanceLogEntity), AttendanceLogVO.class);
    }

    @Override
    public IPage<WorkRecordVO> leaderFetchWorkRecord(QueryParam param) {
        CommonResponse response = this.userApi.findUserByUserId(InvocationInfoProxy.getUserid());
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4e0b\u5f53\u524d\u7528\u6237\u6240\u5728\u73ed\u7ec4\u7684\u5728\u573a\u7528\u6237\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0" + response.getMsg());
        }
        UserVO userVO = (UserVO)response.getData();
        String userMobile = userVO.getUserMobile();
        if (StringUtils.isBlank((CharSequence)userMobile)) {
            throw new BusinessException("\u83b7\u53d6\u9879\u76ee\u4e0b\u5f53\u524d\u7528\u6237\u6240\u5728\u73ed\u7ec4\u7684\u5728\u573a\u7528\u6237\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5f53\u524d\u7528\u6237\u5728\u7cfb\u7edf\u5185\u672a\u7ef4\u62a4\u624b\u673a\u53f7\uff01");
        }
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(ProjectTeamEntity::getPhone, (Object)userMobile);
        List projectTeamEntityList = this.projectTeamService.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isEmpty((Collection)projectTeamEntityList)) {
            return new Page();
        }
        Set ids = projectTeamEntityList.stream().map(BaseEntity::getId).collect(Collectors.toSet());
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("teamName");
        fuzzyFields.add("projectWorkTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        QueryWrapper queryWrapper = AttendanceLogServiceImpl.changeToQueryWrapper((QueryParam)param);
        LambdaQueryWrapper l = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)l.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid())).eq(param.getParams().containsKey("projectId"), WorkRecordEntity::getProjectId, ((Parameter)param.getParams().get("projectId")).getValue())).eq(WorkRecordEntity::getEnterExitState, (Object)1)).in(WorkRecordEntity::getProjectTeamId, ids);
        Page p = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage page = this.workRecordService.page((IPage)p, (Wrapper)queryWrapper);
        Page result = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), WorkRecordVO.class);
        result.setRecords(records);
        return result;
    }

    @Override
    public CommonResponse<JSONObject> leaderCheckDistance(Long projectId, String destination) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)destination, (String)"\u5f53\u524d\u4f4d\u7f6e\u7ecf\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        JSONObject jsonObject = new JSONObject();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid())).eq(WorktimeSetEntity::getProjectId, (Object)projectId);
        WorktimeSetEntity worktimeSetEntity = (WorktimeSetEntity)((Object)this.worktimeSetService.getOne((Wrapper)lambdaQuery));
        Assert.notNull((Object)((Object)worktimeSetEntity), (String)"\u8003\u52e4\u8bbe\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper l = Wrappers.lambdaQuery();
        l.eq(WorktimeSetDetailEntity::getWorktimeId, (Object)worktimeSetEntity.getId());
        List detailList = this.worktimeSetDetailService.list((Wrapper)l);
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            Integer offSiteFlag = worktimeSetEntity.getOffSiteFlag();
            String lngLat = detailList.stream().map(WorktimeSetDetailEntity::getLngLat).collect(Collectors.joining("|"));
            List<DistanceVO> distance = this.amapService.distance(lngLat, destination, "0");
            this.logger.info("\u6821\u9a8c\u8003\u52e4\u8303\u56f4--{}", (Object)JSON.toJSONString(distance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            Map distanceMap = distance.stream().collect(Collectors.toMap(DistanceVO::getDistance, Function.identity(), (key1, key2) -> key2));
            BigDecimal min = distance.stream().map(d -> new BigDecimal(d.getDistance())).min(Comparator.comparing(x -> x)).orElse(null);
            DistanceVO minDistanceVO = (DistanceVO)distanceMap.get(Objects.requireNonNull(min).toString());
            WorktimeSetDetailEntity worktimeSetDetailEntity = (WorktimeSetDetailEntity)((Object)detailList.get(Integer.parseInt(minDistanceVO.getOriginId()) - 1));
            if (new BigDecimal(minDistanceVO.getDistance()).compareTo(worktimeSetDetailEntity.getEffectiveRange()) < 0) {
                jsonObject.put("punchCardPlace", (Object)worktimeSetDetailEntity.getAddress());
                jsonObject.put("remoteFlag", (Object)0);
                return CommonResponse.success((String)"\u8003\u52e4\u8303\u56f4\u6821\u9a8c\u6210\u529f\uff01", (Object)jsonObject);
            }
            if (offSiteFlag == 1) {
                JSONObject regeo = this.amapService.regeo(destination);
                this.logger.info("\u6821\u9a8c\u8003\u52e4\u8303\u56f4\uff0c\u9006\u5730\u7406\u7f16\u7801--{}", (Object)regeo);
                String formattedAddress = regeo.getString("formatted_address");
                jsonObject.put("punchCardPlace", (Object)formattedAddress);
                jsonObject.put("remoteFlag", (Object)1);
                return CommonResponse.error((String)"\u5f53\u524d\u5b9a\u4f4d\u4e0d\u5728\u9879\u76ee\u8bbe\u5b9a\u6253\u5361\u8303\u56f4\u5185\uff0c\u7ee7\u7eed\u6253\u5361\u4f1a\u6807\u8bb0\u4e3a\u5f02\u5e38\u6253\u5361\uff0c\u662f\u5426\u786e\u5b9a\u6253\u5361\uff1f", (Object)jsonObject);
            }
            return CommonResponse.error((String)"\u5f53\u524d\u5b9a\u4f4d\u4e0d\u5728\u9879\u76ee\u8bbe\u5b9a\u6253\u5361\u8303\u56f4\u5185\uff0c\u4e0d\u5141\u8bb8\u6253\u5361", (Object)jsonObject);
        }
        return CommonResponse.error((String)"\u8003\u52e4\u8303\u56f4\u6821\u9a8c\u5931\u8d25\uff01", (Object)jsonObject);
    }

    @Override
    public CommonResponse<WorkerVO> leaderCheckFace(Long projectId, String imgBase64A) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)imgBase64A, (String)"\u5f85\u8bc6\u522b\u4eba\u8138\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        byte[] imgBytes = Base64.getDecoder().decode(imgBase64A);
        CommonResponse response = this.faceAndIdCardService.getUserByFaceImgByte(imgBytes);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)"\u6253\u5361\u5931\u8d25\uff0c\u65e0\u6cd5\u8bc6\u522b\u4eba\u8138");
        }
        HashSet ids = new HashSet((Collection)response.getData());
        this.logger.info("\u901a\u8fc7\u4eba\u8138\u83b7\u53d6\u4eba\u5458ids--{}", (Object)JSON.toJSONString(ids));
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        IPage<WorkRecordVO> page = this.leaderFetchWorkRecord(param);
        List records = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return CommonResponse.error((String)"\u9879\u76ee\u65e0\u5728\u573a\u4eba\u5458");
        }
        Set workerIds = records.stream().map(WorkRecordVO::getWorkerId).collect(Collectors.toSet());
        Map workRecordVOMap = records.stream().collect(Collectors.toMap(WorkRecordVO::getWorkerId, Function.identity(), (key1, key2) -> key2));
        Sets.SetView workerId = Sets.intersection(ids, workerIds);
        if (workerId.isEmpty()) {
            return CommonResponse.error((String)"\u65e0\u6cd5\u8bc6\u522b\u8be5\u4eba\u5458");
        }
        UnmodifiableIterator iterator = workerId.iterator();
        WorkRecordVO workRecordVO = (WorkRecordVO)workRecordVOMap.get(iterator.next());
        WorkerEntity workerEntity = (WorkerEntity)((Object)this.workerService.selectById(workRecordVO.getWorkerId()));
        return CommonResponse.success((String)"\u4eba\u8138\u4fe1\u606f\u6821\u9a8c\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)workerEntity), WorkerVO.class));
    }

    @Override
    public CommonResponse<List<AttendanceLogVO>> leaderCheckExistedLog(Long workerId, Long projectId, String punchCardType) {
        Assert.notNull((Object)workerId, (String)"\u9879\u76ee\u82b1\u540d\u518c\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardType, (String)"\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQuery.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid())).eq(AttendanceLogEntity::getProjectId, (Object)projectId)).eq(AttendanceLogEntity::getWorkerId, (Object)workerId)).eq(AttendanceLogEntity::getPunchCardType, (Object)punchCardType)).eq(AttendanceLogEntity::getPunchCardDate, (Object)DateUtil.formatDate((Date)new Date()));
        if (START_WORK.equals(punchCardType)) {
            lambdaQuery.orderByDesc(AttendanceLogEntity::getStartWorkTime);
        } else {
            lambdaQuery.orderByDesc(AttendanceLogEntity::getEndWorkTime);
        }
        List logs = super.list((Wrapper)lambdaQuery);
        if (CollectionUtils.isNotEmpty((Collection)logs)) {
            return CommonResponse.error((String)("\u4eca\u5929\u5df2\u5b58\u5728" + punchCardType + "\uff0c\u662f\u5426\u9700\u8981\u66f4\u65b0"), (Object)BeanMapper.mapList((Iterable)logs, AttendanceLogVO.class));
        }
        return CommonResponse.success((String)"\u5df2\u5b58\u5728\u7684\u8bb0\u5f55\u6821\u9a8c\u6210\u529f\uff01");
    }

    @Override
    public AttendanceLogVO leaderPunchCard(Long workerId, Long projectId, String punchCardType, String punchCardPlace, Integer remoteFlag) {
        Assert.notNull((Object)workerId, (String)"\u9879\u76ee\u82b1\u540d\u518c\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardType, (String)"\u6253\u5361\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.hasText((String)punchCardPlace, (String)"\u6253\u5361\u5730\u70b9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)remoteFlag, (String)"\u662f\u5426\u662f\u5f02\u5730\u6253\u5361\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQuery.eq(WorkRecordEntity::getProjectId, (Object)projectId)).eq(WorkRecordEntity::getWorkerId, (Object)workerId)).eq(WorkRecordEntity::getEnterExitState, (Object)1);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)lambdaQuery));
        AttendanceLogEntity attendanceLogEntity = WorkRecordMapper.INSTANCE.transformAttendanceLogEntity(workRecordEntity);
        attendanceLogEntity.setPunchCardDate(new Date());
        if (START_WORK.equals(punchCardType)) {
            attendanceLogEntity.setStartWorkTime(new Date());
            attendanceLogEntity.setStartWorkPlace(punchCardPlace);
        } else {
            attendanceLogEntity.setEndWorkTime(new Date());
            attendanceLogEntity.setEndWorkPlace(punchCardPlace);
        }
        attendanceLogEntity.setRemoteFlag(remoteFlag);
        if (remoteFlag == 0) {
            attendanceLogEntity.setAttendanceStatus("\u6b63\u5e38");
        } else {
            attendanceLogEntity.setAttendanceStatus("\u5f02\u5e38");
        }
        attendanceLogEntity.setPunchCardType(punchCardType);
        super.saveOrUpdate((Object)attendanceLogEntity, false);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        wrapper.eq(AttendanceEntity::getProjectId, (Object)projectId);
        wrapper.eq(AttendanceEntity::getWorkerId, (Object)workerId);
        wrapper.eq(AttendanceEntity::getPunchCardDate, (Object)DateUtil.formatDate((Date)new Date()));
        AttendanceEntity attendanceEntity = (AttendanceEntity)((Object)this.attendanceService.getOne((Wrapper)wrapper));
        if (attendanceEntity == null) {
            AttendanceEntity entity = AttendanceLogMapper.INSTANCE.transformAttendanceEntity(attendanceLogEntity);
            entity.setDuration(0L);
            this.attendanceService.saveOrUpdate((Object)entity, false);
        } else {
            if (START_WORK.equals(punchCardType)) {
                attendanceEntity.setStartWorkTime(attendanceLogEntity.getStartWorkTime());
                attendanceEntity.setStartWorkPlace(attendanceLogEntity.getStartWorkPlace());
                if (attendanceEntity.getEndWorkTime() != null) {
                    attendanceEntity.setDuration(DateUtil.between((Date)attendanceEntity.getStartWorkTime(), (Date)attendanceEntity.getEndWorkTime(), (DateUnit)DateUnit.HOUR));
                }
            } else {
                attendanceEntity.setEndWorkTime(attendanceLogEntity.getEndWorkTime());
                attendanceEntity.setEndWorkPlace(attendanceLogEntity.getEndWorkPlace());
                if (attendanceEntity.getStartWorkTime() != null) {
                    attendanceEntity.setDuration(DateUtil.between((Date)attendanceEntity.getStartWorkTime(), (Date)attendanceEntity.getEndWorkTime(), (DateUnit)DateUnit.HOUR));
                }
            }
            attendanceEntity.setAttendanceStatus(attendanceLogEntity.getAttendanceStatus());
            attendanceEntity.setRemoteFlag(attendanceLogEntity.getRemoteFlag());
            this.attendanceService.saveOrUpdate((Object)attendanceEntity, false);
        }
        return (AttendanceLogVO)BeanMapper.map((Object)((Object)attendanceLogEntity), AttendanceLogVO.class);
    }
}

