package com.ejianc.business.labor.controller;

import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.bean.WorkerRegisterEntity;
import com.ejianc.business.labor.enums.WorkerConsts;
import com.ejianc.business.labor.service.*;
import com.ejianc.business.labor.utils.UserInfoValidateUtil;
import com.ejianc.business.labor.utils.WagesTypeEnum;
import com.ejianc.business.labor.vo.BatchCheckPhotoVO;
import com.ejianc.business.labor.vo.IdentityCardInfoVO;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 公司花名册人员
 *
 * @author generator
 *
 */
@Validated
@RestController
@RequestMapping("worker")
public class WorkerController implements Serializable {
    private static final long serialVersionUID = 1L;

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IWorkerService service;

    @Autowired
    private IOrgTeamService orgTeamService;

    @Autowired
    private IWorkerRegisterService workerRegisterService;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IWorkRecordService workRecordService;

    @Resource
    private IIdCardService iIdCardService;

    @Resource
    private IFaceService faceService;

    @Resource
    private IAttachmentApi attachmentApi;

    private static final String BILL_CODE = "LABOR_WORKER";//此处需要根据实际修改


    // 用工记录用工合同附件类型
    private static final String WORK_RECORD_CONTRACT_SOURCE_TYPE = "workRecord001";


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkerVO> saveOrUpdate(@RequestBody WorkerVO saveOrUpdateVO) {
        LambdaQueryWrapper<WorkerEntity> idCardQueryWrapper = new LambdaQueryWrapper<>();
        idCardQueryWrapper.eq(WorkerEntity::getIdCard, saveOrUpdateVO.getIdCard());
        idCardQueryWrapper.eq(WorkerEntity::getTenantId, InvocationInfoProxy.getTenantid());
        idCardQueryWrapper.ne(saveOrUpdateVO.getId() != null, WorkerEntity::getId, saveOrUpdateVO.getId());
        int idCardCount = service.count(idCardQueryWrapper);
        if (idCardCount > 0) {
            return CommonResponse.error("保存或修改单据失败，身份证已存在");
        }

        LambdaQueryWrapper<WorkerEntity> phoneQueryWrapper = new LambdaQueryWrapper<>();
        phoneQueryWrapper.eq(WorkerEntity::getPhone, saveOrUpdateVO.getPhone());
        phoneQueryWrapper.eq(WorkerEntity::getTenantId, InvocationInfoProxy.getTenantid());
        phoneQueryWrapper.ne(saveOrUpdateVO.getId() != null, WorkerEntity::getId, saveOrUpdateVO.getId());
        int phoneCount = service.count(phoneQueryWrapper);
        if (phoneCount > 0) {
            return CommonResponse.error("保存或修改单据失败，手机号已存在");
        }
        WorkerVO vo = service.insertOrUpdate(saveOrUpdateVO);
        // 人脸注册
        service.faceRegistration(vo);
        //用工记录显示
        LambdaQueryWrapper<WorkRecordEntity> workRecordWrapper = Wrappers.lambdaQuery();
        workRecordWrapper.eq(WorkRecordEntity::getWorkerId, saveOrUpdateVO.getId());
        List<WorkRecordEntity> workRecordList = workRecordService.list(workRecordWrapper);
        List<WorkRecordVO> workRecordVOS = BeanMapper.mapList(workRecordList, WorkRecordVO.class);
        if(CollectionUtils.isNotEmpty(workRecordVOS)){
            JSONObject fileParam = new JSONObject();
            List<Long> sourceIds = workRecordVOS.stream().map(WorkRecordVO::getId).collect(Collectors.toList());
            fileParam.put("sourceIds", sourceIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add(WORK_RECORD_CONTRACT_SOURCE_TYPE);
            fileParam.put("sourceTypeList", JSONObject.toJSONString(sourceTypeArr));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(fileParam);
            List<AttachmentVO> fileData = listCommonResponse.getData();
            if(listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(fileData)){
                Map<Long, AttachmentVO> fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                for (WorkRecordVO workRecordVO : workRecordVOS) {
                    AttachmentVO attachmentVO = fileMap.get(workRecordVO.getId());
                    if (attachmentVO!=null){
                        workRecordVO.setSubContractFileId(attachmentVO.getId());
                        workRecordVO.setSubContractFileName(attachmentVO.getFileName());
                    }
                }
            }
        }
        vo.setWorkRecordList(workRecordVOS);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     *  批量修改人员的班组和工种
     * @param updateVO
     * @return
     */
    @RequestMapping(value = "/updateBatWorker", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WorkerVO> updateBatWorker(@RequestBody WorkerVO updateVO) {
        WorkerVO vo = service.updateBatWorker(updateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WorkerVO> queryDetail(Long id) {
        WorkerEntity entity = service.selectById(id);
        WorkerVO vo = BeanMapper.map(entity, WorkerVO.class);
        LambdaQueryWrapper<WorkRecordEntity> workRecordWrapper = Wrappers.lambdaQuery();
        workRecordWrapper.eq(WorkRecordEntity::getWorkerId, entity.getId());
        List<WorkRecordEntity> workRecordList = workRecordService.list(workRecordWrapper);
        List<WorkRecordVO> workRecordVOS = BeanMapper.mapList(workRecordList, WorkRecordVO.class);
        if(CollectionUtils.isNotEmpty(workRecordVOS)){
            JSONObject fileParam = new JSONObject();
            List<Long> sourceIds = workRecordVOS.stream().map(WorkRecordVO::getId).collect(Collectors.toList());
            fileParam.put("sourceIds", sourceIds);
            JSONArray sourceTypeArr = new JSONArray();
            sourceTypeArr.add(WORK_RECORD_CONTRACT_SOURCE_TYPE);
            fileParam.put("sourceTypeList", JSONObject.toJSONString(sourceTypeArr));
            CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryAllBySourceIdList(fileParam);
            List<AttachmentVO> fileData = listCommonResponse.getData();
            if(listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(fileData)){
                Map<Long, AttachmentVO> fileMap = fileData.stream().collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                for (WorkRecordVO workRecordVO : workRecordVOS) {
                    AttachmentVO attachmentVO = fileMap.get(workRecordVO.getId());
                    if (attachmentVO!=null){
                        workRecordVO.setSubContractFileId(attachmentVO.getId());
                        workRecordVO.setSubContractFileName(attachmentVO.getFileName());
                    }
                }
            }
        }
        vo.setWorkRecordList(workRecordVOS);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkerVO> vos) {
        List<Long> delIds = vos.stream().map(WorkerVO::getId).collect(Collectors.toList());
        //查询员工的用工记录
        LambdaQueryWrapper<WorkRecordEntity> workRecordWrapper = new LambdaQueryWrapper<>();
        workRecordWrapper.in(WorkRecordEntity::getWorkerId,delIds);
        workRecordWrapper.eq(WorkRecordEntity::getDr,0);
        int count = workRecordService.count(workRecordWrapper);
        //有用工记录的员工不可删除
        if(count >0){
            return CommonResponse.error("删除失败，当前员工已有用工记录！");
        }
        service.removeByIds(delIds, true);
        //删除成功后，同时删除该人员在中间表的数据
        LambdaUpdateWrapper<WorkerRegisterEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(WorkerRegisterEntity::getDr, 1);
        updateWrapper.in(WorkerRegisterEntity::getWorkerId, delIds);
        workerRegisterService.update(updateWrapper);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Map<String, Parameter> params = param.getParams();

        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("enabled", "desc");
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);

        IPage<WorkerVO> pageData = null;
        IPage<WorkerEntity> page = null;
        List<WorkerEntity> list = null;
        Long teamId = null;
        if (params.containsKey("teamId")) {
            Object teamIdObj = params.get("teamId").getValue();
            teamId = Long.valueOf(String.valueOf(teamIdObj));
            OrgTeamEntity byId = orgTeamService.getById(teamId);
            //如果是根班组不需要过滤，因为班组有的人员所属班组为空
            teamId = byId == null || byId.getParentId() == null ? null : teamId;
            params.remove("teamId");
        }

        if (teamId != null) {
            page = new Page<>(param.getPageIndex(), param.getPageSize());
            list = service.queryOrgTeamWorkerPage((Page<WorkerEntity>) page, param, teamId);
        } else {
            page = service.queryPage(param, false);
            list = page.getRecords();
        }
        pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, WorkerVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);

    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Map<String, Parameter> params = param.getParams();

        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("enabled", "desc");
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);


        IPage<WorkerEntity> page = null;
        List<WorkerEntity> list = null;
        Long teamId = null;
        if (params.containsKey("teamId")) {
            Object teamIdObj = params.get("teamId").getValue();
            teamId = Long.valueOf(String.valueOf(teamIdObj));
            OrgTeamEntity byId = orgTeamService.getById(teamId);
            //如果是根班组不需要过滤，因为班组有的人员所属班组为空
            teamId = byId.getParentId() == null ? null : teamId;
            params.remove("teamId");
        }

        if (teamId != null) {
            page = new Page<>(param.getPageIndex(), param.getPageSize());
            list = service.queryOrgTeamWorkerPage((Page<WorkerEntity>) page, param, teamId);
        } else {
            page = service.queryPage(param, false);
            list = page.getRecords();
        }

        List<WorkerVO> workerVOS = BeanMapper.mapList(list, WorkerVO.class);
        for (WorkerVO workerVO : workerVOS) {
            workerVO.setSexName(WorkerConsts.SexEnum.getNameByCode(workerVO.getSex()));
            workerVO.setIdCardFrontPhotoFlagName(WorkerConsts.ValidateEnum.getNameByCode(workerVO.getIdCardFrontPhotoFlag()));
            workerVO.setFacePhotoFlagName(WorkerConsts.ValidateEnum.getNameByCode(workerVO.getFacePhotoFlag()));
            workerVO.setWorkStateName(WorkerConsts.WorkStateEnum.getNameByCode(workerVO.getWorkState()));
            workerVO.setEnabledName(WorkerConsts.EnabledEnum.getNameByCode(workerVO.getEnabled()));
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", workerVOS);
        ExcelExport.getInstance().export("Worker-export.xlsx", beans, response);
    }

    /**
     * 导入人员模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadPersonTemplet")
    @ResponseBody
    public void downloadPersonTemplet(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "Worker-import.xlsx", "导入人员");
    }

    /**
     * 导入人员校验
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImportPerson", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImportPerson(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            List<WorkerVO> successList = new ArrayList<>();
            List<WorkerVO> errorList = new ArrayList<>();
            if (result != null && result.size() > 0) {
                if (result.get(0).size() != 15) {
                    throw new BusinessException("请按照导入模板导入数据");
                }
            }
            Map<String, Integer> idCardMap = new HashMap<>();
            Map<String, Integer> phoneMap = new HashMap<>();
            for (int i = 0; i < result.size(); i++) {
                //当前行号
                int rowNum = i + 2;
                // 开始判断逻辑
                WorkerVO workerVO = new WorkerVO();
                List<String> row = result.get(i);
                StringBuilder errMsg = new StringBuilder();
                if (row.get(1) == null) {
                    continue;
                }
                //姓名
                String name = row.get(0).trim();
                workerVO.setName(name);
                if (StringUtils.isBlank(name)) {
                    errMsg.append("`姓名不能为空`");
                }
                //身份证号
                String idCard = row.get(1).trim();
                workerVO.setIdCard(idCard);
                if (UserInfoValidateUtil.isIdentityCode(idCard)) {
                    if (!idCardMap.containsKey(idCard)) {
                        LambdaQueryWrapper<WorkerEntity> wrapper = new LambdaQueryWrapper<>();
                        wrapper.eq(WorkerEntity::getIdCard, idCard);
                        wrapper.eq(WorkerEntity::getTenantId, InvocationInfoProxy.getTenantid());
                        int count = service.count(wrapper);
                        if (count > 0) {
                            errMsg.append("`第" + rowNum + "行身份证号在公司花名册已存在`");
                        } else {
                            idCardMap.put(idCard , rowNum);
                        }
                    } else {
                        errMsg.append("`第" + idCardMap.get(idCard) + "、" + rowNum + "行身份证号重复`");
                    }
                } else {
                    errMsg.append("`身份证号为空或不合法`");
                }
                //出生日期
                String birthDate = row.get(2).trim();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                if (StringUtils.isNotBlank(birthDate)) {
                    try {
                        Date parse = sdf.parse(birthDate);
                        workerVO.setBirthDate(parse);
                    } catch (ParseException e) {
                        e.printStackTrace();
                        errMsg.append("`出生日期格式有误`");
                    }
                }
                //性别
                String sex = row.get(3).trim();
                if (StringUtils.isNotBlank(sex)) {
                    if ("男".equals(sex)) {
                        workerVO.setSex(WorkerConsts.SexEnum.男.getCode());//ses 1-男，2-女
                        workerVO.setSexName(WorkerConsts.SexEnum.男.getName());
                    } else {
                        workerVO.setSex(WorkerConsts.SexEnum.女.getCode());//ses 1-男，2-女
                        workerVO.setSexName(WorkerConsts.SexEnum.女.getName());
                    }
                }else{
                    workerVO.setSex(WorkerConsts.SexEnum.男.getCode());//ses 1-男，2-女
                    workerVO.setSexName(WorkerConsts.SexEnum.男.getName());
                }
                //民族
                String nation = row.get(4).trim();
                workerVO.setNation(nation);
                //所属班组
                String teamName = row.get(5);
                if (StringUtils.isNotBlank(teamName)) {
                    teamName = teamName.trim();
                    LambdaQueryWrapper<OrgTeamEntity> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(OrgTeamEntity::getName, teamName);
                    //根据名称匹配
                    List<OrgTeamEntity> list = orgTeamService.list(wrapper);
                    if (CollectionUtils.isNotEmpty(list)) {
                        workerVO.setTeamId(String.valueOf(list.get(0).getId()));
                        workerVO.setTeamName(list.get(0).getName());
                    }
                }
                //工种
                String workType = row.get(6).trim();
                if (workType != null && !"".equals(workType)) {
                    //获取工种的档案
                    CommonResponse<List<DefdocDetailVO>> workerTypeListRes = defdocApi.getDefDocByDefCode("labor_worker_type");
                    if (workerTypeListRes.isSuccess()) {
                        List<DefdocDetailVO> workerTypeList = workerTypeListRes.getData();
                        for (DefdocDetailVO defdocDetailVO : workerTypeList) {
                            if (defdocDetailVO.getName().equals(workType)) {
                                workerVO.setWorkType(String.valueOf(defdocDetailVO.getId()));
                                workerVO.setWorkTypeName(defdocDetailVO.getName());
                            }
                        }
                    } else {
                        errMsg.append("`工种查询失败`");
                    }
                }
                //手机号
                String phone = row.get(7).trim();
                workerVO.setPhone(phone);
                if (StringUtils.isNotBlank(phone)) {
                    if (UserInfoValidateUtil.verifyPhone(phone)) {
                        if (!phoneMap.containsKey(phone)) {
                            LambdaQueryWrapper<WorkerEntity> wrapper = new LambdaQueryWrapper<>();
                            wrapper.eq(WorkerEntity::getPhone, phone);
                            wrapper.eq(WorkerEntity::getTenantId, InvocationInfoProxy.getTenantid());
                            int count = service.count(wrapper);
                            if (count > 0) {
                                errMsg.append("`第" + rowNum + "行手机号在公司花名册已存在`");
                            } else {
                                phoneMap.put(phone, rowNum);
                            }
                        } else {
                            errMsg.append("`第" + phoneMap.get(phone) + "、" + rowNum + "行手机号重复`");
                        }
                    } else {
                        errMsg.append("`手机号不正确`");
                    }
                }
                //开户行
                String bankName = row.get(8).trim();
                workerVO.setBankName(bankName);
                //银行账号
                String bankAccount = row.get(9).trim();
                workerVO.setBankAccount(bankAccount);
                //工资类型
                String wagesType = row.get(10).trim();
                if (wagesType != null && !"".equals(wagesType)) {
                    if (WagesTypeEnum.HOUR.getName().equals(wagesType)) {
                        workerVO.setWagesType(WagesTypeEnum.HOUR.getCode());
                        workerVO.setWagesTypeName(WagesTypeEnum.HOUR.getName());
                    }
                    if (WagesTypeEnum.DAY.getName().equals(wagesType)) {
                        workerVO.setWagesType(WagesTypeEnum.DAY.getCode());
                        workerVO.setWagesTypeName(WagesTypeEnum.DAY.getName());
                    }
                    if (WagesTypeEnum.MONTH.getName().equals(wagesType)) {
                        workerVO.setWagesType(WagesTypeEnum.MONTH.getCode());
                        workerVO.setWagesTypeName(WagesTypeEnum.MONTH.getName());
                    }
                    if (WagesTypeEnum.QUANT.getName().equals(wagesType)) {
                        workerVO.setWagesType(WagesTypeEnum.QUANT.getCode());
                        workerVO.setWagesTypeName(WagesTypeEnum.QUANT.getName());
                    }
                }
                //工价
                String wage = row.get(11);
                if (StringUtils.isNotBlank(wage)) {
                    wage = wage.trim();
                    workerVO.setWage(new BigDecimal(wage));
                }
                //所属地区
                String area = row.get(12);
                if (StringUtils.isNotBlank(area)) {
                    area = area.trim();
                    Map<String, Object> map = service.getArea(area);
                    if (map.get("province") != null) {
                        workerVO.setProvince(String.valueOf(map.get("province")));
                    }
                    if (map.get("city") != null) {
                        workerVO.setCity(String.valueOf(map.get("city")));
                    }
                    if (map.get("area") != null) {
                        workerVO.setArea(String.valueOf(map.get("area")));
                    }
                }
                //居住地址
                String address = row.get(13).trim();
                workerVO.setAddress(address);
                //备注
                String memo = row.get(14).trim();
                workerVO.setMemo(memo);
                workerVO.setErrorMessage(errMsg.toString());
                if (StringUtils.isBlank(workerVO.getErrorMessage())) {
                    successList.add(workerVO);
                } else {
                    workerVO.setId((long) i);
                    errorList.add(workerVO);
                }
                workerVO.setSourceFlag(WorkerConsts.SourceFlagEnum.公司自制.getCode());
                workerVO.setSourceFlagName(WorkerConsts.SourceFlagEnum.公司自制.getName());
            }
            JSONObject json = new JSONObject();
            json.put("successList", BeanMapper.mapList(successList,WorkerEntity.class));
            json.put("errorList", errorList);
            return CommonResponse.success(json);
        }
    }

    /**
     * @description: 保存导入人员信息
     *
     * @param request
     * @param workerEntities
     * @return {@link CommonResponse< String>}
     * @author songlx
     * @date: 2022/11/22
     */
    @RequestMapping(value = "/saveImportPerson", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportPerson(HttpServletRequest request, @RequestBody List<WorkerEntity> workerEntities) {
        List<WorkerVO> workerVOS = BeanMapper.mapList(workerEntities,WorkerVO.class);
        return CommonResponse.success(service.saveImportPerson(request, workerVOS));
    }

    /**
     * 分页查询
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "refWorkerPage", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> refWorkerPage(@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
                                                         @RequestParam(required = false) String relyCondition,
                                                         @RequestParam(required = false) String searchText,
                                                         @RequestParam(required = false) String condition,
                                                         @RequestParam(required = false) String searchObject) {
        Long teamId = null;
        if (StringUtils.isNotBlank(relyCondition)) {
            teamId = Long.parseLong(relyCondition.split("=")[1]);
            OrgTeamEntity orgTeam = orgTeamService.getById(teamId);
            if (orgTeam == null) {
                return CommonResponse.error("当前班组不存在档案！");
            }
            //如果是根班组不需要过滤，因为有的人员所属班组为空也在根班组下面
            teamId = orgTeam.getParentId() == null ? null : teamId;
        }

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        List<String> fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("workTypeName");
        fuzzyFields.add("teamName");
        fuzzyFields.add("phone");

        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);

        Map<String, Parameter> param = queryParam.getParams();

        if (StringUtils.isNotBlank(searchObject)) {
            JSONObject search = JSONObject.parseObject(searchObject);
            if (search.get("name") != null) {
                param.put("name", new Parameter(QueryParam.LIKE, search.get("name").toString()));
            }
            if (search.get("idCard") != null) {
                param.put("idCard", new Parameter(QueryParam.LIKE, search.get("idCard").toString()));
            }
            if (search.get("workTypeName") != null) {
                param.put("workTypeName", new Parameter(QueryParam.LIKE, search.get("workTypeName").toString()));
            }
            if (search.get("teamName") != null) {
                param.put("teamName", new Parameter(QueryParam.LIKE, search.get("teamName").toString()));
            }
            if (search.get("phone") != null) {
                param.put("phone", new Parameter(QueryParam.LIKE, search.get("phone").toString()));
            }
        }

        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("enabled", "desc");
        orderMap.put("createTime", "desc");
        queryParam.setOrderMap(orderMap);


        param.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.put("enabled", new Parameter(QueryParam.EQ, 1));

        IPage<WorkerVO> pageData = null;
        IPage<WorkerEntity> page = null;
        List<WorkerEntity> list = null;

        if (teamId != null) {
            page = new Page<>(queryParam.getPageIndex(), queryParam.getPageSize());
            list = service.queryOrgTeamWorkerPage((Page<WorkerEntity>) page, queryParam, teamId);
        } else {
            page = service.queryPage(queryParam, false);
            list = page.getRecords();
        }
        pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(list, WorkerVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refWorkerData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WorkerVO>> refWorkerData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                         String condition,
                                                         String searchObject,
                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WorkerEntity> page = service.queryPage(param, false);
        IPage<WorkerVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WorkerVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }


    /**
     * 校验身份证以及身份证信息识别
     *
     * @param imageUrl 身份证阿里oss存储在线地址
     * @param side     face：人像面  back：国徽面
     *
     * @return {@link CommonResponse}<{@link IdentityCardInfoVO}>
     */
    @GetMapping(value = "checkAndRecognizeIdentityCardInfo")
    public CommonResponse<IdentityCardInfoVO> checkAndRecognizeIdentityCardInfo(@RequestParam(value = "imageUrl") String imageUrl,
                                                                                @RequestParam(value = "side") String side) {
        return CommonResponse.success("校验身份证以及身份证信息识别，成功！", iIdCardService.checkAndRecognizeIdentityCardInfo(imageUrl, side));
    }

    /**
     * 人脸活体校验
     *
     * @param imgUrl 人脸地址
     *
     * @return {@link CommonResponse}<{@link Boolean}>
     */
    @GetMapping(value = "checkFaceQualityAndLive")
    public CommonResponse<Boolean> checkFaceQualityAndLive(@RequestParam(value = "imgUrl") String imgUrl) {
        return CommonResponse.success("人脸活体校验，成功！", faceService.checkFaceQualityAndLive(imgUrl));
    }

    /**
     * 公司花名册人员身份证和人脸校验定时任务
     *
     * @param request 请求
     *
     * @return {@link CommonResponse}<{@link Void}>
     */
    @PostMapping(value = "/checkTask")
    public CommonResponse<Void> checkTask(HttpServletRequest request) {
        service.checkTask(request);
        return CommonResponse.success("定时任务，身份证和人脸校验执行成功！");
    }

    /**
     * 下载导入证件模版
     *
     * @param request  请求
     * @param response 响应
     */
    @PostMapping(value = "/download")
    public void download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ClassPathResource resource = new ClassPathResource("zip/导入证件.zip");
        InputStream inputStream = resource.getInputStream();

        response.reset();
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("导入证件.zip", "utf-8"));
        response.setContentType("application/octet-stream;charset=UTF-8");
        IoUtil.copy(inputStream, response.getOutputStream());
    }


    /**
     * 批量校验证件
     *
     * @param request  请求
     * @param response 响应
     *
     * @return {@link CommonResponse}<{@link JSONObject}>
     */
    @PostMapping(value = "batchCheck")
    public CommonResponse<JSONObject> batchCheck(HttpServletRequest request, HttpServletResponse response) throws IOException, NoSuchFieldException, IllegalAccessException {
        return CommonResponse.success("批量校验证件，成功！", service.batchCheck(request, response));
    }


    /**
     * 更新照片数据
     *
     * @param batchCheckPhotoVOS 批量导入证件校验VO
     *
     * @return {@link CommonResponse}<{@link Void}>
     */
    @PostMapping(value = "updatePhotoData")
    public CommonResponse<Void> updatePhotoData(@Validated @RequestBody List<BatchCheckPhotoVO> batchCheckPhotoVOS) {
        service.updatePhotoData(batchCheckPhotoVOS);
        return CommonResponse.success("更新照片数据，成功！");
    }


    /**
     * @description: 停用启用
     * @author songlx
     * @date: 2022/11/21
     */
    @GetMapping(value = "enabled")
    public CommonResponse<String> enabled(Long id, Integer enabled) {
        if (id != null && enabled != null) {
            LambdaUpdateWrapper<WorkerEntity> updWrapper = new LambdaUpdateWrapper<>();
            updWrapper.set(WorkerEntity::getEnabled, enabled);
            updWrapper.eq(WorkerEntity::getId, id);
            service.update(updWrapper);
        }
        return CommonResponse.success("停用/启用成功！");
    }


}
