package com.ejianc.business.labor.controller.api;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.SalarySlipEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.ISalarySlipService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/projectTeam/")
public class ProjectTeamApi {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private ISalarySlipService salarySlipService;

    @GetMapping({"/queryTeamWorkerIdByPhone"})
    CommonResponse<List<Long>> queryTeamWorkerIdByPhone( String phone,Long projectId){
        List<Long> workIds=new ArrayList<>();
        List<String> teamIds = new ArrayList<>();
        QueryWrapper<WorkRecordEntity> objectQueryWrapper = new QueryWrapper<>();
        objectQueryWrapper.eq("phone",phone);
        objectQueryWrapper.eq("project_id",projectId);
        List<WorkRecordEntity> workRecordList = workRecordService.list(objectQueryWrapper);
        if (CollectionUtils.isNotEmpty(workRecordList)){
            List<String> teamList = workRecordList.stream().filter(s -> s.getTeamId() != null).map(WorkRecordEntity::getTeamId).
                    collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(teamList)){
                for (String s : teamList) {
                    String[] split = s.split(",");
                    teamIds.addAll(Arrays.asList(split));
                }
                if (CollectionUtils.isNotEmpty(teamIds)){
                    List<WorkRecordVO> workRecordVOs = salarySlipService.queryWorkByTeamId(projectId,teamIds);
                    workIds = workRecordVOs.stream().filter(s -> s.getWorkerId() != null).map(WorkRecordVO::getWorkerId).
                            collect(Collectors.toList());
                }
            }
         }
          return CommonResponse.success("查询人员id成功！", workIds);
    }
    /**
     * 修改工资条的申请金额
     * @param map
     * @return
     */
    @PostMapping({"/updateAlreadyApplyMny"})
    CommonResponse<String> updateAlreadyApplyMny(@RequestBody Map<Long, BigDecimal> map){
        Set<Long> ids = map.keySet();
        if (CollectionUtils.isNotEmpty(ids)){
            for (Long id : ids) {
                BigDecimal alreadyApplyMny = map.get(id);
                LambdaUpdateWrapper<SalarySlipEntity> objectLambdaUpdateWrapper = new LambdaUpdateWrapper<>();
                objectLambdaUpdateWrapper.eq(SalarySlipEntity::getId,id);
                objectLambdaUpdateWrapper.set(SalarySlipEntity::getAlreadyApplyMny,alreadyApplyMny);
                salarySlipService.update(objectLambdaUpdateWrapper);
            }
        }
        return CommonResponse.success("修改已经申请金额成功！");
    }
    /**
     * 根据手机号和项目id查询人员Id
     * @param phone
     * @return
     */
    @GetMapping({"/queryWorkerIdByPhone"})
    CommonResponse<List<Long>> queryWorkerIdByPhone(@RequestParam("phone") String phone){
        List<Long> workerIds = new ArrayList<>();
        QueryWrapper<WorkRecordEntity> objectQueryWrapper = new QueryWrapper<>();
        objectQueryWrapper.eq("phone",phone);
        List<WorkRecordEntity> workRecordList = workRecordService.list(objectQueryWrapper);
        if (CollectionUtils.isNotEmpty(workRecordList)){
            workerIds = workRecordList.stream().filter(s -> s.getTeamId() != null).map(WorkRecordEntity::getWorkerId).distinct().
                    collect(Collectors.toList());
        }
        return CommonResponse.success("查询人员id成功！",workerIds);
    }
}
