package com.ejianc.business.labor.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.labor.vo.SalaryVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.labor.bean.SalaryEntity;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 劳务工资单
 * 
 * @author generator
 * 
 */
public interface ISalaryService extends IBaseService<SalaryEntity> {

    CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response);

    Integer haveSalaryFlag(Long workerId, String exitDate);

    List<AttendanceVO> queryWorkerAttendanceList(Long workerId, String month,Long projectId);

    List<SalaryVO> querySalaryPage(QueryWrapper wrapper, String salaryMonth, Page<SalaryVO> page);
}
