package com.ejianc.business.labor.service;

import com.ejianc.business.labor.vo.FaceInfoVO;

/**
 * 人脸识别接口
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
public interface IFaceService {


	/**
	 * 人脸活体校验
	 *
	 * @param imgUrl 人脸地址
	 *
	 * @return {@link Boolean}
	 */
	Boolean checkFaceQualityAndLive(String imgUrl);

	/**
	 * 人脸注册
	 *
	 * @param faceInfoVO 人脸信息VO
	 * @param checkFlag  是否校验
	 */
	void faceRegistration(FaceInfoVO faceInfoVO, boolean checkFlag);

}
