package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.mapper.WorkerEnterMapper;
import com.ejianc.business.labor.service.*;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.labor.vo.WorkerEnterVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 劳务进场单
 * 
 * @author generator
 * 
 */
@Service("workerEnterService")
public class WorkerEnterServiceImpl extends BaseServiceImpl<WorkerEnterMapper, WorkerEnterEntity> implements IWorkerEnterService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String RECORD_BILL_TYPE = "BT202211000002";//用工记录 billType
    private static final String ENTER_BILL_TYPE = "BT202211000003";//劳务进场 billType
    private static final String WORKER_BILL_TYPE = "BT202211000007";//劳务 billType

    private static final String IDCARD_SOURCE_TYPE = "idCardFront";// 身份证信息正面 sourceType
    private static final String IDBACK_TYPE = "idCardBack";// 身份证信息反面sourceType
    private static final String FACE_TYPE = "face";// 人脸 sourceType ORDER_TYPE
    private static final String ORDER_TYPE = "desc";//ORDER_TYPE

    private static final String RECORD_FILE_SOURCE_TYPE = "workerUser";// 用工记录 附件管理 sourceType
    private static final String ENTER_FILE_SOURCE_TYPE = "worker001";// 劳务进场 附件管理 sourceType
    private static final String WORKER_FILE_SOURCE_TYPE = "worker001";// 劳务 附件管理 sourceType

    private static final String RECORD_CON_SOURCE_TYPE = "workRecord001";// 用工记录 用工合同 sourceType
    private static final String ENTER_CON_SOURCE_TYPE = "wokerEnter002";// 劳务进场 用工合同 sourceType

    private static final String BILL_CODE = "LABOR_WORKER_ENTER";//此处需要根据实际修改
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IWorkRecordService recordService;
    @Autowired
    private IProjectTeamService projectTeamService;
    @Autowired
    private IOrgTeamService orgTeamService;
    @Autowired
    private IWorkerService workerService;


    public WorkerEnterVO saveOrUpdate(WorkerEnterVO saveOrUpdateVO){
        WorkerEnterEntity entity = BeanMapper.map(saveOrUpdateVO, WorkerEnterEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (entity.getSourceFlag()==1){
                entity.setSourceFlagName("自制");
            }
            if (entity.getSourceFlag()==2){
                entity.setSourceFlagName("公司花名册");
            }
            if (entity.getSourceFlag()==3){
                entity.setSourceFlagName("邀请");
            }
        }
        super.saveOrUpdate(entity, false);
        WorkerEnterVO vo = BeanMapper.map(entity, WorkerEnterVO.class);
        return vo;
    }

    @Override
    public CommonResponse<JSONObject> saveCheck(WorkerEnterVO vo){
        // level 0  不可保存
        // level 1 可以保存 提示
        JSONObject jsonObject = new JSONObject();

        // 保存时校验 手机号
        //查看 未生效的进场记录否存在
        QueryWrapper<WorkerEnterEntity> queryEnter = new QueryWrapper<>();
        queryEnter.eq("phone",vo.getPhone());
        queryEnter.eq("tenant_id",InvocationInfoProxy.getTenantid());
        queryEnter.eq("dr",0);

        if (vo.getId()!=null){
            queryEnter.ne("id",vo.getId());
        }
        queryEnter.notIn("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()});
        WorkerEnterEntity enterOne = super.getOne(queryEnter);
        if (enterOne!=null){
            jsonObject.put("level",0);
            jsonObject.put("msg","该手机号被进场记录【"+enterOne.getName()+"】注册，不可重复添加；");
            return CommonResponse.success(jsonObject);
        }

        //租户公司花名册
        QueryWrapper<WorkerEntity> recordOneByPhone = new QueryWrapper<>();
        recordOneByPhone.eq("phone",vo.getPhone());
        recordOneByPhone.eq("dr", 0);
        recordOneByPhone.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<WorkerEntity> list = workerService.list(recordOneByPhone);
        if (CollectionUtils.isNotEmpty(list)){
            jsonObject.put("level",0);
            jsonObject.put("msg","该手机号被公司花名册【"+list.get(0).getName()+"】注册，不可重复添加；");
            return CommonResponse.success(jsonObject);
        }
        //保存时校验身份证号在项目花名册中是否在场，如果在场，提示：该劳务人员已在场，不能重复进场；
        QueryWrapper<WorkRecordEntity> queryRecordCard = new QueryWrapper<>();
        queryRecordCard.eq("id_card",vo.getIdCard());
        queryRecordCard.eq("enter_exit_state",1);
        queryRecordCard.eq("project_id",vo.getProjectId());
        queryRecordCard.eq("last_flag",1);
        queryRecordCard.eq("dr",0);
        queryRecordCard.eq("tenant_id",InvocationInfoProxy.getTenantid());
        WorkRecordEntity recordOneCard = recordService.getOne(queryRecordCard);
        if (recordOneCard!=null){
            jsonObject.put("level",0);
            jsonObject.put("msg","该劳务人员已在场，不能重复进场");
            return CommonResponse.success(jsonObject);
        }
        QueryWrapper<WorkerEnterEntity> queryEnterByCard = new QueryWrapper<>();
        queryEnterByCard.eq("id_card",vo.getIdCard());
        queryEnterByCard.eq("tenant_id",InvocationInfoProxy.getTenantid());
        if (vo.getId()!=null){
            queryEnterByCard.ne("id",vo.getId());
        }
        queryEnterByCard.notIn("bill_state", new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),
                BillStateEnum.PASSED_STATE.getBillStateCode()});
        WorkerEnterEntity enterOneCard = super.getOne(queryEnterByCard);
        if (enterOneCard!=null){
            jsonObject.put("level",0);
            jsonObject.put("msg","该人员在【"+enterOneCard.getProjectName()+"】中已存在未生效的进场记录，请等待上次进场审批通过后再进行本次进场；");
            return CommonResponse.success(jsonObject);
        }
        WorkerEntity recordOneByCard = workerService.queryOneByIdCard(vo.getIdCard());
        if (recordOneByCard!=null){
            jsonObject.put("level",1);
            jsonObject.put("msg","该用户在司花名册中已存在，本次进场将会修改公司花名册中该人员的基本信息，是否确定？");
            return CommonResponse.success(jsonObject);
        }


        jsonObject.put("level",2);
        return CommonResponse.success(jsonObject);
    }


    /**
     *  审批通过 回写 或插入数据
     * @param entity
     */
    @Override
    public void bpmWriteBackAndInsert(WorkerEnterEntity entity){
        boolean recordFlage = true;
        //TODO 推送到那个公司??
        WorkerEntity recordOneByCard = workerService.queryOneByIdCard(entity.getIdCard());
        CommonResponse<ProjectRegisterVO> projectRegisterVOCommonResponse = projectApi.queryProjectDetail(entity.getProjectId());
        if(!projectRegisterVOCommonResponse.isSuccess()) {
            throw new BusinessException("网络异常，获取项目信息， 请稍后再试");
        }
        ProjectRegisterVO project = projectRegisterVOCommonResponse.getData();

        //最终 save newWorker
        WorkerVO newWorker = BeanMapper.map(entity, WorkerVO.class);
        // 回写数据 进场记录生效后，补充公司花名册基本信息。逻辑为：进场有值取进场，进场无值取公司花名册值；
        if (null!=recordOneByCard){
            if (recordOneByCard.getWorkState().equals(1)){
                recordFlage = false;
            }
            newWorker =  BeanMapper.map(recordOneByCard, WorkerVO.class);
            newWorker.setLastProjectId(entity.getProjectId());
            if (null!=entity.getName()){//姓名
                newWorker.setName(entity.getName());
            }
            if (null!=entity.getPhone()){//手机号
                newWorker.setPhone(entity.getPhone());
            }
            if (null!=entity.getSex()){//性别
                newWorker.setSex(entity.getSex());
            }
            if (null!=entity.getBirthDate()){//出生年月
                newWorker.setBirthDate(entity.getBirthDate());
            }
            if (null!=entity.getNation()){// 民族
                newWorker.setNation(entity.getNation());
            }
            if (null!=entity.getWorkType()){// 工种
                newWorker.setWorkType(entity.getWorkType());
            }
            if (null!=entity.getWorkTypeName()){// 工种名称
                newWorker.setWorkTypeName(entity.getWorkTypeName());
            }
            if (null!=entity.getBankName()){// 开户行
                newWorker.setBankName(entity.getBankName());
            }
            if (null!=entity.getBankAccount()){// 银行账号
                newWorker.setBankAccount(entity.getBankAccount());
            }
            if (null!=entity.getWagesType()){// 工资类型
                newWorker.setWagesType(entity.getWagesType());
            }
            if (null!=entity.getWagesTypeName()){// 工资类型名称
                newWorker.setWagesTypeName(entity.getWagesTypeName());
            }
            if (null!=entity.getWage()){// 工价
                newWorker.setWage(entity.getWage());
            }
            if (null!=entity.getProvince()){// 省
                newWorker.setProvince(entity.getProvince());
            }
            if (null!=entity.getCity()){// 市
                newWorker.setCity(entity.getCity());
            }
            if (null!=entity.getArea()){// 省市
                newWorker.setArea(entity.getArea());
            }
            if (null!=entity.getAddress()){// 详细地址
                newWorker.setAddress(entity.getAddress());
            }
            if (null!=entity.getWagesTypeName()){// 工资类型名称
                newWorker.setWagesTypeName(entity.getWagesTypeName());
            }
            if (null!=entity.getMemo()){// 工资类型名称
                newWorker.setMemo(entity.getMemo());
            }

            if (null!=entity.getIdCardFrontPhotoFlag()){// 身份证正面照片状态：0-待校验，1-是，2-否，3-异常
                newWorker.setIdCardFrontPhotoFlag(entity.getIdCardFrontPhotoFlag());
            }
            if (null!=entity.getIdCardBackPhotoFlag()){//  身份证反面照片状态：0-待校验，1-是，2-否，3-异常
                newWorker.setIdCardBackPhotoFlag(entity.getIdCardBackPhotoFlag());
            }
            if (null!=entity.getFacePhotoFlag()){//  人脸采集状态：0-待校验，1-是，2-否，3-异常
                newWorker.setFacePhotoFlag(entity.getFacePhotoFlag());
            }
            if (null!=entity.getIdCardName()){
                newWorker.setIdCardName(entity.getIdCardName());// 身份证照片识别的姓名
            }
            if (null!=entity.getIdCardNo()){
                newWorker.setIdCardNo(entity.getIdCardNo());// 身份证照片识别的身份证号
            }
            if (null!=entity.getIdCardSex()){
                newWorker.setIdCardSex(entity.getIdCardSex());// 身份证照片识别的性别，1-男，2-女
            }
            if (null!=entity.getIdCardBirthDate()){
                newWorker.setIdCardBirthDate(entity.getIdCardBirthDate());// 身份证照片识别的出生年月
            }
            if (null!=entity.getIdCardNation()){
                newWorker.setIdCardNation(entity.getIdCardNation());// 身份证照片识别的民族
            }
            if (null!=entity.getIdCardStartDate()){
                newWorker.setIdCardStartDate(entity.getIdCardStartDate());// // 身份证照片识别的起始有效期
            }
            if (null!=entity.getIdCardEndDate()){
                newWorker.setIdCardEndDate(entity.getIdCardEndDate());// 身份证照片识别的截止有效期
            }
            if (null!=entity.getIdCardIssue()){
                newWorker.setIdCardIssue(entity.getIdCardIssue());// 身份证照片识别的签发机关
            }
            if (null!=entity.getIdCardBackPhotoExceptional()){
                newWorker.setIdCardBackPhotoExceptional(entity.getIdCardBackPhotoExceptional());
            }
            if (null!=entity.getIdCardFrontPhotoExceptional()){
                newWorker.setIdCardFrontPhotoExceptional(entity.getIdCardFrontPhotoExceptional());
            }
            if (null!=entity.getFacePhotoExceptional()){
                newWorker.setFacePhotoExceptional(entity.getFacePhotoExceptional());
            }

        }else {
            //单据审批通过后，该人员进入项目花名册、公司花名册；
            // 如公司花名册没有对应班组，那么班组为空即可；
            if(StringUtils.isNotEmpty(entity.getTeamId())){
                List<String> teamIdS = Arrays.asList(entity.getTeamId().split(","));
                LambdaQueryWrapper<OrgTeamEntity> teamLambda = new LambdaQueryWrapper<>();
                teamLambda.in(OrgTeamEntity::getId,teamIdS);
                List<OrgTeamEntity> list = orgTeamService.list(teamLambda);
                if (CollectionUtils.isNotEmpty(list)){
                    String newTeamIdS = list.stream().map(OrgTeamEntity::getId).collect(Collectors.toList()).
                            stream().map(Objects::toString).collect(Collectors.joining(","));;
                    String newTeamNames = list.stream().map(OrgTeamEntity::getName).collect(Collectors.toList()).
                            stream().map(Objects::toString).collect(Collectors.joining(","));;
                    newWorker.setTeamId(newTeamIdS);
                    newWorker.setTeamName(newTeamNames);
                }else {
                    newWorker.setTeamId(null);
                    newWorker.setTeamName(null);
                }
            }
            newWorker.setId(null);
            //设置来源
            newWorker.setSourceFlag(2);
            newWorker.setSourceFlagName("项目进场");
            newWorker.setSourceProjectId(entity.getProjectId());
            newWorker.setLastProjectId(entity.getProjectId());
        }
        newWorker.setEnabled(1);
        newWorker.setWorkState(1);
        newWorker.setWorkStateName("已入场");
        //劳务信息 往公司花名册 写认证信息 公司花名册会自动写入项目的
        WorkerVO workerVO = workerService.insertOrUpdate(newWorker);
        List<String> typeList = new ArrayList();
        typeList.add(IDCARD_SOURCE_TYPE);
        typeList.add(IDBACK_TYPE);
        typeList.add(FACE_TYPE);
        for (String s :typeList){
            //1.劳务进场 是否存在
            CommonResponse<List<AttachmentVO>> idCardResponse = attachmentApi.queryListBySourceId(
                    entity.getId(), ENTER_BILL_TYPE, s, ORDER_TYPE);
            if (!idCardResponse.isSuccess()){
                throw new BusinessException("网络异常 访问文件中心异常");
            }
            //2.存在就修改公司花名册 修改记录
            if (CollectionUtils.isNotEmpty(idCardResponse.getData())){
                //3.查询公司花名册 是否存在
                CommonResponse<List<AttachmentVO>> orgIdCardResponse = attachmentApi.queryListBySourceId(
                        workerVO.getId(), WORKER_BILL_TYPE, s, ORDER_TYPE);
                if (!orgIdCardResponse.isSuccess()){
                    throw new BusinessException("网络异常 查询文件中心异常");
                }
                if (CollectionUtils.isNotEmpty(orgIdCardResponse.getData())){
                    //4.公司花名册 存在就删除
                    CommonResponse<String> deleteFileByParam = attachmentApi.deleteFileByParam(
                            workerVO.getId(), WORKER_BILL_TYPE, s);
                    if (!deleteFileByParam.isSuccess()){
                        throw new BusinessException("网络异常 文件中心删除失败");
                    }
                }
                //5.然后写入公司花名册
                CommonResponse<String> commonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(
                        Long.toString(entity.getId()), ENTER_BILL_TYPE,s,
                        Long.toString(workerVO.getId()),WORKER_BILL_TYPE ,s );

                if (!commonResponse.isSuccess()){
                    throw new BusinessException("网络异常 文件中心复制失败");
                }

            }
        }

        // 插入数据到 用工记录
        if (recordFlage){
            WorkRecordVO record = BeanMapper.map(entity, WorkRecordVO.class);
            record.setId(IdWorker.getId());
            record.setWorkerId(workerVO.getId());
            record.setProjectTeamId(entity.getTeamId());
            record.setProjectTeamName(entity.getTeamName());
            record.setProjectWorkType(entity.getWorkType());
            record.setProjectWorkTypeName(entity.getWorkTypeName());
            record.setProjectAddress(project.getAddress());
            record.setSourceFlag(1);
            record.setSourceFlagName("项目进场");
            record.setSourceId(entity.getId());
            record.setEnterExitState(1);
            record.setSubContractId(entity.getSubContractId());
            record.setSubContractName(entity.getSubContractName());
            record.setSupplierId(entity.getSupplierId());
            record.setSupplierName(entity.getSupplierName());
            //设置入场信息
            record.setEnterDate(entity.getEnterDate());
            record.setEmployeeId(entity.getEmployeeId());
            record.setEmployeeName(entity.getEmployeeName());
            //设置项目信息
            record.setProjectId(entity.getProjectId());
            record.setProjectName(entity.getProjectName());
            record.setOrgId(entity.getOrgId());
            record.setParentOrgId(entity.getParentOrgId());
            record.setParentOrgName(entity.getParentOrgName());
            List<WorkRecordVO> saveVoList = new ArrayList<>();
            saveVoList.add(record);
            List<WorkRecordVO> recordVOS = recordService.insertWorkRecord(saveVoList);
            WorkRecordVO recordVO = recordVOS.get(0);
            CommonResponse<String> commonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(
                    Long.toString(entity.getId()), ENTER_BILL_TYPE,ENTER_CON_SOURCE_TYPE,
                    Long.toString(recordVO.getId()),RECORD_BILL_TYPE,RECORD_CON_SOURCE_TYPE);
            if (!commonResponse.isSuccess()){
                throw new BusinessException("网络异常 文件中心复制失败");
            }
        }
    }

    @Override
    public Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId) {
        if (teamId == null && workerId == null) {
            return 0;
        }
        return baseMapper.updateWorkerTeamNameByTeamIdOrWorkerId(teamId, workerId);
    }
}
