package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.ProjectTeamEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.service.IProjectTeamService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.business.labor.vo.ProjectTeamVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目班组
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("projectTeam")
public class ProjectTeamController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectApi projectApi;
    private static final String BILL_CODE = "LABOR_PROJECT_TEAM";//此处需要根据实际修改

    @Autowired
    private IProjectTeamService service;

    @Autowired
    private SessionManager sessionManager;


    @Autowired
    private IWorkerEnterService workerEnterService;
    @Autowired
    private IWorkRecordService recordService;

    @Autowired
    private IWorkerEnterService enterService;
    @RequestMapping(value = "/lazyTeamCategory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String,Object>>> lazyTeamCategory (Long parentId,Long projectId){
        //根据项目id查询
        LambdaQueryWrapper<ProjectTeamEntity> wrapperByProject = new LambdaQueryWrapper<>();
        wrapperByProject.eq(projectId!= null, ProjectTeamEntity::getProjectId,projectId);
        wrapperByProject.eq(parentId != null, ProjectTeamEntity::getParentId,parentId);
        wrapperByProject.eq(ProjectTeamEntity::getTenantId,InvocationInfoProxy.getTenantid());
        List<ProjectTeamEntity> list = service.list(wrapperByProject);
        //TODO 无参 当前是项目部门 查询到数据
        if(CollectionUtils.isNotEmpty(list)){
            List<ProjectTeamVO> vos = BeanMapper.mapList(list, ProjectTeamVO.class);
            List<Map> resultMapList = BeanMapper.mapList(vos, Map.class);
            for (Map map :resultMapList){
                System.out.println(map);
                if(map.get("isLeaf").equals(false)){
                    map.put("children", new ArrayList<>());
                }
            }
            return CommonResponse.success(ResultAsTree.createTreeData(resultMapList));
        }else {
            CommonResponse<ProjectRegisterVO> projectResponse = projectApi.queryProjectDetail(projectId);
            if (!projectResponse.isSuccess()){
                throw new BusinessException("网络异常 获取项目信息错误");
            }
            ProjectRegisterVO project = projectResponse.getData();
            //TODO 无参 当前是项目部门 未查询到数据 插入
            ProjectTeamEntity entity = new ProjectTeamEntity();
            Long id = IdWorker.getId();
            entity.setId(id);
            entity.setInnerCode(id.toString());
            entity.setIsLeaf(true);
            UserContext userContext = UserContext.getUserContext();
            userContext.getOrgType();
            entity.setName(project.getName());
            entity.setProjectId(project.getId());
            entity.setProjectName(project.getName());
            entity.setOrgId(project.getProjectDepartmentId());
            entity.setParentOrgId(project.getOrgId());
            entity.setParentOrgName(project.getOrgName());
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),new OrgTeamVO());
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            service.save(entity);
            List<ProjectTeamEntity> listTwo = service.list(wrapperByProject);
            if(CollectionUtils.isNotEmpty(listTwo)){
                List<ProjectTeamVO> vos = BeanMapper.mapList(listTwo, ProjectTeamVO.class);
                List<Map> resultMapList = BeanMapper.mapList(vos, Map.class);
                for (Map map :resultMapList){
                    System.out.println(map);
                    if(map.get("isLeaf").equals(false)){
                        map.put("children", new ArrayList<>());
                    }
                }
                return CommonResponse.success(ResultAsTree.createTreeData(resultMapList));
            }
        }
        return CommonResponse.success();
    }

    /**
     * 参照异步（懒加载）树----分类树
     * @param condition
     * @param pid
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/lazyTeamTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> lazyTeamTree(@RequestParam(required=false) String condition,
                                                     @RequestParam(required=false) Long pid, @RequestParam(required = false) String searchText) {
        QueryParam param = new QueryParam();
        Object notContainsIdAndChild = null;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            //修改班组时，参照中的上级节点不能选择自己和自己的子集
            notContainsIdAndChild = _con.get("notContainsIdAndChild");
            if (_con.containsKey("projectId")){
                param.getParams().put("project_id",new Parameter(QueryParam.EQ,_con.get("projectId")));
            }else {
                param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (pid != null){
            param.getParams().put("parent_id", new Parameter(QueryParam.EQ, pid));
        }
        List<ProjectTeamEntity> projectTeamEntities = service.queryList(param);
        List<Map> list = BeanMapper.mapList(projectTeamEntities, Map.class);

        //修改班组时，参照中的上级节点不能选择自己和自己的子集，需要禁用
        if (null != notContainsIdAndChild) {
            for (Map map : list) {
                String innerCode = String.valueOf(map.get("innerCode"));
                if (innerCode.contains(String.valueOf(notContainsIdAndChild))) {
                    map.put("disable", true);
                }
            }
        }
        return ResultAsTree.createTreeData(list);

    }
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ProjectTeamVO> saveOrUpdate(@RequestBody ProjectTeamVO saveOrUpdateVO) {
        ProjectTeamVO projectTeamVO = service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",projectTeamVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectTeamVO> queryDetail(Long id) {
    	ProjectTeamEntity entity = service.selectById(id);
    	ProjectTeamVO vo = BeanMapper.map(entity, ProjectTeamVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectTeamVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ProjectTeamVO vo : vos) {
                ProjectTeamEntity entity = service.getById(vo.getId());
                if (null==entity.getParentId()) {
                    return CommonResponse.error("删除失败，根班组无法删除！");
                }
                //先查询该班组下是否有子级班组，如果有则无法删除
                LambdaQueryWrapper<ProjectTeamEntity> wrapper = new LambdaQueryWrapper();
                wrapper.eq(ProjectTeamEntity::getProjectId,entity.getProjectId());
                wrapper.eq(ProjectTeamEntity::getParentId, entity.getId());
                int count = service.count(wrapper);
                if (count > 0) {
                    return CommonResponse.error("删除失败，该班组下有子级，无法删除！");
                }
                // 还需要判断该班组下是否有人员 有则不许删除 判断劳务进场是否有改班组的人员
                LambdaQueryWrapper<WorkRecordEntity> recordWrapper = new LambdaQueryWrapper<>();
                recordWrapper.eq(WorkRecordEntity::getProjectId,entity.getProjectId());
                recordWrapper.like(WorkRecordEntity::getTeamId,entity.getId());
                int count1 = recordService.count(recordWrapper);
                if (count1 > 0) {
                    return CommonResponse.error("删除失败，该班组下有人员，无法删除！");
                }
                LambdaQueryWrapper<WorkerEnterEntity> enterWrapper = new LambdaQueryWrapper<>();
                enterWrapper.like(WorkerEnterEntity::getTeamId,entity.getId());
                enterWrapper.eq(WorkerEnterEntity::getProjectId,entity.getProjectId());
                enterWrapper.notIn(WorkerEnterEntity::getBillState,new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode()});

                int count2 = enterService.count(enterWrapper);
                if (count2 > 0) {
                    return CommonResponse.error("删除失败，该班组下有未生效的劳务进场，无法删除！");
                }
            }
        }
        List<Long> delTeamIds = vos.stream().map(ProjectTeamVO::getId).collect(Collectors.toList());
        for (ProjectTeamVO vo : vos) {
            ProjectTeamEntity entity = service.selectById(vo.getId());
            Long parentId = entity.getParentId();
            if (parentId != null) {
                //删除后上级班组没有子级时更改上级班组的isLeaf字段
                LambdaQueryWrapper<ProjectTeamEntity> wrapper = new LambdaQueryWrapper();
                wrapper.eq(ProjectTeamEntity::getParentId, parentId);
                wrapper.notIn(ProjectTeamEntity::getId, delTeamIds);
                int count = service.count(wrapper);
                if (count == 0) {
                    LambdaUpdateWrapper<ProjectTeamEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.set(ProjectTeamEntity::getIsLeaf, Boolean.TRUE);
                    updateWrapper.eq(ProjectTeamEntity::getId, parentId);
                    service.update(updateWrapper);
                }
            }

        }
        service.removeByIds(delTeamIds);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 查询本下所有启用
     * @param param
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> queryList(@RequestBody QueryParam param) {
        List<JSONObject> jsonObjects = new ArrayList<>();
        //查询本下所有启用、在建的项目，按项目创建时间倒序排列；
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        param.getParams().put("status",new Parameter(QueryParam.EQ,2));
        param.getParams().put("validStatus",new Parameter(QueryParam.EQ,0));
        CommonResponse<Page<ProjectRegisterVO>> projectResponse = projectApi.queryProjectPage(param);
        if (!projectResponse.isSuccess()){
            throw new BusinessException("网络异常， 获取项目失败， 请稍后再试");
        }
        List<ProjectRegisterVO> records = projectResponse.getData().getRecords();
        for (ProjectRegisterVO vo :records){
            JSONObject jsonObject = new JSONObject();
            //查询劳务工数量
            LambdaQueryWrapper<WorkRecordEntity> workNumLambda =new LambdaQueryWrapper<>();
            workNumLambda.eq(WorkRecordEntity::getProjectId,vo.getId());
            workNumLambda.eq(WorkRecordEntity::getEnterExitState,1);
            workNumLambda.eq(WorkRecordEntity::getLastFlag,1);
            List<WorkRecordEntity> list = recordService.list(workNumLambda);
            int workNum = list.size();
            jsonObject.put("workNum",workNum);
            //查询班组数量
            LambdaQueryWrapper<ProjectTeamEntity> teamNumLambda =new LambdaQueryWrapper<>();
            teamNumLambda.eq(ProjectTeamEntity::getProjectId,vo.getId());
            teamNumLambda.isNotNull(ProjectTeamEntity::getParentId);
            int teamNum = service.count(teamNumLambda);
            jsonObject.put("teamNum",teamNum);
            //查询工种数量：3
            int workTypeNum = 0;
            List<String> listWithoutDuplicates = new ArrayList<>();
            for (WorkRecordEntity entity:list){
                if (null!=entity.getWorkType()){
                    List<String> strings = Arrays.asList(entity.getWorkType().split(","));
                    listWithoutDuplicates = strings.stream().distinct().collect(Collectors.toList());
                }
            }
            workTypeNum=listWithoutDuplicates.size();
            jsonObject.put("workTypeNum",workTypeNum);
            //查询人脸采集
            workNumLambda.eq(WorkRecordEntity::getFacePhotoFlag,1);
            int faceCollection = recordService.count(workNumLambda);
            jsonObject.put("faceCollection",faceCollection+"/"+workNum);
            String statusStr = "";
//            1-未开工, 2-在建，3-完成
            if (vo.getStatus().equals("1")){
                statusStr="未开工";
            }else if (vo.getStatus().equals("2")){
                statusStr="在建";
            }else {
                statusStr="完成";
            }
            jsonObject.put("status",vo.getStatus());
            jsonObject.put("statusStr",statusStr);
            //基本信息
            jsonObject.put("id",vo.getId());
            jsonObject.put("name",vo.getName());
            jsonObjects.add(jsonObject);
        }
        IPage<JSONObject> pageData = new Page<>(projectResponse.getData().getCurrent(), projectResponse.getData().getSize(), projectResponse.getData().getTotal());
        pageData.setRecords(jsonObjects);
        return CommonResponse.success("查询列表数据成功！",pageData);
    }





    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<>();
        CommonResponse<IPage<JSONObject>> iPageCommonResponse = queryList(param);
        List<JSONObject> resultList = new ArrayList<>();
        if (null!=iPageCommonResponse.getData()){
            resultList = iPageCommonResponse.getData().getRecords();
        }
        //todo:字段翻译等等
        beans.put("records", resultList);
        ExcelExport.getInstance().export("ProjectTeam-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refProjectTeamData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ProjectTeamVO>> refProjectTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ProjectTeamEntity> page = service.queryPage(param,false);
        IPage<ProjectTeamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ProjectTeamVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/insertBatch", method = RequestMethod.POST)
    @ResponseBody
     public CommonResponse<String> insertBatch( @RequestBody List<ProjectTeamVO> vos){
        List<String> strings = service.insertBatch(vos);
        if (strings.size()>0){
            return CommonResponse.error(strings.toString());
        }
        return CommonResponse.success("引入成功");
     }
}
