package com.ejianc.business.labor.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labor.utils.EJCDateUtil;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.labor.vo.WorkerExitVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labor.bean.SalaryEntity;
import com.ejianc.business.labor.service.ISalaryService;
import com.ejianc.business.labor.vo.SalaryVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 劳务工资单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("salary")
public class SalaryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "LABOR_SALARY_CODE";//此处需要根据实际修改

    @Autowired
    private ISalaryService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SalaryVO> saveOrUpdate(@RequestBody SalaryVO saveOrUpdateVO) {
    	SalaryEntity entity = BeanMapper.map(saveOrUpdateVO, SalaryEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SalaryVO vo = BeanMapper.map(entity, SalaryVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalaryVO> queryDetail(Long id) {
    	SalaryEntity entity = service.selectById(id);
    	SalaryVO vo = BeanMapper.map(entity, SalaryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalaryVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SalaryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SalaryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalaryVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        String salaryMonth=null;
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("salaryMonth")){
            salaryMonth = (String)params.get("salaryMonth").getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth=split[0]+"-"+split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<SalaryVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<SalaryVO> list = service.querySalaryPage(wrapper,salaryMonth,page);
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        String salaryMonth=null;
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("salaryMonth")){
            salaryMonth = (String)params.get("salaryMonth").getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth=split[0]+"-"+split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<SalaryVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<SalaryVO> list = service.querySalaryPage(wrapper,salaryMonth,null);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)){
            for (SalaryVO vo : list) {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("Salary-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSalaryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SalaryVO>> refSalaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SalaryEntity> page = service.queryPage(param,false);
        IPage<SalaryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalaryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "salary-import.xlsx", "劳务工资单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse=  service.excelImport(request,response);
        return commonResponse;
    }

    @RequestMapping(value = "/queryWorkerAttendanceList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, Object>> queryWorkerAttendanceList(String month, Long workerId, Long projectId,Long id) {
        String createTime=null;
        if (id!=null){
            SalaryEntity salaryEntity = service.selectById(id);
            createTime = EJCDateUtil.format(salaryEntity.getCreateTime(), EJCDateUtil.DATE_TIME);
        }
        List<AttendanceVO> list=service.queryWorkerAttendanceList(workerId,month,projectId,createTime);
        Integer lastAttendance=0;
        Integer normalAttendance=0;
        Integer abnormalAttendance=0;
        if (CollectionUtils.isNotEmpty(list)){
            for (AttendanceVO attendanceVO : list) {
                lastAttendance+=1;
                if ("正常".equals(attendanceVO.getAttendanceStatus())){
                    normalAttendance+=1;
                }
                if ("异常".equals(attendanceVO.getAttendanceStatus())){
                    abnormalAttendance+=1;
                }
            }
        }
        Map<String, Object> map = new HashMap<>();
        map.put("lastAttendance",lastAttendance);
        map.put("list",list);
        map.put("normalAttendance",normalAttendance);
        map.put("abnormalAttendance",abnormalAttendance);
        return CommonResponse.success("查询列表数据成功！", map);
    }

}
