package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.mapper.AttendanceMapper;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import java.util.Date;


/**
 * 考勤记录
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Service("attendanceService")
public class AttendanceServiceImpl extends BaseServiceImpl<AttendanceMapper, AttendanceEntity> implements IAttendanceService {

    @Override
    public int totalAttendanceDays(Date enterDate, Date exitDate, Long workerId,Long projectId) {
        QueryWrapper<AttendanceEntity> queryWrapper = new QueryWrapper<>();

        queryWrapper.eq("project_id",projectId);

        queryWrapper.eq("worker_id",workerId);
        queryWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        queryWrapper.between("punch_card_date",enterDate,exitDate);
        int count = super.count(queryWrapper);
        return count;
    }
}
