package com.ejianc.business.labor.service.impl;

import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.bean.WorkerRegisterEntity;
import com.ejianc.business.labor.enums.WorkerConsts;
import com.ejianc.business.labor.mapper.WorkerMapper;
import com.ejianc.business.labor.service.*;
import com.ejianc.business.labor.utils.UploadFile;
import com.ejianc.business.labor.vo.BatchCheckPhotoVO;
import com.ejianc.business.labor.vo.FaceInfoVO;
import com.ejianc.business.labor.vo.IdentityCardInfoVO;
import com.ejianc.business.labor.vo.WorkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.*;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/**
 * 公司花名册人员
 *
 * @author generator
 */
@Service("workerService")
public class WorkerServiceImpl extends BaseServiceImpl<WorkerMapper, WorkerEntity> implements IWorkerService {
    private static final String BILL_TYPE = "BT202211000007";
    private static final String ID_CARD_FRONT = "身份证信息面";
    private static final String ID_CARD_BACK = "身份证国徽面";
    private static final String FACE_PHOTO = "人脸照片";
    private static final String FRONT = "idCardFront";
    private static final String BACK = "idCardBack";
    private static final String FACE = "face";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());


    private static final String RECORD_BILL_TYPE = "BT202211000002";//用工记录 billType
    private static final String WORKER_BILL_TYPE = "BT202211000007";//劳务 billType
    private static final String IDCARD_SOURCE_TYPE = "idCardFront";// 身份证信息正面 sourceType
    private static final String IDBACK_TYPE = "idCardBack";// 身份证信息反面sourceType
    private static final String FACE_TYPE = "face";// 人脸 sourceType ORDER_TYPE
    private static final String ORDER_TYPE = "desc";//ORDER_TYPE
    private static final String RECORD_FILE_SOURCE_TYPE = "workerUser";// 用工记录 附件管理 sourceType
    private static final String WORKER_FILE_SOURCE_TYPE = "worker001";// 劳务 附件管理 sourceType

    @Resource
    private IIdCardService idCardService;
    @Resource
    private IFaceService faceService;
    @Resource
    private WorkerMapper workerMapper;
    @Resource
    private UploadFile uploadFile;
    @Resource
    private IAttachmentApi attachmentApi;
    @Value("${fileUrl}")
    private String fileUrl;

    @Autowired
    private IOrgTeamService orgTeamService;
    @Autowired
    private IWorkerRegisterService workerRegisterService;

    @Autowired
    private IWorkRecordService workRecordService;

    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "LABOR_WORKER";//此处需要根据实际修改
    //省市json数据
    private static final String AREA_JSON_STR = "[{\"code\":\"110000\",\"value\":\"北京市\",\"label\":\"北京市\",\"children\":[{\"code\":\"110101\",\"value\":\"东城区\",\"label\":\"东城区\"},{\"code\":\"110102\",\"value\":\"西城区\",\"label\":\"西城区\"},{\"code\":\"110105\",\"value\":\"朝阳区\",\"label\":\"朝阳区\"},{\"code\":\"110106\",\"value\":\"丰台区\",\"label\":\"丰台区\"},{\"code\":\"110107\",\"value\":\"石景山区\",\"label\":\"石景山区\"},{\"code\":\"110108\",\"value\":\"海淀区\",\"label\":\"海淀区\"},{\"code\":\"110109\",\"value\":\"门头沟区\",\"label\":\"门头沟区\"},{\"code\":\"110111\",\"value\":\"房山区\",\"label\":\"房山区\"},{\"code\":\"110112\",\"value\":\"通州区\",\"label\":\"通州区\"},{\"code\":\"110113\",\"value\":\"顺义区\",\"label\":\"顺义区\"},{\"code\":\"110114\",\"value\":\"昌平区\",\"label\":\"昌平区\"},{\"code\":\"110115\",\"value\":\"大兴区\",\"label\":\"大兴区\"},{\"code\":\"110116\",\"value\":\"怀柔区\",\"label\":\"怀柔区\"},{\"code\":\"110117\",\"value\":\"平谷区\",\"label\":\"平谷区\"},{\"code\":\"110118\",\"value\":\"密云区\",\"label\":\"密云区\"},{\"code\":\"110119\",\"value\":\"延庆区\",\"label\":\"延庆区\"}]},{\"code\":\"120000\",\"value\":\"天津市\",\"label\":\"天津市\",\"children\":[{\"code\":\"120101\",\"value\":\"和平区\",\"label\":\"和平区\"},{\"code\":\"120102\",\"value\":\"河东区\",\"label\":\"河东区\"},{\"code\":\"120103\",\"value\":\"河西区\",\"label\":\"河西区\"},{\"code\":\"120104\",\"value\":\"南开区\",\"label\":\"南开区\"},{\"code\":\"120105\",\"value\":\"河北区\",\"label\":\"河北区\"},{\"code\":\"120106\",\"value\":\"红桥区\",\"label\":\"红桥区\"},{\"code\":\"120110\",\"value\":\"东丽区\",\"label\":\"东丽区\"},{\"code\":\"120111\",\"value\":\"西青区\",\"label\":\"西青区\"},{\"code\":\"120112\",\"value\":\"津南区\",\"label\":\"津南区\"},{\"code\":\"120113\",\"value\":\"北辰区\",\"label\":\"北辰区\"},{\"code\":\"120114\",\"value\":\"武清区\",\"label\":\"武清区\"},{\"code\":\"120115\",\"value\":\"宝坻区\",\"label\":\"宝坻区\"},{\"code\":\"120116\",\"value\":\"滨海新区\",\"label\":\"滨海新区\"},{\"code\":\"120117\",\"value\":\"宁河区\",\"label\":\"宁河区\"},{\"code\":\"120118\",\"value\":\"静海区\",\"label\":\"静海区\"},{\"code\":\"120119\",\"value\":\"蓟州区\",\"label\":\"蓟州区\"}]},{\"code\":\"130000\",\"value\":\"河北省\",\"label\":\"河北省\",\"children\":[{\"code\":\"130100\",\"value\":\"石家庄市\",\"label\":\"石家庄市\"},{\"code\":\"130200\",\"value\":\"唐山市\",\"label\":\"唐山市\"},{\"code\":\"130300\",\"value\":\"秦皇岛市\",\"label\":\"秦皇岛市\"},{\"code\":\"130400\",\"value\":\"邯郸市\",\"label\":\"邯郸市\"},{\"code\":\"130500\",\"value\":\"邢台市\",\"label\":\"邢台市\"},{\"code\":\"130600\",\"value\":\"保定市\",\"label\":\"保定市\"},{\"code\":\"130700\",\"value\":\"张家口市\",\"label\":\"张家口市\"},{\"code\":\"130800\",\"value\":\"承德市\",\"label\":\"承德市\"},{\"code\":\"130900\",\"value\":\"沧州市\",\"label\":\"沧州市\"},{\"code\":\"131000\",\"value\":\"廊坊市\",\"label\":\"廊坊市\"},{\"code\":\"131100\",\"value\":\"衡水市\",\"label\":\"衡水市\"}]},{\"code\":\"140000\",\"value\":\"山西省\",\"label\":\"山西省\",\"children\":[{\"code\":\"140100\",\"value\":\"太原市\",\"label\":\"太原市\"},{\"code\":\"140200\",\"value\":\"大同市\",\"label\":\"大同市\"},{\"code\":\"140300\",\"value\":\"阳泉市\",\"label\":\"阳泉市\"},{\"code\":\"140400\",\"value\":\"长治市\",\"label\":\"长治市\"},{\"code\":\"140500\",\"value\":\"晋城市\",\"label\":\"晋城市\"},{\"code\":\"140600\",\"value\":\"朔州市\",\"label\":\"朔州市\"},{\"code\":\"140700\",\"value\":\"晋中市\",\"label\":\"晋中市\"},{\"code\":\"140800\",\"value\":\"运城市\",\"label\":\"运城市\"},{\"code\":\"140900\",\"value\":\"忻州市\",\"label\":\"忻州市\"},{\"code\":\"141000\",\"value\":\"临汾市\",\"label\":\"临汾市\"},{\"code\":\"141100\",\"value\":\"吕梁市\",\"label\":\"吕梁市\"}]},{\"code\":\"150000\",\"value\":\"内蒙古自治区\",\"label\":\"内蒙古自治区\",\"children\":[{\"code\":\"150100\",\"value\":\"呼和浩特市\",\"label\":\"呼和浩特市\"},{\"code\":\"150200\",\"value\":\"包头市\",\"label\":\"包头市\"},{\"code\":\"150300\",\"value\":\"乌海市\",\"label\":\"乌海市\"},{\"code\":\"150400\",\"value\":\"赤峰市\",\"label\":\"赤峰市\"},{\"code\":\"150500\",\"value\":\"通辽市\",\"label\":\"通辽市\"},{\"code\":\"150600\",\"value\":\"鄂尔多斯市\",\"label\":\"鄂尔多斯市\"},{\"code\":\"150700\",\"value\":\"呼伦贝尔市\",\"label\":\"呼伦贝尔市\"},{\"code\":\"150800\",\"value\":\"巴彦淖尔市\",\"label\":\"巴彦淖尔市\"},{\"code\":\"150900\",\"value\":\"乌兰察布市\",\"label\":\"乌兰察布市\"},{\"code\":\"152200\",\"value\":\"兴安盟\",\"label\":\"兴安盟\"},{\"code\":\"152500\",\"value\":\"锡林郭勒盟\",\"label\":\"锡林郭勒盟\"},{\"code\":\"152900\",\"value\":\"阿拉善盟\",\"label\":\"阿拉善盟\"}]},{\"code\":\"210000\",\"value\":\"辽宁省\",\"label\":\"辽宁省\",\"children\":[{\"code\":\"210100\",\"value\":\"沈阳市\",\"label\":\"沈阳市\"},{\"code\":\"210200\",\"value\":\"大连市\",\"label\":\"大连市\"},{\"code\":\"210300\",\"value\":\"鞍山市\",\"label\":\"鞍山市\"},{\"code\":\"210400\",\"value\":\"抚顺市\",\"label\":\"抚顺市\"},{\"code\":\"210500\",\"value\":\"本溪市\",\"label\":\"本溪市\"},{\"code\":\"210600\",\"value\":\"丹东市\",\"label\":\"丹东市\"},{\"code\":\"210700\",\"value\":\"锦州市\",\"label\":\"锦州市\"},{\"code\":\"210800\",\"value\":\"营口市\",\"label\":\"营口市\"},{\"code\":\"210900\",\"value\":\"阜新市\",\"label\":\"阜新市\"},{\"code\":\"211000\",\"value\":\"辽阳市\",\"label\":\"辽阳市\"},{\"code\":\"211100\",\"value\":\"盘锦市\",\"label\":\"盘锦市\"},{\"code\":\"211200\",\"value\":\"铁岭市\",\"label\":\"铁岭市\"},{\"code\":\"211300\",\"value\":\"朝阳市\",\"label\":\"朝阳市\"},{\"code\":\"211400\",\"value\":\"葫芦岛市\",\"label\":\"葫芦岛市\"}]},{\"code\":\"220000\",\"value\":\"吉林省\",\"label\":\"吉林省\",\"children\":[{\"code\":\"220100\",\"value\":\"长春市\",\"label\":\"长春市\"},{\"code\":\"220200\",\"value\":\"吉林市\",\"label\":\"吉林市\"},{\"code\":\"220300\",\"value\":\"四平市\",\"label\":\"四平市\"},{\"code\":\"220400\",\"value\":\"辽源市\",\"label\":\"辽源市\"},{\"code\":\"220500\",\"value\":\"通化市\",\"label\":\"通化市\"},{\"code\":\"220600\",\"value\":\"白山市\",\"label\":\"白山市\"},{\"code\":\"220700\",\"value\":\"松原市\",\"label\":\"松原市\"},{\"code\":\"220800\",\"value\":\"白城市\",\"label\":\"白城市\"},{\"code\":\"222400\",\"value\":\"延边朝鲜族自治州\",\"label\":\"延边朝鲜族自治州\"}]},{\"code\":\"230000\",\"value\":\"黑龙江省\",\"label\":\"黑龙江省\",\"children\":[{\"code\":\"230100\",\"value\":\"哈尔滨市\",\"label\":\"哈尔滨市\"},{\"code\":\"230200\",\"value\":\"齐齐哈尔市\",\"label\":\"齐齐哈尔市\"},{\"code\":\"230300\",\"value\":\"鸡西市\",\"label\":\"鸡西市\"},{\"code\":\"230400\",\"value\":\"鹤岗市\",\"label\":\"鹤岗市\"},{\"code\":\"230500\",\"value\":\"双鸭山市\",\"label\":\"双鸭山市\"},{\"code\":\"230600\",\"value\":\"大庆市\",\"label\":\"大庆市\"},{\"code\":\"230700\",\"value\":\"伊春市\",\"label\":\"伊春市\"},{\"code\":\"230800\",\"value\":\"佳木斯市\",\"label\":\"佳木斯市\"},{\"code\":\"230900\",\"value\":\"七台河市\",\"label\":\"七台河市\"},{\"code\":\"231000\",\"value\":\"牡丹江市\",\"label\":\"牡丹江市\"},{\"code\":\"231100\",\"value\":\"黑河市\",\"label\":\"黑河市\"},{\"code\":\"231200\",\"value\":\"绥化市\",\"label\":\"绥化市\"},{\"code\":\"232700\",\"value\":\"大兴安岭地区\",\"label\":\"大兴安岭地区\"}]},{\"code\":\"310000\",\"value\":\"上海市\",\"label\":\"上海市\",\"children\":[{\"code\":\"310101\",\"value\":\"黄浦区\",\"label\":\"黄浦区\"},{\"code\":\"310104\",\"value\":\"徐汇区\",\"label\":\"徐汇区\"},{\"code\":\"310105\",\"value\":\"长宁区\",\"label\":\"长宁区\"},{\"code\":\"310106\",\"value\":\"静安区\",\"label\":\"静安区\"},{\"code\":\"310107\",\"value\":\"普陀区\",\"label\":\"普陀区\"},{\"code\":\"310109\",\"value\":\"虹口区\",\"label\":\"虹口区\"},{\"code\":\"310110\",\"value\":\"杨浦区\",\"label\":\"杨浦区\"},{\"code\":\"310112\",\"value\":\"闵行区\",\"label\":\"闵行区\"},{\"code\":\"310113\",\"value\":\"宝山区\",\"label\":\"宝山区\"},{\"code\":\"310114\",\"value\":\"嘉定区\",\"label\":\"嘉定区\"},{\"code\":\"310115\",\"value\":\"浦东新区\",\"label\":\"浦东新区\"},{\"code\":\"310116\",\"value\":\"金山区\",\"label\":\"金山区\"},{\"code\":\"310117\",\"value\":\"松江区\",\"label\":\"松江区\"},{\"code\":\"310118\",\"value\":\"青浦区\",\"label\":\"青浦区\"},{\"code\":\"310120\",\"value\":\"奉贤区\",\"label\":\"奉贤区\"},{\"code\":\"310151\",\"value\":\"崇明区\",\"label\":\"崇明区\"}]},{\"code\":\"320000\",\"value\":\"江苏省\",\"label\":\"江苏省\",\"children\":[{\"code\":\"320100\",\"value\":\"南京市\",\"label\":\"南京市\"},{\"code\":\"320200\",\"value\":\"无锡市\",\"label\":\"无锡市\"},{\"code\":\"320300\",\"value\":\"徐州市\",\"label\":\"徐州市\"},{\"code\":\"320400\",\"value\":\"常州市\",\"label\":\"常州市\"},{\"code\":\"320500\",\"value\":\"苏州市\",\"label\":\"苏州市\"},{\"code\":\"320600\",\"value\":\"南通市\",\"label\":\"南通市\"},{\"code\":\"320700\",\"value\":\"连云港市\",\"label\":\"连云港市\"},{\"code\":\"320800\",\"value\":\"淮安市\",\"label\":\"淮安市\"},{\"code\":\"320900\",\"value\":\"盐城市\",\"label\":\"盐城市\"},{\"code\":\"321000\",\"value\":\"扬州市\",\"label\":\"扬州市\"},{\"code\":\"321100\",\"value\":\"镇江市\",\"label\":\"镇江市\"},{\"code\":\"321200\",\"value\":\"泰州市\",\"label\":\"泰州市\"},{\"code\":\"321300\",\"value\":\"宿迁市\",\"label\":\"宿迁市\"}]},{\"code\":\"330000\",\"value\":\"浙江省\",\"label\":\"浙江省\",\"children\":[{\"code\":\"330100\",\"value\":\"杭州市\",\"label\":\"杭州市\"},{\"code\":\"330200\",\"value\":\"宁波市\",\"label\":\"宁波市\"},{\"code\":\"330300\",\"value\":\"温州市\",\"label\":\"温州市\"},{\"code\":\"330400\",\"value\":\"嘉兴市\",\"label\":\"嘉兴市\"},{\"code\":\"330500\",\"value\":\"湖州市\",\"label\":\"湖州市\"},{\"code\":\"330600\",\"value\":\"绍兴市\",\"label\":\"绍兴市\"},{\"code\":\"330700\",\"value\":\"金华市\",\"label\":\"金华市\"},{\"code\":\"330800\",\"value\":\"衢州市\",\"label\":\"衢州市\"},{\"code\":\"330900\",\"value\":\"舟山市\",\"label\":\"舟山市\"},{\"code\":\"331000\",\"value\":\"台州市\",\"label\":\"台州市\"},{\"code\":\"331100\",\"value\":\"丽水市\",\"label\":\"丽水市\"}]},{\"code\":\"340000\",\"value\":\"安徽省\",\"label\":\"安徽省\",\"children\":[{\"code\":\"340100\",\"value\":\"合肥市\",\"label\":\"合肥市\"},{\"code\":\"340200\",\"value\":\"芜湖市\",\"label\":\"芜湖市\"},{\"code\":\"340300\",\"value\":\"蚌埠市\",\"label\":\"蚌埠市\"},{\"code\":\"340400\",\"value\":\"淮南市\",\"label\":\"淮南市\"},{\"code\":\"340500\",\"value\":\"马鞍山市\",\"label\":\"马鞍山市\"},{\"code\":\"340600\",\"value\":\"淮北市\",\"label\":\"淮北市\"},{\"code\":\"340700\",\"value\":\"铜陵市\",\"label\":\"铜陵市\"},{\"code\":\"340800\",\"value\":\"安庆市\",\"label\":\"安庆市\"},{\"code\":\"341000\",\"value\":\"黄山市\",\"label\":\"黄山市\"},{\"code\":\"341100\",\"value\":\"滁州市\",\"label\":\"滁州市\"},{\"code\":\"341200\",\"value\":\"阜阳市\",\"label\":\"阜阳市\"},{\"code\":\"341300\",\"value\":\"宿州市\",\"label\":\"宿州市\"},{\"code\":\"341500\",\"value\":\"六安市\",\"label\":\"六安市\"},{\"code\":\"341600\",\"value\":\"亳州市\",\"label\":\"亳州市\"},{\"code\":\"341700\",\"value\":\"池州市\",\"label\":\"池州市\"},{\"code\":\"341800\",\"value\":\"宣城市\",\"label\":\"宣城市\"}]},{\"code\":\"350000\",\"value\":\"福建省\",\"label\":\"福建省\",\"children\":[{\"code\":\"350100\",\"value\":\"福州市\",\"label\":\"福州市\"},{\"code\":\"350200\",\"value\":\"厦门市\",\"label\":\"厦门市\"},{\"code\":\"350300\",\"value\":\"莆田市\",\"label\":\"莆田市\"},{\"code\":\"350400\",\"value\":\"三明市\",\"label\":\"三明市\"},{\"code\":\"350500\",\"value\":\"泉州市\",\"label\":\"泉州市\"},{\"code\":\"350600\",\"value\":\"漳州市\",\"label\":\"漳州市\"},{\"code\":\"350700\",\"value\":\"南平市\",\"label\":\"南平市\"},{\"code\":\"350800\",\"value\":\"龙岩市\",\"label\":\"龙岩市\"},{\"code\":\"350900\",\"value\":\"宁德市\",\"label\":\"宁德市\"}]},{\"code\":\"360000\",\"value\":\"江西省\",\"label\":\"江西省\",\"children\":[{\"code\":\"360100\",\"value\":\"南昌市\",\"label\":\"南昌市\"},{\"code\":\"360200\",\"value\":\"景德镇市\",\"label\":\"景德镇市\"},{\"code\":\"360300\",\"value\":\"萍乡市\",\"label\":\"萍乡市\"},{\"code\":\"360400\",\"value\":\"九江市\",\"label\":\"九江市\"},{\"code\":\"360500\",\"value\":\"新余市\",\"label\":\"新余市\"},{\"code\":\"360600\",\"value\":\"鹰潭市\",\"label\":\"鹰潭市\"},{\"code\":\"360700\",\"value\":\"赣州市\",\"label\":\"赣州市\"},{\"code\":\"360800\",\"value\":\"吉安市\",\"label\":\"吉安市\"},{\"code\":\"360900\",\"value\":\"宜春市\",\"label\":\"宜春市\"},{\"code\":\"361000\",\"value\":\"抚州市\",\"label\":\"抚州市\"},{\"code\":\"361100\",\"value\":\"上饶市\",\"label\":\"上饶市\"}]},{\"code\":\"370000\",\"value\":\"山东省\",\"label\":\"山东省\",\"children\":[{\"code\":\"370100\",\"value\":\"济南市\",\"label\":\"济南市\"},{\"code\":\"370200\",\"value\":\"青岛市\",\"label\":\"青岛市\"},{\"code\":\"370300\",\"value\":\"淄博市\",\"label\":\"淄博市\"},{\"code\":\"370400\",\"value\":\"枣庄市\",\"label\":\"枣庄市\"},{\"code\":\"370500\",\"value\":\"东营市\",\"label\":\"东营市\"},{\"code\":\"370600\",\"value\":\"烟台市\",\"label\":\"烟台市\"},{\"code\":\"370700\",\"value\":\"潍坊市\",\"label\":\"潍坊市\"},{\"code\":\"370800\",\"value\":\"济宁市\",\"label\":\"济宁市\"},{\"code\":\"370900\",\"value\":\"泰安市\",\"label\":\"泰安市\"},{\"code\":\"371000\",\"value\":\"威海市\",\"label\":\"威海市\"},{\"code\":\"371100\",\"value\":\"日照市\",\"label\":\"日照市\"},{\"code\":\"371300\",\"value\":\"临沂市\",\"label\":\"临沂市\"},{\"code\":\"371400\",\"value\":\"德州市\",\"label\":\"德州市\"},{\"code\":\"371500\",\"value\":\"聊城市\",\"label\":\"聊城市\"},{\"code\":\"371600\",\"value\":\"滨州市\",\"label\":\"滨州市\"},{\"code\":\"371700\",\"value\":\"菏泽市\",\"label\":\"菏泽市\"}]},{\"code\":\"410000\",\"value\":\"河南省\",\"label\":\"河南省\",\"children\":[{\"code\":\"410100\",\"value\":\"郑州市\",\"label\":\"郑州市\"},{\"code\":\"410200\",\"value\":\"开封市\",\"label\":\"开封市\"},{\"code\":\"410300\",\"value\":\"洛阳市\",\"label\":\"洛阳市\"},{\"code\":\"410400\",\"value\":\"平顶山市\",\"label\":\"平顶山市\"},{\"code\":\"410500\",\"value\":\"安阳市\",\"label\":\"安阳市\"},{\"code\":\"410600\",\"value\":\"鹤壁市\",\"label\":\"鹤壁市\"},{\"code\":\"410700\",\"value\":\"新乡市\",\"label\":\"新乡市\"},{\"code\":\"410800\",\"value\":\"焦作市\",\"label\":\"焦作市\"},{\"code\":\"410900\",\"value\":\"濮阳市\",\"label\":\"濮阳市\"},{\"code\":\"411000\",\"value\":\"许昌市\",\"label\":\"许昌市\"},{\"code\":\"411100\",\"value\":\"漯河市\",\"label\":\"漯河市\"},{\"code\":\"411200\",\"value\":\"三门峡市\",\"label\":\"三门峡市\"},{\"code\":\"411300\",\"value\":\"南阳市\",\"label\":\"南阳市\"},{\"code\":\"411400\",\"value\":\"商丘市\",\"label\":\"商丘市\"},{\"code\":\"411500\",\"value\":\"信阳市\",\"label\":\"信阳市\"},{\"code\":\"411600\",\"value\":\"周口市\",\"label\":\"周口市\"},{\"code\":\"411700\",\"value\":\"驻马店市\",\"label\":\"驻马店市\"}]},{\"code\":\"420000\",\"value\":\"湖北省\",\"label\":\"湖北省\",\"children\":[{\"code\":\"420100\",\"value\":\"武汉市\",\"label\":\"武汉市\"},{\"code\":\"420200\",\"value\":\"黄石市\",\"label\":\"黄石市\"},{\"code\":\"420300\",\"value\":\"十堰市\",\"label\":\"十堰市\"},{\"code\":\"420500\",\"value\":\"宜昌市\",\"label\":\"宜昌市\"},{\"code\":\"420600\",\"value\":\"襄阳市\",\"label\":\"襄阳市\"},{\"code\":\"420700\",\"value\":\"鄂州市\",\"label\":\"鄂州市\"},{\"code\":\"420800\",\"value\":\"荆门市\",\"label\":\"荆门市\"},{\"code\":\"420900\",\"value\":\"孝感市\",\"label\":\"孝感市\"},{\"code\":\"421000\",\"value\":\"荆州市\",\"label\":\"荆州市\"},{\"code\":\"421100\",\"value\":\"黄冈市\",\"label\":\"黄冈市\"},{\"code\":\"421200\",\"value\":\"咸宁市\",\"label\":\"咸宁市\"},{\"code\":\"421300\",\"value\":\"随州市\",\"label\":\"随州市\"},{\"code\":\"422800\",\"value\":\"恩施土家族苗族自治州\",\"label\":\"恩施土家族苗族自治州\"}]},{\"code\":\"430000\",\"value\":\"湖南省\",\"label\":\"湖南省\",\"children\":[{\"code\":\"430100\",\"value\":\"长沙市\",\"label\":\"长沙市\"},{\"code\":\"430200\",\"value\":\"株洲市\",\"label\":\"株洲市\"},{\"code\":\"430300\",\"value\":\"湘潭市\",\"label\":\"湘潭市\"},{\"code\":\"430400\",\"value\":\"衡阳市\",\"label\":\"衡阳市\"},{\"code\":\"430500\",\"value\":\"邵阳市\",\"label\":\"邵阳市\"},{\"code\":\"430600\",\"value\":\"岳阳市\",\"label\":\"岳阳市\"},{\"code\":\"430700\",\"value\":\"常德市\",\"label\":\"常德市\"},{\"code\":\"430800\",\"value\":\"张家界市\",\"label\":\"张家界市\"},{\"code\":\"430900\",\"value\":\"益阳市\",\"label\":\"益阳市\"},{\"code\":\"431000\",\"value\":\"郴州市\",\"label\":\"郴州市\"},{\"code\":\"431100\",\"value\":\"永州市\",\"label\":\"永州市\"},{\"code\":\"431200\",\"value\":\"怀化市\",\"label\":\"怀化市\"},{\"code\":\"431300\",\"value\":\"娄底市\",\"label\":\"娄底市\"},{\"code\":\"433100\",\"value\":\"湘西土家族苗族自治州\",\"label\":\"湘西土家族苗族自治州\"}]},{\"code\":\"440000\",\"value\":\"广东省\",\"label\":\"广东省\",\"children\":[{\"code\":\"440100\",\"value\":\"广州市\",\"label\":\"广州市\"},{\"code\":\"440200\",\"value\":\"韶关市\",\"label\":\"韶关市\"},{\"code\":\"440300\",\"value\":\"深圳市\",\"label\":\"深圳市\"},{\"code\":\"440400\",\"value\":\"珠海市\",\"label\":\"珠海市\"},{\"code\":\"440500\",\"value\":\"汕头市\",\"label\":\"汕头市\"},{\"code\":\"440600\",\"value\":\"佛山市\",\"label\":\"佛山市\"},{\"code\":\"440700\",\"value\":\"江门市\",\"label\":\"江门市\"},{\"code\":\"440800\",\"value\":\"湛江市\",\"label\":\"湛江市\"},{\"code\":\"440900\",\"value\":\"茂名市\",\"label\":\"茂名市\"},{\"code\":\"441200\",\"value\":\"肇庆市\",\"label\":\"肇庆市\"},{\"code\":\"441300\",\"value\":\"惠州市\",\"label\":\"惠州市\"},{\"code\":\"441400\",\"value\":\"梅州市\",\"label\":\"梅州市\"},{\"code\":\"441500\",\"value\":\"汕尾市\",\"label\":\"汕尾市\"},{\"code\":\"441600\",\"value\":\"河源市\",\"label\":\"河源市\"},{\"code\":\"441700\",\"value\":\"阳江市\",\"label\":\"阳江市\"},{\"code\":\"441800\",\"value\":\"清远市\",\"label\":\"清远市\"},{\"code\":\"441900\",\"value\":\"东莞市\",\"label\":\"东莞市\"},{\"code\":\"442000\",\"value\":\"中山市\",\"label\":\"中山市\"},{\"code\":\"445100\",\"value\":\"潮州市\",\"label\":\"潮州市\"},{\"code\":\"445200\",\"value\":\"揭阳市\",\"label\":\"揭阳市\"},{\"code\":\"445300\",\"value\":\"云浮市\",\"label\":\"云浮市\"}]},{\"code\":\"450000\",\"value\":\"广西壮族自治区\",\"label\":\"广西壮族自治区\",\"children\":[{\"code\":\"450100\",\"value\":\"南宁市\",\"label\":\"南宁市\"},{\"code\":\"450200\",\"value\":\"柳州市\",\"label\":\"柳州市\"},{\"code\":\"450300\",\"value\":\"桂林市\",\"label\":\"桂林市\"},{\"code\":\"450400\",\"value\":\"梧州市\",\"label\":\"梧州市\"},{\"code\":\"450500\",\"value\":\"北海市\",\"label\":\"北海市\"},{\"code\":\"450600\",\"value\":\"防城港市\",\"label\":\"防城港市\"},{\"code\":\"450700\",\"value\":\"钦州市\",\"label\":\"钦州市\"},{\"code\":\"450800\",\"value\":\"贵港市\",\"label\":\"贵港市\"},{\"code\":\"450900\",\"value\":\"玉林市\",\"label\":\"玉林市\"},{\"code\":\"451000\",\"value\":\"百色市\",\"label\":\"百色市\"},{\"code\":\"451100\",\"value\":\"贺州市\",\"label\":\"贺州市\"},{\"code\":\"451200\",\"value\":\"河池市\",\"label\":\"河池市\"},{\"code\":\"451300\",\"value\":\"来宾市\",\"label\":\"来宾市\"},{\"code\":\"451400\",\"value\":\"崇左市\",\"label\":\"崇左市\"}]},{\"code\":\"460000\",\"value\":\"海南省\",\"label\":\"海南省\",\"children\":[{\"code\":\"460100\",\"value\":\"海口市\",\"label\":\"海口市\"},{\"code\":\"460200\",\"value\":\"三亚市\",\"label\":\"三亚市\"},{\"code\":\"460300\",\"value\":\"三沙市\",\"label\":\"三沙市\"},{\"code\":\"460400\",\"value\":\"儋州市\",\"label\":\"儋州市\"}]},{\"code\":\"500000\",\"value\":\"重庆市\",\"label\":\"重庆市\",\"children\":[{\"code\":\"500101\",\"value\":\"万州区\",\"label\":\"万州区\"},{\"code\":\"500102\",\"value\":\"涪陵区\",\"label\":\"涪陵区\"},{\"code\":\"500103\",\"value\":\"渝中区\",\"label\":\"渝中区\"},{\"code\":\"500104\",\"value\":\"大渡口区\",\"label\":\"大渡口区\"},{\"code\":\"500105\",\"value\":\"江北区\",\"label\":\"江北区\"},{\"code\":\"500106\",\"value\":\"沙坪坝区\",\"label\":\"沙坪坝区\"},{\"code\":\"500107\",\"value\":\"九龙坡区\",\"label\":\"九龙坡区\"},{\"code\":\"500108\",\"value\":\"南岸区\",\"label\":\"南岸区\"},{\"code\":\"500109\",\"value\":\"北碚区\",\"label\":\"北碚区\"},{\"code\":\"500110\",\"value\":\"綦江区\",\"label\":\"綦江区\"},{\"code\":\"500111\",\"value\":\"大足区\",\"label\":\"大足区\"},{\"code\":\"500112\",\"value\":\"渝北区\",\"label\":\"渝北区\"},{\"code\":\"500113\",\"value\":\"巴南区\",\"label\":\"巴南区\"},{\"code\":\"500114\",\"value\":\"黔江区\",\"label\":\"黔江区\"},{\"code\":\"500115\",\"value\":\"长寿区\",\"label\":\"长寿区\"},{\"code\":\"500116\",\"value\":\"江津区\",\"label\":\"江津区\"},{\"code\":\"500117\",\"value\":\"合川区\",\"label\":\"合川区\"},{\"code\":\"500118\",\"value\":\"永川区\",\"label\":\"永川区\"},{\"code\":\"500119\",\"value\":\"南川区\",\"label\":\"南川区\"},{\"code\":\"500120\",\"value\":\"璧山区\",\"label\":\"璧山区\"},{\"code\":\"500151\",\"value\":\"铜梁区\",\"label\":\"铜梁区\"},{\"code\":\"500152\",\"value\":\"潼南区\",\"label\":\"潼南区\"},{\"code\":\"500153\",\"value\":\"荣昌区\",\"label\":\"荣昌区\"},{\"code\":\"500154\",\"value\":\"开州区\",\"label\":\"开州区\"},{\"code\":\"500155\",\"value\":\"梁平区\",\"label\":\"梁平区\"},{\"code\":\"500156\",\"value\":\"武隆区\",\"label\":\"武隆区\"},{\"code\":\"500229\",\"value\":\"城口县\",\"label\":\"城口县\"},{\"code\":\"500230\",\"value\":\"丰都县\",\"label\":\"丰都县\"},{\"code\":\"500231\",\"value\":\"垫江县\",\"label\":\"垫江县\"},{\"code\":\"500233\",\"value\":\"忠县\",\"label\":\"忠县\"},{\"code\":\"500235\",\"value\":\"云阳县\",\"label\":\"云阳县\"},{\"code\":\"500236\",\"value\":\"奉节县\",\"label\":\"奉节县\"},{\"code\":\"500237\",\"value\":\"巫山县\",\"label\":\"巫山县\"},{\"code\":\"500238\",\"value\":\"巫溪县\",\"label\":\"巫溪县\"},{\"code\":\"500240\",\"value\":\"石柱土家族自治县\",\"label\":\"石柱土家族自治县\"},{\"code\":\"500241\",\"value\":\"秀山土家族苗族自治县\",\"label\":\"秀山土家族苗族自治县\"},{\"code\":\"500242\",\"value\":\"酉阳土家族苗族自治县\",\"label\":\"酉阳土家族苗族自治县\"},{\"code\":\"500243\",\"value\":\"彭水苗族土家族自治县\",\"label\":\"彭水苗族土家族自治县\"}]},{\"code\":\"510000\",\"value\":\"四川省\",\"label\":\"四川省\",\"children\":[{\"code\":\"510100\",\"value\":\"成都市\",\"label\":\"成都市\"},{\"code\":\"510300\",\"value\":\"自贡市\",\"label\":\"自贡市\"},{\"code\":\"510400\",\"value\":\"攀枝花市\",\"label\":\"攀枝花市\"},{\"code\":\"510500\",\"value\":\"泸州市\",\"label\":\"泸州市\"},{\"code\":\"510600\",\"value\":\"德阳市\",\"label\":\"德阳市\"},{\"code\":\"510700\",\"value\":\"绵阳市\",\"label\":\"绵阳市\"},{\"code\":\"510800\",\"value\":\"广元市\",\"label\":\"广元市\"},{\"code\":\"510900\",\"value\":\"遂宁市\",\"label\":\"遂宁市\"},{\"code\":\"511000\",\"value\":\"内江市\",\"label\":\"内江市\"},{\"code\":\"511100\",\"value\":\"乐山市\",\"label\":\"乐山市\"},{\"code\":\"511300\",\"value\":\"南充市\",\"label\":\"南充市\"},{\"code\":\"511400\",\"value\":\"眉山市\",\"label\":\"眉山市\"},{\"code\":\"511500\",\"value\":\"宜宾市\",\"label\":\"宜宾市\"},{\"code\":\"511600\",\"value\":\"广安市\",\"label\":\"广安市\"},{\"code\":\"511700\",\"value\":\"达州市\",\"label\":\"达州市\"},{\"code\":\"511800\",\"value\":\"雅安市\",\"label\":\"雅安市\"},{\"code\":\"511900\",\"value\":\"巴中市\",\"label\":\"巴中市\"},{\"code\":\"512000\",\"value\":\"资阳市\",\"label\":\"资阳市\"},{\"code\":\"513200\",\"value\":\"阿坝藏族羌族自治州\",\"label\":\"阿坝藏族羌族自治州\"},{\"code\":\"513300\",\"value\":\"甘孜藏族自治州\",\"label\":\"甘孜藏族自治州\"},{\"code\":\"513400\",\"value\":\"凉山彝族自治州\",\"label\":\"凉山彝族自治州\"}]},{\"code\":\"520000\",\"value\":\"贵州省\",\"label\":\"贵州省\",\"children\":[{\"code\":\"520100\",\"value\":\"贵阳市\",\"label\":\"贵阳市\"},{\"code\":\"520200\",\"value\":\"六盘水市\",\"label\":\"六盘水市\"},{\"code\":\"520300\",\"value\":\"遵义市\",\"label\":\"遵义市\"},{\"code\":\"520400\",\"value\":\"安顺市\",\"label\":\"安顺市\"},{\"code\":\"520500\",\"value\":\"毕节市\",\"label\":\"毕节市\"},{\"code\":\"520600\",\"value\":\"铜仁市\",\"label\":\"铜仁市\"},{\"code\":\"522300\",\"value\":\"黔西南布依族苗族自治州\",\"label\":\"黔西南布依族苗族自治州\"},{\"code\":\"522600\",\"value\":\"黔东南苗族侗族自治州\",\"label\":\"黔东南苗族侗族自治州\"},{\"code\":\"522700\",\"value\":\"黔南布依族苗族自治州\",\"label\":\"黔南布依族苗族自治州\"}]},{\"code\":\"530000\",\"value\":\"云南省\",\"label\":\"云南省\",\"children\":[{\"code\":\"530100\",\"value\":\"昆明市\",\"label\":\"昆明市\"},{\"code\":\"530300\",\"value\":\"曲靖市\",\"label\":\"曲靖市\"},{\"code\":\"530400\",\"value\":\"玉溪市\",\"label\":\"玉溪市\"},{\"code\":\"530500\",\"value\":\"保山市\",\"label\":\"保山市\"},{\"code\":\"530600\",\"value\":\"昭通市\",\"label\":\"昭通市\"},{\"code\":\"530700\",\"value\":\"丽江市\",\"label\":\"丽江市\"},{\"code\":\"530800\",\"value\":\"普洱市\",\"label\":\"普洱市\"},{\"code\":\"530900\",\"value\":\"临沧市\",\"label\":\"临沧市\"},{\"code\":\"532300\",\"value\":\"楚雄彝族自治州\",\"label\":\"楚雄彝族自治州\"},{\"code\":\"532500\",\"value\":\"红河哈尼族彝族自治州\",\"label\":\"红河哈尼族彝族自治州\"},{\"code\":\"532600\",\"value\":\"文山壮族苗族自治州\",\"label\":\"文山壮族苗族自治州\"},{\"code\":\"532800\",\"value\":\"西双版纳傣族自治州\",\"label\":\"西双版纳傣族自治州\"},{\"code\":\"532900\",\"value\":\"大理白族自治州\",\"label\":\"大理白族自治州\"},{\"code\":\"533100\",\"value\":\"德宏傣族景颇族自治州\",\"label\":\"德宏傣族景颇族自治州\"},{\"code\":\"533300\",\"value\":\"怒江傈僳族自治州\",\"label\":\"怒江傈僳族自治州\"},{\"code\":\"533400\",\"value\":\"迪庆藏族自治州\",\"label\":\"迪庆藏族自治州\"}]},{\"code\":\"540000\",\"value\":\"西藏自治区\",\"label\":\"西藏自治区\",\"children\":[{\"code\":\"540100\",\"value\":\"拉萨市\",\"label\":\"拉萨市\"},{\"code\":\"540200\",\"value\":\"日喀则市\",\"label\":\"日喀则市\"},{\"code\":\"540300\",\"value\":\"昌都市\",\"label\":\"昌都市\"},{\"code\":\"540400\",\"value\":\"林芝市\",\"label\":\"林芝市\"},{\"code\":\"540500\",\"value\":\"山南市\",\"label\":\"山南市\"},{\"code\":\"540600\",\"value\":\"那曲市\",\"label\":\"那曲市\"},{\"code\":\"542500\",\"value\":\"阿里地区\",\"label\":\"阿里地区\"}]},{\"code\":\"610000\",\"value\":\"陕西省\",\"label\":\"陕西省\",\"children\":[{\"code\":\"610100\",\"value\":\"西安市\",\"label\":\"西安市\"},{\"code\":\"610200\",\"value\":\"铜川市\",\"label\":\"铜川市\"},{\"code\":\"610300\",\"value\":\"宝鸡市\",\"label\":\"宝鸡市\"},{\"code\":\"610400\",\"value\":\"咸阳市\",\"label\":\"咸阳市\"},{\"code\":\"610500\",\"value\":\"渭南市\",\"label\":\"渭南市\"},{\"code\":\"610600\",\"value\":\"延安市\",\"label\":\"延安市\"},{\"code\":\"610700\",\"value\":\"汉中市\",\"label\":\"汉中市\"},{\"code\":\"610800\",\"value\":\"榆林市\",\"label\":\"榆林市\"},{\"code\":\"610900\",\"value\":\"安康市\",\"label\":\"安康市\"},{\"code\":\"611000\",\"value\":\"商洛市\",\"label\":\"商洛市\"}]},{\"code\":\"620000\",\"value\":\"甘肃省\",\"label\":\"甘肃省\",\"children\":[{\"code\":\"620100\",\"value\":\"兰州市\",\"label\":\"兰州市\"},{\"code\":\"620200\",\"value\":\"嘉峪关市\",\"label\":\"嘉峪关市\"},{\"code\":\"620300\",\"value\":\"金昌市\",\"label\":\"金昌市\"},{\"code\":\"620400\",\"value\":\"白银市\",\"label\":\"白银市\"},{\"code\":\"620500\",\"value\":\"天水市\",\"label\":\"天水市\"},{\"code\":\"620600\",\"value\":\"武威市\",\"label\":\"武威市\"},{\"code\":\"620700\",\"value\":\"张掖市\",\"label\":\"张掖市\"},{\"code\":\"620800\",\"value\":\"平凉市\",\"label\":\"平凉市\"},{\"code\":\"620900\",\"value\":\"酒泉市\",\"label\":\"酒泉市\"},{\"code\":\"621000\",\"value\":\"庆阳市\",\"label\":\"庆阳市\"},{\"code\":\"621100\",\"value\":\"定西市\",\"label\":\"定西市\"},{\"code\":\"621200\",\"value\":\"陇南市\",\"label\":\"陇南市\"},{\"code\":\"622900\",\"value\":\"临夏回族自治州\",\"label\":\"临夏回族自治州\"},{\"code\":\"623000\",\"value\":\"甘南藏族自治州\",\"label\":\"甘南藏族自治州\"}]},{\"code\":\"630000\",\"value\":\"青海省\",\"label\":\"青海省\",\"children\":[{\"code\":\"630100\",\"value\":\"西宁市\",\"label\":\"西宁市\"},{\"code\":\"630200\",\"value\":\"海东市\",\"label\":\"海东市\"},{\"code\":\"632200\",\"value\":\"海北藏族自治州\",\"label\":\"海北藏族自治州\"},{\"code\":\"632300\",\"value\":\"黄南藏族自治州\",\"label\":\"黄南藏族自治州\"},{\"code\":\"632500\",\"value\":\"海南藏族自治州\",\"label\":\"海南藏族自治州\"},{\"code\":\"632600\",\"value\":\"果洛藏族自治州\",\"label\":\"果洛藏族自治州\"},{\"code\":\"632700\",\"value\":\"玉树藏族自治州\",\"label\":\"玉树藏族自治州\"},{\"code\":\"632800\",\"value\":\"海西蒙古族藏族自治州\",\"label\":\"海西蒙古族藏族自治州\"}]},{\"code\":\"640000\",\"value\":\"宁夏回族自治区\",\"label\":\"宁夏回族自治区\",\"children\":[{\"code\":\"640100\",\"value\":\"银川市\",\"label\":\"银川市\"},{\"code\":\"640200\",\"value\":\"石嘴山市\",\"label\":\"石嘴山市\"},{\"code\":\"640300\",\"value\":\"吴忠市\",\"label\":\"吴忠市\"},{\"code\":\"640400\",\"value\":\"固原市\",\"label\":\"固原市\"},{\"code\":\"640500\",\"value\":\"中卫市\",\"label\":\"中卫市\"}]},{\"code\":\"650000\",\"value\":\"新疆维吾尔自治区\",\"label\":\"新疆维吾尔自治区\",\"children\":[{\"code\":\"650100\",\"value\":\"乌鲁木齐市\",\"label\":\"乌鲁木齐市\"},{\"code\":\"650200\",\"value\":\"克拉玛依市\",\"label\":\"克拉玛依市\"},{\"code\":\"650400\",\"value\":\"吐鲁番市\",\"label\":\"吐鲁番市\"},{\"code\":\"650500\",\"value\":\"哈密市\",\"label\":\"哈密市\"},{\"code\":\"652300\",\"value\":\"昌吉回族自治州\",\"label\":\"昌吉回族自治州\"},{\"code\":\"652700\",\"value\":\"博尔塔拉蒙古自治州\",\"label\":\"博尔塔拉蒙古自治州\"},{\"code\":\"652800\",\"value\":\"巴音郭楞蒙古自治州\",\"label\":\"巴音郭楞蒙古自治州\"},{\"code\":\"652900\",\"value\":\"阿克苏地区\",\"label\":\"阿克苏地区\"},{\"code\":\"653000\",\"value\":\"克孜勒苏柯尔克孜自治州\",\"label\":\"克孜勒苏柯尔克孜自治州\"},{\"code\":\"653100\",\"value\":\"喀什地区\",\"label\":\"喀什地区\"},{\"code\":\"653200\",\"value\":\"和田地区\",\"label\":\"和田地区\"},{\"code\":\"654000\",\"value\":\"伊犁哈萨克自治州\",\"label\":\"伊犁哈萨克自治州\"},{\"code\":\"654200\",\"value\":\"塔城地区\",\"label\":\"塔城地区\"},{\"code\":\"654300\",\"value\":\"阿勒泰地区\",\"label\":\"阿勒泰地区\"}]},{\"code\":\"710000\",\"value\":\"台湾省\",\"label\":\"台湾省\",\"children\":[]},{\"code\":\"810000\",\"value\":\"香港特别行政区\",\"label\":\"香港特别行政区\",\"children\":[]},{\"code\":\"820000\",\"value\":\"澳门特别行政区\",\"label\":\"澳门特别行政区\",\"children\":[]}]";


    /**
     * 公司花名册人员身份证和人脸校验定时任务
     *
     * @param request 请求
     */
    @Override
    @Transactional(propagation = Propagation.NOT_SUPPORTED)
    public void checkTask(HttpServletRequest request) {
        logger.info("定时任务，身份证和人脸校验，start！");

        // 查询待检测的公司花名册人员
        LambdaQueryWrapper<WorkerEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(WorkerEntity::getIdCardFrontPhotoFlag, 0)
                .or().eq(WorkerEntity::getIdCardBackPhotoFlag, 0)
                .or().eq(WorkerEntity::getFacePhotoFlag, 0);
        List<WorkerEntity> workerEntityList = workerMapper.selectList(lambdaQuery);

        // 校验身份证和人脸
        if (CollectionUtils.isNotEmpty(workerEntityList)) {
            for (WorkerEntity entity : workerEntityList) {
                // 1.校验身份证人像面
                if (entity.getIdCardFrontPhotoFlag() == 0) {
                    // 获取身份证人像面图片地址
                    CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "idCardFront", null);
                    if (!response.isSuccess() || CollectionUtils.isEmpty(response.getData())) {
                        logger.info("获取身份证人像面图片地址，入参：sourceId-{}，billType-{}", entity.getId(), BILL_TYPE);
                    } else {
                        List<AttachmentVO> faceAttachmentVOList = response.getData();
                        AttachmentVO faceAttachmentVO = faceAttachmentVOList.get(0);
                        String imgUrl = fileUrl + faceAttachmentVO.getFilePath();

                        try {
                            IdentityCardInfoVO identityCardInfoVO = idCardService.checkAndRecognizeIdentityCardInfo(imgUrl, "face");
                            if (identityCardInfoVO != null) {
                                entity.setIdCardFrontPhotoFlag(1);
                                entity.setIdCardName(identityCardInfoVO.getName());
                                entity.setIdCardNo(identityCardInfoVO.getIdNumber());
                                entity.setIdCardSex(identityCardInfoVO.getGender());
                                entity.setIdCardBirthDate(identityCardInfoVO.getBirthDate());
                                entity.setIdCardNation(identityCardInfoVO.getNationality());
                            }
                        } catch (Exception e) {
                            logger.info("定时任务，校验身份证人像面失败，失败原因：{}", e.getMessage());
                            entity.setIdCardFrontPhotoFlag(3);
                            entity.setIdCardFrontPhotoExceptional(e.getMessage());
                        }
                    }
                }

                // 2.校验身份证国徽面
                if (entity.getIdCardBackPhotoFlag() == 0) {
                    // 获取身份证国徽面图片地址
                    CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "idCardBack", null);
                    if (!response.isSuccess() || CollectionUtils.isEmpty(response.getData())) {
                        logger.info("获取身份证国徽面图片地址，入参：sourceId-{}，billType-{}", entity.getId(), BILL_TYPE);
                    } else {
                        List<AttachmentVO> faceAttachmentVOList = response.getData();
                        AttachmentVO faceAttachmentVO = faceAttachmentVOList.get(0);
                        String imgUrl = fileUrl + faceAttachmentVO.getFilePath();

                        try {
                            IdentityCardInfoVO identityCardInfoVO = idCardService.checkAndRecognizeIdentityCardInfo(imgUrl, "back");
                            if (identityCardInfoVO != null) {
                                entity.setIdCardBackPhotoFlag(1);
                                entity.setIdCardStartDate(identityCardInfoVO.getStartDate());
                                entity.setIdCardEndDate(identityCardInfoVO.getEndDate());
                                entity.setIdCardIssue(identityCardInfoVO.getIssue());
                            }
                        } catch (Exception e) {
                            logger.info("定时任务，校验身份证国徽面失败，失败原因：{}", e.getMessage());
                            entity.setIdCardBackPhotoFlag(3);
                            entity.setIdCardBackPhotoExceptional(e.getMessage());
                        }
                    }
                }

                // 3.校验人脸
                if (entity.getFacePhotoFlag() == 0) {
                    // 获取人脸图片地址
                    CommonResponse<List<AttachmentVO>> response = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "face", null);
                    if (!response.isSuccess() || CollectionUtils.isEmpty(response.getData())) {
                        logger.info("获取人脸图片地址，入参：sourceId-{}，billType-{}", entity.getId(), BILL_TYPE);
                    } else {
                        List<AttachmentVO> faceAttachmentVOList = response.getData();
                        AttachmentVO faceAttachmentVO = faceAttachmentVOList.get(0);

                        FaceInfoVO faceInfoVO = new FaceInfoVO();
                        faceInfoVO.setImgUrl(fileUrl + faceAttachmentVO.getFilePath());

                        try {
                            Boolean faceQualityAndLive = faceService.checkFaceQualityAndLive(faceInfoVO.getImgUrl());
                            if (Boolean.TRUE.equals(faceQualityAndLive)) {
                                entity.setFacePhotoFlag(1);
                                // 人脸注册
                                FaceInfoVO infoVO = new FaceInfoVO();
                                infoVO.setUserId(entity.getId());
                                infoVO.setUserName(entity.getName());
                                infoVO.setIdNumber(entity.getIdCard());
                                infoVO.setImgUrl(fileUrl + faceAttachmentVO.getFilePath());
                                faceService.faceRegistration(infoVO, false);
                            }
                        } catch (Exception e) {
                            logger.info("定时任务，人脸活体校验失败，失败原因：{}", e.getMessage());
                            entity.setFacePhotoFlag(3);
                            entity.setFacePhotoExceptional(e.getMessage());
                        }
                    }
                }
            }
            super.updateBatchById(workerEntityList, 100);
        }

        logger.info("定时任务，身份证和人脸校验，end！");
    }

    @Override
    public WorkerVO insertOrUpdate(WorkerVO saveOrUpdateVO) {
        WorkerEntity entity = BeanMapper.map(saveOrUpdateVO, WorkerEntity.class);
        //保存前获取老的中间表班组数据
        List<WorkerRegisterEntity> oldList = new ArrayList<>();
        Long id = entity.getId();
        if (id == null || id == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            if (entity.getWorkState()==null){
                entity.setWorkState(0);
                entity.setEnabled(1);
            }

        } else {
            LambdaQueryWrapper<WorkerRegisterEntity> oldWrapper = new LambdaQueryWrapper<>();
            oldWrapper.eq(WorkerRegisterEntity::getWorkerId, entity.getId());
            oldList = workerRegisterService.list(oldWrapper);
        }

        super.saveOrUpdate(entity, false);
        //如果没有，则新增关系表数据
        if (CollectionUtils.isEmpty(oldList)) {
            String teamId = entity.getTeamId();
            if (teamId != null) {
                String[] split = teamId.split(",");
                for (String s : split) {
                    OrgTeamEntity teamEntity = orgTeamService.selectById(Long.valueOf(s));
                    WorkerRegisterEntity workerRegisterEntity = new WorkerRegisterEntity();
                    workerRegisterEntity.setId(IdWorker.getId());
                    workerRegisterEntity.setWorkerId(entity.getId());
                    workerRegisterEntity.setTeamId(Long.valueOf(s));
                    workerRegisterEntity.setTeamName(teamEntity.getName());
                    workerRegisterEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    workerRegisterEntity.setCreateTime(new Date());
                    workerRegisterService.save(workerRegisterEntity);
                }
            }
        } else {
            //旧中间表数据
            Map<Long, WorkerRegisterEntity> oldMap = oldList.stream().collect(Collectors.toMap(WorkerRegisterEntity::getTeamId, detailEntity -> detailEntity));
            String teamId = entity.getTeamId();
            if (teamId != null) {
                String[] split = teamId.split(",");
                List<String> newTeamIds = new ArrayList<>(Arrays.asList(split));
                List<Long> delIds = new ArrayList<>();
                //循环旧数据
                for (Map.Entry<Long, WorkerRegisterEntity> oldEntity : oldMap.entrySet()) {
                    int index = newTeamIds.indexOf(String.valueOf(oldEntity.getKey()));
                    //判断旧的是否存在新的,如果存在需要移除
                    if (index > -1) {
                        newTeamIds.remove(index);
                    } else {
                        delIds.add(oldEntity.getValue().getId());
                    }
                }
                if (CollectionUtils.isNotEmpty(newTeamIds)) {
                    //新增
                    for (String newTeamId : newTeamIds) {
                        OrgTeamEntity teamEntity = orgTeamService.selectById(Long.valueOf(newTeamId));
                        WorkerRegisterEntity workerRegisterEntity = new WorkerRegisterEntity();
                        workerRegisterEntity.setId(IdWorker.getId());
                        workerRegisterEntity.setWorkerId(entity.getId());
                        workerRegisterEntity.setTeamId(teamEntity.getId());
                        workerRegisterEntity.setTeamName(teamEntity.getName());
                        workerRegisterEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                        workerRegisterEntity.setCreateTime(new Date());
                        workerRegisterService.save(workerRegisterEntity);
                    }
                }
                if (CollectionUtils.isNotEmpty(delIds)) {
                    // 删除关系表数据
                    workerRegisterService.removeByIds(delIds);
                }
            }

        }
        WorkerVO vo = BeanMapper.map(entity, WorkerVO.class);
        //公司花名册修改后同步修改项目花名册用工记录
        this.updateWorkRecord(vo);
        return vo;
    }

    /**
     * 公司花名册修改后同步修改项目花名册用工记录
     */
    public WorkerVO updateWorkRecord(WorkerVO vo){
        LambdaQueryWrapper<WorkRecordEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(WorkRecordEntity::getWorkerId,vo.getId());
        wrapper.eq(WorkRecordEntity::getLastFlag,1);
        List<WorkRecordEntity> list = workRecordService.list(wrapper);
        //判断是否有项目用工记录
        if(CollectionUtils.isNotEmpty(list)){
            // 公司花名册人员回写数据到 人员进场记录 班组除外
            for (WorkRecordEntity recordEntity : list) {
                if (StringUtils.isNotBlank(vo.getName())){//姓名
                    recordEntity.setName(vo.getName());
                }
                if (StringUtils.isNotBlank(vo.getIdCard())){//身份证号
                    recordEntity.setIdCard(vo.getIdCard());
                }
                if (vo.getPhone()!=null){//手机号
                    recordEntity.setPhone(vo.getPhone());
                }
                if (vo.getSex()!=null){//性别
                    recordEntity.setSex(vo.getSex());
                }
                if (vo.getBirthDate()!=null){//出生年月
                    recordEntity.setBirthDate(vo.getBirthDate());
                }
                if (vo.getNation()!=null){// 民族
                    recordEntity.setNation(vo.getNation());
                }
                if (vo.getWorkType()!=null){// 工种
                    recordEntity.setWorkType(vo.getWorkType());
                }
                if (vo.getWorkTypeName()!=null){// 工种名称
                    recordEntity.setWorkTypeName(vo.getWorkTypeName());
                }
                if (vo.getBankName()!=null){// 开户行
                    recordEntity.setBankName(vo.getBankName());
                }
                if (vo.getBankAccount()!=null){// 银行账号
                    recordEntity.setBankAccount(vo.getBankAccount());
                }
                if (vo.getWagesType()!=null){// 工资类型
                    recordEntity.setWagesType(vo.getWagesType());
                }
                if (vo.getWagesTypeName()!=null){// 工资类型名称
                    recordEntity.setWagesTypeName(vo.getWagesTypeName());
                }
                if (vo.getWage()!=null){// 工价
                    recordEntity.setWage(vo.getWage());
                }
                if (vo.getProvince()!=null){// 省
                    recordEntity.setProvince(vo.getProvince());
                }
                if (vo.getCity()!=null){// 市
                    recordEntity.setCity(vo.getCity());
                }
                if (vo.getArea()!=null){// 省市
                    recordEntity.setArea(vo.getArea());
                }
                if (vo.getAddress()!=null){// 详细地址
                    recordEntity.setAddress(vo.getAddress());
                }
                if (vo.getMemo()!=null){// 备注
                    recordEntity.setMemo(vo.getMemo());
                }
                if(vo.getFacePhotoFlag()!=null){ //人脸采集状态
                    recordEntity.setFacePhotoFlag(vo.getFacePhotoFlag());
                }
                if(StringUtils.isNotBlank(vo.getFacePhotoExceptional())){ //人脸采集异常信息
                    recordEntity.setFacePhotoExceptional(vo.getFacePhotoExceptional());
                }
                if(vo.getIdCardFrontPhotoFlag()!=null){ //身份证正面照片状态
                    recordEntity.setIdCardFrontPhotoFlag(vo.getIdCardFrontPhotoFlag());
                }
                if(StringUtils.isNotBlank(vo.getIdCardFrontPhotoExceptional())){ //身份证正面异常信息
                    recordEntity.setIdCardFrontPhotoExceptional(vo.getIdCardFrontPhotoExceptional());
                }
                if(vo.getIdCardBackPhotoFlag()!=null){ //身份证反面照片状态
                    recordEntity.setIdCardBackPhotoFlag(vo.getIdCardBackPhotoFlag());
                }
                if(StringUtils.isNotBlank(vo.getIdCardBackPhotoExceptional())){ //身份证反面异常信息
                    recordEntity.setIdCardBackPhotoExceptional(vo.getIdCardBackPhotoExceptional());
                }
                workRecordService.saveOrUpdate(recordEntity);
                updateAttachmentCheck(vo,recordEntity);
                //查询公司花名册是否存在附件 公司花名册 往项目花名册用工记录 上加
                CommonResponse<List<AttachmentVO>> recordFileResponse = attachmentApi.queryListBySourceId(
                        vo.getId(),RECORD_FILE_SOURCE_TYPE , RECORD_BILL_TYPE, ORDER_TYPE);
                if (!recordFileResponse.isSuccess()){
                    throw new BusinessException("网络异常 访问文件中心异常");
                }
                //人脸注册
                if (CollectionUtils.isNotEmpty(recordFileResponse.getData())){
                    //写入项目花名册用工记录附件
                    attachmentApi.copyFilesFromSourceBillToTargetBill(
                            Long.toString(recordEntity.getId()),WORKER_BILL_TYPE,WORKER_FILE_SOURCE_TYPE,
                            Long.toString(recordEntity.getWorkerId()),RECORD_BILL_TYPE,RECORD_FILE_SOURCE_TYPE);
                }
            }
        }else{
            //人员正常新增保存后没有用工记录，直接人脸注册
            this.faceRegistration(vo);
        }
        return vo;
    }
    /**
     *  图片校验的回写 项目花名册 往公司花名册 写
     */
    public void updateAttachmentCheck(WorkerVO vo,WorkRecordEntity recordEntity){
        List<String> typeList = new ArrayList();
        typeList.add(IDCARD_SOURCE_TYPE);
        typeList.add(IDBACK_TYPE);
        typeList.add(FACE_TYPE);
        for (String s :typeList){
            //1.公司花名册 是否存在
            CommonResponse<List<AttachmentVO>> idCardResponse = attachmentApi.queryListBySourceId(
                    vo.getId(), WORKER_BILL_TYPE, s, ORDER_TYPE);
            if (!idCardResponse.isSuccess()){
                throw new BusinessException("网络异常 访问文件中心异常");
            }
            //2.存在就修改项目花名册用工记录
            if (CollectionUtils.isNotEmpty(idCardResponse.getData())){
                //3.查询项目花名册用工记录 是否存在
                CommonResponse<List<AttachmentVO>> orgIdCardResponse = attachmentApi.queryListBySourceId(
                        recordEntity.getId(), RECORD_BILL_TYPE, s, ORDER_TYPE);
                if (!orgIdCardResponse.isSuccess()){
                    throw new BusinessException("网络异常 查询文件中心异常");
                }
                if (CollectionUtils.isNotEmpty(orgIdCardResponse.getData())){
                    //4.项目花名册用工记录 存在就删除
                    CommonResponse<String> deleteFileByParam = attachmentApi.deleteFileByParam(
                            recordEntity.getId(), RECORD_BILL_TYPE, s);
                    if (!deleteFileByParam.isSuccess()){
                        throw new BusinessException("网络异常 文件中心删除失败");
                    }
                }
                //5.然后写入公司花名册
                CommonResponse<String> commonResponse = attachmentApi.copyFilesFromSourceBillToTargetBill(
                        Long.toString(vo.getId()), WORKER_BILL_TYPE,s ,
                        Long.toString(recordEntity.getId()), RECORD_BILL_TYPE,s );
                if (!commonResponse.isSuccess()){
                    throw new BusinessException("网络异常 文件中心复制失败");
                }
                if (FACE_TYPE.equals(s)) {
                    // 人脸注册
                    AttachmentVO attachmentVO = idCardResponse.getData().get(0);
                    FaceInfoVO faceInfoVO = new FaceInfoVO();
                    faceInfoVO.setUserId(vo.getId());
                    faceInfoVO.setUserName(vo.getName());
                    faceInfoVO.setIdNumber(vo.getIdCard());
                    faceInfoVO.setImgUrl(fileUrl + attachmentVO.getFilePath());
                    faceService.faceRegistration(faceInfoVO, false);
                }
            }

        }
    }

    @Override
    public WorkerVO updateBatWorker(WorkerVO updateVO) {
        List<Long> ids = updateVO.getIds();//用户ids
        String teamId = updateVO.getTeamId();//所选班组
        String teamName = updateVO.getTeamName();//班组名称
        String workType = updateVO.getWorkType();//所选工种
        String workTypeName = updateVO.getWorkTypeName();//工种名称
        if (CollectionUtils.isNotEmpty(ids)) {
            for (Long id : ids) {
                LambdaQueryWrapper<WorkerEntity> queryWapper = new LambdaQueryWrapper<>();
                queryWapper.eq(WorkerEntity::getDr, 0);
                queryWapper.eq(WorkerEntity::getId, id);
                //批量修改前查询人员
                List<WorkerEntity> oldWorkerList = super.list(queryWapper);
                List<WorkerRegisterEntity> oldList = new ArrayList<>();
                List<Long> oldIds = oldWorkerList.stream().map(WorkerEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<WorkerRegisterEntity> wrWrapper = new LambdaQueryWrapper<>();
                wrWrapper.in(WorkerRegisterEntity::getWorkerId, oldIds);
                wrWrapper.eq(WorkerRegisterEntity::getDr, 0);
                //查询修改前人员的关系表数据
                oldList = workerRegisterService.list(wrWrapper);
                //班组或工种不为空才进行修改
                if (teamName != null || workType != null) {
                    LambdaUpdateWrapper<WorkerEntity> wrapper = new LambdaUpdateWrapper<>();
                    wrapper.set(teamId != null, WorkerEntity::getTeamId, teamId);
                    wrapper.set(teamId != null, WorkerEntity::getTeamName, teamName);
                    wrapper.set(workType != null, WorkerEntity::getWorkType, workType);
                    wrapper.set(workType != null, WorkerEntity::getWorkTypeName, workTypeName);
                    wrapper.eq(WorkerEntity::getId, id);
                    super.update(wrapper);
                    //旧中间表数据
                    Map<Long, WorkerRegisterEntity> oldMap = oldList.stream().collect(Collectors.toMap(WorkerRegisterEntity::getTeamId, detailEntity -> detailEntity));
                    if (teamId != null) {
                        String[] split = teamId.split(",");
                        List<String> newTeamIds = new ArrayList<>(Arrays.asList(split));
                        List<Long> delIds = new ArrayList<>();
                        //循环旧数据
                        for (Map.Entry<Long, WorkerRegisterEntity> oldEntity : oldMap.entrySet()) {
                            int index = newTeamIds.indexOf(String.valueOf(oldEntity.getKey()));
                            //判断旧的是否存在新的,如果存在需要移除
                            if (index > -1) {
                                newTeamIds.remove(index);
                            } else {
                                delIds.add(oldEntity.getValue().getId());
                            }
                        }
                        if (CollectionUtils.isNotEmpty(newTeamIds)) {
                            //新增
                            for (String newTeamId : newTeamIds) {
                                OrgTeamEntity teamEntity = orgTeamService.selectById(Long.valueOf(newTeamId));
                                WorkerRegisterEntity workerRegisterEntity = new WorkerRegisterEntity();
                                workerRegisterEntity.setId(IdWorker.getId());
                                workerRegisterEntity.setWorkerId(id);
                                workerRegisterEntity.setTeamId(teamEntity.getId());
                                workerRegisterEntity.setTeamName(teamEntity.getName());
                                workerRegisterEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                                workerRegisterEntity.setCreateTime(new Date());
                                workerRegisterService.save(workerRegisterEntity);
                            }
                        }
                        if (CollectionUtils.isNotEmpty(delIds)) {
                            // 删除关系表数据
                            workerRegisterService.removeByIds(delIds, false);
                        }
                    }
                }
            }
        }
        return updateVO;
    }

    /**
     * 匹配地区
     * @param areaTemp
     * @return
     */
    @Override
    public Map<String, Object> getArea(String areaTemp) {
        String province = null;
        String city = null;
        String area = null;
        String[] split = areaTemp.split("/");
        JSONArray array = JSON.parseArray(AREA_JSON_STR);
        try {
            for (Object o : array) {
                String province_t = ((JSONObject) o).get("value").toString();
                if (province_t.equals(split[0])) {
                    province = province_t;
                    System.out.println("province============" + province);
                    String children = ((JSONObject) o).get("children").toString();
                    JSONArray childArr = JSON.parseArray(children);
                    if (childArr.size() > 0) {
                        for (Object o1 : childArr) {
                            String city_t = ((JSONObject) o1).get("value").toString();
                            if (city_t.equals(split[1])) {
                                city = city_t;
                                System.out.println("city============" + city);
                                break;
                            }
                        }
                    } else {
                        break;
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        List<String> areaList = new ArrayList<>();
        if (province != null && !"".equals(province)) {
            areaList.add(province);
            if (city != null && !"".equals(city)) {
                areaList.add(city);
            }
        }
        if (CollectionUtils.isNotEmpty(areaList)) {
            area = JSON.toJSONString(areaList);
        }
        System.out.println("area字段值为：" + area);
        Map<String, Object> map = new HashMap<>();
        map.put("province", province);
        map.put("city", city);
        map.put("area", area);
        return map;
    }

    /**
     * 累计重复数量
     *
     * @param type      文件类型
     * @param errorList 错误类型
     * @param map       文件错误集合
     */
    private static void sumRepeat(String type, List<BatchCheckPhotoVO> errorList, HashMap<String, Integer> map) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            Integer value = entry.getValue();
            if (value.compareTo(1) > 0) {
                BatchCheckPhotoVO batchCheckPhotoVO = new BatchCheckPhotoVO();
                batchCheckPhotoVO.setFileName(entry.getKey());
                batchCheckPhotoVO.setFileType(type);
                batchCheckPhotoVO.setErrorMessage("表内存在" + value + "张同样命名图片");
                errorList.add(batchCheckPhotoVO);
            }
        }
    }

    /**
     * 批量校验证件
     *
     * @param request  请求
     * @param response 响应
     *
     * @return {@link JSONObject}
     */
    @Override
    public JSONObject batchCheck(HttpServletRequest request, HttpServletResponse response) throws IOException, NoSuchFieldException, IllegalAccessException {
        JSONObject json = new JSONObject();
        List<BatchCheckPhotoVO> successList = new ArrayList<>();
        List<BatchCheckPhotoVO> errorList = new ArrayList<>();

        String authority = request.getHeader("authority");

        // 统计重名图片数量
        HashMap<String, Integer> idCardFrontMap = new HashMap<>();
        HashMap<String, Integer> idCardBackMap = new HashMap<>();
        HashMap<String, Integer> facePhotoMap = new HashMap<>();

        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> files = multipartRequest.getFileMap();
        for (Map.Entry<String, MultipartFile> entry : files.entrySet()) {
            MultipartFile multipartFile = entry.getValue();
            if (multipartFile.isEmpty()) {
                json.put("successList", successList);
                json.put("errorList", errorList);
                return json;
            }

            // todo:还能优化
            File fileCard = File.createTempFile("导入证件", ".zip");
            FileOutputStream fos = new FileOutputStream(fileCard);
            IoUtil.copy(multipartFile.getInputStream(), fos);
            ZipFile zipFile = new ZipFile(fileCard, Charset.forName("GBK"));
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.isDirectory()) {
                    String path = zipEntry.getName();
                    InputStream in = zipFile.getInputStream(zipEntry);
                    // 身份证信息面
                    checkPhoto(successList, errorList, authority, idCardFrontMap, in, path, ID_CARD_FRONT, "idCardFrontPhotoFlag");
                    // 身份证国徽面
                    checkPhoto(successList, errorList, authority, idCardBackMap, in, path, ID_CARD_BACK, "idCardBackPhotoFlag");
                    // 人脸照片
                    checkPhoto(successList, errorList, authority, facePhotoMap, in, path, FACE_PHOTO, "facePhotoFlag");
                }
            }
            Files.deleteIfExists(Paths.get(fileCard.getPath()));
        }

        sumRepeat(ID_CARD_FRONT, errorList, idCardFrontMap);
        sumRepeat(ID_CARD_BACK, errorList, idCardBackMap);
        sumRepeat(FACE_PHOTO, errorList, facePhotoMap);

        json.put("successList", successList);
        json.put("errorList", errorList);
        return json;
    }


    /**
     * 检查身份证号是否正常
     *
     * @param str str
     *
     * @return boolean
     */
    private boolean checkIdCardNo(String str) {
        final String regex_18 = "^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$";
        final String regex_15 = "^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}$";
        return str.matches(regex_18) || str.matches(regex_15);
    }

    /**
     * 图片校验
     *
     * @param successList    成功列表
     * @param errorList      错误列表
     * @param authority      上下文
     * @param idCardFrontMap 累计重复map
     * @param zipInputStream 压缩包输入流
     * @param path           路径名称
     * @param type           文件类型
     *
     * @throws IOException ioexception
     */
    private void checkPhoto(List<BatchCheckPhotoVO> successList, List<BatchCheckPhotoVO> errorList, String authority, HashMap<String, Integer> idCardFrontMap, InputStream zipInputStream, String path, String type, String photoType) throws IOException, NoSuchFieldException, IllegalAccessException {
        String idCardFront = type + "/";
        if (path.contains(idCardFront)) {
            // 截取文件名称
            String pathName = StringUtils.substringAfter(path, idCardFront);
            // 文件名称
            String fileName = StringUtils.substring(pathName, 0);
            // 身份证号码
            String idCard = StringUtils.substringBeforeLast(fileName, ".");

            // 判断截取的身份证号码是不是有效的身份证号码（排除隐藏的其他文件，例如mac系统文件）
            if (checkIdCardNo(idCard)) {
                // 图片后缀（包含.）
                String suffix = fileName.substring(fileName.lastIndexOf("."));

                // 1、导入文件重复
                if (idCardFrontMap.containsKey(fileName)) {
                    idCardFrontMap.put(fileName, idCardFrontMap.get(fileName) + 1);
                } else {
                    idCardFrontMap.put(fileName, 1);
                }

                // 2、图片格式错误
                if (!".jpeg".equals(suffix) && !".jpg".equals(suffix) && !".png".equals(suffix)) {
                    BatchCheckPhotoVO batchCheckPhotoVO = new BatchCheckPhotoVO();
                    batchCheckPhotoVO.setFileName(fileName);
                    batchCheckPhotoVO.setFileType(type);
                    batchCheckPhotoVO.setErrorMessage("照片只支持JPEG、JPG、PNG");
                    errorList.add(batchCheckPhotoVO);
                }

                // 3、劳务工存在公司花名册
                LambdaQueryWrapper<WorkerEntity> lambdaQuery = Wrappers.lambdaQuery();
                lambdaQuery.eq(WorkerEntity::getTenantId, InvocationInfoProxy.getTenantid());
                lambdaQuery.eq(WorkerEntity::getIdCard, idCard);
                WorkerEntity workerEntity = super.getOne(lambdaQuery);
                if (workerEntity == null) {
                    BatchCheckPhotoVO batchCheckPhotoVO = new BatchCheckPhotoVO();
                    batchCheckPhotoVO.setFileName(fileName);
                    batchCheckPhotoVO.setFileType(type);
                    batchCheckPhotoVO.setErrorMessage("该劳务人员在公司花名册不存在");
                    errorList.add(batchCheckPhotoVO);
                } else {
                    // 4、劳务工存在有效的照片
                    Field field = workerEntity.getClass().getDeclaredField(photoType);
                    field.setAccessible(true);
                    Integer fieldInt = (Integer) field.get(workerEntity);
                    if (fieldInt == 1) {
                        BatchCheckPhotoVO batchCheckPhotoVO = new BatchCheckPhotoVO();
                        batchCheckPhotoVO.setFileName(fileName);
                        batchCheckPhotoVO.setFileType(type);
                        batchCheckPhotoVO.setErrorMessage("用户已存在有效照片，不支持导入修改");
                        errorList.add(batchCheckPhotoVO);
                    }
                    if (fieldInt == 2 || fieldInt == 3) {
                        // 创建临时文件
                        File tempFile = File.createTempFile(idCard, suffix);
                        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
                        IoUtil.copy(zipInputStream, fileOutputStream);

                        // 上传文件中心
                        BatchCheckPhotoVO batchCheckPhotoVO = new BatchCheckPhotoVO();
                        batchCheckPhotoVO.setFileName(fileName);
                        batchCheckPhotoVO.setFileType(type);
                        batchCheckPhotoVO.setTempSourceId(IdWorker.getId());
                        AttachmentVO attachmentVO = uploadFile.upload(authority, tempFile, batchCheckPhotoVO.getTempSourceId(), batchCheckPhotoVO.getBillType(), batchCheckPhotoVO.getTempSourceType(), "true");
                        batchCheckPhotoVO.setFileId(attachmentVO.getId());
                        batchCheckPhotoVO.setIdCard(idCard);
                        successList.add(batchCheckPhotoVO);

                        // 立刻删除
                        Files.deleteIfExists(Paths.get(tempFile.getPath()));
                    }
                }
            }
        }
    }


    /**
     * 更新照片数据
     *
     * @param batchCheckPhotoVOS 批量导入证件校验VO
     */
    @Override
    public void updatePhotoData(List<BatchCheckPhotoVO> batchCheckPhotoVOS) {
        ArrayList<WorkerEntity> workerEntityList = new ArrayList<>();
        for (BatchCheckPhotoVO vo : batchCheckPhotoVOS) {
            LambdaQueryWrapper<WorkerEntity> lambdaQuery = Wrappers.lambdaQuery();
            lambdaQuery.eq(WorkerEntity::getTenantId, InvocationInfoProxy.getTenantid());
            lambdaQuery.eq(WorkerEntity::getIdCard, vo.getIdCard());
            WorkerEntity entity = super.getOne(lambdaQuery);
            if (entity != null) {
                boolean flag = false;
                switch (vo.getFileType()) {
                    // 身份证信息面
                    case ID_CARD_FRONT:
                        // 照片状态为异常的先删除后上传
                        if (entity.getIdCardFrontPhotoFlag() == 3) {
                            CommonResponse<String> response = attachmentApi.deleteFileByParam(entity.getId(), BILL_TYPE, FRONT);
                            if (!response.isSuccess()) {
                                logger.info("公司花名册更新照片数据，删除身份证信息面文件失败，失败原因：{}，入参：来源id-{}，来源单据类型-{}，来源业务类型-{}", response.getMsg(), entity.getId(), BILL_TYPE, FRONT);
                            }
                        }
                        // 更新文件中心的来源id和来源类型
                        CommonResponse<AttachmentVO> res = attachmentApi.queryDetail(String.valueOf(vo.getFileId()));
                        if (res.isSuccess()) {
                            AttachmentVO attachmentVO = res.getData();
                            attachmentVO.setSourceId(entity.getId());
                            attachmentVO.setSourceType(FRONT);
                            CommonResponse<String> response = attachmentApi.updateFileInfo(attachmentVO);
                            if (response.isSuccess()) {
                                entity.setIdCardFrontPhotoFlag(0);
                                flag = true;
                            } else {
                                logger.info("批量导入证件更新文件中心身份证信息面失败，失败原因：{}，来源id：{}", res.getMsg(), entity.getId());
                            }
                        } else {
                            logger.info("批量导入证件查询文件中心身份证信息面失败，失败原因：{}，文件id：{}", res.getMsg(), vo.getFileId());
                        }
                        break;
                    // 身份证国徽面
                    case ID_CARD_BACK:
                        // 照片状态为异常的先删除后上传
                        if (entity.getIdCardBackPhotoFlag() == 3) {
                            CommonResponse<String> response = attachmentApi.deleteFileByParam(entity.getId(), BILL_TYPE, BACK);
                            if (!response.isSuccess()) {
                                logger.info("公司花名册更新照片数据，删除身份证国徽面文件失败，失败原因：{}，入参：来源id-{}，来源单据类型-{}，来源业务类型-{}", response.getMsg(), entity.getId(), BILL_TYPE, BACK);
                            }
                        }
                        CommonResponse<AttachmentVO> res1 = attachmentApi.queryDetail(String.valueOf(vo.getFileId()));
                        if (res1.isSuccess()) {
                            AttachmentVO attachmentVO = res1.getData();
                            attachmentVO.setSourceId(entity.getId());
                            attachmentVO.setSourceType(BACK);
                            CommonResponse<String> response = attachmentApi.updateFileInfo(attachmentVO);
                            if (response.isSuccess()) {
                                entity.setIdCardBackPhotoFlag(0);
                                flag = true;
                            } else {
                                logger.info("批量导入证件更新文件中心身份证国徽面失败，失败原因：{}，来源id：{}", res1.getMsg(), entity.getId());
                            }
                        } else {
                            logger.info("批量导入证件查询文件中心身份证国徽面失败，失败原因：{}，文件id：{}", res1.getMsg(), vo.getFileId());
                        }
                        break;
                    // 人脸图片
                    case FACE_PHOTO:
                        // 照片状态为异常的先删除后上传
                        if (entity.getFacePhotoFlag() == 2 || entity.getFacePhotoFlag() == 3) {
                            CommonResponse<String> response = attachmentApi.deleteFileByParam(entity.getId(), BILL_TYPE, FACE);
                            if (!response.isSuccess()) {
                                logger.info("公司花名册更新照片数据，删除人脸图片文件失败，失败原因：{}，入参：来源id-{}，来源单据类型-{}，来源业务类型-{}", response.getMsg(), entity.getId(), BILL_TYPE, FACE);
                            }
                        }
                        CommonResponse<AttachmentVO> res2 = attachmentApi.queryDetail(String.valueOf(vo.getFileId()));
                        if (res2.isSuccess()) {
                            AttachmentVO attachmentVO = res2.getData();
                            attachmentVO.setSourceId(entity.getId());
                            attachmentVO.setSourceType(FACE);
                            CommonResponse<String> response = attachmentApi.updateFileInfo(attachmentVO);
                            if (response.isSuccess()) {
                                entity.setFacePhotoFlag(0);
                                flag = true;
                            } else {
                                logger.info("批量导入证件更新文件中心人脸图片失败，失败原因：{}，来源id：{}", res2.getMsg(), entity.getId());
                            }
                        } else {
                            logger.info("批量导入证件查询文件中心人脸图片失败，失败原因：{}，文件id：{}", res2.getMsg(), vo.getFileId());
                        }
                        break;
                    default:
                        throw new IllegalStateException("Unexpected value: " + vo.getFileType());
                }
                if (flag) {
                    workerEntityList.add(entity);
                }
            }
        }

        if (CollectionUtils.isNotEmpty(workerEntityList)) {
            super.updateBatchById(workerEntityList, 100);
        }
    }

    @Override
    public WorkerEntity queryOneByIdCard(String idCard) {
        WorkerEntity recordOneByCard = new WorkerEntity();
        QueryWrapper<WorkerEntity> queryRecordByCard = new QueryWrapper<>();
        queryRecordByCard.eq("id_card", idCard);
        queryRecordByCard.eq("dr", 0);
        queryRecordByCard.eq("tenant_id", InvocationInfoProxy.getTenantid());
        List<WorkerEntity> list = super.list(queryRecordByCard);
        if (list.size()>1){
            throw new BusinessException("数据错误: 通过身份证查询到"+list.size()+"个公司花名册");
        }
        recordOneByCard = super.getOne(queryRecordByCard);
        return recordOneByCard;
    }

    @Override
    public void updateEnterStatusByIdS(List<Long> ids) {
        LambdaUpdateWrapper<WorkerEntity> wrapper = new LambdaUpdateWrapper<>();
        wrapper.in(WorkerEntity::getId, ids);
        wrapper.set(WorkerEntity::getWorkState, 1);
        super.update(wrapper);
    }

    /**
     * @description: 保存导入人员信息
     *
     * @param request
     * @param workerVOS
     * @return {@link String}
     * @author songlx
     * @date: 2022/11/22
     */
    @Override
    public String saveImportPerson(HttpServletRequest request, List<WorkerVO> workerVOS) {
        if (ListUtil.isEmpty(workerVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<WorkerEntity> list = new ArrayList<>();
        for (WorkerVO importVO : workerVOS) {
            WorkerEntity worker = BeanMapper.map(importVO, WorkerEntity.class);
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),importVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                worker.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            // 1:启用/0:停用
            worker.setEnabled(WorkerConsts.EnabledEnum.启用.getCode());
            // 用工状态：0未入场，1已入场
            worker.setWorkState(WorkerConsts.WorkStateEnum.未入场.getCode());
            worker.setSourceFlag(WorkerConsts.SourceFlagEnum.公司自制.getCode());
            worker.setSourceFlagName(WorkerConsts.SourceFlagEnum.公司自制.getName());
            worker.setIdCardFrontPhotoFlag(2);
            worker.setIdCardBackPhotoFlag(2);
            worker.setFacePhotoFlag(2);
            list.add(worker);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.saveOrUpdateBatch(list);
            //导入成功后插入中间表关系
            for (WorkerEntity entity : list) {
                String teamId = entity.getTeamId();
                if (teamId != null) {
                    OrgTeamEntity teamEntity = orgTeamService.selectById(Long.valueOf(teamId));
                    WorkerRegisterEntity workerRegisterEntity = new WorkerRegisterEntity();
                    workerRegisterEntity.setId(IdWorker.getId());
                    workerRegisterEntity.setWorkerId(entity.getId());
                    workerRegisterEntity.setTeamId(Long.valueOf(teamId));
                    workerRegisterEntity.setTeamName(teamEntity.getName());
                    workerRegisterEntity.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    workerRegisterEntity.setCreateTime(new Date());
                    workerRegisterService.save(workerRegisterEntity);
                }
            }
        }
        return "导入成功！";
    }

    /**
     * @description: 查询班组下的人员
     *
     * @param page
     * @param queryParam
     * @param teamId
     * @return {@link List< WorkerEntity>}
     * @author songlx
     * @date: 2022/11/25
     */
    @Override
    public List<WorkerEntity> queryOrgTeamWorkerPage(Page<WorkerEntity> page, QueryParam queryParam, Long teamId) {
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<WorkerEntity> list = baseMapper.queryOrgTeamWorkerPage(page, wrapper, teamId);
        return list;
    }

    /**
     * @description: 根据班组id改变劳务员工所属班组名称
     * 班组档案修改名称时，劳务员工冗余的所属班组名称没有变化
     * @param teamId 更新此班组下的所有劳务员工的teamname，适用班组名字更新
     * @param workerId 更新此劳务工人的teamname， 需要前置步骤把teamid放对先更新了
     * @return
     * @author songlx
     * @date: 2022/11/28
     */
    @Override
    public Integer updateWorkerTeamNameByTeamIdOrWorkerId(Long teamId, Long workerId) {
        if (teamId == null && workerId == null) {
            return 0;
        }
        return baseMapper.updateWorkerTeamNameByTeamIdOrWorkerId(teamId, workerId);
    }


    /**
     * 人脸注册
     *
     * @param workerVO 保存或更新vo
     */
    @Override
    public void faceRegistration(WorkerVO workerVO) {
        List<Long> attachIds = workerVO.getAttachIds();
        if (CollectionUtils.isNotEmpty(attachIds)) {
            for (Long attachId : attachIds) {
                CommonResponse<AttachmentVO> response = attachmentApi.queryAttachmentDetail(attachId);
                if (!response.isSuccess()) {
                    logger.info("获取人脸图片地址失败，失败原因：，入参：attachId-{}", attachId);
                    throw new BusinessException("获取人脸图片地址失败，失败原因：" + response.getMsg());
                }
                AttachmentVO attachmentVO = response.getData();
                // 判断是不是人脸图片附件
                if (FACE.equals(attachmentVO.getSourceType())) {
                    FaceInfoVO faceInfoVO = new FaceInfoVO();
                    faceInfoVO.setUserId(workerVO.getId());
                    faceInfoVO.setUserName(workerVO.getName());
                    faceInfoVO.setIdNumber(workerVO.getIdCard());
                    faceInfoVO.setImgUrl(fileUrl + attachmentVO.getFilePath());
                    faceService.faceRegistration(faceInfoVO, true);
                }
            }
        }
    }


    /**
     * 删除注册的人脸
     *
     * @param workerId 公司花名册人员id
     */
    @Override
    public void deleteFace(Long workerId) {
        Assert.notNull(workerId, "公司花名册人员id不能为空！");
        faceService.deleteFace(workerId);
    }
}
