/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"attendance"})
public class AttendanceController
implements Serializable {
    private static final long serialVersionUID = 3843428190950238299L;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IBillTypeApi billTypeApi;
    @Resource
    private IBillCodeApi billCodeApi;
    @Resource
    private IOrgApi iOrgApi;
    @Resource
    private IAttendanceService service;
    @Autowired
    private SessionManager sessionManager;

    @PostMapping(value={"/saveOrUpdate"})
    public CommonResponse<AttendanceVO> saveOrUpdate(@RequestBody AttendanceVO saveOrUpdateVO) {
        BillCodeParam billCodeParam;
        CommonResponse billCode;
        AttendanceEntity entity = (AttendanceEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AttendanceEntity.class));
        if (!(entity.getId() != null && entity.getId() != 0L || (billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO))).isSuccess())) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.service.saveOrUpdate((Object)entity, false);
        AttendanceVO vo = (AttendanceVO)BeanMapper.map((Object)((Object)entity), AttendanceVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<AttendanceVO> queryDetail(Long id) {
        AttendanceEntity entity = (AttendanceEntity)((Object)this.service.selectById(id));
        AttendanceVO vo = (AttendanceVO)BeanMapper.map((Object)((Object)entity), AttendanceVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<AttendanceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AttendanceVO attendanceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryPageByPerson"})
    public CommonResponse<IPage<AttendanceVO>> queryPageByPerson(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString()))).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"id as id", "project_id as projectId,project_name as projectName,project_address as projectAddress,name as name,id_card as idCard,team_id as teamId,team_name as teamName,work_type as workType,work_type_name as workTypeName, ifnull(count(*), 0) as attendanceDays, ifnull(sum(duration), 0) as attendanceHours, ifnull(sum(attendance_status = '\u5f02\u5e38'), 0) as attendanceErrors"}).groupBy((Object[])new String[]{"project_id", "name", "id_card", "team_id", "work_type"});
        wrapper.orderByDesc((Object[])new String[]{"create_time", "name"});
        Page p = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage page = this.service.page((IPage)p, (Wrapper)wrapper);
        List pageRecords = page.getRecords();
        List records = BeanMapper.mapList((Iterable)pageRecords, AttendanceVO.class);
        Page result = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        result.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @PostMapping(value={"/queryPageByRecord"})
    public CommonResponse<IPage<AttendanceVO>> queryPageByRecord(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString()))).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.orderByDesc((Object[])new String[]{"punch_card_date", "create_time", "name"});
        Page p = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage page = this.service.page((IPage)p, (Wrapper)wrapper);
        List pageRecords = page.getRecords();
        List records = BeanMapper.mapList((Iterable)pageRecords, AttendanceVO.class);
        Page result = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        result.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)result);
    }

    @PostMapping(value={"excelExportByPerson"})
    public void excelExportByPerson(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString()))).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"project_id as projectId,project_name as projectName,project_address as projectAddress,name as name,id_card as idCard,team_id as teamId,team_name as teamName,work_type as workType,work_type_name as workTypeName, ifnull(count(*), 0) as attendanceDays, ifnull(sum(duration), 0) as attendanceHours, ifnull(sum(attendance_status = '\u5f02\u5e38'), 0) as attendanceErrors"}).groupBy((Object[])new String[]{"project_id", "name", "id_card", "team_id", "work_type"});
        wrapper.orderByDesc((Object[])new String[]{"create_time", "name"});
        Page p = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage page = this.service.page((IPage)p, (Wrapper)wrapper);
        List list = BeanMapper.mapList((Iterable)page.getRecords(), AttendanceVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("AttendancePerson-export.xlsx", beans, response);
    }

    @PostMapping(value={"excelExportByRecord"})
    public void excelExportByRecord(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("name");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("workTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString()))).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.orderByDesc((Object[])new String[]{"punch_card_date", "create_time", "name"});
        Page p = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage page = this.service.page((IPage)p, (Wrapper)wrapper);
        List list = BeanMapper.mapList((Iterable)page.getRecords(), AttendanceVO.class);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttendanceVO attendanceVO;
                attendanceVO.setRemoteFlagName((attendanceVO = (AttendanceVO)iterator.next()).getRemoteFlag() != null && attendanceVO.getRemoteFlag() == 0 ? "\u5426" : "\u662f");
            }
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("AttendanceRecord-export.xlsx", beans, response);
    }

    @GetMapping(value={"/refAttendanceData"})
    public CommonResponse<IPage<AttendanceVO>> refAttendanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AttendanceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

