/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labor.bean.WorkerEnterChangeEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.mapper.WorkerEnterChangeMapper;
import com.ejianc.business.labor.mapper.WorkerEnterRecordMapper;
import com.ejianc.business.labor.service.IWorkerEnterChangeService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.vo.WorkerEnterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="workerEnterChangeService")
public class WorkerEnterChangeServiceImpl
extends BaseServiceImpl<WorkerEnterChangeMapper, WorkerEnterChangeEntity>
implements IWorkerEnterChangeService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ENTER_BILL_TYPE = "BT202211000003";
    private static final String CHANGE_BILL_TYPE = "BT202304000001";
    private static final String IDCARD_SOURCE_TYPE = "idCardFront";
    private static final String IDBACK_TYPE = "idCardBack";
    private static final String FACE_TYPE = "face";
    @Autowired
    private WorkerEnterChangeMapper mapper;
    @Autowired
    private IWorkerEnterService workerEnterService;
    @Autowired
    private WorkerEnterRecordMapper workerEnterRecordMapper;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public WorkerEnterChangeEntity getUnFinishedChange(Long workerEnterId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"worker_enter_id", (Object)workerEnterId);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        ArrayList<Integer> billStates = new ArrayList<Integer>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in((Object)"bill_state", billStates);
        return (WorkerEnterChangeEntity)((Object)this.mapper.selectOne((Wrapper)query));
    }

    @Override
    public WorkerEnterChangeEntity saveOrUpdateChange(WorkerEnterChangeEntity saveEntity) {
        super.saveOrUpdate((Object)saveEntity, false);
        WorkerEnterEntity workerEnterEntity = (WorkerEnterEntity)((Object)this.workerEnterService.selectById(saveEntity.getWorkerEnterId()));
        if (1 != workerEnterEntity.getChangeState()) {
            workerEnterEntity.setChangeState(WorkerEnterVO.CHANGE_STATE_CHANGING);
            workerEnterEntity.setCurChangingId(saveEntity.getId());
            this.workerEnterService.saveOrUpdate((Object)workerEnterEntity, false);
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteChangePlan(List<Long> changeIds) {
        List changeList = this.mapper.selectBatchIds(changeIds);
        List workerEnterIds = changeList.stream().map(WorkerEnterChangeEntity::getWorkerEnterId).collect(Collectors.toList());
        QueryWrapper planQuery = new QueryWrapper();
        planQuery.in((Object)"id", workerEnterIds);
        List workerEnterList = this.workerEnterService.list((Wrapper)planQuery);
        QueryWrapper query = new QueryWrapper();
        query.select(new String[]{"ifnull(count(1), 0) as hisNum, worker_enter_id as planId"});
        query.in((Object)"worker_enter_id", workerEnterIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.groupBy((Object[])new String[]{"worker_enter_id"});
        List queryResult = this.workerEnterRecordMapper.selectMaps((Wrapper)query);
        HashMap hisCountNumMap = new HashMap();
        queryResult.stream().forEach(m -> hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString())));
        Iterator iterator = workerEnterList.iterator();
        while (iterator.hasNext()) {
            WorkerEnterEntity workerEnterEntity;
            workerEnterEntity.setChangeState(null != hisCountNumMap.get((workerEnterEntity = (WorkerEnterEntity)((Object)iterator.next())).getId()) && (Integer)hisCountNumMap.get(workerEnterEntity.getId()) > 0 ? 2 : 0);
            workerEnterEntity.setCurChangingId(null);
        }
        this.workerEnterService.saveOrUpdateBatch(workerEnterList, workerEnterList.size());
        super.removeByIds((Collection)changeList.stream().map(BaseEntity::getId).collect(Collectors.toList()), false);
    }

    private void deleteAttachment(List<Long> changeIds) {
        for (Long changeId : changeIds) {
            CommonResponse r1 = this.attachmentApi.deleteFileByParam(changeId, CHANGE_BILL_TYPE, IDCARD_SOURCE_TYPE);
            if (!r1.isSuccess()) {
                throw new BusinessException("\u5220\u9664\u8eab\u4efd\u8bc1\u4fe1\u606f\u9762\u9644\u4ef6\u5931\u8d25");
            }
            CommonResponse r2 = this.attachmentApi.deleteFileByParam(changeId, CHANGE_BILL_TYPE, IDBACK_TYPE);
            if (!r2.isSuccess()) {
                throw new BusinessException("\u5220\u9664\u8eab\u4efd\u8bc1\u56fd\u5fbd\u9762\u9644\u4ef6\u5931\u8d25");
            }
            CommonResponse r3 = this.attachmentApi.deleteFileByParam(changeId, CHANGE_BILL_TYPE, FACE_TYPE);
            if (r3.isSuccess()) continue;
            throw new BusinessException("\u5220\u9664\u4eba\u8138\u9644\u4ef6\u5931\u8d25");
        }
    }
}

