package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.bean.PointTicketsDetailEntity;
import com.ejianc.business.labor.bean.PointTicketsEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.service.IPointTicketsService;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.labor.vo.PointTicketsDetailVO;
import com.ejianc.business.labor.vo.PointTicketsVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("pointTickets") 
public class PointTicketsBpmServiceImpl implements ICommonBusinessService {


	@Resource
	private IAttendanceService attendanceService;

	@Resource
	private IPointTicketsService service;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		PointTicketsEntity entity = service.selectById(billId);
		List<PointTicketsDetailEntity> detailList = entity.getPointTicketsDetailList();
		if (ListUtil.isNotEmpty(detailList)){
			List<PointTicketsDetailVO> detailVoList = BeanMapper.mapList(detailList, PointTicketsDetailVO.class);
			List<AttendanceVO> attendanceList = new ArrayList();
			List<Long> workerIds = new ArrayList();
			List<AttendanceEntity> updAttEntityList=new ArrayList();
			Map<Long, AttendanceEntity> updMap=new HashMap();
			workerIds = detailVoList.stream().filter(i -> null != i.getWorkerId()).map(PointTicketsDetailVO::getWorkerId).collect(Collectors.toList());

			//查询已存在的当日打卡
			if (ListUtil.isNotEmpty(workerIds)) {
				QueryWrapper<AttendanceEntity> queryWrapper = new QueryWrapper();
				queryWrapper.eq("dr", 0);
				queryWrapper.in("worker_id", workerIds);
				queryWrapper.eq("punch_card_date", entity.getWorkDate());
				updAttEntityList = attendanceService.list(queryWrapper);
				if (ListUtil.isNotEmpty(updAttEntityList)) {
					updMap = updAttEntityList.stream().collect(Collectors.toMap(AttendanceEntity::getWorkerId,  Function.identity(), (k1, k2) -> k2));
				}
			}

			for (PointTicketsDetailVO vo : detailVoList) {
				AttendanceVO attendanceVO = new AttendanceVO();
				//当日已存在打卡则覆盖
				if (updMap.containsKey(vo.getWorkerId())){
					AttendanceEntity attendanceEntity = updMap.get(vo.getWorkerId());
					attendanceVO = BeanMapper.map(attendanceEntity,AttendanceVO.class);
				}
				attendanceVO.setWorkerId(vo.getWorkerId());
				attendanceVO.setProjectTeamId(String.valueOf(entity.getTeamId()));
				attendanceVO.setProjectTeamName(entity.getTeamName());
				attendanceVO.setName(vo.getName());
				attendanceVO.setIdCard(vo.getIdCard());
				attendanceVO.setPhone(vo.getPhone());
				attendanceVO.setTeamId(String.valueOf(entity.getTeamId()));
				attendanceVO.setTeamName(entity.getTeamName());
				attendanceVO.setWorkType(vo.getWorkType());
				attendanceVO.setWorkTypeName(vo.getWorkTypeName());
				attendanceVO.setOrgId(entity.getOrgId());
				attendanceVO.setOrgName(entity.getOrgName());
				attendanceVO.setPunchCardDate(entity.getWorkDate());
				//attendanceVO.setStartWorkTime();
				//attendanceVO.setStartWorkPlace();
				//attendanceVO.setEndWorkTime();
				//attendanceVO.setEndWorkPlace();
				//attendanceVO.setDuration();
				attendanceVO.setAttendanceStatus("点工");
				attendanceVO.setRemoteFlag(0);
				attendanceVO.setProjectId(entity.getProjectId());
				attendanceVO.setProjectName(entity.getProjectName());
				attendanceVO.setSourceId(entity.getId());
				attendanceVO.setSourceDetailId(vo.getId());
				attendanceVO.setActualDays(vo.getActualDays());
				attendanceList.add(attendanceVO);
			}
			attendanceService.saveOrUpdateBatch(BeanMapper.mapList(attendanceList,AttendanceEntity.class));
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		PointTicketsEntity entity = service.selectById(billId);
		List<PointTicketsDetailEntity> detailList = entity.getPointTicketsDetailList();
		if (ListUtil.isNotEmpty(detailList)){
			LambdaUpdateWrapper<AttendanceEntity> lambdaUpdateWrapper = new LambdaUpdateWrapper();
			lambdaUpdateWrapper.eq(AttendanceEntity::getSourceId, billId);
			lambdaUpdateWrapper.set(AttendanceEntity::getDr, 1);
			attendanceService.update(lambdaUpdateWrapper);
		}
		return CommonResponse.success();
	}

}
