package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.laborsub.utils.TreeNodeBUtil;
import com.ejianc.business.laborsub.vo.*;
import com.ejianc.business.sub.bean.ChangeDetailEntity;
import com.ejianc.business.sub.bean.ChangeOtherCostEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.ChangeTypeEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.service.IChangeDetailService;
import com.ejianc.business.sub.service.IChangeOtherCostService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sub.mapper.ChangeMapper;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.service.IChangeService;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * 分包变更实体
 * 
 * @author generator
 * 
 */
@Service("changeService")
public class ChangeServiceImpl extends BaseServiceImpl<ChangeMapper, ChangeEntity> implements IChangeService{

    @Autowired
    private IContractService contractService;

    @Autowired
    private IChangeDetailService changeDetailService;

    @Autowired
    private IChangeOtherCostService otherCostService;

    /**
     * @Description saveOrUpdate 查询当前合同下变更列表
     * @param id
     */
    @Override
    public ChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = contractService.selectById(id);
        ChangeVO changeVO = new ChangeVO();
        BigDecimal baseMoneyWithTax = contractEntity.getBaseMoneyWithTax() == null ? BigDecimal.ZERO : contractEntity.getBaseMoneyWithTax();
        BigDecimal contractAmtWithTax = contractEntity.getContractAmtWithTax() == null ? BigDecimal.ZERO : contractEntity.getContractAmtWithTax();
        changeVO.setId(id);
        changeVO.setBaseMoneyWithTax(baseMoneyWithTax);
        //现合同金额（含税）
        changeVO.setContractAmtWithTax(contractAmtWithTax);


        //累计变更比例
        if(baseMoneyWithTax.compareTo(BigDecimal.ZERO)!=0 && contractAmtWithTax.compareTo(BigDecimal.ZERO)!=0){
            BigDecimal changeAmtRate = (contractAmtWithTax.divide(baseMoneyWithTax,8, ROUND_HALF_DOWN)).multiply(new BigDecimal(100));
            changeVO.setChangeAmtRate(changeAmtRate);
        }

        if(null != contractEntity.getChangeVersion() && contractEntity.getChangeVersion()>0){
            //合同版本号>0说明会有变更记录
            LambdaQueryWrapper<ChangeEntity> lambda = Wrappers.<ChangeEntity>lambdaQuery();
            lambda.eq(ChangeEntity::getContractId,id);
            lambda.orderByDesc(ChangeEntity::getChangeDate);
            List<ChangeEntity> changeList = super.list(lambda);
            //设置变更详情
            changeVO.setChangeList(BeanMapper.mapList(changeList, ChangeVO.class));
            BigDecimal allChangeAmt = new BigDecimal(0);
            for (ChangeEntity c : changeList){
                if (c.getChangeMoney() != null){
                    allChangeAmt = allChangeAmt.add(c.getChangeMoney());
                }
            }
            changeVO.setAllChangeAmt(allChangeAmt);
            changeVO.setChangeNum(changeList.size());
        }
        //判断能否新增变更
        if (SignatureStatusEnum.已签章.getCode().toString().equals(contractEntity.getSignatureStatus())
                && (BillStateEnum.PASSED_STATE.getBillStateCode() == contractEntity.getBillState() || BillStateEnum.COMMITED_STATE.getBillStateCode() == contractEntity.getBillState())) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        }
        return changeVO;
    }

    /**
     * 查询能否变更
     * @param contractId
     * @return
     */
    @Override
    public Boolean editChangeFlag(Long contractId) {
         /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<ChangeEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(ChangeEntity::getContractId, contractId);
        lambda.and(l -> l.ne(ChangeEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<ChangeEntity> changeList = super.list(lambda);
        if (changeList.size() > 0){
            return false;
        }
        return true;
    }

    /**
     * @Author yangst
     * @Description  新增根据合同主键查询变更需要的主合同字段
     * @param contractId
     */
    @Override
    public ChangeVO addConvertByConId(Long contractId) {
        ContractEntity contractEntity = contractService.selectById(contractId);
        ChangeVO changeVO = BeanMapper.map(contractEntity, ChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeContractName(contractEntity.getContractName());
//        changeVO.setBeforeChangeMny(contractEntity.getContractAmt());
//        changeVO.setBeforeChangeMnyWithTax(contractEntity.getContractAmtWithTax());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion()+ 1);
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);


        //设置明细表字段
        List<ChangeDetailVO> changeDetailList = changeVO.getDetailList();
        if(CollectionUtils.isNotEmpty(changeDetailList)){
            changeDetailList.forEach(changeDetailVO ->{
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getPrice());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getRate());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId()!= null && changeDetailVO.getParentId() > 0 ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
            });
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree(changeDetailList));
        List<ChangeClauseVO> changeClauseList = changeVO.getClauseList();
        if(CollectionUtils.isNotEmpty(changeClauseList)){
            changeClauseList.forEach(changeClauseVO ->{
                changeClauseVO.setRowState("add");
            });
        }
        //其他费用
        List<ChangeOtherCostVO> changeOtherCostVOList = changeVO.getOtherCostList();
        if(CollectionUtils.isNotEmpty(changeOtherCostVOList)){
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeCostNum(changeOtherCostVO.getCostNum());
                changeOtherCostVO.setBeforeChangeCostPrice(changeOtherCostVO.getCostPrice());
                changeOtherCostVO.setBeforeChangeCostRate(changeOtherCostVO.getCostRate());
                changeOtherCostVO.setRowState("add");
            });
        }
        return changeVO;
    }

    @Override
    public ChangeVO insertOrUpdate(ChangeVO changeVO) {
        ChangeEntity changeEntity = BeanMapper.map(changeVO, ChangeEntity.class);

        //变更合同只能存在一条未生效的
        //查询语句，主合同id一致，且变更id不同，单据状态不为已通过或已提交的，或签章状态不为已签章的
        LambdaQueryWrapper<ChangeEntity> lambdachange = Wrappers.<ChangeEntity>lambdaQuery();
        lambdachange.eq(ChangeEntity::getContractId,changeVO.getContractId());
        if(changeVO.getId() != null && changeVO.getId() > 0) {
            lambdachange.ne(ChangeEntity::getId,changeVO.getId());
        }
        lambdachange.and(l -> l.ne(ChangeEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode())));
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同已存在未生效的变更单!");
        }

        if (changeEntity.getId() == null){
            if(changeEntity.getChangeVersion() < 10){
                changeEntity.setBillCode(changeEntity.getBillCode() + "10" + changeEntity.getChangeVersion());
            }else{
                changeEntity.setBillCode(changeEntity.getBillCode() + "1" + changeEntity.getChangeVersion());
            }
        }

        //保存前清空主键和父主键，重新生成
        List<ChangeDetailEntity> beforeDetails = changeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(beforeDetails) && null == changeEntity.getId()){
            for(ChangeDetailEntity cdEntity : beforeDetails){
                //设置来源子表主键
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }

        super.saveOrUpdate(changeEntity, false);

        List<ChangeDetailEntity> changeDetailEntities = changeEntity.getDetailList();
        if(CollectionUtils.isNotEmpty(changeDetailEntities)){
            Map<String,Long> idMap=new HashMap<>();
            for(ChangeDetailEntity cdEntity : changeDetailEntities){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(ChangeDetailEntity cdEntity : changeDetailEntities){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            changeDetailService.saveOrUpdateBatch(changeDetailEntities, changeDetailEntities.size(), false);
        }

        saveWriteContract(changeEntity);

        return queryDetail(changeEntity.getId());
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        ChangeEntity changeEntity = super.selectById(id);
        ChangeVO changeVO =  BeanMapper.map(changeEntity, ChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        //设置明细内容
        List<ChangeDetailEntity> detailEntityListDb = changeDetailService.queryList(queryParam, false);
        List<ChangeDetailEntity> detailEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
            detailEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (ChangeDetailEntity cdEntity : detailEntityList) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0 ? cdEntity.getParentId().toString() : "");
                cdEntity.setRowState("edit");
            }
            List<ChangeDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, ChangeDetailVO.class);
            changeVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
        }

        //设置其他花费内容
        List<ChangeOtherCostEntity> otherCostEntityListDb = otherCostService.queryList(queryParam, false);
        List<ChangeOtherCostEntity> otherCostEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(otherCostEntityListDb)){
            otherCostEntityListDb.forEach(entity -> {
                if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                    otherCostEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(otherCostEntityList)){
            for (ChangeOtherCostEntity ocEntity : otherCostEntityList) {
                ocEntity.setRowState("edit");
            }
            List<ChangeOtherCostVO> resultMapList = BeanMapper.mapList(otherCostEntityList, ChangeOtherCostVO.class);
            changeVO.setOtherCostList(resultMapList);
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ChangeVO> vos) {
        ChangeVO changeVo = vos.get(0);
        ChangeEntity entity = super.selectById(changeVo.getId());
        //合同变更只有详情页有删除
        ContractEntity contractEntity = contractService.selectById(entity.getContractId());
        //回写合同表（两个金额四个变更）
//        contractEntity.setId(entity.getContractId());
        contractEntity.setChangeVersion(contractEntity.getChangeVersion()-1);
        contractEntity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);//修改变更中金额
        contractEntity.setChangingMnyWithTax(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        contractService.update(contractEntity, new QueryWrapper<ContractEntity>().eq("id",contractEntity.getId()),false);
        super.removeByIds(vos.stream().map(ChangeVO::getId).collect(Collectors.toList()),false);
        return CommonResponse.success("删除成功！");
    }

    /**
     * 查询变更对比
     * @param id
     * @param contractId
     * @return
     */
    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        ChangeEntity changeEntity = super.selectById(id);
        ChangeCompareVO changeCompareVO = BeanMapper.map(changeEntity, ChangeCompareVO.class);
        ContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
        ChangeCompareVO beforeChangeVO = BeanMapper.map(contractEntity, ChangeCompareVO.class);
        Map<String, Object> returnMap = new HashMap<>();
        if (changeCompareVO != null && beforeChangeVO != null){

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("change_id", new Parameter(QueryParam.EQ, id));
            queryParam.getOrderMap().put("treeIndex", "asc");
            //设置明细内容
            List<ChangeDetailEntity> detailEntityListDb = changeDetailService.queryList(queryParam, false);
            List<ChangeDetailEntity> detailEntityList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(detailEntityListDb)) {
                detailEntityListDb.forEach(entity -> {
                    if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()) {
                        detailEntityList.add(entity);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                List<ChangeDetailVO> resultMapList = BeanMapper.mapList(detailEntityList, ChangeDetailVO.class);
                changeCompareVO.setDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }

            //设置其他花费内容
            List<ChangeOtherCostEntity> otherCostEntityListDb = otherCostService.queryList(queryParam, false);
            List<ChangeOtherCostEntity> otherCostEntityList = new ArrayList<>();
            if (CollectionUtils.isNotEmpty(otherCostEntityListDb)){
                otherCostEntityListDb.forEach(entity -> {
                    if (null == entity.getChangeType() || ChangeTypeEnum.中止.getCode() != entity.getChangeType()){
                        otherCostEntityList.add(entity);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(otherCostEntityList)){
                List<ChangeOtherCostVO> resultMapList = BeanMapper.mapList(otherCostEntityList, ChangeOtherCostVO.class);
                changeCompareVO.setOtherCostList(resultMapList);
            }

            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    /**
     * 保存回写合同
     * @param changeEntity
     */
    private void saveWriteContract(ChangeEntity changeEntity){
        /*
            回写主合同，两个金额四个变更
         */
        LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(ContractEntity::getChangeId, changeEntity.getId());
        updateWrapper.set(ContractEntity::getChangeCode, changeEntity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, changeEntity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.变更中.getCode());
        updateWrapper.set(ContractEntity::getChangingMny, changeEntity.getContractAmt());
        updateWrapper.set(ContractEntity::getChangingMnyWithTax, changeEntity.getContractAmtWithTax());
        updateWrapper.eq(ContractEntity::getId, changeEntity.getContractId());
        contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
    }

}
