package com.ejianc.business.sub.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.laborsub.vo.ContractClauseVO;
import com.ejianc.business.laborsub.vo.ContractDetailVO;
import com.ejianc.business.laborsub.vo.ContractOtherCostVO;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.ContractClauseEntity;
import com.ejianc.business.sub.bean.ContractOtherCostEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 分包合同实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_laborsub_contract")
public class ContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;


    /**
     * 定标结果Id
     */
    @TableField("target_result_id")
    private Long targetResultId;

    /**
     * 定标结果名称
     */
    @TableField("target_result_name")
    private String targetResultName;

    /**
     * 项目Id
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 合同编码
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 合同类别Id
     */
    @TableField("contract_category_id")
    private Long contractCategoryId;

    /**
     * 合同类别名称
     */
    @TableField("contract_category_name")
    private String contractCategoryName;

    /**
     * 甲方Id
     */
    @TableField("first_party_id")
    private Long firstPartyId;

    /**
     * 甲方名称
     */
    @TableField("first_party_name")
    private String firstPartyName;

    /**
     * 供应商Id
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 签订日期
     */
    @TableField("sign_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;

    /**
     * 签约地点
     */
    @TableField("sign_place")
    private String signPlace;

    /**
     * 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
     */
    @TableField("signature_status")
    private String signatureStatus;

    /**
     * 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
     */
    @TableField("performance_status")
    private String performanceStatus;

    /**
     * 经办人Id
     */
    @TableField("operator_id")
    private Long operatorId;

    /**
     * 经办人名称
     */
    @TableField("operator_name")
    private String operatorName;

    /**
     * 工程地点
     */
    @TableField("project_address")
    private String projectAddress;

    /**
     * 合同支付比例
     */
    @TableField("pay_scale")
    private BigDecimal payScale;

    /**
     * 质量标准Id
     */
    @TableField("quality_standard_id")
    private Long qualityStandardId;

    /**
     * 质量标准名称
     */
    @TableField("quality_standard_name")
    private String qualityStandardName;

    /**
     * 项目计税方式名称:简易计税、一般计税
     */
    @TableField("project_tax_caculate_type")
    private String projectTaxCaculateType;

    /**
     * 计价方式：1-可调单价、2-固定总价、3-成本加酬金；
     */
    @TableField("pricing_type")
    private String pricingType;

    /**
     * 起草方式：1、线上起草，2、上传合同，3、线下签订
     */
    @TableField("draft_type")
    private String draftType;

    /**
     * 合同附件路径
     */
    @TableField("contract_file_path")
    private String contractFilePath;

    /**
     * 合同附件Id
     */
    @TableField("contract_file_id")
    private Long contractFileId;

    /**
     * 合同模板Id
     */
    @TableField("contract_template_id")
    private Long contractTemplateId;

    /**
     * 合同模板名称
     */
    @TableField("contract_template_name")
    private String contractTemplateName;

    /**
     * 合同附件版本Id
     */
    @TableField("contract_file_version_id")
    private Long contractFileVersionId;

    /**
     * 合同附件版本
     */
    @TableField("contract_file_version")
    private Long contractFileVersion;

    /**
     * 资质id
     */
    @TableField("material_id")
    private Long materialId;

    /**
     * 资质名称
     */
    @TableField("material_name")
    private String materialName;

    /**
     * 资质证书编号
     */
    @TableField("certificate_no")
    private String certificateNo;

    /**
     * 资质证书发证机关
     */
    @TableField("material_licence_issuing_authority")
    private String materialLicenceIssuingAuthority;

    /**
     * 资质证书授予日期
     */
    @TableField("material_grant_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date materialGrantDate;

    /**
     * 资质证书有效期至
     */
    @TableField("material_valid_till_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date materialValidTillDate;

    /**
     * 安全生成许可证编号
     */
    @TableField("safety_production_license_no")
    private String safetyProductionLicenseNo;

    /**
     * 安全生产许可证授予日期
     */
    @TableField("safety_certi_grant_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safetyCertiGrantDate;

    /**
     * 安全许可证有效期至
     */
    @TableField("safety_certi_valid_till_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date safetyCertiValidTillDate;

    /**
     * 开工日期
     */
    @TableField("project_start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date projectStartDate;

    /**
     * 计划竣工日期
     */
    @TableField("planned_finish_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date plannedFinishDate;

    /**
     * 合同工期:合同工期=计划竣工日期-开工日期+1
     */
    @TableField("contract_days_limit")
    private Integer contractDaysLimit;

    /**
     * 甲方项目经理Id
     */
    @TableField("first_party_project_manager_id")
    private Long firstPartyProjectManagerId;

    /**
     * 甲方项目经理名称
     */
    @TableField("first_party_project_manager_name")
    private String firstPartyProjectManagerName;

    /**
     * 甲方项目经理联系电话
     */
    @TableField("first_party_project_manager_link")
    private String firstPartyProjectManagerLink;

    /**
     * 甲方项目经理职务
     */
    @TableField("first_party_project_manager_post")
    private String firstPartyProjectManagerPost;

    /**
     * 乙方项目经理Id
     */
    @TableField("second_party_project_manager_id")
    private Long secondPartyProjectManagerId;

    /**
     * 乙方项目经理名称
     */
    @TableField("second_party_project_manager_name")
    private String secondPartyProjectManagerName;

    /**
     * 乙方项目经理联系电话
     */
    @TableField("second_party_project_manager_link")
    private String secondPartyProjectManagerLink;

    /**
     * 乙方项目经理职务
     */
    @TableField("second_party_project_manager_post")
    private String secondPartyProjectManagerPost;

    /**
     * 乙方项目经理身份证号
     */
    @TableField("second_party_project_manager_id_card")
    private String secondPartyProjectManagerIdCard;

    /**
     * 合同金额（含税）
     */
    @TableField("contract_amt_with_tax")
    private BigDecimal contractAmtWithTax;

    /**
     * 合同金额（无税）
     */
    @TableField("contract_amt")
    private BigDecimal contractAmt;

    /**
     * 合同税额
     */
    @TableField("contract_tax_amt")
    private BigDecimal contractTaxAmt;

    /**
     * 分包金额（含税）
     */
    @TableField("sub_contract_amt_with_tax")
    private BigDecimal subContractAmtWithTax;

    /**
     * 分包金额（无税）
     */
    @TableField("sub_contract_amt")
    private BigDecimal subContractAmt;

    /**
     * 分包税额
     */
    @TableField("sub_contract_tax_amt")
    private BigDecimal subContractTaxAmt;

    /**
     * 其他金额（含税）
     */
    @TableField("other_amt_with_tax")
    private BigDecimal otherAmtWithTax;

    /**
     * 其他金额（无税）
     */
    @TableField("other_amt")
    private BigDecimal otherAmt;

    /**
     * 其他税额
     */
    @TableField("other_tax_amt")
    private BigDecimal otherTaxAmt;

    /**
     * 单据状态
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 提交日期
     */
    @TableField("commit_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate;

    /**
     * 提交人名称
     */
    @TableField("commit_user_name")
    private String commitUserName;

    /**
     * 提交人账号
     */
    @TableField("commit_user_code")
    private String commitUserCode;

    /**
     * 生效日期
     */
    @TableField("effective_date")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate;

    /**
     * 项目部Id
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 项目部名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 项目部上级组织Id
     */
    @TableField("parent_org_id")
    private Long parentOrgId;

    /**
     * 项目部上级组织名称
     */
    @TableField("parent_org_name")
    private String parentOrgName;

    /**
     * 合同高亮附件路径
     */
    @TableField("contract_file_highlight_path")
    private String contractFileHighlightPath;

    /**
     * 合同高亮附件Id
     */
    @TableField("contract_file_highlight_id")
    private Long contractFileHighlightId;

    /**
     * 初始版本金额
     */
    @TableField("base_money")
    private BigDecimal baseMoney;

    /**
     * 初始版本(含税)金额
     */
    @TableField("base_money_with_tax")
    private BigDecimal baseMoneyWithTax;

    /**
     * 变更前金额
     */
    @TableField("before_change_mny")
    private BigDecimal beforeChangeMny;

    /**
     * 变更前金额（含税）
     */
    @TableField("before_change_mny_with_tax")
    private BigDecimal beforeChangeMnyWithTax;

    /**
     * 变更中金额
     */
    @TableField("changing_mny")
    private BigDecimal changingMny;

    /**
     * 变更中金额（含税）
     */
    @TableField("changing_mny_with_tax")
    private BigDecimal changingMnyWithTax;

    /**
     * 变更单号
     */
    @TableField("change_code")
    private String changeCode;

    /**
     * 变更版本
     */
    @TableField("change_version")
    private Integer changeVersion;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    @TableField("change_status")
    private Integer changeStatus;

    /**
     * 是否补充协议(1:是，0：否)
     */
    @TableField("supplement_flag")
    private Integer supplementFlag;

    /**
     * 主合同Id
     */
    @TableField("main_contract_id")
    private Long mainContractId;

    /**
     * 主合同编码
     */
    @TableField("main_contract_code")
    private String mainContractCode;

    /**
     * 主合同名称
     */
    @TableField("main_contract_name")
    private String mainContractName;

    /**
     * 补充协议补充项描述
     */
    @TableField("supplement_describe")
    private String supplementDescribe;

    /**
     * 主合同创建日期（用于补充协议排列）
     */
    @TableField("main_contract_create_date ")
    private Date mainContractCreateDate ;




//    @TableField(exist=false)
//    @SubEntity(serviceName="contractDetailService")
//    private List<ContractDetailEntity> contractDetailEntities = new ArrayList<>(); // 分包合同明细实体
//    @TableField(exist=false)
//    @SubEntity(serviceName="contractClauseService")
//    private List<ContractClauseEntity> contractClauseEntities = new ArrayList<>(); // 分包合同条款实体
//    @TableField(exist=false)
//    @SubEntity(serviceName="contractOtherCostService")
//    private List<ContractOtherCostEntity> contractOtherCostEntities = new ArrayList<>(); // 分包合同其他费用实体

    @TableField(exist=false)
    @SubEntity(serviceName="contractDetailService",pidName = "contractId")
    private List<ContractDetailEntity> detailList = new ArrayList<>(); // 分包合同明细实体
    @TableField(exist=false)
    @SubEntity(serviceName="contractClauseService",pidName = "contractId")
    private List<ContractClauseEntity> clauseList = new ArrayList<>(); // 分包合同条款实体
    @TableField(exist=false)
    @SubEntity(serviceName="contractOtherCostService",pidName = "contractId")
    private List<ContractOtherCostEntity> otherCostList = new ArrayList<>(); // 分包合同其他费用实体

    public Long getTargetResultId() {
        return targetResultId;
    }

    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }

    public String getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getProjectAddress() {
        return projectAddress;
    }

    public void setProjectAddress(String projectAddress) {
        this.projectAddress = projectAddress;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public Long getQualityStandardId() {
        return qualityStandardId;
    }

    public void setQualityStandardId(Long qualityStandardId) {
        this.qualityStandardId = qualityStandardId;
    }

    public String getQualityStandardName() {
        return qualityStandardName;
    }

    public void setQualityStandardName(String qualityStandardName) {
        this.qualityStandardName = qualityStandardName;
    }

    public String getProjectTaxCaculateType() {
        return projectTaxCaculateType;
    }

    public void setProjectTaxCaculateType(String projectTaxCaculateType) {
        this.projectTaxCaculateType = projectTaxCaculateType;
    }

    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }

    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    public String getCertificateNo() {
        return certificateNo;
    }

    public void setCertificateNo(String certificateNo) {
        this.certificateNo = certificateNo;
    }

    public String getMaterialLicenceIssuingAuthority() {
        return materialLicenceIssuingAuthority;
    }

    public void setMaterialLicenceIssuingAuthority(String materialLicenceIssuingAuthority) {
        this.materialLicenceIssuingAuthority = materialLicenceIssuingAuthority;
    }

    public Date getMaterialGrantDate() {
        return materialGrantDate;
    }

    public void setMaterialGrantDate(Date materialGrantDate) {
        this.materialGrantDate = materialGrantDate;
    }

    public Date getMaterialValidTillDate() {
        return materialValidTillDate;
    }

    public void setMaterialValidTillDate(Date materialValidTillDate) {
        this.materialValidTillDate = materialValidTillDate;
    }

    public String getSafetyProductionLicenseNo() {
        return safetyProductionLicenseNo;
    }

    public void setSafetyProductionLicenseNo(String safetyProductionLicenseNo) {
        this.safetyProductionLicenseNo = safetyProductionLicenseNo;
    }

    public Date getSafetyCertiGrantDate() {
        return safetyCertiGrantDate;
    }

    public void setSafetyCertiGrantDate(Date safetyCertiGrantDate) {
        this.safetyCertiGrantDate = safetyCertiGrantDate;
    }

    public Date getSafetyCertiValidTillDate() {
        return safetyCertiValidTillDate;
    }

    public void setSafetyCertiValidTillDate(Date safetyCertiValidTillDate) {
        this.safetyCertiValidTillDate = safetyCertiValidTillDate;
    }

    public Date getProjectStartDate() {
        return projectStartDate;
    }

    public void setProjectStartDate(Date projectStartDate) {
        this.projectStartDate = projectStartDate;
    }

    public Date getPlannedFinishDate() {
        return plannedFinishDate;
    }

    public void setPlannedFinishDate(Date plannedFinishDate) {
        this.plannedFinishDate = plannedFinishDate;
    }

    public Integer getContractDaysLimit() {
        return contractDaysLimit;
    }

    public void setContractDaysLimit(Integer contractDaysLimit) {
        this.contractDaysLimit = contractDaysLimit;
    }

    public Long getFirstPartyProjectManagerId() {
        return firstPartyProjectManagerId;
    }

    public void setFirstPartyProjectManagerId(Long firstPartyProjectManagerId) {
        this.firstPartyProjectManagerId = firstPartyProjectManagerId;
    }

    public String getFirstPartyProjectManagerName() {
        return firstPartyProjectManagerName;
    }

    public void setFirstPartyProjectManagerName(String firstPartyProjectManagerName) {
        this.firstPartyProjectManagerName = firstPartyProjectManagerName;
    }

    public String getFirstPartyProjectManagerLink() {
        return firstPartyProjectManagerLink;
    }

    public void setFirstPartyProjectManagerLink(String firstPartyProjectManagerLink) {
        this.firstPartyProjectManagerLink = firstPartyProjectManagerLink;
    }

    public String getFirstPartyProjectManagerPost() {
        return firstPartyProjectManagerPost;
    }

    public void setFirstPartyProjectManagerPost(String firstPartyProjectManagerPost) {
        this.firstPartyProjectManagerPost = firstPartyProjectManagerPost;
    }

    public Long getSecondPartyProjectManagerId() {
        return secondPartyProjectManagerId;
    }

    public void setSecondPartyProjectManagerId(Long secondPartyProjectManagerId) {
        this.secondPartyProjectManagerId = secondPartyProjectManagerId;
    }

    public String getSecondPartyProjectManagerName() {
        return secondPartyProjectManagerName;
    }

    public void setSecondPartyProjectManagerName(String secondPartyProjectManagerName) {
        this.secondPartyProjectManagerName = secondPartyProjectManagerName;
    }

    public String getSecondPartyProjectManagerLink() {
        return secondPartyProjectManagerLink;
    }

    public void setSecondPartyProjectManagerLink(String secondPartyProjectManagerLink) {
        this.secondPartyProjectManagerLink = secondPartyProjectManagerLink;
    }

    public String getSecondPartyProjectManagerPost() {
        return secondPartyProjectManagerPost;
    }

    public void setSecondPartyProjectManagerPost(String secondPartyProjectManagerPost) {
        this.secondPartyProjectManagerPost = secondPartyProjectManagerPost;
    }

    public String getSecondPartyProjectManagerIdCard() {
        return secondPartyProjectManagerIdCard;
    }

    public void setSecondPartyProjectManagerIdCard(String secondPartyProjectManagerIdCard) {
        this.secondPartyProjectManagerIdCard = secondPartyProjectManagerIdCard;
    }

    public BigDecimal getContractAmtWithTax() {
        return contractAmtWithTax;
    }

    public void setContractAmtWithTax(BigDecimal contractAmtWithTax) {
        this.contractAmtWithTax = contractAmtWithTax;
    }

    public BigDecimal getContractAmt() {
        return contractAmt;
    }

    public void setContractAmt(BigDecimal contractAmt) {
        this.contractAmt = contractAmt;
    }

    public BigDecimal getContractTaxAmt() {
        return contractTaxAmt;
    }

    public void setContractTaxAmt(BigDecimal contractTaxAmt) {
        this.contractTaxAmt = contractTaxAmt;
    }

    public BigDecimal getSubContractAmtWithTax() {
        return subContractAmtWithTax;
    }

    public void setSubContractAmtWithTax(BigDecimal subContractAmtWithTax) {
        this.subContractAmtWithTax = subContractAmtWithTax;
    }

    public BigDecimal getSubContractAmt() {
        return subContractAmt;
    }

    public void setSubContractAmt(BigDecimal subContractAmt) {
        this.subContractAmt = subContractAmt;
    }

    public BigDecimal getSubContractTaxAmt() {
        return subContractTaxAmt;
    }

    public void setSubContractTaxAmt(BigDecimal subContractTaxAmt) {
        this.subContractTaxAmt = subContractTaxAmt;
    }

    public BigDecimal getOtherAmtWithTax() {
        return otherAmtWithTax;
    }

    public void setOtherAmtWithTax(BigDecimal otherAmtWithTax) {
        this.otherAmtWithTax = otherAmtWithTax;
    }

    public BigDecimal getOtherAmt() {
        return otherAmt;
    }

    public void setOtherAmt(BigDecimal otherAmt) {
        this.otherAmt = otherAmt;
    }

    public BigDecimal getOtherTaxAmt() {
        return otherTaxAmt;
    }

    public void setOtherTaxAmt(BigDecimal otherTaxAmt) {
        this.otherTaxAmt = otherTaxAmt;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBaseMoneyWithTax() {
        return baseMoneyWithTax;
    }

    public void setBaseMoneyWithTax(BigDecimal baseMoneyWithTax) {
        this.baseMoneyWithTax = baseMoneyWithTax;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeMnyWithTax() {
        return beforeChangeMnyWithTax;
    }

    public void setBeforeChangeMnyWithTax(BigDecimal beforeChangeMnyWithTax) {
        this.beforeChangeMnyWithTax = beforeChangeMnyWithTax;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingMnyWithTax() {
        return changingMnyWithTax;
    }

    public void setChangingMnyWithTax(BigDecimal changingMnyWithTax) {
        this.changingMnyWithTax = changingMnyWithTax;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }

    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }

//    /**
//     * 分包合同明细实体
//     */
//    public List<ContractDetailEntity> getContractDetailEntities() {
//        return contractDetailEntities;
//    }
//
//    /**
//     * 分包合同明细实体
//     */
//    public void setContractDetailEntities(List<ContractDetailEntity> contractDetailEntities) {
//        this.contractDetailEntities = contractDetailEntities;
//    }
//    /**
//     * 分包合同条款实体
//     */
//    public List<ContractClauseEntity> getContractClauseEntities() {
//        return contractClauseEntities;
//    }
//
//    /**
//     * 分包合同条款实体
//     */
//    public void setContractClauseEntities(List<ContractClauseEntity> contractClauseEntities) {
//        this.contractClauseEntities = contractClauseEntities;
//    }
//    /**
//     * 分包合同其他费用实体
//     */
//    public List<ContractOtherCostEntity> getContractOtherCostEntities() {
//        return contractOtherCostEntities;
//    }
//
//    /**
//     * 分包合同其他费用实体
//     */
//    public void setContractOtherCostEntities(List<ContractOtherCostEntity> contractOtherCostEntities) {
//        this.contractOtherCostEntities = contractOtherCostEntities;
//    }

    public List<ContractDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ContractDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public List<ContractClauseEntity> getClauseList() {
        return clauseList;
    }

    public void setClauseList(List<ContractClauseEntity> clauseList) {
        this.clauseList = clauseList;
    }

    public List<ContractOtherCostEntity> getOtherCostList() {
        return otherCostList;
    }

    public void setOtherCostList(List<ContractOtherCostEntity> otherCostList) {
        this.otherCostList = otherCostList;
    }
}
