package com.ejianc.business.sub.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 分包记录明细实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_laborsub_contract_record_detail")
public class RecordDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 清单编号
     */
    @TableField("code")
    private String code;

    /**
     * 清单名称
     */
    @TableField("name")
    private String name;

    /**
     * 序号
     */
    @TableField("tree_index")
    private String treeIndex;

    /**
     * 工作内容
     */
    @TableField("work_content")
    private String workContent;

    /**
     * 计量规则
     */
    @TableField("measurement_rules")
    private String measurementRules;

    /**
     * 单位
     */
    @TableField("unit")
    private String unit;

    /**
     * 工程量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 单价（无税）
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 税率
     */
    @TableField("rate")
    private BigDecimal rate;

    /**
     * 金额（无税）
     */
    @TableField("amt")
    private BigDecimal amt;

    /**
     * 单价(含税）
     */
    @TableField("price_with_tax")
    private BigDecimal priceWithTax;

    /**
     * 金额（含税）
     */
    @TableField("amt_with_tax")
    private BigDecimal amtWithTax;

    /**
     * 税额
     */
    @TableField("tax_amt")
    private BigDecimal taxAmt;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 来源数据Id
     */
    @TableField("source_id")
    private Long sourceId;

    /**
     * 来源类型：1-定标结果带入
     */
    @TableField("source_type")
    private String sourceType;

    /**
     * 所属合同Id
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 变更主键
     */
    @TableField("change_id")
    private Long changeId;

    /**
     * 变更子表主键
     */
    @TableField("change_bid")
    private Long changeBid;

    /**
     * 父ID
     */
    @TableField("parent_id")
    private Long parentId;

    /**
     * 变更类型
     */
    @TableField("change_type")
    private Integer changeType;

    @TableField(exist = false)
    private String tid;
    @TableField(exist = false)
    private String tpid;

    /**
     * 记录表ID
     */
    @TableField("record_id")
    private Long recordId;

    /**
     * 来源主合同子表id
     */
    @TableField("src_table_id")
    private Long srcTableId;

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTreeIndex() {
        return treeIndex;
    }

    public void setTreeIndex(String treeIndex) {
        this.treeIndex = treeIndex;
    }

    public String getWorkContent() {
        return workContent;
    }

    public void setWorkContent(String workContent) {
        this.workContent = workContent;
    }

    public String getMeasurementRules() {
        return measurementRules;
    }

    public void setMeasurementRules(String measurementRules) {
        this.measurementRules = measurementRules;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public BigDecimal getAmt() {
        return amt;
    }

    public void setAmt(BigDecimal amt) {
        this.amt = amt;
    }

    public BigDecimal getPriceWithTax() {
        return priceWithTax;
    }

    public void setPriceWithTax(BigDecimal priceWithTax) {
        this.priceWithTax = priceWithTax;
    }

    public BigDecimal getAmtWithTax() {
        return amtWithTax;
    }

    public void setAmtWithTax(BigDecimal amtWithTax) {
        this.amtWithTax = amtWithTax;
    }

    public BigDecimal getTaxAmt() {
        return taxAmt;
    }

    public void setTaxAmt(BigDecimal taxAmt) {
        this.taxAmt = taxAmt;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Long getChangeBid() {
        return changeBid;
    }

    public void setChangeBid(Long changeBid) {
        this.changeBid = changeBid;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }


    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTpid() {
        return tpid;
    }

    public void setTpid(String tpid) {
        this.tpid = tpid;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public Long getSrcTableId() {
        return srcTableId;
    }

    public void setSrcTableId(Long srcTableId) {
        this.srcTableId = srcTableId;
    }
}
