package com.ejianc.business.sub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.vo.TemplateCategoryVO;
import com.ejianc.business.laborsub.vo.ContractVO;
import com.ejianc.business.sub.bean.ContractClauseEntity;
import com.ejianc.business.sub.bean.ContractDetailEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.bean.ContractOtherCostEntity;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.service.IContractDetailService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包合同实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("contract")
public class ContractController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "LABORSUB_CONTRACT";//此处需要根据实际修改

    @Autowired
    private IContractService service;

    private final String ENTITY_REF_CODE = "laborSubContract";

    @Autowired
    private IContractDetailService contractDetailService;

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdate(@RequestBody ContractVO saveorUpdateVO) {
    	ContractVO vo = service.insertOrUpdate(saveorUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 查询合同文件管理信息
     *
     * @param contractId 合同Id
     * @return
     */
    @GetMapping(value = "/getContractFileMgrInfo")
    @ResponseBody
    public CommonResponse<JSONObject> getContractFileMgrInfo(@RequestParam(value = "contractId") Long contractId) {
        JSONObject resp = new JSONObject();
        CommonResponse<BillTypeVO> billTypeResp = billTypeApi.getByRefCode(ENTITY_REF_CODE);
        if(!billTypeResp.isSuccess()) {
            logger.error("根据refCode-{}查询对应元数据失败, 原因：{}", ENTITY_REF_CODE, billTypeResp.getMsg());
            return CommonResponse.error("查询元数据信息失败");
        }

        ContractEntity contractEntity = service.selectById(contractId);
        CommonResponse<TemplateCategoryVO> categoryResp = templateCategoryApi.queryTmplCategoryById(contractEntity.getContractCategoryId());
        if(!categoryResp.isSuccess()) {
            logger.error("根据合同类别I的-{}查询对应合同类别信息失败, 原因：{}", contractEntity.getContractCategoryId(), categoryResp.getMsg());
            return CommonResponse.error("查询合同类别信息失败");
        }
        TemplateCategoryVO category = categoryResp.getData();
        resp.put("contactId", contractEntity.getId());
        resp.put("contractBillTypeCode", billTypeResp.getData().getBillCode());
        resp.put("contractCategoryId", category.getId());
        resp.put("boBillType", category.getBillTypeCode());

        return CommonResponse.success("查询成功！", resp);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> queryDetail(Long id) {
        ContractVO vo = service.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractVO> vos) {
        service.removeByIds(vos.stream().map(ContractVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<ContractEntity> page = service.queryPage(param,false);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ContractEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Contract-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refContractData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ContractVO>> refContractData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ContractEntity> page = service.queryPage(param,false);
        IPage<ContractVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ContractVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 查询分页列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/pageList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> pageList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter("eq",InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("main_contract_create_date", QueryParam.DESC);
        param.getOrderMap().put("supplement_flag", QueryParam.ASC);
        param.getOrderMap().put("create_time", QueryParam.DESC);
        IPage<ContractEntity> pageData= service.queryPage(param,false);


        //页面统计，查询原合同金额，现合同金额
        Map<String, Object> contractAmountMap = service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", BeanMapper.mapList(pageData.getRecords(), ContractVO.class));
        page.put("total", pageData.getTotal());
        page.put("current", pageData.getCurrent());
        page.put("size", pageData.getSize());
        page.put("pages", pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 查询当前合同下补充协议列表
     * @param id
     * @return
     */
    @RequestMapping(value = "/querySupplementRecord", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> querySupplementRecord(Long id) {
        ContractVO vo = service.querySupplementRecord(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description saveOrUpdateSupplement 新增或者修改补充协议
     */
    @RequestMapping(value = "/saveOrUpdateSupplement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ContractVO> saveOrUpdateSupplement(@RequestBody ContractVO saveorUpdateVO) {
        ContractEntity entity = BeanMapper.map(saveorUpdateVO, ContractEntity.class);

        if(saveorUpdateVO.getId() == null || saveorUpdateVO.getId() == 0 ){
            //新增补充协议
            if (saveorUpdateVO.getMainContractId() != null) {

                //补充协议只能存在一条未生效的
                LambdaQueryWrapper<ContractEntity> lambdaQuery = Wrappers.<ContractEntity>lambdaQuery();
                lambdaQuery.eq(ContractEntity::getMainContractId, saveorUpdateVO.getMainContractId());
                lambdaQuery.and(l -> l.ne(ContractEntity::getSignatureStatus, SignatureStatusEnum.已签章.getCode()).or(c -> c.notIn(ContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode())));
                int num = service.count(lambdaQuery);
                if(num > 0){
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }

                List<ContractDetailEntity> detailList = entity.getDetailList();
                List<ContractOtherCostEntity> otherCostList = entity.getOtherCostList();
                List<ContractClauseEntity> clauseList = entity.getClauseList();

                //添加补充协议编码规则
                QueryParam parm = new QueryParam();
                parm.getParams().put("main_contract_id", new Parameter("eq", entity.getMainContractId()));
                List<ContractEntity> supplementList = service.queryList(parm, false);
                String supplementNum = "";
                if (supplementList.size() < 10) {
                    supplementNum += "0" + supplementList.size();
                }

                //主合同
                ContractEntity mainContract = service.selectById(saveorUpdateVO.getMainContractId());
                if (mainContract != null) {
                    entity = BeanMapper.map(mainContract, ContractEntity.class);
                    entity.setId(null);
                    entity.setBillCode(entity.getBillCode() + "2" + supplementNum);

                    //基本信息
                    entity.setContractName(saveorUpdateVO.getContractName());
                    entity.setSignDate(saveorUpdateVO.getSignDate());
                    entity.setOperatorId(saveorUpdateVO.getOperatorId());
                    entity.setOperatorName(saveorUpdateVO.getOperatorName());
                    entity.setPerformanceStatus(saveorUpdateVO.getPerformanceStatus());
                    entity.setDraftType(saveorUpdateVO.getDraftType());

                    //设置文件路径
                    entity.setContractFilePath(saveorUpdateVO.getContractFilePath());
                    entity.setContractFileId(saveorUpdateVO.getContractFileId());

                    entity.setContractTemplateId(saveorUpdateVO.getContractTemplateId());
                    entity.setContractTemplateName(saveorUpdateVO.getContractTemplateName());
                    entity.setContractFileVersionId(saveorUpdateVO.getContractFileVersionId());
                    entity.setContractFileVersion(saveorUpdateVO.getContractFileVersion());

                    entity.setSupplementDescribe(saveorUpdateVO.getSupplementDescribe());

                    //补充金额明细
                    entity.setContractAmt(saveorUpdateVO.getContractAmt());
                    entity.setContractAmtWithTax(saveorUpdateVO.getContractAmtWithTax());
                    entity.setContractTaxAmt(saveorUpdateVO.getContractTaxAmt());

                    entity.setSubContractAmt(saveorUpdateVO.getSubContractAmt());
                    entity.setSubContractAmtWithTax(saveorUpdateVO.getSubContractAmtWithTax());
                    entity.setSubContractTaxAmt(saveorUpdateVO.getSubContractTaxAmt());

                    entity.setOtherAmt(saveorUpdateVO.getOtherAmt());
                    entity.setOtherAmtWithTax(saveorUpdateVO.getOtherAmtWithTax());
                    entity.setOtherTaxAmt(saveorUpdateVO.getOtherTaxAmt());

                    //子表
                    entity.setDetailList(detailList);
                    entity.setOtherCostList(otherCostList);
                    entity.setClauseList(clauseList);

                    //初始化变更字段
                    entity.setBeforeChangeMnyWithTax(null);
                    entity.setBeforeChangeMny(null);
                    entity.setChangingMny(null);
                    entity.setBeforeChangeMnyWithTax(null);
                    entity.setChangeCode(null);
                    entity.setChangeVersion(null);
                    entity.setChangeId(null);
                    entity.setChangeStatus(1);

                    //补充协议状态
                    entity.setSupplementFlag(1);
                    entity.setMainContractId(saveorUpdateVO.getMainContractId());
                    entity.setMainContractCode(saveorUpdateVO.getMainContractCode());
                    entity.setMainContractName(saveorUpdateVO.getMainContractName());

                    entity.setMainContractCreateDate(saveorUpdateVO.getMainContractCreateDate());
                }else {
                    throw new BusinessException("未找到主合同，不能创建补充协议！");
                }
            }
        }


        //设置初始金额
        entity.setBaseMoney(entity.getContractAmt());
        entity.setBaseMoneyWithTax(entity.getContractAmtWithTax());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractAmt());
        entity.setBeforeChangeMnyWithTax(entity.getContractAmtWithTax());


        entity.setCommitDate(new Date());
        entity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
        entity.setCommitUserName(sessionManager.getUserContext().getUserName());



        //保存前清空主键和父主键，重新生成
        List<ContractDetailEntity> beforeDetails = entity.getDetailList();
        if(CollectionUtils.isNotEmpty(beforeDetails) && null == entity.getId()){
            for(ContractDetailEntity cdEntity : beforeDetails){
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }
        service.saveOrUpdate(entity, false);

        List<ContractDetailEntity> supplementDetailEntities = entity.getDetailList();
        if(CollectionUtils.isNotEmpty(supplementDetailEntities)){
            Map<String,Long> idMap=new HashMap<>();
            for(ContractDetailEntity cdEntity : supplementDetailEntities){
                idMap.put(cdEntity.getTid(),cdEntity.getId());
            }
            for(ContractDetailEntity cdEntity : supplementDetailEntities){
                if(StringUtils.isNotEmpty(cdEntity.getTpid())){
                    cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                }
            }
            contractDetailService.saveOrUpdateBatch(supplementDetailEntities, supplementDetailEntities.size(), false);
        }
//        ContractVO vo = BeanMapper.map(entity, ContractVO.class);
        return queryDetail(entity.getId());
//        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    /**
     * @Author
     * @Description  新增根据合同主键查询补充协议需要的主合同字段
     * @param contractId
     * @Return
     */
    @RequestMapping(value = "/addConvertByConId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ContractVO> addConvertByConId(Long contractId) {
        ContractVO vo = service.addConvertByConId(contractId);
        return CommonResponse.success("新增转换数据成功！",vo);
    }


    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/signatureProcess", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> signatureProcess(Long id) {
        /*
            后期修改：签章流程暂定为点击就改为已签章
         */
        ContractEntity contractEntity = service.selectById(id);
        if (contractEntity != null){
            contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
            service.saveOrUpdate(contractEntity);
        }
        return CommonResponse.success();
    }
}
