package com.ejianc.business.sub.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.PerformanceStatusEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISignatureService;
import com.ejianc.framework.core.response.CommonResponse;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.Date;

/**
 * 签章流程
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("signature")
public class SignatureController implements Serializable {

    private static final long serialVersionUID = 1L;

    @Autowired
    private ISignatureService signatureService;

    /**
     * 签章流程
     * @param
     * @return
     */
    @RequestMapping(value = "/changeStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> changeStatus(@RequestParam("billId") Long id, @RequestParam("status") int signatureStatus, @RequestParam("refCode") String refCode) {
        return signatureService.changeStatus(id, signatureStatus, refCode);
    }
}
