package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.PerformanceStatusEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.ISignatureService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("signatureService")
public class SignatureServiceImpl implements ISignatureService {
    @Autowired
    private IContractService contractService;

    @Autowired
    private IChangeService changeService;


    /**
     * 签章流程
     * 判断合同类型做不同操作
     * @param id
     * @param signatureStatus
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> changeStatus(Long id, int signatureStatus, String refCode) {
        /*
            主合同，已签章：
            改变签章状态，改变合同状态
            变更合同，已签章：
            改变签章状态，改变合同状态，回写主合同信息
         */
        if ("laborSubContract".equals(refCode)){//主合同
            ContractEntity contractEntity = contractService.selectById(id);
            if (contractEntity != null){
                if (signatureStatus == SignatureStatusEnum.已签章.getCode()){
                    contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
                    contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode().toString());
                    contractEntity.setEffectiveDate(new Date());
                }else {
                    contractEntity.setSignatureStatus(String.valueOf(signatureStatus));
                }
                contractService.saveOrUpdate(contractEntity);
            }else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        }else if ("laborSubChangeContract".equals(refCode)){//变更合同
            ChangeEntity changeEntity = changeService.selectById(id);
            if (changeEntity != null){
                Boolean changeContractFlag = false;
                if (signatureStatus == SignatureStatusEnum.已签章.getCode()){
                    changeEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode().toString());
                    changeEntity.setEffectiveDate(new Date());
                    changeEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode().toString());
                    changeContractFlag = true;
                }else {
                    changeEntity.setSignatureStatus(String.valueOf(signatureStatus));
                }
                changeService.saveOrUpdate(changeEntity);
                if (changeContractFlag){
                    //回写主合同（变更合同签章状态，主合同变更状态）
                    LambdaUpdateWrapper<ContractEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, Integer.valueOf(changeEntity.getSignatureStatus()));
                    updateWrapper.set(ContractEntity::getChangeStatus, ChangeStatusEnum.已变更.getCode());
                    contractService.update(contractService.selectById(changeEntity.getContractId()), updateWrapper, false);
                }
            }else {
                return CommonResponse.error("找不到合同，请检查合同主键！");
            }
        }else {
            return CommonResponse.error("请检查refCode值是否正确！");
        }
        return CommonResponse.success();
    }
}
