/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.laborsub.utils.TreeNodeBUtil;
import com.ejianc.business.laborsub.vo.ChangeCompareVO;
import com.ejianc.business.laborsub.vo.ChangeDetailVO;
import com.ejianc.business.laborsub.vo.ChangeOtherCostVO;
import com.ejianc.business.laborsub.vo.ChangeVO;
import com.ejianc.business.sub.bean.ChangeDetailEntity;
import com.ejianc.business.sub.bean.ChangeEntity;
import com.ejianc.business.sub.bean.ContractEntity;
import com.ejianc.business.sub.enums.ChangeStatusEnum;
import com.ejianc.business.sub.enums.SignatureStatusEnum;
import com.ejianc.business.sub.mapper.ChangeMapper;
import com.ejianc.business.sub.service.IChangeDetailService;
import com.ejianc.business.sub.service.IChangeOtherCostService;
import com.ejianc.business.sub.service.IChangeService;
import com.ejianc.business.sub.service.IContractService;
import com.ejianc.business.sub.service.IRecordService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="changeService")
public class ChangeServiceImpl
extends BaseServiceImpl<ChangeMapper, ChangeEntity>
implements IChangeService {
    @Autowired
    private IContractService contractService;
    @Autowired
    private IChangeDetailService changeDetailService;
    @Autowired
    private IChangeOtherCostService otherCostService;
    @Autowired
    private IRecordService recordService;

    @Override
    public ChangeVO queryDetailRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(id));
        ChangeVO changeVO = new ChangeVO();
        BigDecimal baseMoneyWithTax = contractEntity.getBaseMoneyWithTax() == null ? BigDecimal.ZERO : contractEntity.getBaseMoneyWithTax();
        BigDecimal contractAmtWithTax = contractEntity.getContractAmtWithTax() == null ? BigDecimal.ZERO : contractEntity.getContractAmtWithTax();
        changeVO.setId(id);
        changeVO.setBaseMoneyWithTax(baseMoneyWithTax);
        changeVO.setContractAmtWithTax(contractAmtWithTax);
        if (contractEntity.getChangeVersion() != null && baseMoneyWithTax.compareTo(BigDecimal.ZERO) != 0 && contractAmtWithTax.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal changeAmtRate = contractAmtWithTax.divide(baseMoneyWithTax, 8, 5).multiply(new BigDecimal(100));
            changeVO.setChangeAmtRate(changeAmtRate);
        }
        if (null != contractEntity.getChangeVersion() && contractEntity.getChangeVersion() > 0) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ChangeEntity::getContractId, (Object)id);
            lambda.orderByDesc(ChangeEntity::getChangeDate);
            lambda.orderByDesc(BaseEntity::getCreateTime);
            List changeList = super.list((Wrapper)lambda);
            changeVO.setChangeList(BeanMapper.mapList((Iterable)changeList, ChangeVO.class));
            BigDecimal allChangeAmt = new BigDecimal(0);
            for (ChangeEntity c : changeList) {
                if (c.getChangeMoney() == null) continue;
                allChangeAmt = allChangeAmt.add(c.getChangeMoney());
            }
            changeVO.setAllChangeAmt(allChangeAmt);
            changeVO.setChangeNum(Integer.valueOf(changeList.size()));
        }
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode() == contractEntity.getBillState() || BillStateEnum.COMMITED_STATE.getBillStateCode() == contractEntity.getBillState())) {
            changeVO.setEditFlag(this.editChangeFlag(id));
        }
        return changeVO;
    }

    @Override
    public Boolean editChangeFlag(Long contractId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ChangeEntity::getContractId, (Object)contractId);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString())).or(c -> (LambdaQueryWrapper)c.notIn(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List changeList = super.list((Wrapper)lambda);
        if (changeList.size() > 0) {
            return false;
        }
        return true;
    }

    @Override
    public ChangeVO addConvertByConId(Long contractId) {
        List changeClauseList;
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        ChangeVO changeVO = (ChangeVO)BeanMapper.map((Object)((Object)contractEntity), ChangeVO.class);
        changeVO.setBillState(null);
        changeVO.setBeforeContractName(contractEntity.getContractName());
        changeVO.setContractId(contractId);
        changeVO.setChangeVersion(Integer.valueOf(contractEntity.getChangeVersion() == null ? 1 : contractEntity.getChangeVersion() + 1));
        changeVO.setCreateUserCode(null);
        changeVO.setCreateTime(null);
        changeVO.setUpdateUserCode(null);
        changeVO.setUpdateTime(null);
        changeVO.setChangeDate(new Date());
        changeVO.setId(null);
        List changeDetailList = changeVO.getDetailList();
        if (CollectionUtils.isNotEmpty((Collection)changeDetailList)) {
            changeDetailList.forEach(changeDetailVO -> {
                changeDetailVO.setSrcTblId(changeDetailVO.getId());
                changeDetailVO.setBeforeChangeNum(changeDetailVO.getNum());
                changeDetailVO.setBeforeChangePrice(changeDetailVO.getPrice());
                changeDetailVO.setBeforeChangeRate(changeDetailVO.getRate());
                changeDetailVO.setTid(changeDetailVO.getId().toString());
                changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                changeDetailVO.setRowState("edit");
            });
        }
        changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeDetailList));
        List changeOtherCostVOList = changeVO.getOtherCostList();
        if (CollectionUtils.isNotEmpty((Collection)changeOtherCostVOList)) {
            changeOtherCostVOList.forEach(changeOtherCostVO -> {
                changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                changeOtherCostVO.setBeforeChangeCostNum(changeOtherCostVO.getCostNum());
                changeOtherCostVO.setBeforeChangeCostPrice(changeOtherCostVO.getCostPrice());
                changeOtherCostVO.setBeforeChangeCostRate(changeOtherCostVO.getCostRate());
                changeOtherCostVO.setRowState("edit");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(changeClauseList = changeVO.getClauseList()))) {
            changeClauseList.forEach(changeClauseVO -> changeClauseVO.setRowState("add"));
        }
        return changeVO;
    }

    @Override
    public ChangeVO insertOrUpdate(ChangeVO changeVO) {
        List<ChangeDetailEntity> beforeDetails;
        ChangeEntity changeEntity = (ChangeEntity)((Object)BeanMapper.map((Object)changeVO, ChangeEntity.class));
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(ChangeEntity::getContractId, (Object)changeVO.getContractId());
        if (changeVO.getId() != null && changeVO.getId() > 0L) {
            lambdachange.ne(BaseEntity::getId, (Object)changeVO.getId());
        }
        lambdachange.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ChangeEntity::getSignatureStatus, (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().toString())).or(c -> (LambdaQueryWrapper)c.notIn(ChangeEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        int num = super.count((Wrapper)lambdachange);
        if (num > 0) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5355!");
        }
        if (changeEntity.getId() == null) {
            changeEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().toString());
            if (changeEntity.getChangeVersion() < 10) {
                changeEntity.setBillCode(changeEntity.getBillCode() + "10" + changeEntity.getChangeVersion());
            } else {
                changeEntity.setBillCode(changeEntity.getBillCode() + "1" + changeEntity.getChangeVersion());
            }
        }
        if (CollectionUtils.isNotEmpty(beforeDetails = changeEntity.getDetailList()) && null == changeEntity.getId()) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (ChangeDetailEntity cdEntity : beforeDetails) {
                if (cdEntity.getId() == null) {
                    IdWorker.getId();
                }
                cdEntity.setParentId(null);
                idMap.put(cdEntity.getTid(), cdEntity.getId());
            }
            for (ChangeDetailEntity cdEntity : beforeDetails) {
                if (!StringUtils.isNotEmpty((CharSequence)cdEntity.getTpid())) continue;
                cdEntity.setParentId((Long)idMap.get(cdEntity.getTpid()));
            }
        }
        super.saveOrUpdate((Object)changeEntity, false);
        this.saveWriteContract(changeEntity);
        return this.queryDetail(changeEntity.getId());
    }

    @Override
    public ChangeVO queryDetail(Long id) {
        List otherCostEntityListDb;
        ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)id));
        ChangeVO changeVO = (ChangeVO)BeanMapper.map((Object)((Object)changeEntity), ChangeVO.class);
        changeVO.setContractType(Integer.valueOf(2));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List detailEntityListDb = this.changeDetailService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
            for (ChangeDetailEntity cdEntity : detailEntityListDb) {
                cdEntity.setTid(cdEntity.getId().toString());
                cdEntity.setTpid(cdEntity.getParentId() != null && cdEntity.getParentId() > 0L ? cdEntity.getParentId().toString() : "");
            }
            List resultMapList = BeanMapper.mapList((Iterable)detailEntityListDb, ChangeDetailVO.class);
            changeVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
        }
        if (CollectionUtils.isNotEmpty((Collection)(otherCostEntityListDb = this.otherCostService.queryList(queryParam, false)))) {
            List resultMapList = BeanMapper.mapList((Iterable)otherCostEntityListDb, ChangeOtherCostVO.class);
            changeVO.setOtherCostList(resultMapList);
        }
        return changeVO;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<ChangeVO> vos) {
        ChangeVO changeVo = vos.get(0);
        ChangeEntity entity = (ChangeEntity)((Object)super.selectById((Serializable)changeVo.getId()));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
        contractEntity.setChangeVersion(contractEntity.getChangeVersion() - 1);
        contractEntity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        contractEntity.setChangingMny(BigDecimal.ZERO);
        contractEntity.setChangingMnyWithTax(BigDecimal.ZERO);
        contractEntity.setChangeCode(null);
        contractEntity.setChangeId(null);
        this.contractService.update((Object)contractEntity, (Wrapper)new QueryWrapper().eq((Object)"id", (Object)contractEntity.getId()), false);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public Map<String, Object> queryChangeCompare(Long id) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)super.selectById((Serializable)id));
        ChangeCompareVO changeCompareVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)changeEntity), ChangeCompareVO.class);
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        ChangeCompareVO beforeChangeVO = (ChangeCompareVO)BeanMapper.map((Object)((Object)contractEntity), ChangeCompareVO.class);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (changeCompareVO != null && beforeChangeVO != null) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("change_id", new Parameter("eq", (Object)id));
            queryParam.getOrderMap().put("treeIndex", "asc");
            List detailEntityListDb = this.changeDetailService.queryList(queryParam, false);
            ArrayList detailEntityList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)detailEntityListDb)) {
                detailEntityListDb.forEach(entity -> {
                    if (null != entity.getChangeType()) {
                        detailEntityList.add(entity);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                List resultMapList = BeanMapper.mapList(detailEntityList, ChangeDetailVO.class);
                changeCompareVO.setDetailList(TreeNodeBUtil.buildTree((List)resultMapList));
            }
            List otherCostEntityListDb = this.otherCostService.queryList(queryParam, false);
            ArrayList otherCostEntityList = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)otherCostEntityListDb)) {
                otherCostEntityListDb.forEach(entity -> {
                    if (null != entity.getChangeType()) {
                        otherCostEntityList.add(entity);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(otherCostEntityList)) {
                List resultMapList = BeanMapper.mapList(otherCostEntityList, ChangeOtherCostVO.class);
                changeCompareVO.setOtherCostList(resultMapList);
            }
            returnMap.put("newData", changeCompareVO);
            returnMap.put("oldData", beforeChangeVO);
        }
        return returnMap;
    }

    private void saveWriteContract(ChangeEntity changeEntity) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ContractEntity::getChangeId, (Object)changeEntity.getId());
        updateWrapper.set(ContractEntity::getChangingMny, (Object)changeEntity.getContractAmt());
        updateWrapper.set(ContractEntity::getChangingMnyWithTax, (Object)changeEntity.getContractAmtWithTax());
        updateWrapper.set(ContractEntity::getChangeCode, (Object)changeEntity.getBillCode());
        updateWrapper.set(ContractEntity::getChangeVersion, (Object)changeEntity.getChangeVersion());
        updateWrapper.set(ContractEntity::getChangeStatus, (Object)ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        updateWrapper.set(ContractEntity::getChangeDate, (Object)changeEntity.getChangeDate());
        updateWrapper.set(ContractEntity::getChangeContractSignatureStatus, (Object)Integer.valueOf(changeEntity.getSignatureStatus()));
        updateWrapper.set(ContractEntity::getChangeDraftType, (Object)changeEntity.getChangeDraftType());
        updateWrapper.eq(BaseEntity::getId, (Object)changeEntity.getContractId());
        this.contractService.update(this.contractService.selectById(changeEntity.getContractId()), (Wrapper)updateWrapper, false);
    }

    @Override
    public ChangeVO queryChangeRecord(Long contractId) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractId));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contract_id", new Parameter("eq", (Object)contractEntity.getId()));
        queryParam.getParams().put("change_id", new Parameter("eq", (Object)contractEntity.getChangeId()));
        List recordList = this.recordService.queryList(queryParam);
        ChangeVO changeVO = new ChangeVO();
        if (CollectionUtils.isNotEmpty((Collection)recordList) && recordList.get(0) != null) {
            changeVO = (ChangeVO)BeanMapper.map(recordList.get(0), ChangeVO.class);
        }
        if (changeVO != null) {
            List changeClauseList;
            List changeDetailList = changeVO.getDetailList();
            if (CollectionUtils.isNotEmpty((Collection)changeDetailList)) {
                changeDetailList.forEach(changeDetailVO -> {
                    changeDetailVO.setSrcTblId(changeDetailVO.getId());
                    changeDetailVO.setBeforeChangeNum(changeDetailVO.getNum());
                    changeDetailVO.setBeforeChangePrice(changeDetailVO.getPrice());
                    changeDetailVO.setBeforeChangeRate(changeDetailVO.getRate());
                    changeDetailVO.setTid(changeDetailVO.getId().toString());
                    changeDetailVO.setTpid(changeDetailVO.getParentId() != null && changeDetailVO.getParentId() > 0L ? changeDetailVO.getParentId().toString() : "");
                    changeDetailVO.setRowState("edit");
                });
            }
            changeVO.setDetailList(TreeNodeBUtil.buildTree((List)changeDetailList));
            List changeOtherCostVOList = changeVO.getOtherCostList();
            if (CollectionUtils.isNotEmpty((Collection)changeOtherCostVOList)) {
                changeOtherCostVOList.forEach(changeOtherCostVO -> {
                    changeOtherCostVO.setSrcTblId(changeOtherCostVO.getId());
                    changeOtherCostVO.setBeforeChangeCostNum(changeOtherCostVO.getCostNum());
                    changeOtherCostVO.setBeforeChangeCostPrice(changeOtherCostVO.getCostPrice());
                    changeOtherCostVO.setBeforeChangeCostRate(changeOtherCostVO.getCostRate());
                    changeOtherCostVO.setRowState("edit");
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(changeClauseList = changeVO.getClauseList()))) {
                changeClauseList.forEach(changeClauseVO -> changeClauseVO.setRowState("add"));
            }
        }
        return changeVO;
    }
}

